/*
 * Decompiled with CFR 0.152.
 */
package lemmini.tools;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.GraphicsOperation;
import lemmini.graphics.LemmImage;
import lemmini.tools.DeleteTreeFileVisitor;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;

public class ToolBox {
    private static final ByteOrderMark[] BYTE_ORDER_MARKS = new ByteOrderMark[]{ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE, ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE};
    private static final ColorModel BITMASK_COLOR_MODEL = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 1}, true, false, 2, 0);

    public static GraphicsOperation createGraphicsOperation() {
        return new GraphicsOperation();
    }

    public static Cursor createCursor(LemmImage image, int centerX, int centerY) {
        return Toolkit.getDefaultToolkit().createCustomCursor(image.getImage(), new Point(centerX, centerY), "");
    }

    public static BufferedImage createImage(int width, int height, int transparency) {
        switch (transparency) {
            case 1: {
                return new BufferedImage(width, height, 1);
            }
            case 2: {
                return new BufferedImage(BITMASK_COLOR_MODEL, BITMASK_COLOR_MODEL.createCompatibleWritableRaster(width, height), false, null);
            }
            case 3: {
                return new BufferedImage(width, height, 2);
            }
        }
        throw new IllegalArgumentException("Invalid transparency: " + transparency);
    }

    public static LemmImage createLemmImage(int width, int height) {
        return ToolBox.createLemmImage(width, height, 3);
    }

    public static LemmImage createLemmImage(int width, int height, int transparency) {
        return new LemmImage(ToolBox.createImage(width, height, transparency));
    }

    public static LemmImage copyLemmImage(LemmImage img) {
        return ToolBox.copyLemmImage(img, 3);
    }

    public static LemmImage copyLemmImage(LemmImage img, int transparency) {
        LemmImage newImg = ToolBox.createLemmImage(img.getWidth(), img.getHeight(), transparency);
        GraphicsContext g = null;
        try {
            g = newImg.createGraphicsContext();
            g.drawImage(img, 0, 0);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return newImg;
    }

    public static List<LemmImage> getAnimation(LemmImage img, int frames) {
        return ToolBox.getAnimation(img, frames, img.getWidth());
    }

    public static List<LemmImage> getAnimation(LemmImage img, int frames, int width) {
        ArrayList<LemmImage> imgList = new ArrayList<LemmImage>(frames);
        int height = img.getHeight() / frames;
        int i = 0;
        int y0 = 0;
        while (i < frames) {
            imgList.add(img.getSubimage(0, y0, width, height));
            ++i;
            y0 += height;
        }
        return imgList;
    }

    public static URL findFile(String fname) {
        ClassLoader loader = ToolBox.class.getClassLoader();
        return loader.getResource(fname);
    }

    public static Path getFileName(Component parent, Path path, String title, boolean load, boolean allowDirectories, String ... ext) {
        File f;
        int returnVal;
        JFileChooser jf = new JFileChooser(path.toFile());
        if (title != null) {
            jf.setDialogTitle(title);
        }
        if (ext != null) {
            StringBuilder sb = new StringBuilder(32);
            int i = 0;
            while (i < ext.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("*.").append(ext[i]);
                ++i;
            }
            FileNameExtensionFilter filter = new FileNameExtensionFilter(sb.toString(), ext);
            jf.setFileFilter(filter);
        }
        jf.setFileSelectionMode(allowDirectories ? 2 : 0);
        if (!load) {
            jf.setDialogType(1);
        }
        if ((returnVal = jf.showDialog(parent, null)) == 0 && (f = jf.getSelectedFile()) != null) {
            return f.toPath().toAbsolutePath();
        }
        return null;
    }

    public static List<Path> getFileNames(Component parent, Path path, boolean load, boolean allowDirectories, String ... ext) {
        int returnVal;
        JFileChooser jf = new JFileChooser(path.toFile());
        if (ext != null) {
            StringBuilder sb = new StringBuilder(32);
            int i = 0;
            while (i < ext.length) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append("*.").append(ext[i]);
                ++i;
            }
            FileNameExtensionFilter filter = new FileNameExtensionFilter(sb.toString(), ext);
            jf.setFileFilter(filter);
        }
        jf.setFileSelectionMode(allowDirectories ? 2 : 0);
        jf.setMultiSelectionEnabled(true);
        if (!load) {
            jf.setDialogType(1);
        }
        if ((returnVal = jf.showDialog(parent, null)) == 0) {
            return Arrays.stream(jf.getSelectedFiles()).map(f -> f.toPath().toAbsolutePath()).collect(Collectors.toList());
        }
        return null;
    }

    public static boolean checkFileID(Reader r, String header) {
        try {
            char[] buf = new char[header.length()];
            r.mark(header.length());
            int charsRead = r.read(buf);
            r.reset();
            String s = new String(buf, 0, charsRead);
            return s.equals(header);
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static BufferedReader getBufferedReader(Path fname) throws IOException {
        InputStream in = null;
        try {
            in = Files.newInputStream(fname, new OpenOption[0]);
            return ToolBox.getBufferedReader(in);
        }
        catch (IOException | SecurityException | UnsupportedCharsetException ex) {
            if (in != null) {
                in.close();
            }
            throw ex;
        }
    }

    public static BufferedReader getBufferedReader(URL file) throws IOException {
        InputStream in = null;
        try {
            in = file.openStream();
            return ToolBox.getBufferedReader(in);
        }
        catch (IOException | SecurityException | UnsupportedCharsetException ex) {
            if (in != null) {
                in.close();
            }
            throw ex;
        }
    }

    public static BufferedReader getBufferedReader(InputStream in) throws IOException {
        BOMInputStream in2 = new BOMInputStream(in, BYTE_ORDER_MARKS);
        Charset encoding = in2.hasBOM() ? Charset.forName(in2.getBOMCharsetName()) : StandardCharsets.UTF_8;
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)in2, encoding));
        return r;
    }

    public static String addBackslashes(String s, boolean addBackslashesToAllSpaces) {
        s = s.replace("\\", "\\\\");
        s = s.replace("#", "\\#");
        s = s.replace("=", "\\=");
        s = s.replace(":", "\\:");
        s = s.replace("!", "\\!");
        if (addBackslashesToAllSpaces) {
            s = s.replace(" ", "\\ ");
        } else if (!s.isEmpty() && s.charAt(0) == ' ') {
            s = "\\" + s;
        }
        return s;
    }

    public static void showException(Throwable ex) {
        StackTraceElement[] ste;
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<html>").append(ex.getClass().getName()).append("<p>");
        if (ex.getMessage() != null) {
            sb.append(ex.getMessage()).append("<p>");
        }
        StackTraceElement[] stackTraceElementArray = ste = ex.getStackTrace();
        int n = ste.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste1 = stackTraceElementArray[n2];
            sb.append(ste1.toString()).append("<p>");
            ++n2;
        }
        sb.append("</html>");
        ex.printStackTrace();
        JOptionPane.showMessageDialog(null, sb.toString(), "Error", 0);
    }

    public static int cap(int min, int value, int max) {
        if (min > max) {
            throw new IllegalArgumentException("max must be >= min");
        }
        return Math.max(min, Math.min(value, max));
    }

    public static long cap(long min, long value, long max) {
        if (min > max) {
            throw new IllegalArgumentException("max must be >= min");
        }
        return Math.max(min, Math.min(value, max));
    }

    public static float cap(float min, float value, float max) {
        if (min > max) {
            throw new IllegalArgumentException("max must be >= min");
        }
        return Math.max(min, Math.min(value, max));
    }

    public static double cap(double min, double value, double max) {
        if (min > max) {
            throw new IllegalArgumentException("max must be >= min");
        }
        return Math.max(min, Math.min(value, max));
    }

    public static int roundToInt(double a) {
        return (int)ToolBox.cap(Integer.MIN_VALUE, Math.round(a), Integer.MAX_VALUE);
    }

    public static int scale(int n, double s) {
        return ToolBox.roundToInt((double)n * s);
    }

    public static double scale(double n, double s) {
        return n * s;
    }

    public static int unscale(int n, double s) {
        return ToolBox.roundToInt((double)n / s);
    }

    public static double unscale(double n, double s) {
        return n / s;
    }

    public static int parseInt(String s) {
        if (s.equalsIgnoreCase("Infinity") || s.equalsIgnoreCase("+Infinity")) {
            return Integer.MAX_VALUE;
        }
        if (s.equalsIgnoreCase("-Infinity")) {
            return Integer.MIN_VALUE;
        }
        int index = 0;
        boolean hasSign = ToolBox.isSign(s.charAt(index));
        if (hasSign) {
            ++index;
        }
        if (s.charAt(index) == '0') {
            int radix;
            if (s.length() <= ++index) {
                return 0;
            }
            switch (s.charAt(index)) {
                case 'X': 
                case 'x': {
                    radix = 16;
                    ++index;
                    break;
                }
                case 'B': 
                case 'b': {
                    radix = 2;
                    ++index;
                    break;
                }
                default: {
                    radix = 10;
                    --index;
                }
            }
            if (radix != 10) {
                if (s.charAt(0) == '-') {
                    throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
                }
                if (ToolBox.isSign(s.charAt(index))) {
                    throw new NumberFormatException("Sign character is not permitted after the radix prefix.");
                }
                return Integer.parseUnsignedInt((hasSign ? Character.valueOf(s.charAt(0)) : "") + s.substring(index), radix);
            }
        }
        return Integer.parseInt(s);
    }

    public static long parseLong(String s) {
        if (s.equalsIgnoreCase("Infinity") || s.equalsIgnoreCase("+Infinity")) {
            return Long.MAX_VALUE;
        }
        if (s.equalsIgnoreCase("-Infinity")) {
            return Long.MIN_VALUE;
        }
        int index = 0;
        boolean hasSign = ToolBox.isSign(s.charAt(index));
        if (hasSign) {
            ++index;
        }
        if (s.charAt(index) == '0') {
            int radix;
            if (s.length() <= ++index) {
                return 0L;
            }
            switch (s.charAt(index)) {
                case 'X': 
                case 'x': {
                    radix = 16;
                    ++index;
                    break;
                }
                case 'B': 
                case 'b': {
                    radix = 2;
                    ++index;
                    break;
                }
                default: {
                    radix = 10;
                }
            }
            if (radix != 10) {
                if (s.charAt(0) == '-') {
                    throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
                }
                if (ToolBox.isSign(s.charAt(index))) {
                    throw new NumberFormatException("Sign character is not permitted after the radix prefix.");
                }
                return Long.parseUnsignedLong((hasSign ? Character.valueOf(s.charAt(0)) : "") + s.substring(index), radix);
            }
        }
        return Long.parseLong(s);
    }

    public static BigInteger parseBigInteger(String s) {
        int index = 0;
        boolean hasSign = ToolBox.isSign(s.charAt(index));
        if (hasSign) {
            ++index;
        }
        if (s.charAt(index) == '0') {
            int radix;
            if (s.length() <= ++index) {
                return BigInteger.ZERO;
            }
            switch (s.charAt(index)) {
                case 'X': 
                case 'x': {
                    radix = 16;
                    ++index;
                    break;
                }
                case 'B': 
                case 'b': {
                    radix = 2;
                    ++index;
                    break;
                }
                default: {
                    radix = 10;
                }
            }
            if (radix != 10) {
                if (ToolBox.isSign(s.charAt(index))) {
                    throw new NumberFormatException("Sign character is not permitted after the radix prefix.");
                }
                return new BigInteger((hasSign ? Character.valueOf(s.charAt(0)) : "") + s.substring(index), radix);
            }
        }
        return new BigInteger(s);
    }

    public static String intToString(int number, boolean useInfinitySymbol) {
        switch (number) {
            case 0x7FFFFFFF: {
                return useInfinitySymbol ? "\u221e" : "Infinity";
            }
            case -2147483648: {
                return useInfinitySymbol ? "-\u221e" : "-Infinity";
            }
        }
        return Integer.toString(number);
    }

    public static boolean isSign(char c) {
        return c == '+' || c == '-';
    }

    public static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    public static boolean looselyEquals(String s1, String s2) {
        return Normalizer.normalize(s1.trim().toLowerCase(Locale.ROOT), Normalizer.Form.NFKC).equals(Normalizer.normalize(s2.trim().toLowerCase(Locale.ROOT), Normalizer.Form.NFKC));
    }

    public static String literalToRegex(String s) {
        StringBuilder sb = null;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            switch (c) {
                case '$': 
                case '(': 
                case '*': 
                case '+': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case '^': 
                case '{': 
                case '|': {
                    if (sb == null) {
                        sb = new StringBuilder(s.length() * 2);
                        sb.append(s.substring(0, i));
                    }
                    sb.append('\\').append(c);
                    break;
                }
                default: {
                    if (sb == null) break;
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb == null ? s : sb.toString();
    }

    public static void deleteFileTree(Path path) throws IOException {
        Files.walkFileTree(path, new DeleteTreeFileVisitor());
    }

    public static String getFileName(String path) {
        if (path.isEmpty() || path.equals("/") || path.equals("\\")) {
            return path;
        }
        int slashPos = -1;
        boolean searchForSlash = true;
        while (searchForSlash) {
            int forwardSlashPos = path.indexOf(47, slashPos + 1);
            int backslashPos = path.indexOf(92, slashPos + 1);
            int newSlashPos = -1;
            if (forwardSlashPos != -1) {
                newSlashPos = backslashPos != -1 ? StrictMath.min(forwardSlashPos, backslashPos) : forwardSlashPos;
            } else if (backslashPos >= 0) {
                newSlashPos = backslashPos;
            }
            if (newSlashPos >= 0 && newSlashPos < path.length() - 1) {
                slashPos = newSlashPos;
                continue;
            }
            searchForSlash = false;
        }
        if (slashPos >= 0) {
            return path.substring(slashPos + 1);
        }
        return path;
    }

    public static String getParent(String path) {
        if (path.isEmpty() || path.equals("/") || path.equals("\\")) {
            return path;
        }
        int slashPos = -1;
        boolean searchForSlash = true;
        while (searchForSlash) {
            int forwardSlashPos = path.indexOf(47, slashPos + 1);
            int backslashPos = path.indexOf(92, slashPos + 1);
            int newSlashPos = -1;
            if (forwardSlashPos != -1) {
                newSlashPos = backslashPos != -1 ? StrictMath.min(forwardSlashPos, backslashPos) : forwardSlashPos;
            } else if (backslashPos >= 0) {
                newSlashPos = backslashPos;
            }
            if (newSlashPos >= 0 && newSlashPos < path.length() - 1) {
                slashPos = newSlashPos;
                continue;
            }
            searchForSlash = false;
        }
        if (slashPos >= 0) {
            return path.substring(0, slashPos + 1);
        }
        if (path.endsWith("\\")) {
            return "\\";
        }
        return "/";
    }
}

