/*
 * Decompiled with CFR 0.152.
 */
package lemmini.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import lemmini.game.Core;
import lemmini.game.Resource;
import lemmini.tools.ToolBox;

public class Props {
    private final Properties hash = new Properties();
    private String header = new String();

    public void setHeader(String h) {
        this.header = h;
    }

    public void clear() {
        this.hash.clear();
    }

    public void remove(String key) {
        this.hash.remove(key);
    }

    public void set(String key, String value) {
        this.hash.setProperty(key, value);
    }

    public void setInt(String key, int value) {
        this.hash.setProperty(key, Integer.toString(value));
    }

    public void setDouble(String key, double value) {
        this.hash.setProperty(key, Double.toString(value));
    }

    public void setBoolean(String key, boolean value) {
        this.hash.setProperty(key, Boolean.toString(value));
    }

    public String get(String key, String def) {
        return this.hash.getProperty(key, def);
    }

    public static String get(Collection<? extends Props> pCollection, String key, String def) {
        for (Props props : pCollection) {
            if (!props.containsKey(key)) continue;
            return props.get(key, def);
        }
        return def;
    }

    public String[] getArray(String key, String[] def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        String[] members = s.split(",");
        int i = 0;
        while (i < members.length) {
            members[i] = members[i].trim();
            ++i;
        }
        return members;
    }

    public static String[] getArray(Collection<? extends Props> pCollection, String key, String[] def) {
        for (Props props : pCollection) {
            if (!props.containsKey(key)) continue;
            return props.getArray(key, def);
        }
        return def;
    }

    public int getInt(String key, int def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        return ToolBox.parseInt(s.trim());
    }

    public static int getInt(Collection<? extends Props> pCollection, String key, int def) {
        for (Props props : pCollection) {
            if (!props.containsKey(key)) continue;
            return props.getInt(key, def);
        }
        return def;
    }

    public int[] getIntArray(String key, int[] def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        String[] members = s.split(",");
        int[] ret = new int[members.length];
        int i = 0;
        while (i < members.length) {
            ret[i] = ToolBox.parseInt(members[i].trim());
            ++i;
        }
        return ret;
    }

    public static int[] getIntArray(Collection<? extends Props> pCollection, String key, int[] def) {
        for (Props props : pCollection) {
            if (!props.containsKey(key)) continue;
            return props.getIntArray(key, def);
        }
        return def;
    }

    public double getDouble(String key, double def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        if ((s = s.trim()).equalsIgnoreCase("Infinity") || s.equalsIgnoreCase("+Infinity")) {
            return Double.POSITIVE_INFINITY;
        }
        if (s.equalsIgnoreCase("-Infinity")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (s.equalsIgnoreCase("NaN") || s.equalsIgnoreCase("+NaN") || s.equalsIgnoreCase("-NaN")) {
            return Double.NaN;
        }
        return Double.parseDouble(s);
    }

    public static double getDouble(Collection<? extends Props> pCollection, String key, double def) {
        for (Props props : pCollection) {
            if (!props.containsKey(key)) continue;
            return props.getDouble(key, def);
        }
        return def;
    }

    public double[] getDoubleArray(String key, double[] def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        String[] members = s.split(",");
        double[] ret = new double[members.length];
        int i = 0;
        while (i < members.length) {
            members[i] = members[i].trim();
            ret[i] = s.equalsIgnoreCase("Infinity") || s.equalsIgnoreCase("+Infinity") ? Double.POSITIVE_INFINITY : (s.equalsIgnoreCase("-Infinity") ? Double.NEGATIVE_INFINITY : (s.equalsIgnoreCase("NaN") || s.equalsIgnoreCase("+NaN") || s.equalsIgnoreCase("-NaN") ? Double.NaN : Double.parseDouble(members[i])));
            ++i;
        }
        return ret;
    }

    public static double[] getDoubleArray(Collection<? extends Props> pCollection, String key, double[] def) {
        for (Props props : pCollection) {
            if (!props.containsKey(key)) continue;
            return props.getDoubleArray(key, def);
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        return Boolean.parseBoolean(s.trim());
    }

    public static boolean getBoolean(Collection<? extends Props> pCollection, String key, boolean def) {
        for (Props props : pCollection) {
            if (!props.containsKey(key)) continue;
            return props.getBoolean(key, def);
        }
        return def;
    }

    public boolean[] getBooleanArray(String key, boolean[] def) {
        String s = this.hash.getProperty(key);
        if (s == null) {
            return def;
        }
        String[] members = s.split(",");
        boolean[] ret = new boolean[members.length];
        int i = 0;
        while (i < members.length) {
            ret[i] = Boolean.parseBoolean(members[i].trim());
            ++i;
        }
        return ret;
    }

    public static boolean[] getBooleanArray(Collection<? extends Props> pCollection, String key, boolean[] def) {
        for (Props props : pCollection) {
            if (!props.containsKey(key)) continue;
            return props.getBooleanArray(key, def);
        }
        return def;
    }

    public boolean containsKey(String key) {
        return this.hash.containsKey(key);
    }

    public boolean save(Path fname, boolean reload) {
        try {
            if (Files.exists(fname, new LinkOption[0]) && reload) {
                this.load(fname);
            }
            Throwable throwable = null;
            Object var4_7 = null;
            try (BufferedWriter w = Files.newBufferedWriter(fname, new OpenOption[0]);){
                return this.save(w);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean save(String fname) {
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (BufferedWriter w = Core.resourceTree.newBufferedWriter(fname, new OpenOption[0]);){
                return this.save(w);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean save(Writer w) {
        try {
            this.hash.store(w, this.header);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean load(Path fname) {
        block12: {
            Throwable throwable = null;
            Object var3_5 = null;
            BufferedReader r = ToolBox.getBufferedReader(fname);
            try {
                this.hash.load(r);
                if (r == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | NullPointerException e) {
                    return false;
                }
            }
            ((Reader)r).close();
        }
        return true;
    }

    public boolean load(URL file) {
        block12: {
            Throwable throwable = null;
            Object var3_5 = null;
            BufferedReader r = ToolBox.getBufferedReader(file);
            try {
                this.hash.load(r);
                if (r == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | NullPointerException e) {
                    return false;
                }
            }
            ((Reader)r).close();
        }
        return true;
    }

    public boolean load(Resource resource) {
        block12: {
            Throwable throwable = null;
            Object var3_5 = null;
            BufferedReader r = resource.getBufferedReader();
            try {
                this.hash.load(r);
                if (r == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (r != null) {
                            ((Reader)r).close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | NullPointerException e) {
                    return false;
                }
            }
            ((Reader)r).close();
        }
        return true;
    }

    public boolean load(Reader r) {
        try {
            this.hash.load(r);
            return true;
        }
        catch (IOException | NullPointerException e) {
            return false;
        }
    }

    public int getHighestLevel(int groupNum) {
        Set<Object> keys = this.hash.keySet();
        int max = -1;
        for (Object k : keys) {
            String match;
            String key = k.toString();
            if (!key.startsWith(match = "group" + groupNum + "_level")) continue;
            int idx2 = key.indexOf("_", match.length() - 1);
            String tmpNum = key.substring(match.length(), idx2);
            try {
                int num = Integer.parseInt(tmpNum);
                if (num <= max) continue;
                max = num;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return max;
    }
}

