/*
 * Decompiled with CFR 0.152.
 */
package lemmini.tools;

public class NanosecondTimer {
    private long timeBase = System.nanoTime();

    public long delta() {
        long t = System.nanoTime();
        long delta = t - this.timeBase;
        if (delta < 0L) {
            System.out.printf("NanosecondTimer inconsistency detected: %d ns", -delta);
            this.timeBase = t;
            delta = 0L;
        }
        return delta;
    }

    public long deltaUpdate() {
        long t = System.nanoTime();
        long delta = t - this.timeBase;
        if (delta < 0L) {
            System.out.printf("NanosecondTimer inconsistency detected: %d ns", -delta);
            delta = 0L;
        }
        this.timeBase = t;
        return delta;
    }

    public boolean timePassed(long dt) {
        long delta = this.delta();
        return delta >= dt;
    }

    public boolean timePassedUpdate(long dt) {
        long t = System.nanoTime();
        long delta = this.delta();
        if (delta >= dt) {
            this.timeBase = t;
            return true;
        }
        return false;
    }

    public boolean timePassedAdd(long dt) {
        long delta = this.delta();
        if (delta >= dt) {
            this.timeBase += dt;
            return true;
        }
        return false;
    }

    public void update() {
        long t;
        this.timeBase = t = System.nanoTime();
    }

    public void update(long delta) {
        this.timeBase += delta;
    }
}

