/*
 * Decompiled with CFR 0.152.
 */
package lemmini.sound;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.LemmException;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.sound.Music;
import lemmini.sound.MusicPlayer;
import lemmini.sound.Sound;

public class WaveMusic
implements Runnable,
MusicPlayer {
    private boolean loopSong;
    private boolean play;
    private SourceDataLine line;
    private DataLine.Info info;
    private Resource file;
    private Resource introFile;
    private AudioInputStream in;
    private AudioInputStream introIn;
    private AudioInputStream din;
    private boolean playIntro;
    private AudioFormat format;
    private Thread waveThread;

    @Override
    public void load(Resource resource, boolean loop) throws ResourceException, LemmException {
        if (this.waveThread != null) {
            this.close();
        }
        this.loopSong = loop;
        try {
            this.in = null;
            this.format = null;
            this.file = resource;
            this.introFile = resource.getSibling(Core.appendBeforeExtension(resource.getFileName(), "_intro"));
            InputStream tempIn = this.file.getInputStream();
            this.in = tempIn.markSupported() ? AudioSystem.getAudioInputStream(tempIn) : AudioSystem.getAudioInputStream(new BufferedInputStream(tempIn));
            if (this.in != null) {
                this.format = WaveMusic.getDecodeFormat(this.in.getFormat());
                if (this.introFile.exists()) {
                    tempIn = this.introFile.getInputStream();
                    this.introIn = tempIn.markSupported() ? AudioSystem.getAudioInputStream(tempIn) : AudioSystem.getAudioInputStream(new BufferedInputStream(tempIn));
                    AudioFormat introFormat = WaveMusic.getDecodeFormat(this.introIn.getFormat());
                    if (introFormat.matches(this.format)) {
                        this.playIntro = true;
                    } else {
                        this.playIntro = false;
                        this.introIn.close();
                    }
                } else {
                    this.playIntro = false;
                }
                this.info = new DataLine.Info(SourceDataLine.class, this.format, GameController.sound.getBufferSize());
            }
            this.din = AudioSystem.getAudioInputStream(this.format, this.playIntro ? this.introIn : this.in);
            if (this.loopSong && !this.playIntro) {
                this.din.mark(Integer.MAX_VALUE);
            }
        }
        catch (FileNotFoundException ex) {
            throw new ResourceException(resource);
        }
        catch (IOException ex) {
            throw new LemmException(resource + " (IO exception)");
        }
        catch (UnsupportedAudioFileException ex) {
            throw new LemmException(String.valueOf(resource.getFileName()) + " (Unsupported Audio File)");
        }
        this.waveThread = new Thread(this);
        this.waveThread.start();
    }

    private static AudioFormat getDecodeFormat(AudioFormat baseFormat) {
        if (baseFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED || baseFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
            return baseFormat;
        }
        return new AudioFormat(baseFormat.getSampleRate(), 16, baseFormat.getChannels(), true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            try {
                this.line = (SourceDataLine)GameController.sound.getLine(this.info);
                byte[] data = new byte[this.line.getBufferSize()];
                this.line.open();
                this.line.start();
                this.setGain(Music.getGain());
                int bytesRead = 0;
                while (bytesRead != -1) {
                    if (Thread.currentThread() != this.waveThread) {
                        return;
                    }
                    if (this.play) {
                        bytesRead = this.din.read(data);
                        if (bytesRead != -1) {
                            this.line.write(data, 0, bytesRead);
                            continue;
                        }
                        if (this.playIntro) {
                            this.din.close();
                            this.din = AudioSystem.getAudioInputStream(this.format, this.in);
                            if (this.loopSong) {
                                this.din.mark(Integer.MAX_VALUE);
                            }
                            this.playIntro = false;
                            bytesRead = 0;
                            continue;
                        }
                        if (this.loopSong) {
                            if (this.din.markSupported()) {
                                this.din.reset();
                            } else {
                                this.din.close();
                                InputStream tempIn = this.file.getInputStream();
                                this.in = tempIn.markSupported() ? AudioSystem.getAudioInputStream(tempIn) : AudioSystem.getAudioInputStream(new BufferedInputStream(tempIn));
                                this.din = AudioSystem.getAudioInputStream(this.format, this.in);
                                this.din.mark(Integer.MAX_VALUE);
                            }
                            bytesRead = 0;
                            continue;
                        }
                        this.line.drain();
                        continue;
                    }
                    this.line.stop();
                    WaveMusic waveMusic = this;
                    synchronized (waveMusic) {
                        while (!this.play && Thread.currentThread() == this.waveThread) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    this.line.start();
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.line.stop();
                this.line.flush();
                this.line.close();
                this.close();
                return;
            }
        }
        finally {
            this.line.stop();
            this.line.flush();
            this.line.close();
            this.close();
        }
    }

    @Override
    public synchronized void stop() {
        this.play = false;
    }

    @Override
    public synchronized void play() {
        this.play = true;
        this.notifyAll();
    }

    @Override
    public void close() {
        if (this.waveThread == null) {
            return;
        }
        Thread moribund = this.waveThread;
        this.waveThread = null;
        try {
            moribund.interrupt();
            moribund.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            if (this.introIn != null) {
                this.introIn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.din.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setGain(double gain) {
        if (gain > 2.0) {
            gain = 2.0;
        } else if (gain < 0.0) {
            gain = 0.0;
        }
        if (this.line != null) {
            Sound.setLineGain(this.line, gain);
        }
    }
}

