/*
 * Decompiled with CFR 0.152.
 */
package lemmini.sound;

import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.game.SpriteObject;
import lemmini.game.Vsfx;
import lemmini.tools.Props;
import lemmini.tools.ToolBox;

public class Sound {
    private static final int MAX_SIMUL_SOUNDS = 7;
    private static final String SOUND_INI_STR = "sound/sound.ini";
    private static int lineCounter = 0;
    private boolean loaded = false;
    private final Map<Effect, Integer> effects = new EnumMap<Effect, Integer>(Effect.class);
    private final List<LineHandler> lineHandlers = new ArrayList<LineHandler>(7);
    private Deque<LineHandler> availableLineHandlers;
    private Resource[] resources;
    private final List<String> sampleNames;
    private final int[] pitchedSampleID;
    private byte[][] soundBuffers;
    private final AudioFormat format;
    private final DataLine.Info info;
    private byte[][][] pitchBuffers;
    private final byte[][] origPitchBuffers;
    private final AudioFormat[] origPitchFormats;
    private double gain;
    static int mixerIdx;
    static List<Mixer> mixers;
    static int sampleNum;
    private final float sampleRate;
    private final int bufferSize;
    private final Quality resamplingQuality;

    public Sound() throws ResourceException {
        Props programProps = Core.programProps;
        this.sampleRate = (float)programProps.getDouble("sampleRate", 44100.0);
        this.bufferSize = programProps.getInt("bufferSize", 8192);
        Quality[] rqArray = Quality.values();
        int rq = programProps.getInt("resamplingQuality", Quality.CUBIC.ordinal());
        this.resamplingQuality = rq < 0 ? rqArray[0] : (rq >= rqArray.length ? rqArray[rqArray.length - 1] : rqArray[rq]);
        programProps.setDouble("sampleRate", this.sampleRate);
        programProps.setInt("bufferSize", this.bufferSize);
        programProps.setInt("resamplingQuality", this.resamplingQuality.ordinal());
        this.gain = 1.0;
        this.sampleNames = new ArrayList<String>(64);
        this.format = new AudioFormat(this.sampleRate, 16, 2, true, false);
        this.info = new DataLine.Info(SourceDataLine.class, this.format, this.bufferSize);
        PitchedEffect[] peValues = PitchedEffect.values();
        this.pitchBuffers = new byte[peValues.length][][];
        int i = 0;
        while (i < peValues.length) {
            int numPitches = peValues[i].getNumPitches();
            this.pitchBuffers[i] = new byte[numPitches][];
            ++i;
        }
        this.origPitchBuffers = new byte[peValues.length][];
        this.origPitchFormats = new AudioFormat[peValues.length];
        this.pitchedSampleID = new int[peValues.length];
        this.load();
        Mixer.Info[] mixInfo = AudioSystem.getMixerInfo();
        mixers = new ArrayList<Mixer>(16);
        mixerIdx = -1;
        String selectedMixerName = Core.programProps.get("mixerName", "");
        Mixer.Info[] infoArray = mixInfo;
        int n = mixInfo.length;
        int n2 = 0;
        while (n2 < n) {
            Mixer.Info mixInfo1 = infoArray[n2];
            Mixer mixer = AudioSystem.getMixer(mixInfo1);
            int num = mixer.getMaxLines(new Line.Info(SourceDataLine.class));
            if (num != 0) {
                mixers.add(mixer);
                if (mixerIdx < 0 && mixer.getMixerInfo().getName().equals(selectedMixerName)) {
                    mixerIdx = mixers.size() - 1;
                }
            }
            ++n2;
        }
        mixerIdx = Math.max(0, mixerIdx);
        this.availableLineHandlers = new LinkedList<LineHandler>();
        int i2 = 0;
        while (i2 < 7) {
            LineHandler lineHandler = new LineHandler((SourceDataLine)this.getLine(this.info), this.availableLineHandlers);
            this.availableLineHandlers.add(lineHandler);
            lineHandler.setGain(this.gain);
            lineHandler.start();
            this.lineHandlers.add(lineHandler);
            ++i2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void load() throws ResourceException {
        int i;
        boolean reloadPitched;
        PitchedEffect[] peValues;
        Resource resource;
        block38: {
            block34: {
                String sName22;
                Props p = new Props();
                resource = Core.findResource(SOUND_INI_STR, true);
                if (!p.load(resource)) {
                    throw new ResourceException(SOUND_INI_STR);
                }
                this.sampleNames.clear();
                int i2 = 0;
                while ((sName22 = p.get("sound_" + i2, null)) != null) {
                    this.sampleNames.add(sName22);
                    ++i2;
                }
                Effect[] effectArray = Effect.values();
                int n = effectArray.length;
                int sName22 = 0;
                while (true) {
                    if (sName22 >= n) {
                        peValues = PitchedEffect.values();
                        reloadPitched = false;
                        if (!this.loaded) {
                            sampleNum = this.sampleNames.size();
                            this.resources = new Resource[sampleNum];
                            this.soundBuffers = new byte[sampleNum][];
                            reloadPitched = true;
                            i = 0;
                            break;
                        }
                        break block34;
                    }
                    Effect e = effectArray[sName22];
                    this.effects.put(e, p.getInt(e.getKeyName(), -1));
                    ++sName22;
                }
                while (i < peValues.length) {
                    this.pitchedSampleID[i] = this.effects.get((Object)peValues[i].getEffect());
                    ++i;
                }
                break block38;
            }
            if (this.sampleNames.size() != sampleNum) {
                sampleNum = this.sampleNames.size();
                this.resources = Arrays.copyOf(this.resources, sampleNum);
                this.soundBuffers = (byte[][])Arrays.copyOf(this.soundBuffers, sampleNum);
            }
            i = 0;
            while (i < peValues.length) {
                int sampleID = this.effects.get((Object)peValues[i].getEffect());
                if (sampleID != this.pitchedSampleID[i]) {
                    reloadPitched = true;
                    this.pitchedSampleID[i] = sampleID;
                }
                ++i;
            }
        }
        try {
            i = 0;
            while (i < sampleNum) {
                block40: {
                    AudioFormat currentFormat;
                    block37: {
                        block35: {
                            block39: {
                                resource = Core.findResource("sound/" + this.sampleNames.get(i), Core.SOUND_EXTENSIONS);
                                if (!this.loaded) break block39;
                                if (resource.equals(this.resources[i])) break block40;
                                if (!reloadPitched) {
                                    int j = 0;
                                    while (j < peValues.length) {
                                        if (i == this.pitchedSampleID[j]) {
                                            reloadPitched = true;
                                            break block35;
                                        }
                                        ++j;
                                    }
                                }
                                break block35;
                            }
                            this.resources[i] = resource;
                        }
                        Throwable throwable = null;
                        Object var8_16 = null;
                        try {
                            BufferedInputStream in = new BufferedInputStream(resource.getInputStream());
                            try {
                                try (AudioInputStream ais = AudioSystem.getAudioInputStream(in);){
                                    currentFormat = ais.getFormat();
                                    this.soundBuffers[i] = new byte[(int)ais.getFrameLength() * currentFormat.getFrameSize()];
                                    ais.read(this.soundBuffers[i]);
                                }
                                if (in == null) break block37;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (in == null) throw throwable;
                                ((InputStream)in).close();
                                throw throwable;
                            }
                            ((InputStream)in).close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    this.soundBuffers[i] = Sound.convert(this.soundBuffers[i], currentFormat, this.format.getSampleSizeInBits(), this.format.getFrameSize(), this.format.getChannels(), this.format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED, this.format.isBigEndian());
                    currentFormat = new AudioFormat(currentFormat.getSampleRate(), this.format.getSampleSizeInBits(), this.format.getChannels(), this.format.getEncoding() == AudioFormat.Encoding.PCM_SIGNED, this.format.isBigEndian());
                    int j = 0;
                    while (true) {
                        if (j >= peValues.length) {
                            this.soundBuffers[i] = Sound.resample(this.soundBuffers[i], currentFormat, this.format.getSampleRate(), this.resamplingQuality);
                            break;
                        }
                        if (this.effects.get((Object)peValues[j].getEffect()) == i) {
                            this.origPitchBuffers[j] = this.soundBuffers[i];
                            this.origPitchFormats[j] = currentFormat;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (IOException | UnsupportedAudioFileException ex) {
            throw new ResourceException(resource);
        }
        if (reloadPitched) {
            i = 0;
            while (i < peValues.length) {
                if (this.pitchedSampleID[i] >= 0) {
                    Sound.createPitched(peValues[i], this.origPitchFormats[i], this.format.getSampleRate(), this.resamplingQuality, this.origPitchBuffers[i], this.pitchBuffers[i]);
                } else {
                    this.pitchBuffers = null;
                }
                ++i;
            }
        }
        this.loaded = true;
    }

    public String[] getMixers() {
        if (mixers == null) {
            return null;
        }
        return (String[])mixers.stream().map(mixer -> mixer.getMixerInfo().getName()).toArray(String[]::new);
    }

    public synchronized void setMixerIdx(int idx) {
        int oldMixerIdx = mixerIdx;
        if (oldMixerIdx != (mixerIdx = idx < 0 || idx >= mixers.size() ? 0 : idx)) {
            LinkedList<LineHandler> tempLineHandlers = new LinkedList<LineHandler>();
            this.lineHandlers.stream().forEach(LineHandler::close);
            this.lineHandlers.clear();
            int i = 0;
            while (i < 7) {
                LineHandler lineHandler = new LineHandler((SourceDataLine)this.getLine(this.info), tempLineHandlers);
                tempLineHandlers.add(lineHandler);
                lineHandler.setGain(this.gain);
                lineHandler.start();
                this.lineHandlers.add(lineHandler);
                ++i;
            }
            this.availableLineHandlers = tempLineHandlers;
        }
    }

    public synchronized int getMixerIdx() {
        return mixerIdx;
    }

    public final Line getLine(DataLine.Info info) {
        try {
            return mixers.get(mixerIdx).getLine(info);
        }
        catch (LineUnavailableException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(int idx, double pan) {
        LineHandler lh;
        Deque<LineHandler> tempLineHandlers;
        if (idx < 0 || !GameController.isOptionEnabled(GameController.Option.SOUND_ON)) {
            return;
        }
        Deque<LineHandler> deque = tempLineHandlers = this.availableLineHandlers;
        synchronized (deque) {
            lh = tempLineHandlers.pollFirst();
            if (lh != null) {
                tempLineHandlers.addLast(lh);
            }
        }
        if (lh != null) {
            lh.play(this.soundBuffers[idx], pan);
        }
    }

    public void play(int idx) {
        this.play(idx, 0.0);
    }

    public void play(Effect e, double pan) {
        this.play(this.effects.get((Object)e), pan);
    }

    public void play(Effect e) {
        this.play(this.effects.get((Object)e), 0.0);
    }

    public void play(SpriteObject spr) {
        this.play(spr.getSound(), Sound.getPan(spr.midX()));
    }

    public void playVisualSFXSilent(int idx, int x, int y) {
        if (GameController.isOptionEnabled(GameController.SLTooOption.VISUAL_SFX) && idx >= 0 && idx < 28) {
            Vsfx v = new Vsfx(x, y, idx);
            GameController.addVsfx(v);
        }
    }

    public void playVisualSFXSilent(Effect e, int x, int y) {
        this.playVisualSFXSilent(this.effects.get((Object)e), x, y);
    }

    public void playVisualSFX(int idx, int x, int y) {
        this.play(idx, Sound.getPan(x));
        this.playVisualSFXSilent(idx, x, y);
    }

    public void playVisualSFX(int idx, Point xy) {
        this.playVisualSFX(idx, (int)xy.getX(), (int)xy.getY());
    }

    public void playVisualSFX(SpriteObject spr) {
        this.playVisualSFX(spr.getSound(), spr.midX(), spr.midY());
    }

    public void playVisualSFX(Effect e, int x, int y) {
        this.playVisualSFX(this.effects.get((Object)e), x, y);
    }

    public static double getPan(int x) {
        double panFactor = Core.getDrawWidth();
        double retPan = ((double)x - ((double)GameController.getXPos() + (double)Core.getDrawWidth() / 2.0)) / panFactor;
        return retPan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playPitched(PitchedEffect pe, int pitch) {
        LineHandler lh;
        Deque<LineHandler> tempLineHandlers;
        if (!GameController.isOptionEnabled(GameController.Option.SOUND_ON)) {
            return;
        }
        Deque<LineHandler> deque = tempLineHandlers = this.availableLineHandlers;
        synchronized (deque) {
            lh = tempLineHandlers.pollFirst();
            if (lh != null) {
                tempLineHandlers.addLast(lh);
            }
        }
        if (lh != null) {
            lh.play(this.pitchBuffers[pe.ordinal()][pitch], 0.0);
        }
    }

    public static byte[] resample(byte[] buffer, AudioFormat af, float newSampleRate, Quality quality) {
        int minValue;
        int maxValue;
        int origin;
        float sampleRate = af.getSampleRate();
        if (sampleRate == newSampleRate) {
            return buffer;
        }
        int sampleSize = af.getSampleSizeInBits();
        int frameSize = af.getFrameSize();
        int numChannels = af.getChannels();
        int bytesPerSample = frameSize / numChannels;
        int numFrames = buffer.length / frameSize;
        boolean bigEndian = af.isBigEndian();
        boolean signed = af.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        double scale = (double)newSampleRate / (double)af.getSampleRate();
        int n = origin = signed ? 0 : 1 << sampleSize - 1;
        if (signed) {
            maxValue = -((-1 << sampleSize - 1) + 1);
            minValue = -1 << sampleSize - 1;
        } else {
            maxValue = -((-1 << sampleSize) + 1);
            minValue = 0;
        }
        int newNumFrames = (int)((double)numFrames * scale);
        byte[] newBuffer = new byte[newNumFrames * frameSize];
        int f = 0;
        while (f < newNumFrames) {
            int c = 0;
            while (c < numChannels) {
                int newSample;
                double ofs;
                int pos = (int)((double)f / scale);
                if (pos >= numFrames) {
                    pos = numFrames - 1;
                }
                if ((ofs = (double)f / scale - (double)pos) < 0.0) {
                    ofs = 0.0;
                } else if (ofs > 1.0) {
                    ofs = 1.0;
                }
                int sample0 = 0;
                int sample1 = 0;
                int sample2 = 0;
                int sample3 = 0;
                int sb = 0;
                while (sb < bytesPerSample) {
                    boolean signBit = signed && sb == (bigEndian ? 0 : bytesPerSample - 1);
                    switch (quality) {
                        case CUBIC: {
                            sample0 = pos - 1 >= 0 ? (sample0 |= (buffer[(pos - 1) * frameSize + c * bytesPerSample + sb] & (signBit ? -1 : 255)) << 8 * (bigEndian ? bytesPerSample - 1 - sb : sb)) : origin;
                            sample3 = pos + 2 < numFrames ? (sample3 |= (buffer[(pos + 2) * frameSize + c * bytesPerSample + sb] & (signBit ? -1 : 255)) << 8 * (bigEndian ? bytesPerSample - 1 - sb : sb)) : origin;
                        }
                        default: {
                            if (pos + 1 < numFrames) {
                                sample2 |= (buffer[(pos + 1) * frameSize + c * bytesPerSample + sb] & (signBit ? -1 : 255)) << 8 * (bigEndian ? bytesPerSample - 1 - sb : sb);
                                break;
                            }
                            sample2 = origin;
                        }
                        case NEAREST: 
                    }
                    sample1 |= (buffer[pos * frameSize + c * bytesPerSample + sb] & (signBit ? -1 : 255)) << 8 * (bigEndian ? bytesPerSample - 1 - sb : sb);
                    ++sb;
                }
                switch (quality) {
                    case CUBIC: {
                        double a0 = -0.5 * (double)sample0 + 1.5 * (double)sample1 - 1.5 * (double)sample2 + 0.5 * (double)sample3;
                        double a1 = (double)sample0 - 2.5 * (double)sample1 + (double)(2 * sample2) - 0.5 * (double)sample3;
                        double a2 = -0.5 * (double)sample0 + 0.5 * (double)sample2;
                        double a3 = sample1;
                        newSample = ToolBox.roundToInt(a0 * Math.pow(ofs, 3.0) + a1 * Math.pow(ofs, 2.0) + a2 * ofs + a3);
                        newSample = ToolBox.cap(minValue, newSample, maxValue);
                        break;
                    }
                    default: {
                        newSample = ToolBox.roundToInt((double)sample1 + (double)(sample2 - sample1) * ofs);
                        break;
                    }
                    case NEAREST: {
                        newSample = sample1;
                    }
                }
                int sb2 = 0;
                while (sb2 < bytesPerSample) {
                    newBuffer[f * frameSize + c * numChannels + sb2] = (byte)(newSample >>> 8 * (bigEndian ? bytesPerSample - 1 - sb2 : sb2));
                    ++sb2;
                }
                ++c;
            }
            ++f;
        }
        return newBuffer;
    }

    public static byte[] convert(byte[] buffer, AudioFormat af, int newSampleSize, int newFrameSize, int newNumChannels, boolean newSigned, boolean newBigEndian) {
        int sampleSize = af.getSampleSizeInBits();
        int frameSize = af.getFrameSize();
        int numChannels = af.getChannels();
        boolean signed = af.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        boolean bigEndian = af.isBigEndian();
        if (signed == newSigned && sampleSize == newSampleSize && frameSize == newFrameSize && numChannels == newNumChannels && bigEndian == newBigEndian) {
            return buffer;
        }
        int numFrames = buffer.length / frameSize;
        int bytesPerSample = frameSize / numChannels;
        int newBytesPerSample = newFrameSize / newNumChannels;
        int origin = newSigned ? 0 : 1 << sampleSize - 1;
        int minChannels = Math.min(numChannels, newNumChannels);
        byte[] newBuffer = new byte[numFrames * newFrameSize];
        int[] oldSamples = new int[numChannels];
        int[] newSamples = new int[newNumChannels];
        Arrays.fill(newSamples, origin);
        int i = 0;
        while (i < numFrames) {
            int k;
            int j = 0;
            while (j < numChannels) {
                oldSamples[j] = 0;
                k = 0;
                while (k < bytesPerSample) {
                    boolean signBit = signed && k == (bigEndian ? 0 : bytesPerSample - 1);
                    int n = j;
                    oldSamples[n] = oldSamples[n] | (buffer[i * frameSize + j * bytesPerSample + k] & (signBit ? -1 : 255)) << 8 * (bigEndian ? bytesPerSample - 1 - k : k);
                    ++k;
                }
                if (!signed) {
                    int n = j;
                    oldSamples[n] = oldSamples[n] + (-1 << sampleSize - 1);
                }
                oldSamples[j] = oldSamples[j] << 32 - sampleSize >> 32 - newSampleSize;
                if (!newSigned) {
                    int n = j;
                    oldSamples[n] = oldSamples[n] - (-1 << sampleSize - 1);
                }
                ++j;
            }
            if (numChannels == 1 && newNumChannels >= 2) {
                newSamples[0] = oldSamples[0];
                newSamples[1] = oldSamples[0];
            } else if (numChannels >= 2 && newNumChannels == 1) {
                newSamples[0] = oldSamples[0] / 2 + oldSamples[1] / 2 + (oldSamples[0] % 2 + oldSamples[1] % 2) / 2;
            } else {
                System.arraycopy(oldSamples, 0, newSamples, 0, minChannels);
            }
            j = 0;
            while (j < newNumChannels) {
                k = 0;
                while (k < newBytesPerSample) {
                    newBuffer[i * newFrameSize + j * newBytesPerSample + k] = (byte)(newSamples[j] >>> 8 * (newBigEndian ? newBytesPerSample - 1 - k : k));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return newBuffer;
    }

    public static void createPitched(PitchedEffect pe, AudioFormat af, float newSampleRate, Quality quality, byte[] oldBuffer, byte[][] newBuffers) {
        int i = 0;
        while (i < pe.getNumPitches()) {
            double dpitch = Math.pow(pe.getBase(), ((double)i + pe.getExpNumeratorOffset()) / pe.getExpDenominator());
            float newSpeed = (float)((double)newSampleRate / dpitch);
            newBuffers[i] = Sound.resample(oldBuffer, af, newSpeed, quality);
            ++i;
        }
    }

    public static void setLineGain(Line line, double gn) {
        if (line != null) {
            try {
                FloatControl control = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                double maxGain = Math.pow(10.0, control.getMaximum() / 20.0f);
                double minGain = Math.pow(10.0, control.getMinimum() / 20.0f);
                if (gn < minGain) {
                    gn = minGain;
                } else if (gn > maxGain) {
                    gn = maxGain;
                }
                float fgain = 20.0f * (float)Math.log10(gn);
                control.setValue(fgain);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public double getGain() {
        return this.gain;
    }

    public void setGain(double gn) {
        this.gain = gn;
        this.lineHandlers.stream().forEach(lh -> lh.setGain(gn));
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Quality getResamplingQuality() {
        return this.resamplingQuality;
    }

    public static enum Effect {
        START("start"),
        CHANGE_RR("changeRR"),
        SELECT_SKILL("selectSkill"),
        ASSIGN_SKILL("assignSkill"),
        INVALID("invalid"),
        NUKE("nuke"),
        OHNO("ohno"),
        EXPLODE("explode"),
        SPLAT("splat"),
        DROWN("drown"),
        DIE("die"),
        STEEL("steel"),
        STEP_WARNING("stepWarning");

        private final String keyName;

        private Effect(String newKeyName) {
            this.keyName = newKeyName;
        }

        public String getKeyName() {
            return this.keyName;
        }
    }

    private class LineHandler
    implements Runnable,
    Closeable {
        private final SourceDataLine line;
        private final Deque<LineHandler> origDeque;
        private final int lineBufferSize;
        private double gain;
        private float pan;
        private byte[] nextBuffer;
        private boolean open;
        private final Thread lineThread;

        LineHandler(SourceDataLine line, Deque<LineHandler> origDeque) {
            this.line = line;
            this.origDeque = origDeque;
            this.lineBufferSize = Sound.this.info.getMaxBufferSize();
            this.gain = 1.0;
            this.pan = 0.0f;
            this.nextBuffer = null;
            this.open = false;
            StringBuilder stringBuilder = new StringBuilder("LineHandler-");
            int n = lineCounter;
            lineCounter = n + 1;
            this.lineThread = new Thread(null, this, stringBuilder.append(n).toString());
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void play(byte[] newBuffer, double newPan) {
            if (!this.open) {
                return;
            }
            LineHandler lineHandler = this;
            synchronized (lineHandler) {
                this.nextBuffer = newBuffer;
                this.pan = (float)ToolBox.cap(-1.0, newPan, 1.0);
                this.notifyAll();
            }
        }

        void start() {
            this.lineThread.start();
        }

        @Override
        public void close() {
            this.open = false;
            this.lineThread.interrupt();
        }

        void setGain(double gn) {
            this.gain = gn;
            if (this.line.isOpen()) {
                Sound.setLineGain(this.line, gn);
            }
        }

        private void setPan(float pan) {
            try {
                FloatControl control = (FloatControl)this.line.getControl(FloatControl.Type.PAN);
                control.setValue(pan);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static enum PitchedEffect {
        RELEASE_RATE(Effect.CHANGE_RR, 2.0, -100.0, 96.0, 269),
        SKILL(Effect.SELECT_SKILL, 2.0, -4.0, 12.0, 13);

        private final Effect effect;
        private final double base;
        private final double expNumeratorOffset;
        private final double expDenominator;
        private final int numPitches;

        private PitchedEffect(Effect newEffect, double newBase, double newExpNumeratorOffset, double newExpDenominator, int newNumPitches) {
            this.effect = newEffect;
            this.base = newBase;
            this.expNumeratorOffset = newExpNumeratorOffset;
            this.expDenominator = newExpDenominator;
            this.numPitches = newNumPitches;
        }

        private Effect getEffect() {
            return this.effect;
        }

        private double getBase() {
            return this.base;
        }

        private double getExpNumeratorOffset() {
            return this.expNumeratorOffset;
        }

        private double getExpDenominator() {
            return this.expDenominator;
        }

        private int getNumPitches() {
            return this.numPitches;
        }
    }

    public static enum Quality {
        NEAREST,
        LINEAR,
        CUBIC;

    }
}

