/*
 * Decompiled with CFR 0.152.
 */
package lemmini.sound;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lemmini.game.Core;
import lemmini.game.LemmException;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.sound.MidiMusic;
import lemmini.sound.ModMusic;
import lemmini.sound.MusicPlayer;
import lemmini.sound.WaveMusic;
import org.apache.commons.io.FilenameUtils;

public class Music {
    private static Type type;
    private static boolean playing;
    private static ModMusic modMusic;
    private static MidiMusic midiMusic;
    private static WaveMusic waveMusic;
    private static double gain;
    private static MusicPlayer musicPlayer;
    private static boolean midiAvailable;

    static {
        gain = 1.0;
    }

    public static void init() {
        type = Type.NONE;
        playing = false;
        modMusic = new ModMusic();
        waveMusic = new WaveMusic();
        try {
            midiMusic = new MidiMusic();
            midiAvailable = true;
        }
        catch (LemmException e) {
            midiAvailable = false;
        }
    }

    public static void load(String fName) throws ResourceException, LemmException {
        Music.close();
        playing = false;
        Resource resource = Core.findResource(fName, Core.MUSIC_EXTENSIONS);
        switch (FilenameUtils.getExtension(resource.getFileName()).toLowerCase(Locale.ROOT)) {
            case "mid": {
                if (!midiAvailable) {
                    throw new LemmException("MIDI not supported.");
                }
                musicPlayer = midiMusic;
                type = Type.MIDI;
                break;
            }
            case "xm": 
            case "mod": 
            case "s3m": {
                musicPlayer = modMusic;
                type = Type.MOD;
                break;
            }
            default: {
                musicPlayer = waveMusic;
                type = Type.WAVE;
            }
        }
        musicPlayer.load(resource, true);
    }

    public static String getRandomTrack(String style, String specialStyle) {
        List<String> musicList;
        if (!specialStyle.isEmpty()) {
            musicList = Core.searchForResources("music/special/", true, Core.MUSIC_EXTENSIONS);
            for (String music2 : musicList) {
                if (!specialStyle.toLowerCase(Locale.ROOT).equals(FilenameUtils.removeExtension(music2).toLowerCase(Locale.ROOT))) continue;
                return "special/" + music2;
            }
        }
        if (!style.isEmpty() && (musicList = Core.searchForResources("music/" + style + "/", true, Core.MUSIC_EXTENSIONS).stream().map(FilenameUtils::removeExtension).map(music -> music.toLowerCase(Locale.ROOT)).filter(music -> !music.endsWith("_intro")).distinct().collect(Collectors.toList())).size() > 0) {
            double r = Math.random() * (double)musicList.size();
            return String.valueOf(style) + "/" + musicList.get((int)r);
        }
        musicList = Core.searchForResources("music/", true, Core.MUSIC_EXTENSIONS).stream().map(FilenameUtils::removeExtension).map(music -> music.toLowerCase(Locale.ROOT)).filter(music -> !music.endsWith("_intro")).distinct().collect(Collectors.toList());
        double r = Math.random() * (double)musicList.size();
        return musicList.get((int)r);
    }

    public static void play() {
        if (musicPlayer != null) {
            musicPlayer.play();
            playing = true;
        }
    }

    public static void stop() {
        if (musicPlayer != null) {
            musicPlayer.stop();
        }
        playing = false;
    }

    public static void close() {
        if (musicPlayer != null) {
            musicPlayer.close();
        }
        playing = false;
    }

    public static boolean isPlaying() {
        return playing;
    }

    public static double getGain() {
        return gain;
    }

    public static void setGain(double gn) {
        gain = gn;
        if (musicPlayer != null) {
            musicPlayer.setGain(gain);
        }
    }

    public static Type getType() {
        return type;
    }

    public static enum Type {
        NONE,
        MIDI,
        MOD,
        WAVE;

    }
}

