/*
 * Decompiled with CFR 0.152.
 */
package lemmini.sound;

import ibxm.IBXM;
import ibxm.Module;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import lemmini.game.GameController;
import lemmini.game.LemmException;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.sound.Music;
import lemmini.sound.MusicPlayer;
import lemmini.sound.Sound;
import lemmini.tools.ToolBox;

public class ModMusic
implements Runnable,
MusicPlayer {
    private IBXM ibxm;
    private boolean loopSong;
    private boolean play;
    private Thread modThread;
    private SourceDataLine line;

    @Override
    public void load(Resource resource, boolean loop) throws ResourceException, LemmException {
        Module module;
        if (this.modThread != null) {
            this.close();
        }
        this.loopSong = loop;
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (InputStream songInputStream = resource.getInputStream();){
                module = new Module(songInputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            throw new ResourceException(resource);
        }
        catch (IOException ex) {
            throw new LemmException(String.valueOf(resource.getFileName()) + " (IO exception)");
        }
        int sampleRate = ToolBox.cap(8000, (int)GameController.sound.getSampleRate(), 128000);
        this.ibxm = new IBXM(module, sampleRate);
        switch (GameController.sound.getResamplingQuality()) {
            case CUBIC: {
                this.ibxm.setInterpolation(2);
                break;
            }
            default: {
                this.ibxm.setInterpolation(1);
                break;
            }
            case NEAREST: {
                this.ibxm.setInterpolation(0);
            }
        }
        this.modThread = new Thread(this);
        this.modThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block22: {
            try {
                af = new AudioFormat(this.ibxm.getSampleRate(), 16, 2, true, false);
                bufferSize = Math.max(GameController.sound.getBufferSize() / 2, this.ibxm.getMixBufferLength());
                if (bufferSize % 2 > 0) {
                    bufferSize += 2 - bufferSize % 2;
                }
                lineInfo = new DataLine.Info(SourceDataLine.class, af, bufferSize * 2);
                this.line = (SourceDataLine)GameController.sound.getLine(lineInfo);
                ibuf = new int[bufferSize];
                obuf = new byte[bufferSize * 2];
                this.line.open();
                this.line.start();
                this.setGain(Music.getGain());
                remain = songlen = this.ibxm.calculateSongDuration();
lbl15:
                // 4 sources

                while (true) {
                    block21: {
                        if (remain <= 0) return;
                        if (Thread.currentThread() != this.modThread) {
                            return;
                        }
                        if (!this.play) break block21;
                        count = this.ibxm.getAudio(ibuf);
                        if (count > remain) {
                            count = remain;
                        }
                        ix = 0;
                        if (true) ** GOTO lbl65
                    }
                    this.line.stop();
                    var8_10 = this;
                    synchronized (var8_10) {
                        while (true) {
                            if (this.play || Thread.currentThread() != this.modThread) {
                                break;
                            }
                            try {
                                this.wait();
                            }
                            catch (InterruptedException var9_12) {
                                // empty catch block
                            }
                        }
                    }
                    this.line.start();
                    continue;
                    break;
                }
            }
            catch (LineUnavailableException e) {
                e.printStackTrace();
                this.line.stop();
                this.line.flush();
                this.line.close();
                return;
            }
            finally {
                this.line.stop();
                this.line.flush();
                this.line.close();
            }
            do {
                ox = ix * 2;
                if (ibuf[ix] > 32767) {
                    ibuf[ix] = 32767;
                } else if (ibuf[ix] < -32768) {
                    ibuf[ix] = -32768;
                }
                obuf[ox] = (byte)ibuf[ix];
                obuf[ox + 1] = (byte)(ibuf[ix] >> 8);
                ++ix;
lbl65:
                // 2 sources

            } while (ix < count * 2);
            this.line.write(obuf, 0, count * 4);
            if ((remain -= count) != 0) ** GOTO lbl15
            if (!this.loopSong) break block22;
            remain = songlen;
            ** GOTO lbl15
        }
        this.line.drain();
        ** continue;
    }

    @Override
    public synchronized void stop() {
        this.play = false;
    }

    @Override
    public synchronized void play() {
        this.play = true;
        this.notifyAll();
    }

    @Override
    public void close() {
        if (this.modThread == null) {
            return;
        }
        this.stop();
        Thread moribund = this.modThread;
        this.modThread = null;
        try {
            moribund.interrupt();
            moribund.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void setGain(double gain) {
        if (gain > 2.0) {
            gain = 2.0;
        } else if (gain < 0.0) {
            gain = 0.0;
        }
        if (this.line != null) {
            Sound.setLineGain(this.line, gain);
        }
    }
}

