/*
 * Decompiled with CFR 0.152.
 */
package lemmini.sound;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.SysexMessage;
import javax.sound.midi.Track;
import javax.sound.midi.Transmitter;
import lemmini.game.Core;
import lemmini.game.LemmException;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.sound.Music;
import lemmini.sound.MusicPlayer;

public class MidiMusic
implements MusicPlayer {
    private Sequencer sequencer;
    private Synthesizer synthesizer;
    private Transmitter transmitter;
    private Receiver receiver;
    private boolean canPlay;
    private final byte[] gainSysexData = new byte[]{-16, 127, 127, 4, 1, 127, 127, -9};
    private final SysexMessage gainSysex = new SysexMessage();

    public MidiMusic() throws LemmException {
        try {
            this.canPlay = false;
            this.sequencer = MidiSystem.getSequencer(false);
            this.synthesizer = MidiSystem.getSynthesizer();
            if (this.sequencer == null || this.synthesizer == null) {
                throw new LemmException("MIDI not supported.");
            }
        }
        catch (MidiUnavailableException ex) {
            throw new LemmException("MIDI not supported.");
        }
    }

    @Override
    public void load(Resource resource, boolean loop) throws ResourceException, LemmException {
        this.close();
        try {
            Sequence mySeq;
            this.synthesizer = MidiSystem.getSynthesizer();
            this.transmitter = this.sequencer.getTransmitter();
            this.receiver = this.synthesizer.getReceiver();
            this.transmitter.setReceiver(this.receiver);
            this.sequencer.setLoopCount(-1);
            Throwable throwable = null;
            Object var5_5 = null;
            try (BufferedInputStream in = new BufferedInputStream(resource.getInputStream());){
                mySeq = MidiSystem.getSequence(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            Soundbank soundbank = MidiMusic.getSoundbank(resource);
            if (this.sequencer != null) {
                this.sequencer.setSequence(mySeq);
                if (loop) {
                    long[] loopPoints = MidiMusic.findLoopPoints(mySeq);
                    this.sequencer.setLoopStartPoint(loopPoints[0]);
                    this.sequencer.setLoopEndPoint(loopPoints[1]);
                    this.sequencer.setLoopCount(-1);
                }
                this.sequencer.open();
                this.synthesizer.open();
                if (soundbank != null && this.synthesizer.isSoundbankSupported(soundbank)) {
                    this.synthesizer.loadAllInstruments(soundbank);
                }
                this.setGain(Music.getGain());
                this.canPlay = true;
            }
        }
        catch (InvalidMidiDataException ex) {
            throw new LemmException(String.valueOf(resource.getFileName()) + " (Invalid MIDI data)");
        }
        catch (FileNotFoundException ex) {
            throw new ResourceException(resource);
        }
        catch (IOException ex) {
            throw new LemmException(String.valueOf(resource.getFileName()) + " (IO exception)");
        }
        catch (MidiUnavailableException ex) {
            throw new LemmException("MIDI not supported.");
        }
    }

    @Override
    public void play() {
        if (this.canPlay && this.sequencer != null) {
            this.sequencer.start();
        }
    }

    @Override
    public void stop() {
        if (this.canPlay && this.sequencer != null) {
            this.sequencer.stop();
        }
    }

    @Override
    public void close() {
        this.stop();
        if (this.sequencer != null) {
            this.sequencer.close();
        }
        if (this.synthesizer != null) {
            this.synthesizer.close();
        }
        this.canPlay = false;
    }

    @Override
    public void setGain(double gn) {
        if (this.synthesizer != null && this.receiver != null) {
            int gain = gn > 1.0 ? 16383 : (gn < 0.0 ? 0 : (int)(gn * 16383.0));
            byte gainLsb = (byte)(gain & 0x7F);
            byte gainMsb = (byte)(gain >> 7 & 0x7F);
            this.gainSysexData[5] = gainLsb;
            this.gainSysexData[6] = gainMsb;
            try {
                this.gainSysex.setMessage(this.gainSysexData, this.gainSysexData.length);
                this.receiver.send(this.gainSysex, -1L);
            }
            catch (InvalidMidiDataException invalidMidiDataException) {
                // empty catch block
            }
        }
    }

    private static long[] findLoopPoints(Sequence seq) throws InvalidMidiDataException {
        long loopStart = -1L;
        long loopEnd = -1L;
        long controller111Pos = -1L;
        Track[] tracks = seq.getTracks();
        int i = Math.min(tracks.length, 2) - 1;
        block8: while (i >= 0) {
            Track track = tracks[i];
            int j = track.size() - 1;
            while (j >= 0) {
                block19: {
                    ShortMessage sm;
                    MidiMessage mm;
                    MidiEvent me;
                    block18: {
                        String markerText;
                        me = track.get(j);
                        mm = me.getMessage();
                        if (!(mm instanceof MetaMessage)) break block18;
                        MetaMessage meta = (MetaMessage)mm;
                        if (meta.getType() != 6) break block19;
                        switch (markerText = new String(meta.getData(), StandardCharsets.US_ASCII)) {
                            case "loopStart": {
                                if (loopStart == -1L) {
                                    loopStart = me.getTick();
                                    break;
                                }
                                break block19;
                            }
                            case "loopEnd": {
                                if (loopEnd == -1L) {
                                    loopEnd = me.getTick();
                                    break;
                                }
                                break block19;
                            }
                        }
                        break block19;
                    }
                    if (mm instanceof ShortMessage && (sm = (ShortMessage)mm).getCommand() == 176 && sm.getData1() == 111 && controller111Pos == -1L) {
                        controller111Pos = me.getTick();
                    }
                }
                if (loopStart != -1L && loopEnd != -1L) break block8;
                --j;
            }
            --i;
        }
        if (loopStart < 0L) {
            loopStart = controller111Pos;
        }
        if (loopStart < 0L) {
            loopStart = 0L;
        }
        if (loopEnd < loopStart) {
            loopEnd = -1L;
        }
        return new long[]{loopStart, loopEnd};
    }

    private static Soundbank getSoundbank(Resource resource) {
        Resource resource2;
        block12: {
            resource2 = Core.findResource(resource.getOriginalPath(), Core.SOUNDBANK_EXTENSIONS);
            if (resource2 != null) break block12;
            return null;
        }
        try {
            Soundbank sb;
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedInputStream in = new BufferedInputStream(resource2.getInputStream());){
                sb = MidiSystem.getSoundbank(in);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return sb;
        }
        catch (IOException | InvalidMidiDataException | ResourceException ex) {
            return null;
        }
    }
}

