/*
 * Decompiled with CFR 0.152.
 */
package lemmini.gui;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import lemmini.LemminiFrame;
import lemmini.game.Core;

public class PlayerDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Vector<String> players;
    private JButton jButtonCancel;
    private JButton jButtonDelete;
    private JButton jButtonNew;
    private JButton jButtonOK;
    private JList<String> jListPlayers;
    private JScrollPane jScrollPanePlayers;

    public PlayerDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.jScrollPanePlayers = new JScrollPane();
        this.players = new Vector();
        int i = 0;
        while (i < Core.getPlayerCount()) {
            this.players.add(Core.getPlayer(i));
            ++i;
        }
        this.jListPlayers = new JList<String>(this.players);
        this.jListPlayers.setSelectedValue(Core.player.getName(), true);
        this.jButtonNew = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Manage Players");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LemminiFrame.class.getClassLoader().getResource("icon_256.png")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PlayerDialog.this.formWindowClosing(evt);
            }
        });
        this.jScrollPanePlayers.setViewportView(this.jListPlayers);
        this.jButtonNew.setText("New Player...");
        this.jButtonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerDialog.this.jButtonNewActionPerformed(evt);
            }
        });
        this.jButtonDelete.setText("Delete Selected Players");
        this.jButtonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerDialog.this.jButtonDeleteActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlayerDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPanePlayers).addGroup(layout.createSequentialGroup().addComponent(this.jButtonNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 112, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPanePlayers, -1, 149, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonNew).addComponent(this.jButtonDelete).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.players.clear();
        this.players = null;
    }

    private void jButtonNewActionPerformed(ActionEvent evt) {
        String player = JOptionPane.showInputDialog(LemminiFrame.getFrame(), "Enter Player Name", "Input", 3);
        if (player != null) {
            boolean found = false;
            for (String p : this.players) {
                if (!p.toLowerCase(Locale.ROOT).equals(player.toLowerCase(Locale.ROOT))) continue;
                player = p;
                found = true;
                break;
            }
            if (!found) {
                this.players.add(player);
                this.jListPlayers.setListData(this.players);
                int i = this.players.size() - 1;
                if (i >= 0) {
                    this.jListPlayers.setSelectedIndex(i);
                }
            }
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        int[] indices = this.jListPlayers.getSelectedIndices();
        int i = indices.length - 1;
        while (i >= 0) {
            int idx = indices[i];
            Core.deletePlayer(idx);
            this.players.remove(idx);
            --i;
        }
        this.jListPlayers.setListData(this.players);
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.players.clear();
        this.players = null;
        this.dispose();
    }

    public List<String> getPlayers() {
        return this.players;
    }

    public int getSelection() {
        return this.jListPlayers.getSelectedIndex();
    }
}

