/*
 * Decompiled with CFR 0.152.
 */
package lemmini.gui;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import lemmini.LemminiFrame;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.sound.Music;

public class OptionsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxAdvanced;
    private JCheckBox jCheckBoxBilinear;
    private JCheckBox jCheckBoxClassicCursor;
    private JCheckBox jCheckBoxEnableMusic;
    private JCheckBox jCheckBoxEnableSound;
    private JCheckBox jCheckBoxFaster;
    private JCheckBox jCheckBoxNoPercentages;
    private JCheckBox jCheckBoxPauseStopsFastForward;
    private JCheckBox jCheckBoxReplayScroll;
    private JCheckBox jCheckBoxSwap;
    private JCheckBox jCheckBoxUnpauseOnAssignment;
    private JCheckBox jCheckBoxTimedBombers;
    private JCheckBox jCheckBoxUnlockAllLevels;
    private JCheckBox jCheckBoxDisableScrollWheel;
    private JCheckBox jCheckBoxDisableFrameStepping;
    private JCheckBox jCheckBoxVisualSfx;
    private JCheckBox jCheckBoxEnhancedStatus;
    private JCheckBox jCheckBoxShowLevelName;
    private JCheckBox jCheckBoxEnhancedIconBar;
    private JCheckBox jCheckBoxIconLabels;
    private JCheckBox jCheckBoxFullColorMinimap;
    private JCheckBox jCheckBoxClassicScroller;
    private JCheckBox jCheckBoxShowMenuBar;
    private JCheckBox jCheckBoxAutoSaveReplays;
    private JComboBox<String> jComboBoxMixer;
    private JLabel jLabelMixer;
    private JLabel jLabelMusicVolume;
    private JLabel jLabelSoundVolume;
    private JLabel jLabelExitSound;
    private JRadioButton jRadioButtonYippee;
    private JRadioButton jRadioButtonBoing;
    private JRadioButton jRadioButtonAuto;
    private ButtonGroup exitSoundGroup;
    private JLabel jLabelMenuTheme;
    private JRadioButton jRadioButtonAmigaTheme;
    private JRadioButton jRadioButtonWinLemmTheme;
    private ButtonGroup menuThemeGroup;
    private JPanel jPanelGraphics;
    private JPanel jPanelClassicMode;
    private JPanel jPanelControlScheme;
    private JPanel jPanelMisc;
    private JPanel jPanelReplays;
    private JPanel jPanelSound;
    private JSlider jSliderMusicVolume;
    private JSlider jSliderSoundVolume;

    public OptionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.jPanelSound = new JPanel();
        this.jCheckBoxEnableMusic = new JCheckBox();
        this.jLabelMusicVolume = new JLabel();
        this.jSliderMusicVolume = new JSlider();
        this.jCheckBoxEnableSound = new JCheckBox();
        this.jLabelSoundVolume = new JLabel();
        this.jSliderSoundVolume = new JSlider();
        this.jLabelMixer = new JLabel();
        this.jComboBoxMixer = new JComboBox<String>(GameController.sound.getMixers());
        this.jLabelExitSound = new JLabel();
        this.jRadioButtonYippee = new JRadioButton();
        this.jRadioButtonBoing = new JRadioButton();
        this.jRadioButtonAuto = new JRadioButton();
        this.exitSoundGroup = new ButtonGroup();
        this.jLabelMenuTheme = new JLabel();
        this.jRadioButtonAmigaTheme = new JRadioButton();
        this.jRadioButtonWinLemmTheme = new JRadioButton();
        this.menuThemeGroup = new ButtonGroup();
        this.jPanelGraphics = new JPanel();
        this.jCheckBoxBilinear = new JCheckBox();
        this.jPanelClassicMode = new JPanel();
        this.jPanelControlScheme = new JPanel();
        this.jPanelMisc = new JPanel();
        this.jPanelReplays = new JPanel();
        this.jCheckBoxAdvanced = new JCheckBox();
        this.jCheckBoxClassicCursor = new JCheckBox();
        this.jCheckBoxSwap = new JCheckBox();
        this.jCheckBoxFaster = new JCheckBox();
        this.jCheckBoxPauseStopsFastForward = new JCheckBox();
        this.jCheckBoxNoPercentages = new JCheckBox();
        this.jCheckBoxReplayScroll = new JCheckBox();
        this.jCheckBoxUnpauseOnAssignment = new JCheckBox();
        this.jCheckBoxTimedBombers = new JCheckBox();
        this.jCheckBoxUnlockAllLevels = new JCheckBox();
        this.jCheckBoxDisableScrollWheel = new JCheckBox();
        this.jCheckBoxDisableFrameStepping = new JCheckBox();
        this.jCheckBoxVisualSfx = new JCheckBox();
        this.jCheckBoxEnhancedStatus = new JCheckBox();
        this.jCheckBoxShowLevelName = new JCheckBox();
        this.jCheckBoxEnhancedIconBar = new JCheckBox();
        this.jCheckBoxIconLabels = new JCheckBox();
        this.jCheckBoxFullColorMinimap = new JCheckBox();
        this.jCheckBoxClassicScroller = new JCheckBox();
        this.jCheckBoxShowMenuBar = new JCheckBox();
        this.jCheckBoxAutoSaveReplays = new JCheckBox();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Options");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LemminiFrame.class.getClassLoader().getResource("icon_256.png")));
        this.setResizable(false);
        this.jPanelSound.setBorder(BorderFactory.createTitledBorder(null, "Sound", 2, 0));
        this.jCheckBoxEnableMusic.setSelected(GameController.isOptionEnabled(GameController.Option.MUSIC_ON));
        this.jCheckBoxEnableMusic.setText("Enable Music");
        this.jLabelMusicVolume.setLabelFor(this.jSliderMusicVolume);
        this.jLabelMusicVolume.setText("Music Volume");
        this.jSliderMusicVolume.setMajorTickSpacing(10);
        this.jSliderMusicVolume.setMaximum(200);
        this.jSliderMusicVolume.setPaintTicks(true);
        this.jSliderMusicVolume.setValue((int)(100.0 * GameController.getMusicGain()));
        this.jCheckBoxEnableSound.setSelected(GameController.isOptionEnabled(GameController.Option.SOUND_ON));
        this.jCheckBoxEnableSound.setText("Enable Sound Effects");
        this.jLabelSoundVolume.setLabelFor(this.jSliderSoundVolume);
        this.jLabelSoundVolume.setText("Sound Volume");
        this.jSliderSoundVolume.setMajorTickSpacing(10);
        this.jSliderSoundVolume.setMaximum(200);
        this.jSliderSoundVolume.setPaintTicks(true);
        this.jSliderSoundVolume.setValue((int)(100.0 * GameController.getSoundGain()));
        this.jLabelMixer.setText("SFX Mixer");
        this.jCheckBoxVisualSfx.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.VISUAL_SFX));
        this.jCheckBoxVisualSfx.setText("Enable Visual SFX");
        this.jLabelExitSound.setText("Exit Sound");
        this.jRadioButtonYippee.setText("Yippee");
        this.jRadioButtonBoing.setText("Boing");
        this.jRadioButtonAuto.setText("Auto");
        this.exitSoundGroup.add(this.jRadioButtonYippee);
        this.exitSoundGroup.add(this.jRadioButtonBoing);
        this.exitSoundGroup.add(this.jRadioButtonAuto);
        GameController.ExitSoundOption exitSoundOption = GameController.getExitSoundOption();
        switch (exitSoundOption) {
            case YIPPEE: {
                this.jRadioButtonYippee.setSelected(true);
                break;
            }
            case BOING: {
                this.jRadioButtonBoing.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonAuto.setSelected(true);
            }
        }
        this.jCheckBoxEnhancedStatus.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_STATUS));
        this.jCheckBoxEnhancedStatus.setText("Enhanced Status Bar");
        this.jCheckBoxEnhancedStatus.addActionListener(e -> {
            boolean enabled = this.jCheckBoxEnhancedStatus.isSelected();
            this.jCheckBoxShowLevelName.setEnabled(enabled);
            if (!enabled) {
                this.jCheckBoxShowLevelName.setSelected(false);
            }
        });
        this.jCheckBoxShowLevelName.setEnabled(this.jCheckBoxEnhancedStatus.isSelected());
        this.jCheckBoxShowLevelName.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.SHOW_LEVEL_NAME));
        this.jCheckBoxShowLevelName.setText("Show Level Name on the Status Bar");
        this.jCheckBoxEnhancedIconBar.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR));
        this.jCheckBoxEnhancedIconBar.setText("Enhanced Icon Bar");
        this.jCheckBoxIconLabels.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.ICON_LABELS));
        this.jCheckBoxIconLabels.setText("Show Labels on the Icon Bar");
        this.jCheckBoxFullColorMinimap.setSelected(GameController.isOptionEnabled(GameController.RetroLemminiOption.FULL_COLOR_MINIMAP));
        this.jCheckBoxFullColorMinimap.setText("Full Color Minimap");
        this.jCheckBoxClassicScroller.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.CLASSIC_SCROLLER));
        this.jCheckBoxClassicScroller.setText("Classic Scroller");
        this.jCheckBoxClassicScroller.setToolTipText("Show the classic ticker tape scroller on the title screen");
        this.jCheckBoxShowMenuBar.setSelected(GameController.isOptionEnabled(GameController.RetroLemminiOption.SHOW_MENU_BAR));
        this.jCheckBoxShowMenuBar.setText("Show Menu Bar (Ctrl + M)");
        this.jCheckBoxShowMenuBar.setToolTipText("Show the menu bar at the top of the game window. Use Ctrl + M to toggle visibility at any time");
        this.jLabelMenuTheme.setText("Menu Theme");
        this.jRadioButtonAmigaTheme.setText("Amiga");
        this.jRadioButtonWinLemmTheme.setText("WinLemm");
        this.menuThemeGroup.add(this.jRadioButtonAmigaTheme);
        this.menuThemeGroup.add(this.jRadioButtonWinLemmTheme);
        GameController.MenuThemeOption menuThemeOption = GameController.getMenuThemeOption();
        switch (menuThemeOption) {
            case AMIGA: {
                this.jRadioButtonAmigaTheme.setSelected(true);
                break;
            }
            default: {
                this.jRadioButtonWinLemmTheme.setSelected(true);
            }
        }
        this.jComboBoxMixer.setSelectedIndex(GameController.sound.getMixerIdx());
        GroupLayout jPanelSoundLayout = new GroupLayout(this.jPanelSound);
        this.jPanelSound.setLayout(jPanelSoundLayout);
        jPanelSoundLayout.setHorizontalGroup(jPanelSoundLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSoundLayout.createSequentialGroup().addContainerGap().addGroup(jPanelSoundLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jCheckBoxEnableSound).addComponent(this.jCheckBoxEnableMusic).addComponent(this.jLabelMusicVolume).addComponent(this.jSliderMusicVolume, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelSoundVolume).addComponent(this.jSliderSoundVolume, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelMixer).addComponent(this.jComboBoxMixer, 0, -1, Short.MAX_VALUE).addComponent(this.jCheckBoxVisualSfx).addComponent(this.jLabelExitSound).addGroup(jPanelSoundLayout.createSequentialGroup().addComponent(this.jRadioButtonYippee).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonBoing).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonAuto))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelSoundLayout.setVerticalGroup(jPanelSoundLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelSoundLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxEnableMusic).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelMusicVolume).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderMusicVolume, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 40, 40).addComponent(this.jCheckBoxEnableSound).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxVisualSfx).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelSoundVolume).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderSoundVolume, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 40, 40).addComponent(this.jLabelMixer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxMixer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, 20, 20).addComponent(this.jLabelExitSound).addGroup(jPanelSoundLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonYippee).addComponent(this.jRadioButtonBoing).addComponent(this.jRadioButtonAuto)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelGraphics.setBorder(BorderFactory.createTitledBorder(null, "Graphics", 2, 0));
        this.jCheckBoxBilinear.setSelected(Core.isBilinear());
        this.jCheckBoxBilinear.setText("Bilinear Filtering");
        GroupLayout jPanelGraphicsLayout = new GroupLayout(this.jPanelGraphics);
        this.jPanelGraphics.setLayout(jPanelGraphicsLayout);
        jPanelGraphicsLayout.setHorizontalGroup(jPanelGraphicsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGraphicsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelGraphicsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxShowMenuBar).addComponent(this.jCheckBoxBilinear).addComponent(this.jCheckBoxClassicScroller).addComponent(this.jCheckBoxEnhancedStatus).addComponent(this.jCheckBoxShowLevelName).addComponent(this.jCheckBoxEnhancedIconBar).addComponent(this.jCheckBoxIconLabels).addComponent(this.jCheckBoxFullColorMinimap).addComponent(this.jLabelMenuTheme).addGroup(jPanelGraphicsLayout.createSequentialGroup().addComponent(this.jRadioButtonAmigaTheme).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButtonWinLemmTheme).addContainerGap(-1, Short.MAX_VALUE)))));
        jPanelGraphicsLayout.setVerticalGroup(jPanelGraphicsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelGraphicsLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxShowMenuBar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxBilinear).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxClassicScroller).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxEnhancedStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxShowLevelName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxEnhancedIconBar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxIconLabels).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxFullColorMinimap).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelMenuTheme).addGroup(jPanelGraphicsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButtonAmigaTheme).addComponent(this.jRadioButtonWinLemmTheme)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelReplays.setBorder(BorderFactory.createTitledBorder(null, "Replays", 2, 0));
        this.jCheckBoxAutoSaveReplays.setSelected(GameController.isOptionEnabled(GameController.RetroLemminiOption.AUTOSAVE_REPLAYS));
        this.jCheckBoxAutoSaveReplays.setText("Auto-Save Successful Replays");
        this.jCheckBoxAutoSaveReplays.setToolTipText("Automatically saves replays for succesfully-completed levels to 'resources/replays/'");
        GroupLayout jPanelReplaysLayout = new GroupLayout(this.jPanelReplays);
        this.jPanelReplays.setLayout(jPanelReplaysLayout);
        jPanelReplaysLayout.setHorizontalGroup(jPanelReplaysLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelReplaysLayout.createSequentialGroup().addContainerGap().addGroup(jPanelReplaysLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAutoSaveReplays)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelReplaysLayout.setVerticalGroup(jPanelReplaysLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelReplaysLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxAutoSaveReplays).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelClassicMode.setBorder(BorderFactory.createTitledBorder(null, "Classic Mode", 2, 0));
        this.jCheckBoxAdvanced.setSelected(GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT));
        this.jCheckBoxAdvanced.setText("Advanced Select");
        this.jCheckBoxAdvanced.setToolTipText("Hold directional keys to select only Lemmings going in that same direction. Hold Up to select only Walkers.");
        this.jCheckBoxTimedBombers.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.TIMED_BOMBERS));
        this.jCheckBoxTimedBombers.setText("Enable 5 second timed bombers");
        this.jCheckBoxDisableFrameStepping.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.DISABLE_FRAME_STEPPING));
        this.jCheckBoxDisableFrameStepping.setText("Disable Frame Stepping");
        this.jCheckBoxDisableFrameStepping.setToolTipText("Disable advancing the game by single frames when paused.");
        GroupLayout jPanelClassicModeLayout = new GroupLayout(this.jPanelClassicMode);
        this.jPanelClassicMode.setLayout(jPanelClassicModeLayout);
        jPanelClassicModeLayout.setHorizontalGroup(jPanelClassicModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelClassicModeLayout.createSequentialGroup().addContainerGap().addGroup(jPanelClassicModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxAdvanced).addComponent(this.jCheckBoxTimedBombers).addComponent(this.jCheckBoxDisableFrameStepping)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelClassicModeLayout.setVerticalGroup(jPanelClassicModeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelClassicModeLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxAdvanced).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxTimedBombers).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDisableFrameStepping).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelControlScheme.setBorder(BorderFactory.createTitledBorder(null, "Control Scheme", 2, 0));
        this.jCheckBoxClassicCursor.setSelected(GameController.isOptionEnabled(GameController.Option.CLASSIC_CURSOR));
        this.jCheckBoxClassicCursor.setText("Classic Cursor");
        this.jCheckBoxClassicCursor.setToolTipText("The Standard Cursor centers around the selected lemming. The Classic Cursor follows the mouse.");
        this.jCheckBoxSwap.setSelected(GameController.isOptionEnabled(GameController.Option.SWAP_BUTTONS));
        this.jCheckBoxSwap.setText("Swap Middle/Right Mouse Buttons");
        this.jCheckBoxSwap.setToolTipText("When disabled: Middle button drags the viewport, Right button only selects Walkers.");
        this.jCheckBoxFaster.setSelected(GameController.isOptionEnabled(GameController.Option.FASTER_FAST_FORWARD));
        this.jCheckBoxFaster.setText("Double Fast-Forward Speed");
        this.jCheckBoxFaster.setToolTipText("Standard Fast-Forward is 3x faster than normal. Doubled Fast-Forward is 6x faster than normal.");
        this.jCheckBoxPauseStopsFastForward.setSelected(GameController.isOptionEnabled(GameController.Option.PAUSE_STOPS_FAST_FORWARD));
        this.jCheckBoxPauseStopsFastForward.setText("Stop Fast-Forward When Pausing");
        this.jCheckBoxReplayScroll.setSelected(GameController.isOptionEnabled(GameController.Option.REPLAY_SCROLL));
        this.jCheckBoxReplayScroll.setText("Scroll Level During Replay");
        this.jCheckBoxUnpauseOnAssignment.setSelected(GameController.isOptionEnabled(GameController.Option.UNPAUSE_ON_ASSIGNMENT));
        this.jCheckBoxUnpauseOnAssignment.setText("Unpause After Assigning Skill");
        this.jCheckBoxDisableScrollWheel.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.DISABLE_SCROLL_WHEEL));
        this.jCheckBoxDisableScrollWheel.setText("Disable Scroll Wheel");
        this.jCheckBoxDisableScrollWheel.setToolTipText("Prevent the scroll wheel from changing the selected skill.");
        GroupLayout jPanelControlSchemeLayout = new GroupLayout(this.jPanelControlScheme);
        this.jPanelControlScheme.setLayout(jPanelControlSchemeLayout);
        jPanelControlSchemeLayout.setHorizontalGroup(jPanelControlSchemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelControlSchemeLayout.createSequentialGroup().addContainerGap().addGroup(jPanelControlSchemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxClassicCursor).addComponent(this.jCheckBoxSwap).addComponent(this.jCheckBoxDisableScrollWheel).addComponent(this.jCheckBoxFaster).addComponent(this.jCheckBoxPauseStopsFastForward).addComponent(this.jCheckBoxUnpauseOnAssignment).addComponent(this.jCheckBoxReplayScroll)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelControlSchemeLayout.setVerticalGroup(jPanelControlSchemeLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelControlSchemeLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxClassicCursor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxSwap).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxDisableScrollWheel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxFaster).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxPauseStopsFastForward).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxUnpauseOnAssignment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxReplayScroll).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelMisc.setBorder(BorderFactory.createTitledBorder(null, "Miscellaneous", 2, 0));
        this.jCheckBoxNoPercentages.setSelected(!GameController.isOptionEnabled(GameController.Option.NO_PERCENTAGES));
        this.jCheckBoxNoPercentages.setText("Use Percentage For Rescue Count");
        this.jCheckBoxUnlockAllLevels.setSelected(GameController.isOptionEnabled(GameController.SLTooOption.UNLOCK_ALL_LEVELS));
        this.jCheckBoxUnlockAllLevels.setText("Unlock all levels");
        this.jCheckBoxUnlockAllLevels.setToolTipText("All access to all levels, without having to complete previous ones.");
        GroupLayout jPanelMiscLayout = new GroupLayout(this.jPanelMisc);
        this.jPanelMisc.setLayout(jPanelMiscLayout);
        jPanelMiscLayout.setHorizontalGroup(jPanelMiscLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMiscLayout.createSequentialGroup().addContainerGap().addGroup(jPanelMiscLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxNoPercentages).addComponent(this.jCheckBoxUnlockAllLevels)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelMiscLayout.setVerticalGroup(jPanelMiscLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelMiscLayout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBoxNoPercentages).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxUnlockAllLevels).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonOK.setText("Save and Close");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OptionsDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel)).addGroup(layout.createSequentialGroup().addComponent(this.jPanelSound, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelGraphics, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelReplays, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelClassicMode, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelControlScheme, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelMisc, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelSound, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jPanelGraphics, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelReplays, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jPanelClassicMode, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelControlScheme, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelMisc, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.applyChanges();
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void applyChanges() {
        GameController.setOption(GameController.Option.MUSIC_ON, this.jCheckBoxEnableMusic.isSelected());
        if (GameController.getLevel() != null) {
            if (GameController.isOptionEnabled(GameController.Option.MUSIC_ON) && GameController.getGameState() == GameController.State.LEVEL) {
                Music.play();
            } else {
                Music.stop();
            }
        }
        GameController.setMusicGain((double)this.jSliderMusicVolume.getValue() / 100.0);
        GameController.setOption(GameController.Option.SOUND_ON, this.jCheckBoxEnableSound.isSelected());
        GameController.setSoundGain((double)this.jSliderSoundVolume.getValue() / 100.0);
        GameController.sound.setMixerIdx(this.jComboBoxMixer.getSelectedIndex());
        GameController.setExitSoundOption(this.jRadioButtonYippee.isSelected() ? GameController.ExitSoundOption.YIPPEE : (this.jRadioButtonBoing.isSelected() ? GameController.ExitSoundOption.BOING : GameController.ExitSoundOption.AUTO));
        Core.setBilinear(this.jCheckBoxBilinear.isSelected());
        GameController.setOption(GameController.Option.CLASSIC_CURSOR, this.jCheckBoxClassicCursor.isSelected());
        GameController.setOption(GameController.SLTooOption.ENHANCED_STATUS, this.jCheckBoxEnhancedStatus.isSelected());
        GameController.setOption(GameController.SLTooOption.SHOW_LEVEL_NAME, this.jCheckBoxShowLevelName.isSelected());
        GameController.setOption(GameController.SLTooOption.ENHANCED_ICONBAR, this.jCheckBoxEnhancedIconBar.isSelected());
        GameController.setOption(GameController.SLTooOption.ICON_LABELS, this.jCheckBoxIconLabels.isSelected());
        GameController.setOption(GameController.RetroLemminiOption.FULL_COLOR_MINIMAP, this.jCheckBoxFullColorMinimap.isSelected());
        GameController.setOption(GameController.SLTooOption.CLASSIC_SCROLLER, this.jCheckBoxClassicScroller.isSelected());
        GameController.setMenuThemeOption(this.jRadioButtonAmigaTheme.isSelected() ? GameController.MenuThemeOption.AMIGA : GameController.MenuThemeOption.WINLEMM);
        GameController.setOption(GameController.RetroLemminiOption.AUTOSAVE_REPLAYS, this.jCheckBoxAutoSaveReplays.isSelected());
        GameController.setOption(GameController.RetroLemminiOption.SHOW_MENU_BAR, this.jCheckBoxShowMenuBar.isSelected());
        GameController.setOption(GameController.Option.ADVANCED_SELECT, this.jCheckBoxAdvanced.isSelected());
        GameController.setOption(GameController.Option.SWAP_BUTTONS, this.jCheckBoxSwap.isSelected());
        GameController.setOption(GameController.Option.FASTER_FAST_FORWARD, this.jCheckBoxFaster.isSelected());
        GameController.setOption(GameController.Option.PAUSE_STOPS_FAST_FORWARD, this.jCheckBoxPauseStopsFastForward.isSelected());
        GameController.setOption(GameController.Option.NO_PERCENTAGES, !this.jCheckBoxNoPercentages.isSelected());
        GameController.setOption(GameController.Option.REPLAY_SCROLL, this.jCheckBoxReplayScroll.isSelected());
        GameController.setOption(GameController.Option.UNPAUSE_ON_ASSIGNMENT, this.jCheckBoxUnpauseOnAssignment.isSelected());
        GameController.setOption(GameController.SLTooOption.TIMED_BOMBERS, this.jCheckBoxTimedBombers.isSelected());
        GameController.setOption(GameController.SLTooOption.UNLOCK_ALL_LEVELS, this.jCheckBoxUnlockAllLevels.isSelected());
        GameController.setOption(GameController.SLTooOption.DISABLE_SCROLL_WHEEL, this.jCheckBoxDisableScrollWheel.isSelected());
        GameController.setOption(GameController.SLTooOption.DISABLE_FRAME_STEPPING, this.jCheckBoxDisableFrameStepping.isSelected());
        GameController.setOption(GameController.SLTooOption.VISUAL_SFX, this.jCheckBoxVisualSfx.isSelected());
        Core.saveSettings();
    }
}

