/*
 * Decompiled with CFR 0.152.
 */
package lemmini.gui;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lemmini.LemminiFrame;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.LevelInfo;
import lemmini.game.LevelPack;
import lemmini.game.LevelRecord;
import lemmini.gui.LevelItem;
import lemmini.tools.ToolBox;
import org.apache.commons.io.FilenameUtils;

public class LevelDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static Path lvlPath = Paths.get(".", new String[0]);
    private DefaultMutableTreeNode topNode = null;
    private DefaultTreeModel levelModel = null;
    private LevelItem selectedLevel = null;
    private int[] levelPackPositionLookup;
    private int[][] ratingPositionLookup;
    private int[][][] levelPositionLookup;
    private JButton jButtonAddExternalLevels;
    private JButton jButtonCancel;
    private JButton jButtonClearExternalLevels;
    private JButton jButtonOK;
    private JLabel jLabelAuthor;
    private JLabel jLabelExternalLevels;
    private JLabel jLabelLemmingsSaved;
    private JLabel jLabelNumBashers;
    private JLabel jLabelNumBlockers;
    private JLabel jLabelNumBombers;
    private JLabel jLabelNumBuilders;
    private JLabel jLabelNumClimbers;
    private JLabel jLabelNumDiggers;
    private JLabel jLabelNumFloaters;
    private JLabel jLabelNumLemmings;
    private JLabel jLabelNumMiners;
    private JLabel jLabelNumToRescue;
    private JLabel jLabelReleaseRate;
    private JLabel jLabelScore;
    private JLabel jLabelSkillsUsed;
    private JLabel jLabelTimeElapsed;
    private JLabel jLabelTimeLimit;
    private JPanel jPanelAuthor;
    private JPanel jPanelLevelInfo;
    private JPanel jPanelRecords;
    private JScrollPane jScrollPaneLevels;
    private JSeparator jSeparatorSkills;
    private JTextField jTextFieldAuthor;
    private JTextField jTextFieldLemmingsSaved;
    private JTextField jTextFieldNumBashers;
    private JTextField jTextFieldNumBlockers;
    private JTextField jTextFieldNumBombers;
    private JTextField jTextFieldNumBuilders;
    private JTextField jTextFieldNumClimbers;
    private JTextField jTextFieldNumDiggers;
    private JTextField jTextFieldNumFloaters;
    private JTextField jTextFieldNumLemmings;
    private JTextField jTextFieldNumMiners;
    private JTextField jTextFieldNumToRescue;
    private JTextField jTextFieldReleaseRate;
    private JTextField jTextFieldScore;
    private JTextField jTextFieldSkillsUsed;
    private JTextField jTextFieldTimeElapsed;
    private JTextField jTextFieldTimeLimit;
    private JTree jTreeLevels;

    public LevelDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setMinimumSize(this.getSize());
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.jScrollPaneLevels = new JScrollPane();
        this.topNode = new DefaultMutableTreeNode("Levels");
        this.levelModel = new DefaultTreeModel(this.topNode);
        this.refreshLevels();
        this.jTreeLevels = new JTree();
        this.jTreeLevels.getSelectionModel().setSelectionMode(1);
        this.jPanelAuthor = new JPanel();
        this.jLabelAuthor = new JLabel();
        this.jTextFieldAuthor = new JTextField();
        this.jPanelLevelInfo = new JPanel();
        this.jLabelNumLemmings = new JLabel();
        this.jTextFieldNumLemmings = new JTextField();
        this.jLabelNumToRescue = new JLabel();
        this.jTextFieldNumToRescue = new JTextField();
        this.jLabelReleaseRate = new JLabel();
        this.jTextFieldReleaseRate = new JTextField();
        this.jLabelTimeLimit = new JLabel();
        this.jTextFieldTimeLimit = new JTextField();
        this.jSeparatorSkills = new JSeparator();
        this.jLabelNumClimbers = new JLabel();
        this.jTextFieldNumClimbers = new JTextField();
        this.jLabelNumFloaters = new JLabel();
        this.jTextFieldNumFloaters = new JTextField();
        this.jLabelNumBombers = new JLabel();
        this.jTextFieldNumBombers = new JTextField();
        this.jLabelNumBlockers = new JLabel();
        this.jTextFieldNumBlockers = new JTextField();
        this.jLabelNumBuilders = new JLabel();
        this.jTextFieldNumBuilders = new JTextField();
        this.jLabelNumBashers = new JLabel();
        this.jTextFieldNumBashers = new JTextField();
        this.jLabelNumMiners = new JLabel();
        this.jTextFieldNumMiners = new JTextField();
        this.jLabelNumDiggers = new JLabel();
        this.jTextFieldNumDiggers = new JTextField();
        this.jPanelRecords = new JPanel();
        this.jLabelLemmingsSaved = new JLabel();
        this.jTextFieldLemmingsSaved = new JTextField();
        this.jLabelSkillsUsed = new JLabel();
        this.jTextFieldSkillsUsed = new JTextField();
        this.jLabelTimeElapsed = new JLabel();
        this.jTextFieldTimeElapsed = new JTextField();
        this.jLabelScore = new JLabel();
        this.jTextFieldScore = new JTextField();
        this.jLabelExternalLevels = new JLabel();
        this.jButtonAddExternalLevels = new JButton();
        this.jButtonClearExternalLevels = new JButton();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Select Level");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LemminiFrame.class.getClassLoader().getResource("icon_256.png")));
        this.jTreeLevels.setModel(this.levelModel);
        this.jTreeLevels.setRootVisible(false);
        this.jTreeLevels.setShowsRootHandles(true);
        this.jTreeLevels.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                LevelDialog.this.jTreeLevelsMousePressed(evt);
            }
        });
        this.jTreeLevels.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent evt) {
                LevelDialog.this.jTreeLevelsValueChanged(evt);
            }
        });
        this.jTreeLevels.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LevelDialog.this.jTreeLevelsKeyPressed(evt);
            }
        });
        this.jScrollPaneLevels.setViewportView(this.jTreeLevels);
        this.selectCurrentLevel();
        this.jLabelAuthor.setText("Author:");
        this.jTextFieldAuthor.setEditable(false);
        this.jTextFieldAuthor.setHighlighter(null);
        GroupLayout jPanelAuthorLayout = new GroupLayout(this.jPanelAuthor);
        this.jPanelAuthor.setLayout(jPanelAuthorLayout);
        jPanelAuthorLayout.setHorizontalGroup(jPanelAuthorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAuthorLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabelAuthor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldAuthor).addContainerGap()));
        jPanelAuthorLayout.setVerticalGroup(jPanelAuthorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelAuthorLayout.createSequentialGroup().addContainerGap().addGroup(jPanelAuthorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelAuthor).addComponent(this.jTextFieldAuthor, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelLevelInfo.setBorder(BorderFactory.createTitledBorder(null, "Level info", 2, 0));
        this.jLabelNumLemmings.setHorizontalAlignment(11);
        this.jLabelNumLemmings.setText("Number of Lemmings:");
        this.jTextFieldNumLemmings.setEditable(false);
        this.jTextFieldNumLemmings.setHighlighter(null);
        this.jLabelNumToRescue.setHorizontalAlignment(11);
        this.jLabelNumToRescue.setText("Lemmings to be saved:");
        this.jTextFieldNumToRescue.setEditable(false);
        this.jTextFieldNumToRescue.setHighlighter(null);
        this.jLabelReleaseRate.setHorizontalAlignment(11);
        this.jLabelReleaseRate.setText("Release rate:");
        this.jTextFieldReleaseRate.setEditable(false);
        this.jTextFieldReleaseRate.setHighlighter(null);
        this.jLabelTimeLimit.setHorizontalAlignment(11);
        this.jLabelTimeLimit.setText("Time limit:");
        this.jTextFieldTimeLimit.setEditable(false);
        this.jTextFieldTimeLimit.setHighlighter(null);
        this.jLabelNumClimbers.setHorizontalAlignment(11);
        this.jLabelNumClimbers.setText("Climbers:");
        this.jTextFieldNumClimbers.setEditable(false);
        this.jTextFieldNumClimbers.setHighlighter(null);
        this.jLabelNumFloaters.setHorizontalAlignment(11);
        this.jLabelNumFloaters.setText("Floaters:");
        this.jTextFieldNumFloaters.setEditable(false);
        this.jTextFieldNumFloaters.setHighlighter(null);
        this.jLabelNumBombers.setHorizontalAlignment(11);
        this.jLabelNumBombers.setText("Bombers:");
        this.jTextFieldNumBombers.setEditable(false);
        this.jTextFieldNumBombers.setHighlighter(null);
        this.jLabelNumBlockers.setHorizontalAlignment(11);
        this.jLabelNumBlockers.setText("Blockers:");
        this.jTextFieldNumBlockers.setEditable(false);
        this.jTextFieldNumBlockers.setHighlighter(null);
        this.jLabelNumBuilders.setHorizontalAlignment(11);
        this.jLabelNumBuilders.setText("Builders:");
        this.jTextFieldNumBuilders.setEditable(false);
        this.jTextFieldNumBuilders.setHighlighter(null);
        this.jLabelNumBashers.setHorizontalAlignment(11);
        this.jLabelNumBashers.setText("Bashers:");
        this.jTextFieldNumBashers.setEditable(false);
        this.jTextFieldNumBashers.setHighlighter(null);
        this.jLabelNumMiners.setHorizontalAlignment(11);
        this.jLabelNumMiners.setText("Miners:");
        this.jTextFieldNumMiners.setEditable(false);
        this.jTextFieldNumMiners.setHighlighter(null);
        this.jLabelNumDiggers.setHorizontalAlignment(11);
        this.jLabelNumDiggers.setText("Diggers:");
        this.jTextFieldNumDiggers.setEditable(false);
        this.jTextFieldNumDiggers.setHighlighter(null);
        GroupLayout jPanelLevelInfoLayout = new GroupLayout(this.jPanelLevelInfo);
        this.jPanelLevelInfo.setLayout(jPanelLevelInfoLayout);
        jPanelLevelInfoLayout.setHorizontalGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLevelInfoLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparatorSkills).addGroup(jPanelLevelInfoLayout.createSequentialGroup().addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelReleaseRate, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelNumLemmings, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelTimeLimit, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelNumToRescue, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldTimeLimit, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldReleaseRate, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldNumToRescue, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldNumLemmings, GroupLayout.Alignment.TRAILING, -2, 50, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanelLevelInfoLayout.createSequentialGroup().addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelNumDiggers, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelNumMiners, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelNumBashers, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelNumBuilders, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelNumBlockers, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelNumBombers, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelNumFloaters, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelNumClimbers, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldNumClimbers, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldNumFloaters, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldNumBombers, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldNumBlockers, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldNumBuilders, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldNumBashers, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldNumMiners, GroupLayout.Alignment.TRAILING, -2, 50, -2).addComponent(this.jTextFieldNumDiggers, GroupLayout.Alignment.TRAILING, -2, 50, -2)))).addContainerGap()));
        jPanelLevelInfoLayout.setVerticalGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelLevelInfoLayout.createSequentialGroup().addContainerGap().addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumLemmings).addComponent(this.jTextFieldNumLemmings, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumToRescue).addComponent(this.jTextFieldNumToRescue, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelReleaseRate).addComponent(this.jTextFieldReleaseRate, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTimeLimit).addComponent(this.jTextFieldTimeLimit, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparatorSkills, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumClimbers).addComponent(this.jTextFieldNumClimbers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumFloaters).addComponent(this.jTextFieldNumFloaters, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumBombers).addComponent(this.jTextFieldNumBombers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumBlockers).addComponent(this.jTextFieldNumBlockers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumBuilders).addComponent(this.jTextFieldNumBuilders, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumBashers).addComponent(this.jTextFieldNumBashers, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumMiners).addComponent(this.jTextFieldNumMiners, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelLevelInfoLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelNumDiggers).addComponent(this.jTextFieldNumDiggers, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanelRecords.setBorder(BorderFactory.createTitledBorder(null, "Records", 2, 0));
        this.jLabelLemmingsSaved.setHorizontalAlignment(11);
        this.jLabelLemmingsSaved.setText("Most Lemmings saved:");
        this.jTextFieldLemmingsSaved.setEditable(false);
        this.jTextFieldLemmingsSaved.setHighlighter(null);
        this.jLabelSkillsUsed.setHorizontalAlignment(11);
        this.jLabelSkillsUsed.setText("Fewest skills used:");
        this.jTextFieldSkillsUsed.setEditable(false);
        this.jTextFieldSkillsUsed.setHighlighter(null);
        this.jLabelTimeElapsed.setHorizontalAlignment(11);
        this.jLabelTimeElapsed.setText("Best time (elapsed):");
        this.jTextFieldTimeElapsed.setEditable(false);
        this.jTextFieldTimeElapsed.setHighlighter(null);
        this.jLabelScore.setHorizontalAlignment(11);
        this.jLabelScore.setText("Highest score:");
        this.jTextFieldScore.setEditable(false);
        this.jTextFieldScore.setHighlighter(null);
        GroupLayout jPanelRecordsLayout = new GroupLayout(this.jPanelRecords);
        this.jPanelRecords.setLayout(jPanelRecordsLayout);
        jPanelRecordsLayout.setHorizontalGroup(jPanelRecordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRecordsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelRecordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelScore, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelTimeElapsed, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelSkillsUsed, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelLemmingsSaved, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelRecordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jTextFieldScore, -1, 60, Short.MAX_VALUE).addComponent(this.jTextFieldTimeElapsed).addComponent(this.jTextFieldSkillsUsed).addComponent(this.jTextFieldLemmingsSaved)).addContainerGap()));
        jPanelRecordsLayout.setVerticalGroup(jPanelRecordsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelRecordsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelRecordsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelLemmingsSaved).addComponent(this.jTextFieldLemmingsSaved, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelRecordsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelSkillsUsed).addComponent(this.jTextFieldSkillsUsed, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelRecordsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelTimeElapsed).addComponent(this.jTextFieldTimeElapsed, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanelRecordsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelScore).addComponent(this.jTextFieldScore, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jLabelExternalLevels.setText("External Levels:");
        this.jButtonAddExternalLevels.setText("Add...");
        this.jButtonAddExternalLevels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelDialog.this.jButtonAddExternalLevelsActionPerformed(evt);
            }
        });
        this.jButtonClearExternalLevels.setText("Clear");
        this.jButtonClearExternalLevels.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelDialog.this.jButtonClearExternalLevelsActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPaneLevels).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.jPanelLevelInfo, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelRecords, -2, -1, -2)).addComponent(this.jPanelAuthor, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.jLabelExternalLevels).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAddExternalLevels).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonClearExternalLevels).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 455, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanelAuthor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelLevelInfo, -2, -1, -2).addComponent(this.jPanelRecords, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPaneLevels)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelExternalLevels).addComponent(this.jButtonAddExternalLevels).addComponent(this.jButtonClearExternalLevels).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jTreeLevelsKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            TreePath selPath = this.jTreeLevels.getSelectionPath();
            Object[] selPathArray = selPath.getPath();
            if (selPathArray.length >= 4) {
                this.selectedLevel = (LevelItem)((DefaultMutableTreeNode)selPathArray[3]).getUserObject();
                this.dispose();
            } else if (this.jTreeLevels.isExpanded(selPath)) {
                this.jTreeLevels.collapsePath(selPath);
            } else {
                this.jTreeLevels.expandPath(selPath);
            }
        }
    }

    private void jTreeLevelsMousePressed(MouseEvent evt) {
        Object[] selPathArray;
        TreePath selPath;
        if (evt.getClickCount() == 2 && (selPath = this.jTreeLevels.getPathForLocation(evt.getX(), evt.getY())) != null && (selPathArray = selPath.getPath()).length >= 4) {
            this.selectedLevel = (LevelItem)((DefaultMutableTreeNode)selPathArray[3]).getUserObject();
            this.dispose();
        }
    }

    private void jTreeLevelsValueChanged(TreeSelectionEvent evt) {
        this.fillInInfo();
    }

    private void jButtonAddExternalLevelsActionPerformed(ActionEvent evt) {
        List<Path> externLvls = ToolBox.getFileNames(this, lvlPath, true, true, Core.LEVEL_EXTENSIONS);
        if (externLvls != null) {
            if (!externLvls.isEmpty()) {
                lvlPath = externLvls.get(0).getParent();
            }
            int[] lastLevelPosition = null;
            for (Path externLvl : externLvls) {
                if (Files.isDirectory(externLvl, new LinkOption[0])) {
                    try {
                        Throwable throwable = null;
                        Object var7_9 = null;
                        try (DirectoryStream<Path> stream = Files.newDirectoryStream(externLvl, entry -> {
                            String extension = FilenameUtils.getExtension(entry.toString()).toLowerCase(Locale.ROOT);
                            return extension.equals("ini") || extension.equals("lvl") || extension.equals("dat");
                        });){
                            for (Path lvl : stream) {
                                int[] levelPosition = GameController.addExternalLevel(lvl, null, false);
                                if (levelPosition == null) continue;
                                lastLevelPosition = levelPosition;
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                int[] levelPosition = GameController.addExternalLevel(externLvl, null, false);
                if (levelPosition == null) continue;
                lastLevelPosition = levelPosition;
            }
            if (lastLevelPosition != null) {
                this.refreshLevels();
                this.levelModel.reload();
                this.selectLevel((int)lastLevelPosition[0], (int)lastLevelPosition[1], (int)lastLevelPosition[2]);
            } else {
                JOptionPane.showMessageDialog(this, "No valid level files were loaded.", "Load Level", 0);
            }
        }
    }

    private void jButtonClearExternalLevelsActionPerformed(ActionEvent evt) {
        GameController.clearExternalLevelList();
        this.refreshLevels();
        this.levelModel.reload();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        TreePath selPath = this.jTreeLevels.getSelectionPath();
        Object[] selPathArray = selPath.getPath();
        if (selPathArray.length >= 4) {
            this.selectedLevel = (LevelItem)((DefaultMutableTreeNode)selPathArray[3]).getUserObject();
        }
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public int[] getSelectedLevel() {
        int[] retArray = null;
        if (this.selectedLevel != null) {
            retArray = new int[]{this.selectedLevel.levelPack, this.selectedLevel.rating, this.selectedLevel.levelIndex};
        }
        return retArray;
    }

    private void refreshLevels() {
        this.topNode.removeAllChildren();
        int levelPackCount = GameController.getLevelPackCount();
        this.levelPackPositionLookup = new int[levelPackCount];
        this.ratingPositionLookup = new int[levelPackCount][];
        this.levelPositionLookup = new int[levelPackCount][][];
        int i = 0;
        int ia = 0;
        while (i < levelPackCount) {
            LevelPack lp = GameController.getLevelPack(i);
            DefaultMutableTreeNode lpNode = new DefaultMutableTreeNode();
            List<String> ratings = lp.getRatings();
            this.ratingPositionLookup[i] = new int[ratings.size()];
            this.levelPositionLookup[i] = new int[ratings.size()][];
            boolean packCompleted = true;
            int ja = 0;
            ListIterator<String> lit = ratings.listIterator();
            while (lit.hasNext()) {
                int j = lit.nextIndex();
                String rating = lit.next();
                DefaultMutableTreeNode ratingNode = new DefaultMutableTreeNode();
                List<String> levels = lp.getLevels(j);
                this.levelPositionLookup[i][j] = new int[levels.size()];
                boolean ratingCompleted = true;
                int ka = 0;
                ListIterator<String> lit2 = levels.listIterator();
                while (lit2.hasNext()) {
                    int k = lit2.nextIndex();
                    String level = lit2.next();
                    if (lp.getAllLevelsUnlocked() || Core.player.isAvailable(lp.getName(), rating, k)) {
                        LevelItem levelItem = new LevelItem(i, j, k, level, Core.player.getLevelRecord(lp.getName(), rating, k).isCompleted());
                        DefaultMutableTreeNode levelNode = new DefaultMutableTreeNode(levelItem, false);
                        ratingNode.add(levelNode);
                        this.levelPositionLookup[i][j][k] = ka++;
                        if (levelItem.completed) continue;
                        ratingCompleted = false;
                        continue;
                    }
                    this.levelPositionLookup[i][j][k] = -1;
                    ratingCompleted = false;
                }
                if (ratingCompleted) {
                    rating = String.valueOf(rating) + " (completed)";
                } else {
                    packCompleted = false;
                }
                ratingNode.setUserObject(rating);
                if (ratingNode.getChildCount() > 0) {
                    lpNode.add(ratingNode);
                    this.ratingPositionLookup[i][j] = ja++;
                    continue;
                }
                this.ratingPositionLookup[i][j] = -1;
            }
            lpNode.setUserObject(String.valueOf(lp.getName()) + (packCompleted ? " (completed)" : ""));
            if (lpNode.getChildCount() > 0) {
                this.topNode.add(lpNode);
                this.levelPackPositionLookup[i] = ia++;
            } else {
                this.levelPackPositionLookup[i] = -1;
            }
            ++i;
        }
    }

    private void selectLevel(int lp, int rating, int level) {
        if (lp < 0 || lp >= this.levelPackPositionLookup.length || rating < 0 || rating >= this.ratingPositionLookup[lp].length || level < 0 || level >= this.levelPositionLookup[lp][rating].length) {
            return;
        }
        int newLp = this.levelPackPositionLookup[lp];
        int newRating = this.ratingPositionLookup[lp][rating];
        int newLevel = this.levelPositionLookup[lp][rating][level];
        if (newLp >= 0 && newRating >= 0 && newLevel >= 0) {
            Object[] selPathArray = new Object[4];
            TreeNode lpNode = this.topNode.getChildAt(newLp);
            TreeNode ratingNode = lpNode.getChildAt(newRating);
            TreeNode levelNode = ratingNode.getChildAt(newLevel);
            selPathArray[0] = this.topNode;
            selPathArray[1] = lpNode;
            selPathArray[2] = ratingNode;
            selPathArray[3] = levelNode;
            this.jTreeLevels.setSelectionPath(new TreePath(selPathArray));
        }
        this.fillInInfo();
        this.jTreeLevels.scrollPathToVisible(this.jTreeLevels.getSelectionPath());
    }

    private void selectCurrentLevel() {
        GameController.State state = GameController.getGameState();
        if (state == GameController.State.BRIEFING || state == GameController.State.LEVEL || state == GameController.State.LEVEL_END || state == GameController.State.DEBRIEFING) {
            this.selectLevel(GameController.getCurLevelPackIdx(), GameController.getCurRating(), GameController.getCurLevelNumber());
            this.jButtonOK.setEnabled(true);
        }
    }

    private void fillInInfo() {
        TreePath selPath = this.jTreeLevels.getSelectionPath();
        if (selPath != null && selPath.getPathCount() >= 4) {
            LevelItem lvlItem = (LevelItem)((DefaultMutableTreeNode)selPath.getPath()[3]).getUserObject();
            LevelPack lvlPack = GameController.getLevelPack(lvlItem.levelPack);
            LevelInfo lvlInfo = lvlPack.getInfo(lvlItem.rating, lvlItem.levelIndex);
            LevelRecord lvlRecord = Core.player.getLevelRecord(lvlPack.getName(), lvlPack.getRatings().get(lvlItem.rating), lvlItem.levelIndex);
            this.jTextFieldAuthor.setText(lvlInfo.getAuthor());
            int numLemmings = lvlInfo.getNumLemmings();
            int numToRescue = lvlInfo.getNumToRescue();
            int timeLimit = lvlInfo.getTimeLimit();
            this.jTextFieldNumLemmings.setText(Integer.toString(numLemmings));
            if (GameController.isOptionEnabled(GameController.Option.NO_PERCENTAGES) || numLemmings > 100) {
                this.jTextFieldNumToRescue.setText(Integer.toString(numToRescue));
            } else {
                this.jTextFieldNumToRescue.setText(String.valueOf(Integer.toString(numToRescue * 100 / numLemmings)) + "%");
            }
            this.jTextFieldReleaseRate.setText(Integer.toString(lvlInfo.getReleaseRate()));
            if (timeLimit <= 0) {
                this.jTextFieldTimeLimit.setText("None");
            } else {
                this.jTextFieldTimeLimit.setText(String.format("%d:%02d", timeLimit / 60, timeLimit % 60));
            }
            this.jTextFieldNumClimbers.setText(ToolBox.intToString(lvlInfo.getNumClimbers(), true));
            this.jTextFieldNumFloaters.setText(ToolBox.intToString(lvlInfo.getNumFloaters(), true));
            this.jTextFieldNumBombers.setText(ToolBox.intToString(lvlInfo.getNumBombers(), true));
            this.jTextFieldNumBlockers.setText(ToolBox.intToString(lvlInfo.getNumBlockers(), true));
            this.jTextFieldNumBuilders.setText(ToolBox.intToString(lvlInfo.getNumBuilders(), true));
            this.jTextFieldNumBashers.setText(ToolBox.intToString(lvlInfo.getNumBashers(), true));
            this.jTextFieldNumMiners.setText(ToolBox.intToString(lvlInfo.getNumMiners(), true));
            this.jTextFieldNumDiggers.setText(ToolBox.intToString(lvlInfo.getNumDiggers(), true));
            if (lvlRecord.isCompleted()) {
                int lemmingsSaved = lvlRecord.getLemmingsSaved();
                int timeElapsed = lvlRecord.getTimeElapsed();
                if (GameController.isOptionEnabled(GameController.Option.NO_PERCENTAGES) || numLemmings > 100) {
                    this.jTextFieldLemmingsSaved.setText(Integer.toString(lvlRecord.getLemmingsSaved()));
                } else {
                    this.jTextFieldLemmingsSaved.setText(String.valueOf(Integer.toString(lemmingsSaved * 100 / numLemmings)) + "%");
                }
                this.jTextFieldSkillsUsed.setText(Integer.toString(lvlRecord.getSkillsUsed()));
                this.jTextFieldTimeElapsed.setText(String.format("%d:%02d", timeElapsed / 60, timeElapsed % 60));
                this.jTextFieldScore.setText(Integer.toString(lvlRecord.getScore()));
            } else {
                this.jTextFieldLemmingsSaved.setText("");
                this.jTextFieldSkillsUsed.setText("");
                this.jTextFieldTimeElapsed.setText("");
                this.jTextFieldScore.setText("");
            }
            this.jButtonOK.setEnabled(true);
        } else {
            this.jTextFieldAuthor.setText("");
            this.jTextFieldNumLemmings.setText("");
            this.jTextFieldNumToRescue.setText("");
            this.jTextFieldReleaseRate.setText("");
            this.jTextFieldTimeLimit.setText("");
            this.jTextFieldNumClimbers.setText("");
            this.jTextFieldNumFloaters.setText("");
            this.jTextFieldNumBombers.setText("");
            this.jTextFieldNumBlockers.setText("");
            this.jTextFieldNumBuilders.setText("");
            this.jTextFieldNumBashers.setText("");
            this.jTextFieldNumMiners.setText("");
            this.jTextFieldNumDiggers.setText("");
            this.jTextFieldLemmingsSaved.setText("");
            this.jTextFieldSkillsUsed.setText("");
            this.jTextFieldTimeElapsed.setText("");
            this.jTextFieldScore.setText("");
            this.jButtonOK.setEnabled(false);
        }
    }
}

