/*
 * Decompiled with CFR 0.152.
 */
package lemmini.gui;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import lemmini.LemminiFrame;
import lemmini.game.GameController;

public class LevelCodeDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private String[] levelPacks;
    private int levelPackIndex;
    private String code;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox<String> jComboBoxLvlPack;
    private JLabel jLabelCode;
    private JLabel jLabelLvlPack;
    private JTextField jTextFieldCode;

    public LevelCodeDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setLocationRelativeTo(parent);
    }

    private void initComponents() {
        this.jLabelLvlPack = new JLabel();
        this.levelPacks = new String[GameController.getLevelPackCount() - 1];
        int i = 0;
        while (i < this.levelPacks.length) {
            this.levelPacks[i] = GameController.getLevelPack(i + 1).getName();
            ++i;
        }
        this.levelPackIndex = GameController.getCurLevelPackIdx();
        if (this.levelPackIndex == 0) {
            this.levelPackIndex = 1;
        }
        this.jComboBoxLvlPack = new JComboBox<String>(this.levelPacks);
        this.jLabelCode = new JLabel();
        this.jTextFieldCode = new JTextField();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Enter Level Code");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LemminiFrame.class.getClassLoader().getResource("icon_256.png")));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LevelCodeDialog.this.formWindowClosing(evt);
            }
        });
        this.jLabelLvlPack.setLabelFor(this.jComboBoxLvlPack);
        this.jLabelLvlPack.setText("Choose Level Pack:");
        this.jComboBoxLvlPack.setSelectedIndex(this.levelPackIndex - 1);
        this.jLabelCode.setLabelFor(this.jTextFieldCode);
        this.jLabelCode.setText("Enter Level Code:");
        this.jTextFieldCode.setCursor(new Cursor(2));
        this.jTextFieldCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelCodeDialog.this.jTextFieldCodeActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelCodeDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LevelCodeDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBoxLvlPack, 0, -1, Short.MAX_VALUE).addComponent(this.jTextFieldCode).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelLvlPack).addComponent(this.jLabelCode)).addGap(0, 187, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabelLvlPack).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBoxLvlPack, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabelCode).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldCode, -2, -1, -2).addGap(18, 18, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.code = null;
        this.levelPackIndex = -1;
    }

    private void jTextFieldCodeActionPerformed(ActionEvent evt) {
        this.code = this.jTextFieldCode.getText();
        this.levelPackIndex = this.jComboBoxLvlPack.getSelectedIndex() + 1;
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.code = this.jTextFieldCode.getText();
        this.levelPackIndex = this.jComboBoxLvlPack.getSelectedIndex() + 1;
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.code = null;
        this.levelPackIndex = -1;
        this.dispose();
    }

    public String getCode() {
        return this.code;
    }

    public int getLevelPack() {
        return this.levelPackIndex;
    }
}

