/*
 * Decompiled with CFR 0.152.
 */
package lemmini.gui;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import lemmini.LemminiFrame;

public class LegalFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private boolean ok = false;
    private URL thisURL;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JEditorPane jEditorPaneLegal;
    private JScrollPane jScrollPaneLegal;

    public LegalFrame() {
        this.initComponents();
        this.setMinimumSize(this.getSize());
    }

    private void initComponents() {
        this.jScrollPaneLegal = new JScrollPane();
        this.jEditorPaneLegal = new JEditorPane();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("RetroLemmini - Disclaimer");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(LemminiFrame.class.getClassLoader().getResource("icon_256.png")));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                LegalFrame.this.formWindowClosed(evt);
            }
        });
        ClassLoader loader = LegalFrame.class.getClassLoader();
        this.thisURL = loader.getResource("disclaimer.htm");
        this.jEditorPaneLegal.setEditable(false);
        try {
            this.jEditorPaneLegal.setPage(this.thisURL);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.jEditorPaneLegal.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                LegalFrame.this.jEditorPaneLegalHyperlinkUpdate(evt);
            }
        });
        this.jScrollPaneLegal.setViewportView(this.jEditorPaneLegal);
        this.jButtonOK.setText("I agree");
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegalFrame.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("I disagree");
        this.jButtonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LegalFrame.this.jButtonCancelActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPaneLegal, -2, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 466, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPaneLegal, -1, 421, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOK).addComponent(this.jButtonCancel)).addContainerGap()));
        this.pack();
        this.setLocationRelativeTo(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formWindowClosed(WindowEvent evt) {
        LegalFrame legalFrame = this;
        synchronized (legalFrame) {
            this.notifyAll();
        }
    }

    private void jEditorPaneLegalHyperlinkUpdate(HyperlinkEvent evt) {
        block10: {
            URL url = evt.getURL();
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    if (url.sameFile(this.thisURL)) {
                        this.jEditorPaneLegal.setPage(url);
                        break block10;
                    }
                    Desktop.getDesktop().browse(url.toURI());
                }
                catch (IOException | URISyntaxException exception) {}
            } else if (evt.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                if (url.sameFile(this.thisURL)) {
                    this.jEditorPaneLegal.setToolTipText(url.getRef());
                } else {
                    this.jEditorPaneLegal.setToolTipText(url.toExternalForm());
                }
            } else if (evt.getEventType() == HyperlinkEvent.EventType.EXITED) {
                this.jEditorPaneLegal.setToolTipText(null);
            }
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        this.ok = true;
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.ok = false;
        this.dispose();
    }

    public boolean isOK() {
        return this.ok;
    }

    public synchronized void waitUntilClosed() {
        while (this.isVisible()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

