/*
 * Decompiled with CFR 0.152.
 */
package lemmini.graphics;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Hashtable;
import lemmini.graphics.GraphicsContext;
import lemmini.tools.ToolBox;

public class LemmImage {
    private final BufferedImage image;

    public LemmImage(BufferedImage image) {
        this.image = image;
    }

    public LemmImage(LemmImage image) {
        BufferedImage oldBufferedImage = image.getImage();
        this.image = new BufferedImage(oldBufferedImage.getColorModel(), oldBufferedImage.copyData(null), oldBufferedImage.isAlphaPremultiplied(), image.getProperties());
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Hashtable<String, Object> getProperties() {
        String[] propertyNames = this.image.getPropertyNames();
        if (propertyNames == null) {
            return null;
        }
        Hashtable<String, Object> properties = new Hashtable<String, Object>(propertyNames.length);
        String[] stringArray = propertyNames;
        int n = propertyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            properties.put(propertyName, this.image.getProperty(propertyName));
            ++n2;
        }
        return properties;
    }

    public LemmImage getScaledInstance(int targetWidth, int targetHeight) {
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return this.getScaledInstance(targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR, false);
    }

    public LemmImage getScaledInstance(int targetWidth, int targetHeight, Object interpolationHint, boolean multipass) {
        int h;
        int w;
        int transparency = this.image.getTransparency();
        BufferedImage img = this.image;
        if (multipass) {
            w = this.getWidth();
            h = this.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (multipass) {
                w = Math.max(w / 2, targetWidth);
                h = Math.max(h / 2, targetHeight);
            }
            BufferedImage tmp = ToolBox.createImage(w, h, transparency);
            Graphics2D g2 = null;
            try {
                g2 = tmp.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, interpolationHint);
                g2.drawImage(img, 0, 0, w, h, null);
            }
            finally {
                if (g2 != null) {
                    g2.dispose();
                }
            }
            img = tmp;
        } while (w != targetWidth || h != targetHeight);
        return new LemmImage(img);
    }

    public LemmImage transform(boolean rotate, boolean flipHoriz, boolean flipVert) {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        BufferedImage tmp = rotate ? ToolBox.createImage(height, width, this.image.getTransparency()) : ToolBox.createImage(width, height, this.image.getTransparency());
        int width2 = tmp.getWidth();
        int height2 = tmp.getHeight();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int x2 = x;
                int y2 = y;
                if (rotate) {
                    int oldX2 = x2;
                    x2 = width2 - 1 - y2;
                    y2 = oldX2;
                }
                if (flipVert) {
                    y2 = height2 - 1 - y2;
                }
                if (flipHoriz) {
                    x2 = width2 - 1 - x2;
                }
                tmp.setRGB(x2, y2, this.image.getRGB(x, y));
                ++x;
            }
            ++y;
        }
        return new LemmImage(tmp);
    }

    public GraphicsContext createGraphicsContext() {
        return new GraphicsContext(this.image.createGraphics());
    }

    public LemmImage getSubimage(int x, int y, int w, int h) {
        return new LemmImage(this.image.getSubimage(x, y, w, h));
    }

    public int getWidth() {
        return this.image.getWidth();
    }

    public int getHeight() {
        return this.image.getHeight();
    }

    public int getRGB(int x, int y) {
        if (x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight()) {
            return this.image.getRGB(x, y);
        }
        return 0;
    }

    public int[] getRGB(int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        return this.image.getRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public void setRGB(int x, int y, int rgb) {
        if (x >= 0 && x < this.getWidth() && y >= 0 && y < this.getHeight()) {
            this.image.setRGB(x, y, rgb);
        }
    }

    public void addRGB(int x, int y, int rgb) {
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return;
        }
        double alphaA = LemmImage.intToDouble(this.image.getRGB(x, y) >>> 24 & 0xFF);
        double alphaB = LemmImage.intToDouble(rgb >>> 24 & 0xFF);
        if (alphaB <= 0.0) {
            return;
        }
        if (alphaA <= 0.0 || alphaB >= 1.0) {
            this.image.setRGB(x, y, rgb);
            return;
        }
        double redA = LemmImage.intToDouble(this.image.getRGB(x, y) >>> 16 & 0xFF);
        double greenA = LemmImage.intToDouble(this.image.getRGB(x, y) >>> 8 & 0xFF);
        double blueA = LemmImage.intToDouble(this.image.getRGB(x, y) & 0xFF);
        double redB = LemmImage.intToDouble(rgb >>> 16 & 0xFF);
        double greenB = LemmImage.intToDouble(rgb >>> 8 & 0xFF);
        double blueB = LemmImage.intToDouble(rgb & 0xFF);
        double alphaNew = alphaB + alphaA * (1.0 - alphaB);
        double redNew = (redB * alphaB + redA * alphaA * (1.0 - alphaB)) / alphaNew;
        double greenNew = (greenB * alphaB + greenA * alphaA * (1.0 - alphaB)) / alphaNew;
        double blueNew = (blueB * alphaB + blueA * alphaA * (1.0 - alphaB)) / alphaNew;
        int rgbNew = LemmImage.doubleToInt(alphaNew) << 24 | LemmImage.doubleToInt(redNew) << 16 | LemmImage.doubleToInt(greenNew) << 8 | LemmImage.doubleToInt(blueNew);
        this.image.setRGB(x, y, rgbNew);
    }

    public void addRGBBehind(int x, int y, int rgb) {
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return;
        }
        double alphaA = LemmImage.intToDouble(this.image.getRGB(x, y) >>> 24 & 0xFF);
        double alphaB = LemmImage.intToDouble(rgb >>> 24 & 0xFF);
        if (alphaA >= 1.0 || alphaB <= 0.0) {
            return;
        }
        if (alphaA <= 0.0) {
            this.image.setRGB(x, y, rgb);
            return;
        }
        double redA = LemmImage.intToDouble(this.image.getRGB(x, y) >>> 16 & 0xFF);
        double greenA = LemmImage.intToDouble(this.image.getRGB(x, y) >>> 8 & 0xFF);
        double blueA = LemmImage.intToDouble(this.image.getRGB(x, y) & 0xFF);
        double redB = LemmImage.intToDouble(rgb >>> 16 & 0xFF);
        double greenB = LemmImage.intToDouble(rgb >>> 8 & 0xFF);
        double blueB = LemmImage.intToDouble(rgb & 0xFF);
        double alphaNew = alphaA + alphaB * (1.0 - alphaA);
        double redNew = (redA * alphaA + redB * alphaB * (1.0 - alphaA)) / alphaNew;
        double greenNew = (greenA * alphaA + greenB * alphaB * (1.0 - alphaA)) / alphaNew;
        double blueNew = (blueA * alphaA + blueB * alphaB * (1.0 - alphaA)) / alphaNew;
        int rgbNew = LemmImage.doubleToInt(alphaNew) << 24 | LemmImage.doubleToInt(redNew) << 16 | LemmImage.doubleToInt(greenNew) << 8 | LemmImage.doubleToInt(blueNew);
        this.image.setRGB(x, y, rgbNew);
    }

    public void replaceColor(int oldRGB, int newRGB) {
        int w = this.getWidth();
        int h = this.getHeight();
        int xp = 0;
        while (xp < w) {
            int yp = 0;
            while (yp < h) {
                int rgb = this.getRGB(xp, yp);
                if ((rgb & 0xFFFFFF) == oldRGB) {
                    this.setRGB(xp, yp, newRGB & 0xFFFFFF | rgb & 0xFF000000);
                }
                ++yp;
            }
            ++xp;
        }
    }

    public void removeAlpha(int x, int y, int alpha) {
        if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) {
            return;
        }
        double alphaA = LemmImage.intToDouble(this.image.getRGB(x, y) >>> 24 & 0xFF);
        double alphaB = LemmImage.intToDouble(alpha);
        if (alphaB >= 1.0) {
            this.image.setRGB(x, y, 0);
            return;
        }
        if (alphaB <= 0.0) {
            return;
        }
        int alphaNew = LemmImage.doubleToInt(alphaA * (1.0 - alphaB));
        if (alphaNew > 0) {
            this.image.setRGB(x, y, this.image.getRGB(x, y) & 0xFFFFFF | alphaNew << 24);
        } else {
            this.image.setRGB(x, y, 0);
        }
    }

    public boolean isPixelOpaque(int x, int y) {
        return this.getRGB(x, y) >>> 24 >= 128;
    }

    public void applyTint(int tint) {
        double alphaTint = LemmImage.intToDouble(tint >>> 24 & 0xFF);
        double redTint = LemmImage.intToDouble(tint >>> 16 & 0xFF);
        double greenTint = LemmImage.intToDouble(tint >>> 8 & 0xFF);
        double blueTint = LemmImage.intToDouble(tint & 0xFF);
        if (alphaTint <= 0.0) {
            return;
        }
        int y = 0;
        while (y < this.image.getHeight()) {
            int x = 0;
            while (x < this.image.getWidth()) {
                this.image.setRGB(x, y, LemmImage.applyTint(this.image.getRGB(x, y), alphaTint, redTint, greenTint, blueTint));
                ++x;
            }
            ++y;
        }
    }

    public static int applyTint(int original, int tint) {
        double alphaTint = LemmImage.intToDouble(tint >>> 24 & 0xFF);
        double redTint = LemmImage.intToDouble(tint >>> 16 & 0xFF);
        double greenTint = LemmImage.intToDouble(tint >>> 8 & 0xFF);
        double blueTint = LemmImage.intToDouble(tint & 0xFF);
        return LemmImage.applyTint(original, alphaTint, redTint, greenTint, blueTint);
    }

    private static int applyTint(int original, double alphaTint, double redTint, double greenTint, double blueTint) {
        if (alphaTint <= 0.0) {
            return original;
        }
        int alphaOrig = original >>> 24 & 0xFF;
        if (alphaOrig <= 0) {
            return original;
        }
        double redOrig = LemmImage.intToDouble(original >>> 16 & 0xFF);
        double greenOrig = LemmImage.intToDouble(original >>> 8 & 0xFF);
        double blueOrig = LemmImage.intToDouble(original & 0xFF);
        double redNew = redTint * alphaTint + redOrig * (1.0 - alphaTint);
        double greenNew = greenTint * alphaTint + greenOrig * (1.0 - alphaTint);
        double blueNew = blueTint * alphaTint + blueOrig * (1.0 - alphaTint);
        int rgbNew = alphaOrig << 24 | LemmImage.doubleToInt(redNew) << 16 | LemmImage.doubleToInt(greenNew) << 8 | LemmImage.doubleToInt(blueNew);
        return rgbNew;
    }

    private static double intToDouble(int i) {
        return ToolBox.cap(0.0, (double)i / 255.0, 1.0);
    }

    private static int doubleToInt(double d) {
        return ToolBox.cap(0, ToolBox.roundToInt(d * 255.0), 255);
    }
}

