/*
 * Decompiled with CFR 0.152.
 */
package lemmini.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import lemmini.graphics.LemmImage;

public class GraphicsContext {
    private final Graphics2D graphics;

    public GraphicsContext(Graphics2D graphics) {
        this.graphics = graphics;
    }

    public void setClip(int x, int y, int width, int height) {
        this.graphics.setClip(x, y, width, height);
    }

    public void clearRect(int x, int y, int width, int height) {
        this.graphics.clearRect(x, y, width, height);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.graphics.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.graphics.fillRect(x, y, width, height);
    }

    public void setBackground(Color bgColor) {
        this.graphics.setBackground(bgColor);
    }

    public void setColor(Color color) {
        this.graphics.setColor(color);
    }

    public void drawImage(LemmImage image, int x, int y) {
        this.graphics.drawImage((Image)image.getImage(), x, y, null);
    }

    public void drawImage(LemmImage image, int x, int y, double scale) {
        BufferedImage origImage = image.getImage();
        BufferedImage newResized = GraphicsContext.resize(origImage, (int)((double)image.getWidth() * scale), (int)((double)image.getHeight() * scale));
        this.graphics.drawImage((Image)newResized, x, y, null);
    }

    public static BufferedImage resize(BufferedImage image, int width, int height) {
        BufferedImage newResizedImage = new BufferedImage(width, height, 2);
        Graphics2D g = newResizedImage.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.fillRect(0, 0, width, height);
        HashMap<RenderingHints.Key, Object> hints = new HashMap<RenderingHints.Key, Object>();
        hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        hints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.addRenderingHints(hints);
        g.drawImage(image, 0, 0, width, height, null);
        g.dispose();
        return newResizedImage;
    }

    public void drawImage(LemmImage image, int x, int y, int width, int height) {
        this.graphics.drawImage(image.getImage(), x, y, width, height, null);
    }

    public void drawImage(LemmImage image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2) {
        this.graphics.drawImage(image.getImage(), dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null);
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.graphics.setRenderingHint(hintKey, hintValue);
    }

    public void grabPixels(LemmImage image, int x, int y, int w, int h, int[] pix, int off, int scanSize) {
        PixelGrabber pixelgrabber = new PixelGrabber(image.getImage(), x, y, w, h, pix, off, scanSize);
        try {
            pixelgrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void copy(LemmImage source, LemmImage target) {
        WritableRaster rImgSpr = target.getImage().getRaster();
        rImgSpr.setRect(source.getImage().getRaster());
    }

    public void dispose() {
        this.graphics.dispose();
    }
}

