/*
 * Decompiled with CFR 0.152.
 */
package lemmini.graphics;

import java.awt.Color;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;

public class GraphicsBuffer {
    private LemmImage image;
    private LemmImage subimage;
    private GraphicsContext graphics;
    private final int transparency;
    private final boolean resizable;

    public GraphicsBuffer(int width, int height, int transparency, boolean resizable) {
        this.transparency = transparency;
        this.resizable = resizable;
        this.setSize(width, height);
    }

    public final synchronized void setSize(int width, int height) {
        if (this.image != null && !this.resizable) {
            return;
        }
        int w = width;
        int h = height;
        if (this.image != null) {
            w = Math.max(w, this.image.getWidth());
            h = Math.max(h, this.image.getHeight());
        }
        if (this.resizable) {
            w = GraphicsBuffer.toPowerOf2(w);
            h = GraphicsBuffer.toPowerOf2(h);
        }
        if (this.image == null || w > this.image.getWidth() || h > this.image.getHeight()) {
            if (this.graphics != null) {
                this.graphics.dispose();
            }
            this.image = ToolBox.createLemmImage(w, h, this.transparency);
            this.graphics = this.image.createGraphicsContext();
            if (this.transparency == 1) {
                this.graphics.setBackground(new Color(0, 0, 0));
            } else {
                this.graphics.setBackground(new Color(0, 0, 0, 0));
            }
        }
        if (this.subimage == null || width != this.subimage.getWidth() || height != this.subimage.getHeight()) {
            this.subimage = this.resizable ? this.image.getSubimage(0, 0, width, height) : this.image;
        }
    }

    public synchronized LemmImage getImage() {
        return this.subimage;
    }

    public synchronized GraphicsContext getGraphicsContext() {
        return this.graphics;
    }

    public synchronized void dispose() {
        this.graphics.dispose();
    }

    private static int toPowerOf2(int n) {
        if (n <= 0) {
            return 1;
        }
        if (n > 2) {
            return Integer.highestOneBit(n - 1 << 1);
        }
        return n;
    }
}

