/*
 * Decompiled with CFR 0.152.
 */
package lemmini.gameutil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import lemmini.game.GameController;
import lemmini.game.Lemming;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.ArrayUtils;

public class Sprite {
    protected final int numFrames;
    protected int width;
    protected int height;
    private int counter;
    private final int speed;
    private int frameIdx;
    protected Animation animMode;
    protected int[] sound;
    private boolean triggered;
    protected List<LemmImage> frames;
    protected boolean modifiable;
    protected int[][] origColors;
    private Lemming lemming;

    public static Animation getAnimationMode(int t) {
        switch (t) {
            case 1: {
                return Animation.LOOP;
            }
            case 2: {
                return Animation.TRIGGERED;
            }
            case 3: {
                return Animation.ONCE;
            }
        }
        return Animation.NONE;
    }

    public Sprite(LemmImage sourceImg, int animFrames, int animSpeed, boolean modifiable) {
        this.numFrames = animFrames;
        this.width = sourceImg.getWidth();
        this.height = sourceImg.getHeight() / this.numFrames;
        this.counter = 0;
        this.speed = animSpeed;
        this.frameIdx = 0;
        this.animMode = Animation.NONE;
        this.sound = ArrayUtils.EMPTY_INT_ARRAY;
        this.triggered = false;
        this.frames = ToolBox.getAnimation(sourceImg, animFrames);
        this.modifiable = modifiable;
        if (modifiable) {
            this.origColors = new int[this.numFrames][];
            ListIterator<LemmImage> lit = this.frames.listIterator();
            while (lit.hasNext()) {
                int i = lit.nextIndex();
                LemmImage frame = ToolBox.copyLemmImage(lit.next());
                lit.set(frame);
                this.origColors[i] = frame.getRGB(0, 0, this.width, this.height, null, 0, this.width);
            }
        } else {
            this.origColors = null;
        }
        this.lemming = null;
    }

    public Sprite(List<LemmImage> frames, int animSpeed, boolean modifiable) {
        this.numFrames = frames.size();
        this.width = frames.get(0).getWidth();
        this.height = frames.get(0).getHeight();
        this.counter = 0;
        this.speed = animSpeed;
        this.frameIdx = 0;
        this.animMode = Animation.NONE;
        this.sound = ArrayUtils.EMPTY_INT_ARRAY;
        this.triggered = false;
        this.modifiable = modifiable;
        if (modifiable) {
            this.frames = new ArrayList<LemmImage>(frames);
            this.origColors = new int[this.numFrames][];
            ListIterator<LemmImage> lit = this.frames.listIterator();
            while (lit.hasNext()) {
                int i = lit.nextIndex();
                LemmImage frame = ToolBox.copyLemmImage(lit.next());
                lit.set(frame);
                this.origColors[i] = frame.getRGB(0, 0, this.width, this.height, null, 0, this.width);
            }
        } else {
            this.frames = frames;
            this.origColors = null;
        }
        this.lemming = null;
    }

    public Sprite(Sprite src) {
        this.numFrames = src.numFrames;
        this.width = src.width;
        this.height = src.height;
        this.counter = src.counter;
        this.speed = src.speed;
        this.frameIdx = src.frameIdx;
        this.animMode = src.animMode;
        this.sound = (int[])src.sound.clone();
        this.triggered = src.triggered;
        this.frames = new ArrayList<LemmImage>(src.frames);
        ListIterator<LemmImage> lit = this.frames.listIterator();
        while (lit.hasNext()) {
            LemmImage frame = new LemmImage(lit.next());
            lit.set(frame);
        }
        this.modifiable = src.modifiable;
        this.origColors = (int[][])ArrayUtils.clone((Object[])src.origColors);
        if (this.origColors != null) {
            int i = 0;
            while (i < this.origColors.length) {
                this.origColors[i] = (int[])this.origColors[i].clone();
                ++i;
            }
        }
        this.lemming = src.lemming;
    }

    public LemmImage getImage(int idx) {
        return this.frames.get(idx);
    }

    public LemmImage getImage() {
        return this.getImage(this.frameIdx);
    }

    public void setImage(int idx, LemmImage img) {
        this.frames.set(idx, img);
    }

    public LemmImage getImageAnim() {
        switch (this.animMode) {
            case LOOP: {
                if (++this.counter < this.speed) break;
                this.counter = 0;
                if (++this.frameIdx < this.numFrames) break;
                this.frameIdx = 0;
                break;
            }
            case ONCE: {
                if (++this.counter < this.speed) break;
                this.counter = 0;
                if (this.frameIdx >= this.numFrames - 1) break;
                ++this.frameIdx;
                break;
            }
            case TRIGGERED: {
                if (this.triggered) {
                    if (++this.counter >= this.speed) {
                        this.counter = 0;
                        if (++this.frameIdx >= this.numFrames) {
                            this.frameIdx = 0;
                        }
                    }
                    if (this.frameIdx > 0) {
                        if (this.counter != 0 || this.lemming == null) break;
                        GameController.sound.playVisualSFX(this.sound[this.frameIdx], this.lemming.midX(), this.lemming.midY());
                        break;
                    }
                    this.frameIdx = 0;
                    if (this.counter < this.speed - 1) break;
                    this.triggered = false;
                    break;
                }
                this.frameIdx = 0;
                this.counter = 0;
                break;
            }
        }
        return this.getImage(this.frameIdx);
    }

    public void setPixelVisibility(int x, int y, boolean visible) {
        if (!this.modifiable) {
            return;
        }
        if (x >= 0 && x < this.width && y >= 0 && y < this.height) {
            ListIterator<LemmImage> lit = this.frames.listIterator();
            while (lit.hasNext()) {
                int i = lit.nextIndex();
                lit.next().setRGB(x, y, visible ? this.origColors[i][y * this.width + x] : 0);
            }
        }
    }

    public void flipSprite(boolean horizontal, boolean vertical) {
        if (!this.modifiable || !horizontal && !vertical) {
            return;
        }
        ListIterator<LemmImage> lit = this.frames.listIterator();
        while (lit.hasNext()) {
            int i = lit.nextIndex();
            LemmImage imgSpr = lit.next().transform(false, horizontal, vertical);
            lit.set(imgSpr);
            int[] buffer = (int[])this.origColors[i].clone();
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    this.origColors[i][y * this.width + x] = buffer[(vertical ? this.height - y - 1 : y) * this.width + (horizontal ? this.width - x - 1 : x)];
                    ++x;
                }
                ++y;
            }
        }
    }

    public void applyTint(int tint) {
        if (!this.modifiable || (tint & 0xFF000000) == 0) {
            return;
        }
        ListIterator<LemmImage> lit = this.frames.listIterator();
        while (lit.hasNext()) {
            int i = lit.nextIndex();
            lit.next().applyTint(tint);
            int y = 0;
            while (y < this.height) {
                int x = 0;
                while (x < this.width) {
                    this.origColors[i][y * this.width + x] = LemmImage.applyTint(this.origColors[i][y * this.width + x], tint);
                    ++x;
                }
                ++y;
            }
        }
    }

    public Animation getAnimMode() {
        return this.animMode;
    }

    public void setAnimMode(Animation mode) {
        this.animMode = mode;
    }

    public boolean canBeTriggered() {
        return this.animMode == Animation.TRIGGERED;
    }

    public boolean isTriggered() {
        return this.triggered;
    }

    public boolean trigger(Lemming l) {
        if (this.triggered) {
            return false;
        }
        this.lemming = l;
        if (this.sound.length == 1) {
            GameController.sound.playVisualSFX(this.sound[0], l.midX(), l.midY());
        } else if (this.sound.length > 1) {
            GameController.sound.playVisualSFX(this.sound[1], l.midX(), l.midY());
        }
        this.triggered = true;
        this.frameIdx = 0;
        this.counter = this.speed - 1;
        return true;
    }

    public int getFrameIdx() {
        return this.frameIdx;
    }

    public void setFrameIdx(int frameIdx) {
        this.frameIdx = frameIdx;
    }

    public int getNumFrames() {
        return this.numFrames;
    }

    public int getSound() {
        if (ArrayUtils.isEmpty((int[])this.sound)) {
            return -1;
        }
        int currentSound = this.sound[0];
        if (GameController.getExitSoundOption() == GameController.ExitSoundOption.BOING) {
            return currentSound == 23 ? 14 : currentSound;
        }
        if (GameController.getExitSoundOption() == GameController.ExitSoundOption.YIPPEE) {
            return currentSound == 14 ? 23 : currentSound;
        }
        return currentSound;
    }

    public void setSound(int[] s) {
        if (s.length >= 2) {
            this.sound = new int[this.numFrames];
            Arrays.fill(this.sound, -1);
            int i = 0;
            while (i < s.length - 1) {
                if (s[i + 1] >= 0) {
                    this.sound[s[i + 1]] = s[i] == 23 || s[i] == 14 ? this.applySoundPreference(s[i]) : s[i];
                }
                i += 2;
            }
        } else if (s.length == 1) {
            this.sound = new int[1];
            this.sound[0] = s[0] == 14 || s[0] == 23 ? this.applySoundPreference(s[0]) : s[0];
        } else {
            this.sound = null;
        }
    }

    private int applySoundPreference(int inputSound) {
        if (GameController.getExitSoundOption() == GameController.ExitSoundOption.BOING) {
            return inputSound == 23 ? 14 : inputSound;
        }
        if (GameController.getExitSoundOption() == GameController.ExitSoundOption.YIPPEE) {
            return inputSound == 14 ? 23 : inputSound;
        }
        return inputSound;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public static enum Animation {
        NONE,
        LOOP,
        TRIGGERED,
        ONCE,
        ONCE_ENTRANCE;

    }
}

