/*
 * Decompiled with CFR 0.152.
 */
package lemmini.gameutil;

import lemmini.tools.NanosecondTimer;

public class KeyRepeat {
    private final NanosecondTimer timer;
    private State state;
    private DcState dcState;
    private int mask;
    private final long timeFirstPress;
    private final long timeRepeat;
    private final long timeDoubleClick;
    private Event event = Event.NONE;

    public KeyRepeat(long tfirst, long trep, long tdc) {
        this.timer = new NanosecondTimer();
        this.timeFirstPress = tfirst;
        this.timeRepeat = trep;
        this.timeDoubleClick = tdc;
        this.init();
    }

    public final void init() {
        this.state = State.OFF;
        this.dcState = DcState.OFF;
        this.mask = 0;
        this.timer.update();
    }

    public synchronized void pressed(int m) {
        if ((this.mask & m) == m) {
            return;
        }
        switch (this.dcState) {
            case OFF: {
                this.dcState = DcState.PRESSED_ONCE;
                this.event = Event.SINGLE_CLICK;
                break;
            }
            case PRESSED_ONCE: {
                if (!this.timer.timePassed(this.timeDoubleClick)) {
                    this.dcState = DcState.OFF;
                    this.event = Event.DOUBLE_CLICK;
                    break;
                }
                this.event = Event.SINGLE_CLICK;
                break;
            }
        }
        this.mask |= m;
        this.state = State.DETECT_FIRST;
        this.timer.update();
    }

    public synchronized void released(int m) {
        this.mask &= ~m;
        if (this.mask == 0) {
            this.state = State.OFF;
        }
    }

    public synchronized Event fired() {
        if (this.event != Event.NONE) {
            Event temp = this.event;
            this.event = Event.NONE;
            return temp;
        }
        if (this.mask == 0) {
            return Event.NONE;
        }
        switch (this.state) {
            case DETECT_FIRST: {
                if (!this.timer.timePassedUpdate(this.timeFirstPress)) break;
                this.state = State.REPEAT;
                this.dcState = DcState.OFF;
                return Event.SINGLE_CLICK;
            }
            case REPEAT: {
                if (!this.timer.timePassedUpdate(this.timeRepeat)) break;
                return Event.SINGLE_CLICK;
            }
        }
        return Event.NONE;
    }

    private static enum DcState {
        OFF,
        PRESSED_ONCE;

    }

    public static enum Event {
        NONE,
        SINGLE_CLICK,
        DOUBLE_CLICK;

    }

    private static enum State {
        OFF,
        DETECT_FIRST,
        REPEAT;

    }
}

