/*
 * Decompiled with CFR 0.152.
 */
package lemmini.gameutil;

import java.awt.Color;
import lemmini.game.Core;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;

public class Fader {
    public static final int FADE_STEP_FAST = 15;
    public static final int FADE_STEP_SLOW = 8;
    private static final int WIDTH = 64;
    private static final int HEIGHT = 64;
    private static final int MAX_ALPHA = 255;
    private static int fadeValue;
    private static State fadeState;
    private static int fadeStep;
    private static int color;
    private static int alpha;
    private static LemmImage alphaImg;
    private static GraphicsContext alphaGfx;

    static {
        fadeState = State.OFF;
        fadeStep = 15;
        color = 0;
        alpha = 128;
        alphaImg = null;
    }

    public static synchronized void setColor(int c) {
        color = c & 0xFFFFFF;
        Fader.init();
    }

    public static synchronized void setAlpha(int a) {
        alpha = ToolBox.cap(0, a, 255);
        Fader.init();
    }

    private static void init() {
        if (alphaImg == null) {
            alphaImg = ToolBox.createLemmImage(64, 64);
            alphaGfx = alphaImg.createGraphicsContext();
        }
        Color fillColor = new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha);
        alphaGfx.setBackground(fillColor);
        alphaGfx.clearRect(0, 0, 64, 64);
    }

    public static synchronized void apply(GraphicsContext g) {
        int width = Core.getDrawWidth();
        int height = Core.getDrawHeight();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                g.drawImage(alphaImg, x, y);
                x += 64;
            }
            y += 64;
        }
    }

    public static synchronized void setState(State s) {
        fadeState = s;
        switch (fadeState) {
            case BLACK: 
            case IN: {
                fadeValue = 255;
                Fader.setAlpha(fadeValue);
                break;
            }
            case OFF: 
            case OUT: {
                fadeValue = 0;
                Fader.setAlpha(fadeValue);
                break;
            }
        }
    }

    public static synchronized State getState() {
        return fadeState;
    }

    public static void setStep(int step) {
        fadeStep = step;
    }

    public static int getStep() {
        return fadeStep;
    }

    public static synchronized void fade() {
        switch (fadeState) {
            case IN: {
                if (fadeValue >= fadeStep) {
                    fadeValue -= fadeStep;
                } else {
                    fadeValue = 0;
                    fadeState = State.OFF;
                }
                Fader.setAlpha(fadeValue);
                break;
            }
            case OUT: {
                if (fadeValue <= 255 - fadeStep) {
                    fadeValue += fadeStep;
                } else {
                    fadeValue = 255;
                    fadeState = State.BLACK;
                }
                Fader.setAlpha(fadeValue);
                break;
            }
        }
    }

    public static enum State {
        OFF,
        BLACK,
        IN,
        OUT;

    }
}

