/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Color;
import java.awt.RenderingHints;
import java.util.List;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.LemmFont;
import lemmini.game.Level;
import lemmini.game.LevelCode;
import lemmini.game.LevelPack;
import lemmini.game.MiscGfx;
import lemmini.game.TextDialog;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.StringUtils;

public class TextScreen {
    private static final Object monitor = new Object();
    private static final int SCROLL_Y = 164;
    private static final int SCROLL_WIDTH = 750;
    private static final int SCROLL_PADDING = 4;
    private static final int SCROLL_STEP = 2;
    private static final int FAILURE_THRESHOLD_FOR_HINTS = 3;
    private static final int MAX_ROT_CTR = 99;
    private static final int ROT_ANIM_LENGTH = 21;
    private static final String SCROLL_TEXT = "RetroLemmini - a game engine for Lemmings(tm) in Java. Programmed by Will James... Based on SuperLemminiToo by Charles... SuperLemmini by Ryan Sakowski... Original Lemmini by Volker Oth. Lemmini website: www.lemmini.de. Thanks to Martin Cameron for his IBXM library, Mindless for his MOD conversions of the original Amiga Lemmings tunes, the guys of DMA Design for the original Lemmings game, ccexplore and the other nice folks at the Lemmings Forum for discussion and advice, and Oracle for maintaining Java and providing the community with a free development environment. We accept no responsibility for: Loss of sleep... Loss of hair... Loss of sanity! Click 'Play Level' to begin... ";
    private static TextDialog textDialog;
    private static LemmImage[] rotImg;
    private static int rotCtr;
    private static int scrollPixCtr;
    private static LemmImage scrollerImg;
    private static Mode mode;
    private static int hintIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMode(Mode m) {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            if (mode != m) {
                switch (m) {
                    case INTRO: {
                        TextScreen.initIntro();
                        break;
                    }
                    case BRIEFING: {
                        TextScreen.initBriefing();
                        break;
                    }
                    case DEBRIEFING: {
                        TextScreen.initDebriefing();
                        break;
                    }
                }
            }
            mode = m;
        }
    }

    static void initIntro() {
        textDialog.clear();
        if (GameController.getMenuThemeOption() == GameController.MenuThemeOption.WINLEMM) {
            TextScreen.createWinLemmThemeMenu();
        } else {
            TextScreen.createLemminiThemeMenu();
        }
    }

    private static void createWinLemmThemeMenu() {
        textDialog.setBackground(MiscGfx.getImage(MiscGfx.Index.BACKGROUND_MAIN_WINLEMM), true);
        List<LemmImage> cardChoose = MiscGfx.getAnimation(MiscGfx.Index.CARD_CHOOSE_LEVEL_LEMMING, 2);
        textDialog.addButton(cardChoose.get(0), cardChoose.get(0), cardChoose.get(1), "Menu Cards", -339, -24, Button.CHOOSE_LEVEL);
        List<LemmImage> cardPlay = MiscGfx.getAnimation(MiscGfx.Index.CARD_PLAY_LEVEL_LEMMING, 2);
        textDialog.addButton(cardPlay.get(0), cardPlay.get(0), cardPlay.get(1), "Menu Cards", 152, -24, Button.PLAY_LEVEL);
        List<LemmImage> cardOptions = MiscGfx.getAnimation(MiscGfx.Index.CARD_OPTIONS, 2);
        textDialog.addButton(cardOptions.get(0), cardOptions.get(0), cardOptions.get(1), "Menu Cards", -132, -24, Button.OPTIONS);
        List<LemmImage> cardReplays = MiscGfx.getAnimation(MiscGfx.Index.CARD_REPLAYS, 2);
        textDialog.addButton(cardReplays.get(0), cardReplays.get(0), cardReplays.get(1), "Menu Cards", 0, -24, Button.LOAD_REPLAY);
        List<LemmImage> cardPlayers = MiscGfx.getAnimation(MiscGfx.Index.CARD_PLAYERS, 2);
        textDialog.addButton(cardPlayers.get(0), cardPlayers.get(0), cardPlayers.get(1), "Menu Cards", -132, 35, Button.PLAYERS);
        List<LemmImage> cardCodes = MiscGfx.getAnimation(MiscGfx.Index.CARD_CODES, 2);
        textDialog.addButton(cardCodes.get(0), cardCodes.get(0), cardCodes.get(1), "Menu Cards", 0, 35, Button.ENTER_CODE);
        LemmImage menuLemming = MiscGfx.getImage(MiscGfx.Index.MENU_LEMMING);
        textDialog.addButton(menuLemming, menuLemming, menuLemming, "Menu Cards", -70, -92, Button.NONE);
        TextScreen.addWinLemmThemeVersionNumber();
    }

    public static void createLemminiThemeMenu() {
        textDialog.setBackground(MiscGfx.getImage(MiscGfx.Index.BACKGROUND_MAIN_AMIGA), true);
        textDialog.addTextButton("Levels", "Levels", null, -15, -1, Button.CHOOSE_LEVEL, LemmFont.LemmColor.GREEN, LemmFont.LemmColor.YELLOW);
        textDialog.addTextButton("Play", "Play", null, -3, -1, Button.PLAY_LEVEL, LemmFont.LemmColor.TURQUOISE, LemmFont.LemmColor.YELLOW);
        textDialog.addTextButton("Options", "Options", null, 7, -1, Button.OPTIONS, LemmFont.LemmColor.GREEN, LemmFont.LemmColor.YELLOW);
        textDialog.addTextButton("Enter Code", "Enter Code", null, -15, 1, Button.ENTER_CODE, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
        textDialog.addTextButton("Load Replay", "Load Replay", null, 3, 1, Button.LOAD_REPLAY, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
        textDialog.addTextButton("Players", "Players", null, -15, 2, Button.PLAYERS, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
        textDialog.addTextButton("Exit", "Exit", null, 10, 2, Button.EXIT, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
        String revision = "Version 2.3";
        int revisionX = revision.length() / 2 + 1;
        textDialog.addTextButton(revision, revision, null, -revisionX, 4, Button.ABOUT, LemmFont.LemmColor.VIOLET, LemmFont.LemmColor.YELLOW);
    }

    private static void addWinLemmThemeVersionNumber() {
        String revision = " 2.3 @";
        int yPosition = 116;
        int charWidth = 26;
        int totalWidth = revision.length() * charWidth;
        LemmImage versionImg = MiscGfx.getImage(MiscGfx.Index.VERSION_WINLEMM);
        int versionImgX = -(versionImg.getWidth() / 2) - totalWidth / 2;
        textDialog.addButton(versionImg, versionImg, versionImg, "versionImages", versionImgX, yPosition, Button.ABOUT);
        List<LemmImage> versionNum = MiscGfx.getAnimation(MiscGfx.Index.VERSION_NUMS_WINLEMM, 17);
        int startX = versionImgX + versionImg.getWidth() - 2;
        char[] cArray = revision.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            int frameIndex;
            char c = cArray[n2];
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    frameIndex = c - 48;
                    break;
                }
                case '.': {
                    frameIndex = 10;
                    break;
                }
                case '-': {
                    frameIndex = 11;
                    break;
                }
                case 'A': {
                    frameIndex = 13;
                    break;
                }
                case 'B': {
                    frameIndex = 14;
                    break;
                }
                case '*': {
                    frameIndex = 15;
                    break;
                }
                case '@': {
                    frameIndex = 16;
                    break;
                }
                default: {
                    frameIndex = 12;
                }
            }
            LemmImage img = versionNum.get(frameIndex);
            textDialog.addButton(img, img, img, "versionImages", startX, yPosition, Button.ABOUT);
            startX += charWidth;
            ++n2;
        }
    }

    static void initBriefing() {
        textDialog.clear();
        hintIndex = 0;
        TextScreen.drawBackground();
        Level level = GameController.getLevel();
        textDialog.addImage(GameController.getMapPreview(), null, -225);
        TextScreen.addLevelName(level);
        TextScreen.showLevelInfo();
        textDialog.addTextButton("Start Level", "Start Level", null, -12, 6, Button.START_LEVEL, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
        textDialog.addTextButton("Menu", "Menu", null, 4, 6, Button.MENU, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
    }

    static void initDebriefing() {
        textDialog.clear();
        TextScreen.drawBackground();
        int numLemmings = GameController.getNumLemmingsMax();
        int toRescue = GameController.getNumToRescue();
        int rescued = GameController.getNumExited();
        int toRescuePercent = toRescue * 100 / numLemmings;
        int rescuedPercent = rescued * 100 / numLemmings;
        int rescuedOfToRescue = toRescue == 0 ? 0 : rescued * 100 / toRescue;
        int timeElapsed = GameController.getLevelRecord().getTimeElapsed();
        int skillsUsed = GameController.getLevelRecord().getSkillsUsed();
        int score = GameController.getScore();
        if (GameController.getTime() == 0 && GameController.isTimed()) {
            textDialog.addStringCentered("Time is up.", null, -7, LemmFont.LemmColor.TURQUOISE);
        } else {
            textDialog.addStringCentered("All lemmings accounted for.", null, -7, LemmFont.LemmColor.TURQUOISE);
        }
        if (GameController.isOptionEnabled(GameController.Option.NO_PERCENTAGES) || numLemmings > 100) {
            textDialog.addStringCentered(String.format("You needed %d | You rescued %d", toRescue, rescued), null, -5, LemmFont.LemmColor.VIOLET);
        } else {
            textDialog.addStringCentered(String.format("You needed %d%% | You rescued %d%%", toRescuePercent, rescuedPercent), null, -5, LemmFont.LemmColor.VIOLET);
        }
        String timeTaken = String.format("%d:%02d", timeElapsed / 60, timeElapsed % 60);
        textDialog.addStringCentered(String.format("Time taken %s | Skills used %d", timeTaken, skillsUsed), null, -4, LemmFont.LemmColor.VIOLET);
        String pointWord = score == 1 ? "point" : "points";
        textDialog.addStringCentered(String.format("Your score is %d %s", score, pointWord), null, -3, LemmFont.LemmColor.GREEN);
        LevelPack lp = GameController.getCurLevelPack();
        List<String> debriefings = lp.getDebriefings();
        if (GameController.wasLost()) {
            String debriefing = GameController.getNumExited() <= 0 ? debriefings.get(0) : (rescuedOfToRescue < 50 ? debriefings.get(1) : (rescuedPercent < toRescuePercent - 5 ? debriefings.get(2) : (rescuedPercent < toRescuePercent - 1 ? debriefings.get(3) : debriefings.get(4))));
            textDialog.addStringCentered(debriefing, null, -1, LemmFont.LemmColor.RED);
            textDialog.addTextButton("Retry Level", "Retry Level", null, -12, 5, Button.RESTART, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
        } else {
            String debriefing = rescued <= toRescue && rescued < numLemmings ? debriefings.get(5) : (rescuedPercent < toRescuePercent + 20 && rescued < numLemmings ? debriefings.get(6) : (rescued < numLemmings ? debriefings.get(7) : debriefings.get(8)));
            textDialog.addStringCentered(debriefing, null, -1, LemmFont.LemmColor.RED);
            int lpn = GameController.getCurLevelPackIdx();
            int r = GameController.getCurRating();
            int ln = GameController.getCurLevelNumber();
            if (TextScreen.allLevelsCompleted(lp, r)) {
                List<String> ratings = lp.getRatings();
                textDialog.addStringCentered("Congratulations!", null, 2, LemmFont.LemmColor.YELLOW);
                textDialog.addStringCentered(String.format("You finished all the %s levels!", ratings.get(GameController.getCurRating())), null, 3, LemmFont.LemmColor.GREEN);
            } else if (lp.getLevelCount(r) > ln + 1) {
                int absLevel = GameController.absLevelNum(lpn, r, ln + 1);
                String code = LevelCode.create(lp.getCodeSeed(), absLevel, rescuedPercent, GameController.getTimesFailed(), 0, lp.getCodeOffset());
                if ((lpn != 0 || r != 0) && code != null) {
                    textDialog.addStringCentered(String.format("Your access code for level %d%nis %s", ln + 2, code), null, 2, LemmFont.LemmColor.YELLOW);
                }
            }
            if (r < lp.getRatings().size() - 1 || lp.getLevelCount(r) > ln + 1) {
                textDialog.addTextButton("Continue", "Continue", null, -11, 5, Button.CONTINUE, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
            }
        }
        if (!GameController.getWasCheated()) {
            textDialog.addTextButton("View Replay", "View Replay", null, 1, 5, Button.REPLAY, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
            textDialog.addTextButton("Save Replay", "Save Replay", null, 1, 6, Button.SAVE_REPLAY, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
        }
        textDialog.addTextButton("Menu", "Menu", null, -9, 6, Button.MENU, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
        Core.programProps.set("lastLevelPlayed", GameController.getLastLevelPlayedString());
        Core.programProps.save(Core.getProgramPropsFilePath(), false);
    }

    public static boolean allLevelsCompleted(LevelPack pack, int rating) {
        int l = 0;
        while (l < pack.getLevelCount(rating)) {
            if (!Core.player.getLevelRecord(pack.getName(), pack.getRatings().get(rating), l).isCompleted()) {
                return false;
            }
            ++l;
        }
        return true;
    }

    private static void drawBackground() {
        LemmImage backgroundImg = GameController.getMenuThemeOption() == GameController.MenuThemeOption.WINLEMM ? MiscGfx.getImage(MiscGfx.Index.BACKGROUND_LEVEL_WINLEMM) : MiscGfx.getImage(MiscGfx.Index.BACKGROUND_LEVEL_AMIGA);
        textDialog.setBackground(backgroundImg, true);
    }

    public static void addLevelName(Level level) {
        int levelNumber = GameController.getCurLevelNumber() + 1;
        String levelText = String.format("Level %-3d", levelNumber);
        textDialog.addString(levelText, null, -21, -4, LemmFont.LemmColor.RED);
        String levelName = level.getLevelName();
        int levelNameX = levelName.length() <= 22 ? 0 - levelName.length() / 2 : -11;
        textDialog.addString(String.format("%s", levelName), null, levelNameX, -4, LemmFont.LemmColor.RED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showLevelInfo() {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            textDialog.clearGroup("info");
            Level level = GameController.getLevel();
            String rating = GameController.getCurLevelPack().getRatings().get(GameController.getCurRating());
            textDialog.addString(String.format("Number of Lemmings %d", level.getNumLemmings()), "info", -9, -2, LemmFont.LemmColor.BLUE);
            if (GameController.isOptionEnabled(GameController.Option.NO_PERCENTAGES) || level.getNumLemmings() > 100) {
                textDialog.addString(String.format("%d to be saved", level.getNumToRescue()), "info", -9, -1, LemmFont.LemmColor.GREEN);
            } else {
                textDialog.addString(String.format("%d%% to be saved", level.getNumToRescue() * 100 / level.getNumLemmings()), "info", -9, -1, LemmFont.LemmColor.GREEN);
            }
            textDialog.addString(String.format("Release Rate %d", level.getReleaseRate()), "info", -9, 0, LemmFont.LemmColor.YELLOW);
            int minutes = level.getTimeLimitSeconds() / 60;
            int seconds = level.getTimeLimitSeconds() % 60;
            if (!GameController.isTimed()) {
                textDialog.addString("No time limit", "info", -9, 1, LemmFont.LemmColor.TURQUOISE);
            } else if (seconds == 0) {
                String minuteWord = minutes == 1 ? "Minute" : "Minutes";
                textDialog.addString(String.format("Time      %d %s", minutes, minuteWord), "info", -9, 1, LemmFont.LemmColor.TURQUOISE);
            } else {
                textDialog.addString(String.format("Time      %d-%02d", minutes, seconds), "info", -9, 1, LemmFont.LemmColor.TURQUOISE);
            }
            textDialog.addString(String.format("Rating    %s", rating), "info", -9, 2, LemmFont.LemmColor.VIOLET);
            String author = level.getAuthor();
            if (StringUtils.isNotEmpty((CharSequence)author)) {
                textDialog.addString(String.format("Author    %s", author), "info", -9, 3, LemmFont.LemmColor.RED);
            }
            if (level.getNumHints() > 0 && (Core.player.isDebugMode() || GameController.getTimesFailed() >= 3)) {
                textDialog.addTextButton("Show Hint", "Show Hint", "info", -4, 5, Button.SHOW_HINT, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showHint() {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            textDialog.clearGroup("info");
            Level level = GameController.getLevel();
            textDialog.addString(String.format("Hint %d", hintIndex + 1), "info", -3, -2, LemmFont.LemmColor.TURQUOISE);
            textDialog.addStringCentered(level.getHint(hintIndex), "info", 0, LemmFont.LemmColor.GREEN);
            textDialog.addTextButton("Show Info", "Show Info", "info", -4, 5, Button.SHOW_INFO, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
            if (hintIndex > 0) {
                textDialog.addTextButton("Previous Hint", "Previous Hint", "info", -19, 5, Button.PREVIOUS_HINT, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
            }
            if (Core.player.isDebugMode() && hintIndex < level.getNumHints() - 1 || hintIndex < Math.min(level.getNumHints() - 1, GameController.getTimesFailed() - 3)) {
                textDialog.addTextButton("Next Hint", "Next Hint", "info", 8, 5, Button.NEXT_HINT, LemmFont.LemmColor.BLUE, LemmFont.LemmColor.YELLOW);
            }
        }
    }

    public static void nextHint() {
        ++hintIndex;
        TextScreen.showHint();
    }

    public static void previousHint() {
        --hintIndex;
        TextScreen.showHint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextDialog getDialog() {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            return textDialog;
        }
    }

    public static void init() {
        rotCtr = 0;
        TextScreen.drawLogo();
        scrollPixCtr = 0;
        TextScreen.drawScroller();
        textDialog = new TextDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            switch (mode) {
                case INTRO: {
                    TextScreen.update_intro();
                    break;
                }
                case BRIEFING: {
                    TextScreen.update_briefing();
                    break;
                }
                case DEBRIEFING: {
                    TextScreen.update_debriefing();
                    break;
                }
            }
        }
    }

    private static void update_intro() {
        textDialog.clearGroup("introAnimation");
        int logoY = -140;
        if (GameController.getMenuThemeOption() == GameController.MenuThemeOption.WINLEMM) {
            logoY = -128;
        }
        if (++rotCtr > 99) {
            int rotImgFrameIdx = rotCtr - 99;
            if (rotImgFrameIdx >= rotImg.length) {
                rotImgFrameIdx -= (rotImgFrameIdx - 21 + 1) * 2;
            }
            if (rotImgFrameIdx <= 0) {
                rotImgFrameIdx = 0;
                rotCtr = 0;
            }
            LemmImage rotImgFrame = rotImg[rotImgFrameIdx];
            textDialog.addImage(rotImgFrame, "introAnimation", logoY - rotImgFrame.getHeight() / 2);
        } else {
            textDialog.addImage(rotImg[0], "introAnimation", logoY - rotImg[0].getHeight() / 2);
        }
        LemmImage subimage = scrollerImg.getSubimage(scrollPixCtr, 0, 750, scrollerImg.getHeight());
        textDialog.addImage(subimage, "introAnimation", 164);
        LemmImage lScrollerLem = MiscGfx.getImage(MiscGfx.Index.SCROLLER_LEMMING_LEFT);
        LemmImage rScrollerLem = MiscGfx.getImage(MiscGfx.Index.SCROLLER_LEMMING_RIGHT);
        textDialog.addImage(lScrollerLem, "introAnimation", -391, 148);
        textDialog.addImage(rScrollerLem, "introAnimation", 327, 148);
        if ((scrollPixCtr += 2) >= scrollerImg.getWidth() - 750) {
            scrollPixCtr = 0;
        }
    }

    private static void update_briefing() {
    }

    private static void update_debriefing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawScreen(GraphicsContext g, int x, int y, int width, int height) {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            textDialog.drawScreen(g, x, y, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMenuTheme() {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            switch (mode) {
                case INTRO: {
                    TextScreen.initIntro();
                    TextScreen.drawLogo();
                    break;
                }
                case BRIEFING: {
                    TextScreen.initBriefing();
                    TextScreen.drawLogo();
                    break;
                }
                case DEBRIEFING: {
                    TextScreen.initDebriefing();
                    TextScreen.drawLogo();
                    break;
                }
            }
        }
    }

    private static MiscGfx.Index getLogoImageIndex() {
        if (GameController.getMenuThemeOption() == GameController.MenuThemeOption.AMIGA) {
            return MiscGfx.Index.RETROLEMMINI_LOGO_AMIGA;
        }
        return MiscGfx.Index.RETROLEMMINI_LOGO_WINLEMM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawLogo() {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            MiscGfx.Index img = TextScreen.getLogoImageIndex();
            int width = GameController.getMenuThemeOption() == GameController.MenuThemeOption.WINLEMM ? 480 : 560;
            int height = GameController.getMenuThemeOption() == GameController.MenuThemeOption.WINLEMM ? 140 : 185;
            rotImg = new LemmImage[21];
            TextScreen.rotImg[0] = MiscGfx.getImage(img).getScaledInstance(width, height);
            int i = 1;
            while (i < rotImg.length) {
                TextScreen.rotImg[i] = i < 11 ? rotImg[0].getScaledInstance(rotImg[0].getWidth(), Math.max((int)((double)rotImg[0].getHeight() * ((20.0 - (double)i * 2.0) / 20.0)), 1), RenderingHints.VALUE_INTERPOLATION_BILINEAR, false) : rotImg[20 - i].transform(false, false, true);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toggleScrollerType() {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            TextScreen.drawScroller();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawScroller() {
        Object object = TextScreen.getMonitor();
        synchronized (object) {
            LemmImage tempScrollerImg = ToolBox.createLemmImage(LemmFont.getWidth() * (LemmFont.getCharCount(SCROLL_TEXT) + 8) + 1500, LemmFont.getHeight());
            LemmFont.LemmColor textColor = LemmFont.LemmColor.YELLOW;
            GraphicsContext scrollerGfx = null;
            try {
                scrollerGfx = tempScrollerImg.createGraphicsContext();
                scrollerGfx.setBackground(new Color(0, 0, 0, 0));
                LemmFont.strImage(scrollerGfx, SCROLL_TEXT, 750 + LemmFont.getWidth() * 4, 0, textColor);
            }
            finally {
                if (scrollerGfx != null) {
                    scrollerGfx.dispose();
                }
            }
            LemmImage tickerTape = MiscGfx.getImage(MiscGfx.Index.TICKER_TAPE_BLUE);
            double scaleHeight = 1.0;
            double scaleWidth = 1.0;
            if (GameController.isOptionEnabled(GameController.SLTooOption.CLASSIC_SCROLLER)) {
                scaleHeight = 0.8;
                scaleWidth = 0.8;
            }
            double padding = 60.0;
            scrollerImg = ToolBox.createLemmImage((int)((double)tempScrollerImg.getWidth() * scaleWidth + padding) + tickerTape.getWidth() * 2, Math.max((int)((double)tempScrollerImg.getHeight() * scaleHeight), tickerTape.getHeight()));
            try {
                scrollerGfx = scrollerImg.createGraphicsContext();
                scrollerGfx.setBackground(new Color(0, 0, 0, 0));
                if (GameController.isOptionEnabled(GameController.SLTooOption.CLASSIC_SCROLLER)) {
                    int idx = 0;
                    do {
                        scrollerGfx.drawImage(tickerTape, idx, 0);
                    } while ((idx += tickerTape.getWidth()) < scrollerImg.getWidth());
                    scrollerGfx.drawImage(tempScrollerImg, 0, 6, scaleHeight);
                } else {
                    scrollerGfx.drawImage(tempScrollerImg, 0, 0, scrollerImg.getWidth(), scrollerImg.getHeight());
                }
            }
            finally {
                if (scrollerGfx != null) {
                    scrollerGfx.dispose();
                }
            }
        }
    }

    public static Object getMonitor() {
        return monitor;
    }

    public static enum Button {
        PLAY_LEVEL,
        CHOOSE_LEVEL,
        LOAD_REPLAY,
        ENTER_CODE,
        PLAYERS,
        OPTIONS,
        ABOUT,
        EXIT,
        START_LEVEL,
        SHOW_HINT,
        SHOW_INFO,
        NEXT_HINT,
        PREVIOUS_HINT,
        CONTINUE,
        RESTART,
        MENU,
        REPLAY,
        SAVE_REPLAY,
        NONE;

    }

    public static enum Mode {
        INIT,
        INTRO,
        BRIEFING,
        DEBRIEFING;

    }
}

