/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import lemmini.game.Button;
import lemmini.game.LemmFont;
import lemmini.game.TextButton;
import lemmini.game.TextDialogImage;
import lemmini.game.TextScreen;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;

public class TextDialog {
    private final Map<String, List<TextDialogImage>> images;
    private final Map<String, List<Button>> buttons = new LinkedHashMap<String, List<Button>>();
    private LemmImage backgroundImage;
    private boolean tileBackground;

    public TextDialog() {
        this.images = new LinkedHashMap<String, List<TextDialogImage>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, List<Object>> map = this.images;
        synchronized (map) {
            this.images.clear();
        }
        map = this.buttons;
        synchronized (map) {
            this.buttons.clear();
        }
        this.backgroundImage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawScreen(GraphicsContext g, int x, int y, int width, int height) {
        int widthHalf = width / 2;
        int heightHalf = height / 2;
        int centerX = widthHalf + x;
        int centerY = heightHalf + y;
        if (this.backgroundImage != null) {
            if (this.tileBackground) {
                int imageWidth = this.backgroundImage.getWidth();
                int imageHeight = this.backgroundImage.getHeight();
                int xMin = widthHalf % imageWidth == 0 ? 0 : centerX - (widthHalf / imageWidth + 1) * imageWidth;
                int yMin = heightHalf % imageHeight == 0 ? 0 : centerY - (heightHalf / imageHeight + 1) * imageHeight;
                int xa = xMin;
                while (xa < x + width) {
                    int ya = yMin;
                    while (ya < y + width) {
                        g.drawImage(this.backgroundImage, xa, ya);
                        ya += imageHeight;
                    }
                    xa += imageWidth;
                }
            } else {
                int xa = x + (width - this.backgroundImage.getWidth()) / 2;
                int ya = y + (height - this.backgroundImage.getHeight()) / 2;
                g.drawImage(this.backgroundImage, xa, ya);
            }
        }
        Map<String, List<Object>> map = this.images;
        synchronized (map) {
            this.images.keySet().stream().forEachOrdered(s -> this.images.get(s).stream().forEachOrdered(img -> img.draw(g, centerX, centerY)));
        }
        map = this.buttons;
        synchronized (map) {
            this.buttons.keySet().stream().forEachOrdered(s -> this.buttons.get(s).stream().forEachOrdered(b -> b.draw(g, centerX, centerY)));
        }
    }

    public void setBackground(LemmImage image, boolean tiled) {
        this.backgroundImage = image;
        this.tileBackground = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addString(String s, String group, int x0, int y0, LemmFont.LemmColor col) {
        if (LemmFont.getCharCount(s) <= 0) {
            return;
        }
        int width = LemmFont.getWidth();
        int height = LemmFont.getHeight();
        List<String> sa = LemmFont.split(s, 0);
        Map<String, List<TextDialogImage>> map = this.images;
        synchronized (map) {
            this.addImageGroup(group);
            List<TextDialogImage> groupList = this.images.get(group);
            int x = x0 * width;
            ListIterator<String> lit = sa.listIterator();
            while (lit.hasNext()) {
                int i = lit.nextIndex();
                String line = lit.next();
                if (LemmFont.getCharCount(line) <= 0) continue;
                int y = (y0 + i) * (height + 4);
                groupList.add(new TextDialogImage(line, x, y, col));
            }
        }
    }

    public void addString(String s, String group, int x, int y) {
        this.addString(s, group, x, y, LemmFont.LemmColor.GREEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStringCentered(String s, String group, int y0, LemmFont.LemmColor col) {
        if (LemmFont.getCharCount(s) <= 0) {
            return;
        }
        int width = LemmFont.getWidth();
        int height = LemmFont.getHeight();
        List<String> sa = LemmFont.split(s, Math.max(1, 800 / width));
        Map<String, List<TextDialogImage>> map = this.images;
        synchronized (map) {
            this.addImageGroup(group);
            List<TextDialogImage> groupList = this.images.get(group);
            ListIterator<String> lit = sa.listIterator();
            while (lit.hasNext()) {
                int i = lit.nextIndex();
                String line = lit.next();
                int charCount = LemmFont.getCharCount(line);
                if (charCount <= 0) continue;
                if (charCount % 2 > 0) {
                    charCount = charCount + 2 - charCount % 2;
                }
                int y = (y0 + i) * (height + 4);
                int x = -(charCount * width / 2);
                groupList.add(new TextDialogImage(line, x, y, col));
            }
        }
    }

    public void addStringCentered(String s, String group, int y) {
        this.addStringCentered(s, group, y, LemmFont.LemmColor.GREEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(LemmImage img, String group, int x, int y) {
        Map<String, List<TextDialogImage>> map = this.images;
        synchronized (map) {
            this.addImageGroup(group);
            this.images.get(group).add(new TextDialogImage(img, x, y));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(LemmImage img, String group, int y) {
        int x = -(img.getWidth() / 2);
        Map<String, List<TextDialogImage>> map = this.images;
        synchronized (map) {
            this.addImageGroup(group);
            this.images.get(group).add(new TextDialogImage(img, x, y));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addButton(LemmImage img, LemmImage imgSelected, LemmImage imgPressed, String group, int x, int y, TextScreen.Button type) {
        Button b = new Button(x, y, type);
        b.SetImage(img);
        b.SetImageSelected(imgSelected);
        b.SetImagePressed(imgPressed);
        Map<String, List<Button>> map = this.buttons;
        synchronized (map) {
            this.addButtonGroup(group);
            this.buttons.get(group).add(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTextButton(String t, String ts, String group, int x0, int y0, TextScreen.Button type, LemmFont.LemmColor textCol, LemmFont.LemmColor selectedCol) {
        int x = x0 * LemmFont.getWidth();
        int y = y0 * (LemmFont.getHeight() + 4);
        TextButton b = new TextButton(x, y, type);
        b.setText(t, textCol);
        b.setTextSelected(ts, selectedCol);
        Map<String, List<Button>> map = this.buttons;
        synchronized (map) {
            this.addButtonGroup(group);
            this.buttons.get(group).add(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextScreen.Button handleLeftClick(int x, int y) {
        Map<String, List<Button>> map = this.buttons;
        synchronized (map) {
            for (List<Button> bl : this.buttons.values()) {
                for (Button b : bl) {
                    if (!b.inside(x, y)) continue;
                    b.pressed = b.inside(x, y);
                    return b.type;
                }
            }
        }
        return TextScreen.Button.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMouseReleased() {
        Map<String, List<Button>> map = this.buttons;
        synchronized (map) {
            for (List<Button> bl : this.buttons.values()) {
                for (Button b : bl) {
                    b.pressed = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMouseMove(int x, int y) {
        Map<String, List<Button>> map = this.buttons;
        synchronized (map) {
            this.buttons.values().stream().forEach(bl -> bl.stream().forEach(b -> {
                b.selected = b.inside(x, y);
            }));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearGroup(String group) {
        Map<String, List<Object>> map = this.images;
        synchronized (map) {
            if (this.images.containsKey(group)) {
                this.images.get(group).clear();
            }
        }
        map = this.buttons;
        synchronized (map) {
            if (this.buttons.containsKey(group)) {
                this.buttons.get(group).clear();
            }
        }
    }

    private void addImageGroup(String group) {
        if (!this.images.containsKey(group)) {
            this.images.put(group, new ArrayList(16));
        }
    }

    private void addButtonGroup(String group) {
        if (!this.buttons.containsKey(group)) {
            this.buttons.put(group, new ArrayList(16));
        }
    }
}

