/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import lemmini.game.StencilPixel;
import org.apache.commons.lang3.ArrayUtils;

public class Stencil {
    public static final int MSK_EMPTY = 0;
    public static final int MSK_BRICK = 1;
    public static final int MSK_STEEL_BRICK = 2;
    public static final int MSK_STEEL_OBJECT = 4;
    public static final int MSK_STEEL = 6;
    public static final int MSK_NO_ONE_WAY = 8;
    public static final int MSK_NO_ONE_WAY_DRAW = 16;
    public static final int MSK_TURN_LEFT = 32;
    public static final int MSK_TURN_RIGHT = 64;
    public static final int MSK_BLOCKER_LEFT = 128;
    public static final int MSK_BLOCKER_CENTER = 256;
    public static final int MSK_BLOCKER_RIGHT = 512;
    public static final int MSK_BLOCKER = 896;
    public static final int MSK_ONE_WAY_LEFT = 1024;
    public static final int MSK_ONE_WAY_RIGHT = 2048;
    public static final int MSK_ONE_WAY = 3072;
    public static final int MSK_TRAP_LIQUID = 4096;
    public static final int MSK_TRAP_REMOVE = 8192;
    public static final int MSK_TRAP_FIRE = 16384;
    public static final int MSK_TRAP = 28672;
    public static final int MSK_EXIT = 32768;
    private final StencilPixel[] stencil;
    private final int width;
    private final int height;

    public Stencil(int w, int h) {
        this.width = w;
        this.height = h;
        this.stencil = new StencilPixel[this.width * this.height];
        int i = 0;
        while (i < this.stencil.length) {
            this.stencil[i] = new StencilPixel();
            ++i;
        }
    }

    public void clear() {
        int size = this.width * this.height;
        int idx = 0;
        while (idx < size) {
            this.stencil[idx].clear();
            ++idx;
        }
    }

    public void setMask(int x, int y, int val) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        int pos = x + y * this.width;
        this.stencil[pos].setMask(val);
    }

    public void setMask(int pos, int val) {
        int y = pos / this.width;
        int x = pos % this.width;
        this.setMask(x, y, val);
    }

    public void andMask(int x, int y, int val) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        int pos = x + y * this.width;
        this.stencil[pos].andMask(val);
    }

    public void andMask(int pos, int val) {
        int y = pos / this.width;
        int x = pos % this.width;
        this.andMask(x, y, val);
    }

    public void orMask(int x, int y, int val) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        int pos = x + y * this.width;
        this.stencil[pos].orMask(val);
    }

    public void orMask(int pos, int val) {
        int y = pos / this.width;
        int x = pos % this.width;
        this.orMask(x, y, val);
    }

    public void setMaskObjectID(int x, int y, int id) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        int pos = x + y * this.width;
        this.stencil[pos].setMaskObjectID(id);
    }

    public void setMaskObjectID(int pos, int id) {
        int y = pos / this.width;
        int x = pos % this.width;
        this.setMaskObjectID(x, y, id);
    }

    public int getMask(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return 0;
        }
        int pos = x + y * this.width;
        return this.stencil[pos].getMask();
    }

    public int getMask(int pos) {
        int y = pos / this.width;
        int x = pos % this.width;
        return this.getMask(x, y);
    }

    public void addGadget(int x, int y, int aMask, int aID) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        int pos = x + y * this.width;
        this.stencil[pos].addGadget(aMask, aID);
    }

    public void addID(int x, int y, int id) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return;
        }
        int pos = x + y * this.width;
        this.stencil[pos].addObjectID(id);
    }

    public void addID(int pos, int id) {
        int y = pos / this.width;
        int x = pos % this.width;
        this.addID(x, y, id);
    }

    public int[] getIDs(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        int pos = x + y * this.width;
        return this.stencil[pos].getObjectIDs();
    }

    public int[] getIDs(int pos) {
        int y = pos / this.width;
        int x = pos % this.width;
        return this.getIDs(x, y);
    }

    public int getMaskObjectID(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            return -1;
        }
        int pos = x + y * this.width;
        return this.stencil[pos].getMaskObjectID();
    }

    public int getMaskObjectID(int pos) {
        int y = pos / this.width;
        int x = pos % this.width;
        return this.getMaskObjectID(x, y);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

