/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.util.ArrayList;
import java.util.ListIterator;
import lemmini.game.GraphicSet;
import lemmini.game.ResourceException;
import lemmini.gameutil.Sprite;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.ArrayUtils;

public class SpriteObject
extends Sprite {
    private int x;
    private int y;
    private Type type;
    private boolean[][] mask;
    private int maskOffsetX;
    private int maskOffsetY;
    private int maskWidth;
    private int maskHeight;
    private boolean visOnTerrain;

    public static Type getType(int t) {
        switch (t) {
            case 1: {
                return Type.TURN_LEFT;
            }
            case 2: {
                return Type.TURN_RIGHT;
            }
            case 3: {
                return Type.ONE_WAY_RIGHT;
            }
            case 4: {
                return Type.ONE_WAY_LEFT;
            }
            case 5: {
                return Type.TRAP_DROWN;
            }
            case 6: {
                return Type.TRAP_REPLACE;
            }
            case 7: {
                return Type.TRAP_DIE;
            }
            case 8: {
                return Type.EXIT;
            }
            case 9: {
                return Type.STEEL;
            }
            case 32: {
                return Type.ENTRANCE;
            }
        }
        return Type.PASSIVE;
    }

    public SpriteObject(LemmImage sourceImg, int animFrames, int animSpeed, boolean modifiable) {
        super(sourceImg, animFrames, animSpeed, modifiable);
        this.type = Type.PASSIVE;
        this.x = 0;
        this.y = 0;
    }

    public SpriteObject(GraphicSet.LvlObject obj, GraphicSet.Orientation orientation, boolean modifiable) throws ResourceException {
        super(obj.getImages(orientation), obj.getSpeed(), modifiable);
        this.animMode = obj.getAnimationMode();
        this.type = obj.getType();
        this.mask = obj.getMask();
        this.maskOffsetX = obj.getMaskOffsetX();
        this.maskOffsetY = obj.getMaskOffsetY();
        this.maskWidth = ArrayUtils.isNotEmpty((Object[])this.mask) ? this.mask[0].length : 0;
        this.maskHeight = this.mask.length;
        this.sound = (int[])obj.getSound().clone();
        this.x = 0;
        this.y = 0;
    }

    public SpriteObject(SpriteObject src) {
        super(src);
        this.x = src.getX();
        this.y = src.getY();
        this.mask = (boolean[][])src.mask.clone();
        int i = 0;
        while (i < this.mask.length) {
            this.mask[i] = (boolean[])this.mask[i].clone();
            ++i;
        }
        this.maskOffsetX = src.getMaskOffsetX();
        this.maskOffsetY = src.getMaskOffsetY();
        this.maskWidth = src.getMaskWidth();
        this.maskHeight = src.getMaskHeight();
        this.type = src.type;
        this.mask = src.mask;
    }

    int getMaskType() {
        switch (this.type) {
            case TURN_LEFT: {
                return 32;
            }
            case TURN_RIGHT: {
                return 64;
            }
            case ONE_WAY_LEFT: {
                return 1024;
            }
            case ONE_WAY_RIGHT: {
                return 2048;
            }
            case TRAP_DROWN: {
                return 4096;
            }
            case TRAP_REPLACE: {
                return 8192;
            }
            case TRAP_DIE: {
                return 16384;
            }
            case EXIT: {
                return 32768;
            }
            case STEEL: {
                return 4;
            }
        }
        return -1;
    }

    public final void setX(int xi) {
        this.x = xi;
    }

    public int getX() {
        return this.x;
    }

    public int midX() {
        return this.x + this.width / 2;
    }

    public final void setY(int yi) {
        this.y = yi;
    }

    public int getY() {
        return this.y;
    }

    public int midY() {
        return this.y + this.height / 2;
    }

    public int getMaskOffsetX() {
        return this.maskOffsetX;
    }

    public int getMaskOffsetY() {
        return this.maskOffsetY;
    }

    public int getMaskWidth() {
        return this.maskWidth;
    }

    public int getMaskHeight() {
        return this.maskHeight;
    }

    public void setVisOnTerrain(boolean vis) {
        this.visOnTerrain = vis;
        if (vis && !this.modifiable) {
            this.frames = new ArrayList(this.frames);
            this.origColors = new int[this.numFrames][];
            ListIterator<LemmImage> lit = this.frames.listIterator();
            while (lit.hasNext()) {
                int i = lit.nextIndex();
                LemmImage frame = ToolBox.copyLemmImage((LemmImage)lit.next());
                lit.set(frame);
                this.origColors[i] = frame.getRGB(0, 0, this.width, this.height, null, 0, this.width);
            }
        } else if (!vis && this.modifiable) {
            this.origColors = null;
        }
        this.modifiable = vis;
    }

    public void setType(Type t) {
        this.type = t;
    }

    public Type getType() {
        return this.type;
    }

    public boolean getVisOnTerrain() {
        return this.visOnTerrain;
    }

    public boolean getMask(int x, int y) {
        int tempX = x - this.maskOffsetX;
        int tempY = y - this.maskOffsetY;
        if (this.type != Type.PASSIVE && this.type != Type.ENTRANCE && tempY >= 0 && tempY < this.maskHeight && tempX >= 0 && tempX < this.maskWidth) {
            return this.mask[tempY][tempX];
        }
        return false;
    }

    public static enum Type {
        PASSIVE(false, false),
        TURN_LEFT(true, false),
        TURN_RIGHT(true, false),
        ONE_WAY_LEFT(false, true),
        ONE_WAY_RIGHT(false, true),
        TRAP_DROWN(true, false),
        TRAP_REPLACE(true, false),
        TRAP_DIE(true, false),
        EXIT(true, false),
        STEEL(false, false),
        ENTRANCE(false, false);

        private final boolean triggeredByFoot;
        private final boolean oneWay;

        private Type(boolean triggeredByFoot, boolean sometimesIndestructible) {
            this.triggeredByFoot = triggeredByFoot;
            this.oneWay = sometimesIndestructible;
        }

        public boolean isTriggeredByFoot() {
            return this.triggeredByFoot;
        }

        public boolean isOneWay() {
            return this.oneWay;
        }
    }
}

