/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import lemmini.game.Core;
import lemmini.game.GraphicSet;
import lemmini.game.LemmException;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.graphics.LemmImage;
import lemmini.tools.Props;

public class SpecialGraphicSet {
    private static final List<String> DEFAULT_SPECIAL_STYLES = Arrays.asList("awesome", "menace", "beastii", "beasti", "covox", "prima", "apple");
    private final String name;
    private final Props props;
    private final Color bgColor;
    private final int debrisColor;
    private final int debrisColor2;
    private final int[] particleColor;
    private final int positionX;
    private final int positionY;
    private LemmImage image = null;
    private boolean[][] mask = null;
    private boolean[][] steelMask = null;

    public SpecialGraphicSet(String name) throws LemmException, ResourceException {
        int x;
        LemmImage sourceImage;
        this.name = name;
        this.props = new Props();
        Resource resource = Core.findResource("styles/special/" + name + "/" + name + ".ini", true);
        if (!this.props.load(resource)) {
            throw new LemmException("Unable to read " + name + ".ini.");
        }
        int bgCol = this.props.getInt("bgColor", this.props.getInt("bgColor", 0)) | 0xFF000000;
        this.bgColor = new Color(bgCol);
        this.debrisColor = this.props.getInt("debrisColor", 0xFFFFFF) | 0xFF000000;
        this.debrisColor2 = this.props.getInt("debrisColor2", this.debrisColor) | 0xFF000000;
        this.particleColor = this.props.getIntArray("particleColor", this.props.getIntArray("particleColor", GraphicSet.DEFAULT_PARTICLE_COLORS));
        int i = 0;
        while (i < this.particleColor.length) {
            int n = i++;
            this.particleColor[n] = this.particleColor[n] | 0xFF000000;
        }
        this.positionX = this.props.getInt("positionX", 0);
        this.positionY = this.props.getInt("positionY", 0);
        resource = Core.findResource("styles/special/" + name + "/" + name + ".png", Core.IMAGE_EXTENSIONS);
        this.image = Core.loadLemmImage(resource);
        try {
            resource = Core.findResource("styles/special/" + name + "/" + name + "m.png", Core.IMAGE_EXTENSIONS);
            sourceImage = Core.loadLemmImage(resource);
        }
        catch (ResourceException ex) {
            sourceImage = this.image;
        }
        this.mask = new boolean[sourceImage.getHeight()][sourceImage.getWidth()];
        int y = 0;
        while (y < this.mask.length) {
            x = 0;
            while (x < this.mask[y].length) {
                this.mask[y][x] = sourceImage.getRGB(x, y) >>> 24 >= 128;
                ++x;
            }
            ++y;
        }
        try {
            resource = Core.findResource("styles/special/" + name + "/" + name + "s.png", Core.IMAGE_EXTENSIONS);
            sourceImage = Core.loadLemmImage(resource);
            this.steelMask = new boolean[sourceImage.getHeight()][sourceImage.getWidth()];
            y = 0;
            while (y < this.steelMask.length) {
                x = 0;
                while (x < this.steelMask[y].length) {
                    this.steelMask[y][x] = sourceImage.getRGB(x, y) >>> 24 >= 128;
                    ++x;
                }
                ++y;
            }
        }
        catch (ResourceException ex) {
            this.steelMask = new boolean[0][0];
        }
    }

    public String getName() {
        return this.name;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public int getDebrisColor() {
        return this.debrisColor;
    }

    public int getDebrisColor2() {
        return this.debrisColor2;
    }

    public int[] getParticleColor() {
        return this.particleColor;
    }

    public int getPositionX() {
        return this.positionX;
    }

    public int getPositionY() {
        return this.positionY;
    }

    public LemmImage getImage() {
        return this.image;
    }

    public boolean[][] getMask() {
        return this.mask;
    }

    public boolean[][] getSteelMask() {
        return this.steelMask;
    }
}

