/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import lemmini.LemminiFrame;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.LemmException;
import lemmini.game.Lemming;
import lemmini.game.LevelPack;
import lemmini.game.ReplayAssignSkillEvent;
import lemmini.game.ReplayEvent;
import lemmini.game.ReplayLevelInfo;
import lemmini.game.ReplayMovePosEvent;
import lemmini.game.ReplayReleaseRateEvent;
import lemmini.game.ReplaySelectSkillEvent;
import lemmini.tools.ToolBox;

public class ReplayStream {
    static final int ASSIGN_SKILL = 0;
    static final int MOVE_POS = 1;
    static final int SELECT_SKILL = 2;
    static final int SET_RELEASE_RATE = 3;
    static final int NUKE = 4;
    static final int END = 5;
    static final int CURRENT_FORMAT = 1;
    static final String CURRENT_REVISION = "2.3";
    static final String SUPERLEMMINI_REVISION = "0.104";
    private List<ReplayEvent> events = new ArrayList<ReplayEvent>(256);
    private int replayIndex = 0;
    private int format = 0;
    private String revision;
    private int players;

    public void rewind() {
        this.replayIndex = 0;
    }

    ReplayEvent getNext(int ctr) {
        if (this.replayIndex >= this.events.size()) {
            return null;
        }
        ReplayEvent r = this.events.get(this.replayIndex);
        if (ctr >= r.frameCtr) {
            ++this.replayIndex;
            return r;
        }
        return null;
    }

    public void clear() {
        this.events.clear();
    }

    public void clearFrom(int ctr) {
        int i = this.events.size() - 1;
        while (i >= 0) {
            ReplayEvent r = this.events.get(i);
            if (r.frameCtr <= ctr && (r.frameCtr != ctr || i <= this.replayIndex)) break;
            this.events.remove(i);
            --i;
        }
        this.replayIndex = 0;
    }

    public ReplayLevelInfo load(Path fname) throws LemmException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = ToolBox.getBufferedReader(fname);){
                ArrayList<ReplayEvent> ev = new ArrayList<ReplayEvent>(256);
                String line = br.readLine();
                if (!line.equals("#REPLAY NEW")) {
                    throw new LemmException("First line of replay does not equal \"#REPLAY NEW\".");
                }
                line = br.readLine();
                if (line.startsWith("#FORMAT ")) {
                    this.format = Integer.parseInt(line.substring(8).trim());
                    if (this.format > 1) {
                        throw new LemmException(String.format("Unsupported replay format: %d", this.format));
                    }
                } else {
                    throw new LemmException("Replay file does not specify a format.");
                }
                line = br.readLine();
                if (!line.startsWith("#REVISION ")) {
                    throw new LemmException("Replay file does not specify a revision.");
                }
                this.revision = line.substring(10).trim();
                line = br.readLine();
                if (line.startsWith("#Players ")) {
                    this.players = Integer.parseInt(line.substring(9).trim());
                    if (this.players != 1) {
                        throw new LemmException("Replay file does not contain exactly one player.");
                    }
                } else {
                    throw new LemmException("Replay file does not specify a player count.");
                }
                line = br.readLine();
                String[] e = line.split(",");
                int j = 0;
                while (j < e.length) {
                    e[j] = e[j].trim();
                    ++j;
                }
                if (e.length < 3 || e[0].charAt(0) != '#') {
                    throw new LemmException("Replay file does not specify a level.");
                }
                ReplayLevelInfo rli = new ReplayLevelInfo();
                rli.setLevelPack(e[0].substring(1));
                rli.setRatingNumber(Integer.parseInt(e[1]));
                rli.setLvlNumber(Integer.parseInt(e[2]));
                if (e.length >= 4) {
                    rli.setRatingName(e[3]);
                } else {
                    rli.setRatingName(null);
                }
                if (e.length >= 5) {
                    rli.setLvlName(e[4]);
                } else {
                    rli.setLvlName(null);
                }
                while ((line = br.readLine()) != null) {
                    e = line.split(",");
                    int i = 0;
                    while (i < e.length) {
                        e[i] = e[i].trim();
                        ++i;
                    }
                    if (e.length < 2) {
                        throw new LemmException("Not enough values in replay event.");
                    }
                    switch (Integer.parseInt(e[1])) {
                        case 0: {
                            if (e.length < 4) {
                                throw new LemmException("Not enough values in replay event for ASSIGN_SKILL.");
                            }
                            boolean isTimedBomber = e.length >= 5 ? Boolean.parseBoolean(e[4]) : GameController.isOptionEnabled(GameController.SLTooOption.TIMED_BOMBERS);
                            ev.add(new ReplayAssignSkillEvent(Integer.parseInt(e[0]), Lemming.Type.valueOf(e[2]), Integer.parseInt(e[3]), isTimedBomber));
                            break;
                        }
                        case 1: {
                            if (e.length < 5) {
                                throw new LemmException("Not enough values in replay event.");
                            }
                            ev.add(new ReplayMovePosEvent(Integer.parseInt(e[0]), Integer.parseInt(e[2]), Integer.parseInt(e[3]), Integer.parseInt(e[4])));
                            break;
                        }
                        case 2: {
                            if (e.length < 4) {
                                throw new LemmException("Not enough values in replay event.");
                            }
                            ev.add(new ReplaySelectSkillEvent(Integer.parseInt(e[0]), Lemming.Type.valueOf(e[2]), Integer.parseInt(e[3])));
                            break;
                        }
                        case 3: {
                            if (e.length < 3) {
                                throw new LemmException("Not enough values in replay event.");
                            }
                            ev.add(new ReplayReleaseRateEvent(Integer.parseInt(e[0]), Integer.parseInt(e[2])));
                            break;
                        }
                        case 4: {
                            ev.add(new ReplayEvent(Integer.parseInt(e[0]), 4));
                            break;
                        }
                        case 5: {
                            ev.add(new ReplayEvent(Integer.parseInt(e[0]), 5));
                            break;
                        }
                        default: {
                            throw new LemmException(String.format("Unsupported event found: %s", e[1]));
                        }
                    }
                }
                this.events = ev;
                if (!this.revision.equals(CURRENT_REVISION) && !this.revision.equals(SUPERLEMMINI_REVISION)) {
                    JOptionPane.showMessageDialog(LemminiFrame.getFrame(), "This replay was created with a potentially incompatible version of RetroLemmini. For this reason, the replay might not play properly.", "Load Replay", 2);
                }
                return rli;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ArrayIndexOutOfBoundsException | NumberFormatException e) {
            throw new LemmException("Error reading replay file.");
        }
    }

    private boolean save(BufferedWriter w) {
        try {
            w.write("#REPLAY NEW");
            w.newLine();
            w.write("#FORMAT 1");
            w.newLine();
            w.write("#REVISION 2.3");
            w.newLine();
            w.write("#Players 1");
            w.newLine();
            LevelPack lp = GameController.getCurLevelPack();
            w.write(String.format("#%s, %d, %d, %s, %s", lp.getName().trim(), GameController.getCurRating(), GameController.getCurLevelNumber(), lp.getRatings().get(GameController.getCurRating()).trim(), GameController.getLevel().getLevelName().trim()));
            w.newLine();
            for (ReplayEvent r : this.events) {
                w.write(r.toString());
                w.newLine();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean save(Path fname) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter w = Files.newBufferedWriter(fname, new OpenOption[0]);){
                return this.save(w);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            return false;
        }
    }

    public boolean save(String fname) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedWriter w = Core.resourceTree.newBufferedWriter(fname, new OpenOption[0]);){
                return this.save(w);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            return false;
        }
    }

    public void addNukeEvent(int ctr) {
        ReplayEvent event = new ReplayEvent(ctr, 4);
        this.events.add(event);
    }

    public void addEndEvent(int ctr) {
        this.removeEndEvent();
        ReplayEvent event = new ReplayEvent(ctr, 5);
        this.events.add(event);
    }

    public void addAssignSkillEvent(int ctr, Lemming.Type skill, int lemming) {
        boolean isTimedBomber = GameController.isOptionEnabled(GameController.SLTooOption.TIMED_BOMBERS);
        ReplayAssignSkillEvent event = new ReplayAssignSkillEvent(ctr, skill, lemming, isTimedBomber);
        this.events.add(event);
    }

    public void addSelectSkillEvent(int ctr, Lemming.Type skill, int plr) {
        ReplaySelectSkillEvent event = new ReplaySelectSkillEvent(ctr, skill, plr);
        this.events.add(event);
    }

    public void addPosEvent(int ctr, int xPos, int yPos, int plr) {
        ReplayMovePosEvent event = new ReplayMovePosEvent(ctr, xPos, yPos, plr);
        this.events.add(event);
    }

    public void addReleaseRateEvent(int ctr, int releaseRate) {
        ReplayReleaseRateEvent event = new ReplayReleaseRateEvent(ctr, releaseRate);
        this.events.add(event);
    }

    private void removeEndEvent() {
        ListIterator<ReplayEvent> lit = this.events.listIterator(this.events.size());
        while (lit.hasPrevious()) {
            ReplayEvent r = lit.previous();
            if (r.type != 5) continue;
            lit.remove();
        }
    }
}

