/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.LevelPack;
import lemmini.game.LevelRecord;
import lemmini.tools.Props;
import lemmini.tools.ToolBox;
import org.apache.commons.io.FilenameUtils;

public class Player {
    private Props props;
    private Map<String, LevelGroup> lvlGroups;
    private boolean debugMode;
    private boolean maximumExitPhysics;
    private String name;

    public Player(String n) {
        block13: {
            System.out.println("    initalizing player: " + n);
            this.name = n;
            this.lvlGroups = new LinkedHashMap<String, LevelGroup>();
            this.props = new Props();
            Path iniFilePath = Player.getPlayerINIFilePath(this.name);
            System.out.println("    loading player level stats: " + iniFilePath);
            if (this.props.load(iniFilePath)) {
                int idx = 0;
                while (true) {
                    System.out.print("    loading level group " + idx);
                    String[] s = this.props.getArray("group" + idx, null);
                    if (s == null || s.length < 2 || s[0] == null) {
                        System.out.println(": <no valid group data found. skipping...>");
                        break block13;
                    }
                    String s1 = s[s.length - 1];
                    String groupName = "";
                    int a = 0;
                    while (a < s.length - 1) {
                        groupName = String.valueOf(groupName) + s[a];
                        if (a < s.length - 2) {
                            groupName = String.valueOf(groupName) + ", ";
                        }
                        ++a;
                    }
                    System.out.print(": \ufffd" + groupName + "\ufffd");
                    BigInteger unlockedLevels = ToolBox.parseBigInteger(s1);
                    System.out.println("  [" + unlockedLevels.bitLength() + ":" + unlockedLevels.toString(16) + "]");
                    LinkedHashMap<Integer, LevelRecord> levelRecords = new LinkedHashMap<Integer, LevelRecord>();
                    System.out.print("    building level stats map...");
                    if (GameController.isOptionEnabled(GameController.SLTooOption.DEBUG_VERBOSE_PLAYER_LOAD)) {
                        System.out.println();
                    }
                    int compCount = 0;
                    int maxLevel = this.props.getHighestLevel(idx) + 1;
                    maxLevel = Math.max(maxLevel, unlockedLevels.bitLength());
                    int j = 0;
                    while (j < maxLevel) {
                        String levelSetting;
                        String completedKey;
                        boolean completed;
                        if (GameController.isOptionEnabled(GameController.SLTooOption.DEBUG_VERBOSE_PLAYER_LOAD)) {
                            System.out.print("     level " + j + ": ");
                        }
                        if (completed = this.props.getBoolean(completedKey = String.valueOf(levelSetting = "group" + idx + "_level" + j) + "_completed", false)) {
                            ++compCount;
                            int lemmingsSaved = this.props.getInt(String.valueOf(levelSetting) + "_lemmingsSaved", -1);
                            int skillsUsed = this.props.getInt(String.valueOf(levelSetting) + "_skillsUsed", -1);
                            int timeElapsed = this.props.getInt(String.valueOf(levelSetting) + "_timeElapsed", -1);
                            int score = this.props.getInt(String.valueOf(levelSetting) + "_score", -1);
                            levelRecords.put(j, new LevelRecord(completed, lemmingsSaved, skillsUsed, timeElapsed, score));
                            if (GameController.isOptionEnabled(GameController.SLTooOption.DEBUG_VERBOSE_PLAYER_LOAD)) {
                                System.out.print("[completed]");
                                System.out.print(" saved: " + lemmingsSaved);
                                System.out.print(" skills: " + skillsUsed);
                                System.out.print(" time: " + timeElapsed);
                                System.out.print(" score: " + score);
                            }
                        } else {
                            levelRecords.put(j, LevelRecord.BLANK_LEVEL_RECORD);
                            if (GameController.isOptionEnabled(GameController.SLTooOption.DEBUG_VERBOSE_PLAYER_LOAD)) {
                                System.out.print("[incomplete] ... creating blank records.");
                            }
                        }
                        if (GameController.isOptionEnabled(GameController.SLTooOption.DEBUG_VERBOSE_PLAYER_LOAD)) {
                            System.out.println();
                        }
                        ++j;
                    }
                    this.lvlGroups.put(groupName, new LevelGroup(levelRecords));
                    System.out.println("     Highest recorded level: " + maxLevel + ", Total completed: " + compCount);
                    ++idx;
                }
            }
            System.out.println("    ini file not found... new one created.");
        }
        this.debugMode = false;
        System.out.println();
    }

    public void setDebugMode(boolean d) {
        this.debugMode = d;
    }

    public void setMaximumExitPhysics(boolean e) {
        this.maximumExitPhysics = e;
    }

    public void store() {
        Set<String> groupKeys = this.lvlGroups.keySet();
        int idx = 0;
        for (String s : groupKeys) {
            LevelGroup lg = this.lvlGroups.get(s);
            String sout = String.valueOf(s) + ", " + lg.getBitField();
            this.props.set("group" + idx, sout);
            Set availableLevels = lg.levelRecords.keySet();
            for (Integer lvlNum : availableLevels) {
                LevelRecord lr = (LevelRecord)lg.levelRecords.get(lvlNum);
                if (!lr.isCompleted()) continue;
                this.props.setBoolean("group" + idx + "_level" + lvlNum + "_completed", true);
                this.props.setInt("group" + idx + "_level" + lvlNum + "_lemmingsSaved", lr.getLemmingsSaved());
                this.props.setInt("group" + idx + "_level" + lvlNum + "_skillsUsed", lr.getSkillsUsed());
                this.props.setInt("group" + idx + "_level" + lvlNum + "_timeElapsed", lr.getTimeElapsed());
                this.props.setInt("group" + idx + "_level" + lvlNum + "_score", lr.getScore());
            }
            ++idx;
        }
        this.props.save(Player.getPlayerINIFilePath(this.name), true);
    }

    public void setAvailable(String pack, String rating, int num) {
        String id = LevelPack.getID(pack, rating);
        LevelGroup lg = this.lvlGroups.get(id);
        if (lg == null) {
            LinkedHashMap<Integer, LevelRecord> records = new LinkedHashMap<Integer, LevelRecord>();
            records.put(0, LevelRecord.BLANK_LEVEL_RECORD);
            lg = new LevelGroup(records);
            this.lvlGroups.put(id, lg);
        }
        if (!lg.levelRecords.containsKey(num)) {
            lg.levelRecords.put(num, LevelRecord.BLANK_LEVEL_RECORD);
        }
    }

    public boolean isAvailable(String pack, String rating, int num) {
        if (GameController.isOptionEnabled(GameController.SLTooOption.UNLOCK_ALL_LEVELS) || this.isDebugMode()) {
            return true;
        }
        String id = LevelPack.getID(pack, rating);
        LevelGroup lg = this.lvlGroups.get(id);
        if (lg == null) {
            return num == 0;
        }
        return lg.levelRecords.containsKey(num);
    }

    public void setLevelRecord(String pack, String rating, int num, LevelRecord record) {
        String id = LevelPack.getID(pack, rating);
        LevelGroup lg = this.lvlGroups.get(id);
        if (lg == null) {
            LinkedHashMap<Integer, LevelRecord> records = new LinkedHashMap<Integer, LevelRecord>();
            records.put(0, LevelRecord.BLANK_LEVEL_RECORD);
            lg = new LevelGroup(records);
            this.lvlGroups.put(id, lg);
        }
        if (record.isCompleted()) {
            LevelRecord oldRecord = (LevelRecord)lg.levelRecords.get(num);
            if (oldRecord != null) {
                lg.levelRecords.put(num, new LevelRecord(true, Math.max(oldRecord.getLemmingsSaved(), record.getLemmingsSaved()), Math.min(oldRecord.getSkillsUsed(), record.getSkillsUsed()), Math.min(oldRecord.getTimeElapsed(), record.getTimeElapsed()), Math.max(oldRecord.getScore(), record.getScore())));
            } else {
                lg.levelRecords.put(num, record);
            }
        }
    }

    public LevelRecord getLevelRecord(String pack, String rating, int num) {
        String id = LevelPack.getID(pack, rating);
        LevelGroup lg = this.lvlGroups.get(id);
        if (lg == null || !lg.levelRecords.containsKey(num)) {
            return LevelRecord.BLANK_LEVEL_RECORD;
        }
        return (LevelRecord)lg.levelRecords.get(num);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isMaximumExitPhysics() {
        return this.maximumExitPhysics;
    }

    public static Path getPlayerINIFilePath(String name) {
        Path retFile = Core.settingsTree.getPath("players/" + Player.addEscapes(name) + ".ini");
        if (Files.notExists(retFile, new LinkOption[0])) {
            for (Path file : Core.settingsTree.getAllPathsRegex("players/[^/]+\\.ini")) {
                String fileName = FilenameUtils.removeExtension(file.getFileName().toString());
                String convertedFileName = Player.convertEscapes(fileName);
                if (!convertedFileName.equals(name)) continue;
                retFile = file;
                break;
            }
        }
        return retFile;
    }

    public static void deletePlayerINIFile(String name) {
        Core.resourceTree.getAllPathsRegex("players/[^/]+\\.ini").stream().map(file -> FilenameUtils.removeExtension(file.getFileName().toString())).forEach(fileName -> {
            String convertedFileName = Player.convertEscapes(fileName);
            if (convertedFileName.equals(name)) {
                try {
                    Core.resourceTree.delete("players/" + fileName + ".ini");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public static String addEscapes(String s) {
        boolean convertAllChars;
        int length = s.length();
        StringBuilder sb = null;
        switch (s.toLowerCase(Locale.ROOT)) {
            case "aux": 
            case "con": 
            case "nul": 
            case "prn": 
            case "com0": 
            case "com1": 
            case "com2": 
            case "com3": 
            case "com4": 
            case "com5": 
            case "com6": 
            case "com7": 
            case "com8": 
            case "com9": 
            case "lpt0": 
            case "lpt1": 
            case "lpt2": 
            case "lpt3": 
            case "lpt4": 
            case "lpt5": 
            case "lpt6": 
            case "lpt7": 
            case "lpt8": 
            case "lpt9": {
                convertAllChars = true;
                break;
            }
            default: {
                convertAllChars = false;
            }
        }
        int i = 0;
        while (i < length) {
            boolean convertChar;
            int c = s.codePointAt(i);
            if (convertAllChars) {
                convertChar = true;
            } else {
                switch (c) {
                    case 34: 
                    case 42: 
                    case 47: 
                    case 58: 
                    case 60: 
                    case 62: 
                    case 63: 
                    case 92: 
                    case 95: 
                    case 124: {
                        convertChar = true;
                        break;
                    }
                    default: {
                        boolean bl = convertChar = c < 32 || c > 126 || i == 0 && c == 46;
                    }
                }
            }
            if (convertChar) {
                if (sb == null) {
                    sb = new StringBuilder(length * 5);
                    sb.append(s.substring(0, i));
                }
                if (Character.isBmpCodePoint(c)) {
                    sb.append(String.format(Locale.ROOT, "_%04x", c));
                } else {
                    sb.append(String.format(Locale.ROOT, "__%06x", c));
                }
            } else if (sb != null) {
                sb.appendCodePoint(c);
            }
            i += Character.charCount(c);
        }
        return sb == null ? s : sb.toString();
    }

    public static String convertEscapes(String s) {
        int length = s.length();
        StringBuilder sb = null;
        int i = 0;
        while (i < length) {
            if (i < s.length() - 4 && s.charAt(i) == '_' && ToolBox.isHexDigit(s.charAt(i + 1)) && ToolBox.isHexDigit(s.charAt(i + 2)) && ToolBox.isHexDigit(s.charAt(i + 3)) && ToolBox.isHexDigit(s.charAt(i + 4))) {
                if (sb == null) {
                    sb = new StringBuilder(length);
                    sb.append(s.substring(0, i));
                }
                sb.append((char)Integer.parseInt(s.substring(i + 1, i + 5), 16));
                i += 4;
            } else if (i < s.length() - 7 && s.charAt(i) == '_' && s.charAt(i + 1) == '_' && ToolBox.isHexDigit(s.charAt(i + 2)) && ToolBox.isHexDigit(s.charAt(i + 3)) && ToolBox.isHexDigit(s.charAt(i + 4)) && ToolBox.isHexDigit(s.charAt(i + 5)) && ToolBox.isHexDigit(s.charAt(i + 6)) && ToolBox.isHexDigit(s.charAt(i + 7))) {
                if (sb == null) {
                    sb = new StringBuilder(length);
                    sb.append(s.substring(0, i));
                }
                sb.appendCodePoint(Integer.parseInt(s.substring(i + 2, i + 8), 16));
                i += 7;
            } else if (sb != null) {
                sb.append(s.charAt(i));
            }
            ++i;
        }
        return sb == null ? s : sb.toString();
    }

    private class LevelGroup {
        private final Map<Integer, LevelRecord> levelRecords;

        private LevelGroup(Map<Integer, LevelRecord> levelRecords) {
            this.levelRecords = levelRecords;
        }

        private BigInteger getBitField() {
            Set<Integer> availableLevels = this.levelRecords.keySet();
            BigInteger bf = BigInteger.ZERO;
            for (Integer lvlNum : availableLevels) {
                bf = bf.setBit(lvlNum);
            }
            return bf;
        }
    }
}

