/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lemmini.game.Core;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;

public class NumFont {
    private static int width;
    private static int height;
    private static final List<LemmImage> NUM_IMG;
    private static final Map<Integer, LemmImage> NUM_IMG_MAP;

    static {
        NUM_IMG = new ArrayList<LemmImage>(15);
        NUM_IMG_MAP = new HashMap<Integer, LemmImage>();
    }

    public static void init() throws ResourceException {
        LemmImage numImgTemp2;
        Resource resource = Core.findResource("gfx/misc/numfont.png", Core.IMAGE_EXTENSIONS);
        NUM_IMG.clear();
        LemmImage sourceImg = Core.loadLemmImage(resource);
        width = sourceImg.getWidth();
        height = sourceImg.getHeight() / 10;
        List<LemmImage> numImgTemp = ToolBox.getAnimation(sourceImg, 10);
        NUM_IMG.addAll(numImgTemp);
        resource = Core.findResource("gfx/misc/numfont2.png", Core.IMAGE_EXTENSIONS);
        sourceImg = Core.loadLemmImage(resource);
        numImgTemp = ToolBox.getAnimation(sourceImg, 5);
        NUM_IMG.addAll(numImgTemp);
        NUM_IMG_MAP.clear();
        GraphicsContext g = null;
        int i = 0;
        while (i < 100) {
            numImgTemp2 = ToolBox.createLemmImage(width * 2, height);
            try {
                g = numImgTemp2.createGraphicsContext();
                g.drawImage(NUM_IMG.get(i / 10), 0, 0);
                g.drawImage(NUM_IMG.get(i % 10), width, 0);
            }
            finally {
                if (g != null) {
                    g.dispose();
                }
            }
            NUM_IMG_MAP.put(i, numImgTemp2);
            ++i;
        }
        numImgTemp2 = ToolBox.createLemmImage(width * 2, height);
        try {
            g = numImgTemp2.createGraphicsContext();
            g.drawImage(NUM_IMG.get(13), 0, 0);
            g.drawImage(NUM_IMG.get(14), width, 0);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        NUM_IMG_MAP.put(Integer.MAX_VALUE, numImgTemp2);
        numImgTemp2 = ToolBox.createLemmImage(width * 3, height);
        try {
            g = numImgTemp2.createGraphicsContext();
            g.drawImage(NUM_IMG.get(10), 0, 0);
            g.drawImage(NUM_IMG.get(13), width, 0);
            g.drawImage(NUM_IMG.get(14), width * 2, 0);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        NUM_IMG_MAP.put(Integer.MIN_VALUE, numImgTemp2);
        numImgTemp2 = ToolBox.createLemmImage(width * 2, height);
        try {
            g = numImgTemp2.createGraphicsContext();
            g.drawImage(NUM_IMG.get(10), 0, 0);
            g.drawImage(NUM_IMG.get(10), width, 0);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        NUM_IMG_MAP.put(null, numImgTemp2);
    }

    public static LemmImage numImage(Integer n) {
        LemmImage numImgTemp = NUM_IMG_MAP.get(n);
        if (numImgTemp != null) {
            return numImgTemp;
        }
        String numString = n.toString();
        numImgTemp = ToolBox.createLemmImage(width * numString.length(), height);
        GraphicsContext g = null;
        try {
            g = numImgTemp.createGraphicsContext();
            int i = 0;
            while (i < numString.length()) {
                int numIndex = -1;
                switch (numString.charAt(i)) {
                    case '-': {
                        numIndex = 10;
                        break;
                    }
                    case '0': {
                        numIndex = 0;
                        break;
                    }
                    case '1': {
                        numIndex = 1;
                        break;
                    }
                    case '2': {
                        numIndex = 2;
                        break;
                    }
                    case '3': {
                        numIndex = 3;
                        break;
                    }
                    case '4': {
                        numIndex = 4;
                        break;
                    }
                    case '5': {
                        numIndex = 5;
                        break;
                    }
                    case '6': {
                        numIndex = 6;
                        break;
                    }
                    case '7': {
                        numIndex = 7;
                        break;
                    }
                    case '8': {
                        numIndex = 8;
                        break;
                    }
                    case '9': {
                        numIndex = 9;
                    }
                }
                if (numIndex >= 0) {
                    g.drawImage(NUM_IMG.get(numIndex), width * i, 0);
                }
                ++i;
            }
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        NUM_IMG_MAP.put(n, numImgTemp);
        return numImgTemp;
    }
}

