/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.util.ArrayList;
import java.util.List;
import lemmini.game.Core;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.game.Vsfx;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.math.NumberUtils;

public class MiscGfx {
    private static final List<LemmImage> images = new ArrayList<LemmImage>(16);
    private static final List<LemmImage> vsfx_images = new ArrayList<LemmImage>(30);
    private static LemmImage minimap;
    private static LemmImage minimapLarge;
    private static int minimapWidth;

    public static void init(int mmWidth) throws ResourceException {
        images.clear();
        Resource resource = Core.findResource("gfx/icons/minimap_left.png", Core.IMAGE_EXTENSIONS);
        LemmImage img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/icons/minimap_center.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/icons/minimap_right.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/iconbar/large_minimap_left.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/iconbar/large_minimap_center.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/iconbar/large_minimap_right.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/misc/minimap_arrows.png", Core.IMAGE_EXTENSIONS);
        List<LemmImage> anim = ToolBox.getAnimation(Core.loadLemmImage(resource), 4);
        images.addAll(anim);
        resource = Core.findResource("gfx/menu/retrolemmini_logo_amiga.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/retrolemmini_logo_retro.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/background_level_amiga.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/background_level_retro.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/background_main_amiga.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/background_main_retro.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/misc/replay.png", Core.IMAGE_EXTENSIONS);
        anim = ToolBox.getAnimation(Core.loadLemmImage(resource), 2);
        images.addAll(anim);
        resource = Core.findResource("gfx/misc/select.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/misc/status-icons.png", Core.IMAGE_EXTENSIONS);
        anim = ToolBox.getAnimation(Core.loadLemmImage(resource), 4);
        images.addAll(anim);
        resource = Core.findResource("gfx/iconbar/iconbar_filler.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/ticker_tape_blue.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/ticker_tape_pink.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/ticker_tape_yellow.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/scroller_lemming_left.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/scroller_lemming_right.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/menu_lemming.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/card_play_level_lemming.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/card_choose_level_lemming.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/card_codes.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/card_options.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/card_players.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/card_replays.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/floater_lemming.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/version_retro.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/menu/version_numbers_retro.png", Core.IMAGE_EXTENSIONS);
        img = Core.loadLemmImage(resource);
        images.add(img);
        resource = Core.findResource("gfx/misc/vsfxbig.png", Core.IMAGE_EXTENSIONS);
        anim = ToolBox.getAnimation(Core.loadLemmImage(resource), 28);
        vsfx_images.addAll(anim);
        minimapWidth = -1;
        MiscGfx.setMinimapWidth(mmWidth);
    }

    public static LemmImage getImage(Index idx) {
        return images.get(idx.ordinal());
    }

    public static LemmImage getVsfxImage(Vsfx.Vsfx_Index idx) {
        return vsfx_images.get(idx.ordinal());
    }

    public static LemmImage getVsfxImage(int idx) {
        return vsfx_images.get(idx);
    }

    public static LemmImage getMinimapImage() {
        return minimap;
    }

    public static LemmImage getMinimapLargeImage() {
        return minimapLarge;
    }

    public static int getMinimapWidth() {
        return minimapWidth;
    }

    public static void setMinimapWidth(int width) {
        if (width == minimapWidth) {
            return;
        }
        minimapWidth = width;
        minimap = MiscGfx.createMiniMapFrame(width);
        minimapLarge = MiscGfx.createLargeMiniMapFrame(width);
    }

    private static LemmImage createMiniMapFrame(int width) {
        int x;
        int BORDER = 4;
        LemmImage minimapLeft = images.get(Index.MINIMAP_LEFT.ordinal());
        LemmImage minimapCenter = images.get(Index.MINIMAP_CENTER.ordinal());
        LemmImage minimapRight = images.get(Index.MINIMAP_RIGHT.ordinal());
        int leftWidth = Math.min(minimapLeft.getWidth(), 4 + width);
        int centerWidth = width + 4 - leftWidth;
        int rightWidth = minimapRight.getWidth();
        LemmImage tempMinimap = ToolBox.createLemmImage(leftWidth + centerWidth + rightWidth, NumberUtils.max((int)minimapLeft.getHeight(), (int)minimapCenter.getHeight(), (int)minimapRight.getHeight()));
        int y = 0;
        while (y < minimapLeft.getHeight()) {
            x = 0;
            while (x < leftWidth) {
                tempMinimap.setRGB(x, y, minimapLeft.getRGB(x, y));
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < minimapCenter.getHeight()) {
            x = 0;
            while (x < centerWidth) {
                tempMinimap.setRGB(leftWidth + x, y, minimapCenter.getRGB(x % minimapCenter.getWidth(), y));
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < minimapRight.getHeight()) {
            x = 0;
            while (x < rightWidth) {
                tempMinimap.setRGB(4 + width + x, y, minimapRight.getRGB(x, y));
                ++x;
            }
            ++y;
        }
        return tempMinimap;
    }

    private static LemmImage createLargeMiniMapFrame(int width) {
        int x;
        int BORDER = 7;
        LemmImage minimapLeft = images.get(Index.MINIMAP_LARGE_LEFT.ordinal());
        LemmImage minimapCenter = images.get(Index.MINIMAP_LARGE_CENTER.ordinal());
        LemmImage minimapRight = images.get(Index.MINIMAP_LARGE_RIGHT.ordinal());
        int leftWidth = Math.min(minimapLeft.getWidth(), 7 + width);
        int centerWidth = width + 7 - leftWidth;
        int rightWidth = minimapRight.getWidth();
        LemmImage tempMinimap = ToolBox.createLemmImage(leftWidth + centerWidth + rightWidth, NumberUtils.max((int)minimapLeft.getHeight(), (int)minimapCenter.getHeight(), (int)minimapRight.getHeight()));
        int y = 0;
        while (y < minimapLeft.getHeight()) {
            x = 0;
            while (x < leftWidth) {
                tempMinimap.setRGB(x, y, minimapLeft.getRGB(x, y));
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < minimapCenter.getHeight()) {
            x = 0;
            while (x < centerWidth) {
                tempMinimap.setRGB(leftWidth + x, y, minimapCenter.getRGB(x % minimapCenter.getWidth(), y));
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < minimapRight.getHeight()) {
            x = 0;
            while (x < rightWidth) {
                tempMinimap.setRGB(7 + width + x, y, minimapRight.getRGB(x, y));
                ++x;
            }
            ++y;
        }
        return tempMinimap;
    }

    public static List<LemmImage> getAnimation(Index index, int frameCount) {
        LemmImage spriteSheet = MiscGfx.getImage(index);
        return ToolBox.getAnimation(spriteSheet, frameCount);
    }

    public static enum Index {
        MINIMAP_LEFT,
        MINIMAP_CENTER,
        MINIMAP_RIGHT,
        MINIMAP_LARGE_LEFT,
        MINIMAP_LARGE_CENTER,
        MINIMAP_LARGE_RIGHT,
        MINIMAP_ARROW_LEFT,
        MINIMAP_ARROW_UP,
        MINIMAP_ARROW_RIGHT,
        MINIMAP_ARROW_DOWN,
        RETROLEMMINI_LOGO_AMIGA,
        RETROLEMMINI_LOGO_WINLEMM,
        BACKGROUND_LEVEL_AMIGA,
        BACKGROUND_LEVEL_WINLEMM,
        BACKGROUND_MAIN_AMIGA,
        BACKGROUND_MAIN_WINLEMM,
        REPLAY_1,
        REPLAY_2,
        SELECT,
        STATUS_HATCH,
        STATUS_HOME,
        STATUS_ACTIVE,
        STATUS_TIME,
        ICONBAR_FILLER,
        TICKER_TAPE_BLUE,
        TICKER_TAPE_PINK,
        TICKER_TAPE_YELLOW,
        SCROLLER_LEMMING_LEFT,
        SCROLLER_LEMMING_RIGHT,
        MENU_LEMMING,
        CARD_PLAY_LEVEL_LEMMING,
        CARD_CHOOSE_LEVEL_LEMMING,
        CARD_CODES,
        CARD_OPTIONS,
        CARD_PLAYERS,
        CARD_REPLAYS,
        FLOATER_LEMMING,
        VERSION_WINLEMM,
        VERSION_NUMS_WINLEMM;

    }
}

