/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Color;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.Level;
import lemmini.game.MiscGfx;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;

public class Minimap {
    private static final Color LEMM_COLOR = Color.RED;
    private static final Color FRAME_COLOR = Color.YELLOW;
    private static final int LEMM_DOT_SCALE = 2;
    private static final int MAX_VISIBLE_WIDTH = 200;
    private static final int MAX_VISIBLE_HEIGHT = 40;
    private static LemmImage img;
    private static double scaleX;
    private static double scaleY;
    private static int visibleWidth;
    private static int visibleHeight;
    private static int xPos;
    private static boolean tinted;

    public static void init(double sx, double sy, boolean tint) {
        scaleX = sx;
        scaleY = sy;
        tinted = tint;
        Level level = GameController.getLevel();
        LemmImage fgImage = GameController.getFgImage();
        img = level.createMinimap(fgImage, scaleX, scaleY, false, tint, false);
        visibleWidth = Math.min(img.getWidth(), 200);
        visibleHeight = Math.min(img.getHeight(), 40);
        MiscGfx.setMinimapWidth(visibleWidth);
        if (visibleWidth >= img.getWidth()) {
            xPos = 0;
        } else {
            int xPosTemp = ToolBox.scale(GameController.getLevel().getXPosCenter(), scaleX) - visibleWidth / 2;
            xPos = ToolBox.cap(0, xPosTemp, img.getWidth() - visibleWidth);
        }
    }

    public static void draw(GraphicsContext g, int x, int y) {
        g.drawImage(img, x - xPos, y - ToolBox.scale(GameController.getYPos(), scaleY));
    }

    public static void drawLemming(GraphicsContext g, int x, int y, int lx, int ly) {
        int sx = x + ToolBox.scale(lx, scaleX) - xPos - 1;
        int sy = y + ToolBox.scale(ly - GameController.getYPos(), scaleY) - 2;
        if (sx + 2 > x && sx < x + visibleWidth && sy + 2 > y && sy < y + visibleHeight) {
            g.setColor(LEMM_COLOR);
            g.fillRect(sx, sy, 2, 2);
        }
    }

    public static void drawFrame(GraphicsContext g, int x, int y) {
        int wWidth = ToolBox.scale(Core.getDrawWidth(), scaleX);
        int scaledXPos = ToolBox.scale(GameController.getXPos(), scaleX);
        g.setColor(FRAME_COLOR);
        if (GameController.getWidth() < Core.getDrawWidth()) {
            g.drawRect(x, y, ToolBox.scale(GameController.getWidth(), scaleX) - 1, visibleHeight - 1);
        } else {
            g.drawRect(x + scaledXPos - xPos, y, wWidth - 1, visibleHeight - 1);
        }
    }

    public static LemmImage getImage() {
        return img;
    }

    public static int getVisibleWidth() {
        return visibleWidth;
    }

    public static int getVisibleHeight() {
        return visibleHeight;
    }

    public static int getXPos() {
        return xPos;
    }

    public static double getScaleX() {
        return scaleX;
    }

    public static double getScaleY() {
        return scaleY;
    }

    public static int move(int x, int y) {
        int scaledDrawWidth = ToolBox.scale(Core.getDrawWidth(), scaleX);
        int cappedX = (int)ToolBox.cap((double)scaledDrawWidth / 2.0, (double)x, (double)Math.max(visibleWidth, scaledDrawWidth) - (double)scaledDrawWidth / 2.0);
        return ToolBox.unscale(cappedX - scaledDrawWidth / 2 + xPos, scaleX);
    }

    public static void adjustXPos() {
        if (img.getWidth() <= 200) {
            xPos = 0;
        } else {
            int scaledDrawWidth = ToolBox.scale(Core.getDrawWidth(), scaleX);
            int scaledXPos = ToolBox.cap(0, ToolBox.scale(GameController.getXPos(), scaleX), img.getWidth() - scaledDrawWidth);
            if (scaledXPos < xPos) {
                xPos = scaledXPos;
            } else if (scaledXPos > xPos + visibleWidth - scaledDrawWidth) {
                xPos = scaledXPos + scaledDrawWidth - visibleWidth;
            }
        }
    }

    public static boolean isTinted() {
        return tinted;
    }

    public static int tintColor(int color) {
        int alpha = (color & 0xFF000000) >>> 24;
        int sum = 0;
        int i = 0;
        while (i < 3) {
            sum += color >> 8 * i & 0xFF;
            ++i;
        }
        sum /= 3;
        if ((sum += 96) > 255) {
            sum = 255;
        }
        color = alpha << 24 | sum << 8 & 0xFF00;
        return color;
    }
}

