/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import lemmini.game.GameController;
import lemmini.game.Minimap;
import lemmini.game.SpriteObject;
import lemmini.game.Stencil;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.BooleanUtils;

public class Mask {
    private final int width;
    private final int height;
    private final List<LemmImage> mask;
    private final List<LemmImage> originalColorMask;

    public Mask(LemmImage img, int frames) {
        this.width = img.getWidth();
        this.height = img.getHeight() / frames;
        this.mask = ToolBox.getAnimation(img, frames);
        this.originalColorMask = new ArrayList<LemmImage>(this.mask);
    }

    public void eraseMask(int x0, int y0, int maskNum, int eraseMask, int checkMask) {
        int xMax;
        LemmImage fgImage = GameController.getFgImage();
        LemmImage fgImageSmall = Minimap.getImage();
        Stencil stencil = GameController.getStencil();
        LemmImage m = this.mask.get(maskNum);
        double scaleX = (double)fgImageSmall.getWidth() / (double)fgImage.getWidth();
        double scaleY = (double)fgImageSmall.getHeight() / (double)fgImage.getHeight();
        double scaleXHalf = scaleX / 2.0;
        double scaleYHalf = scaleY / 2.0;
        int yMax = y0 + this.height;
        if (yMax >= fgImage.getHeight()) {
            yMax = fgImage.getHeight();
        }
        if ((xMax = x0 + this.width) >= fgImage.getWidth()) {
            xMax = fgImage.getWidth();
        }
        int bgCol = Minimap.isTinted() ? 0 : GameController.getLevel().getBgColor().getRGB();
        int y = y0;
        while (y < yMax) {
            if (y >= 0) {
                double scaledY = ((double)y + 0.5) * scaleY % 1.0;
                boolean drawSmallY = scaledY >= (0.5 - scaleYHalf) % 1.0 && scaledY < (0.5 + scaleYHalf) % 1.0 || Math.abs(scaleY) >= 1.0;
                int x = x0;
                while (x < xMax) {
                    if (x >= 0) {
                        double scaledX = ((double)x + 0.5) * scaleX % 1.0;
                        boolean drawSmallX = scaledX >= (0.5 - scaleXHalf) % 1.0 && scaledX < (0.5 + scaleXHalf) % 1.0 || Math.abs(scaleX) >= 1.0;
                        int maskAlpha = m.getRGB(x - x0, y - y0) >>> 24;
                        int s = stencil.getMask(x, y);
                        if (!BooleanUtils.toBoolean((int)(s & checkMask))) {
                            int[] objects = stencil.getIDs(x, y);
                            fgImage.removeAlpha(x, y, maskAlpha);
                            if (drawSmallX && drawSmallY) {
                                fgImageSmall.removeAlpha(ToolBox.scale(x, scaleX), ToolBox.scale(y, scaleY), maskAlpha);
                                fgImageSmall.addRGBBehind(ToolBox.scale(x, scaleX), ToolBox.scale(y, scaleY), bgCol);
                            }
                            if (!fgImage.isPixelOpaque(x, y)) {
                                int[] nArray = objects;
                                int n = objects.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    int obj = nArray[n2];
                                    SpriteObject spr = GameController.getLevel().getSprObject(obj);
                                    if (spr != null && spr.getVisOnTerrain()) {
                                        spr.setPixelVisibility(x - spr.getX(), y - spr.getY(), false);
                                    }
                                    ++n2;
                                }
                            }
                            if (m.isPixelOpaque(x - x0, y - y0)) {
                                stencil.andMask(x, y, ~eraseMask);
                            }
                        }
                    }
                    ++x;
                }
            }
            ++y;
        }
    }

    public void paintStep(int x0, int y0, int maskNum) {
        int xMax;
        LemmImage fgImage = GameController.getFgImage();
        LemmImage fgImageSmall = Minimap.getImage();
        Stencil stencil = GameController.getStencil();
        LemmImage m = this.mask.get(maskNum);
        double scaleX = (double)fgImageSmall.getWidth() / (double)fgImage.getWidth();
        double scaleY = (double)fgImageSmall.getHeight() / (double)fgImage.getHeight();
        double scaleXHalf = scaleX / 2.0;
        double scaleYHalf = scaleY / 2.0;
        int yMax = y0 + this.height;
        if (yMax >= fgImage.getHeight()) {
            yMax = fgImage.getHeight();
        }
        if ((xMax = x0 + this.width) >= fgImage.getWidth()) {
            xMax = fgImage.getWidth();
        }
        int y = y0;
        while (y < yMax) {
            if (y >= 0) {
                double scaledY = ((double)y + 0.5) * scaleY % 1.0;
                boolean drawSmallY = scaledY >= (0.5 - scaleYHalf) % 1.0 && scaledY < (0.5 + scaleYHalf) % 1.0 || Math.abs(scaleY) >= 1.0;
                int x = x0;
                while (x < xMax) {
                    if (x >= 0) {
                        double scaledX = ((double)x + 0.5) * scaleX % 1.0;
                        boolean drawSmallX = scaledX >= (0.5 - scaleXHalf) % 1.0 && scaledX < (0.5 + scaleXHalf) % 1.0 || Math.abs(scaleX) >= 1.0;
                        int color = m.getRGB(x - x0, y - y0);
                        int[] objects = stencil.getIDs(x, y);
                        fgImage.addRGB(x, y, color);
                        if (drawSmallX && drawSmallY) {
                            int stepCol = Minimap.isTinted() ? Minimap.tintColor(color) : color;
                            fgImageSmall.addRGB(ToolBox.scale(x, scaleX), ToolBox.scale(y, scaleY), stepCol);
                        }
                        if (fgImage.isPixelOpaque(x, y)) {
                            int[] nArray = objects;
                            int n = objects.length;
                            int n2 = 0;
                            while (n2 < n) {
                                int obj = nArray[n2];
                                SpriteObject spr = GameController.getLevel().getSprObject(obj);
                                if (!(spr == null || !spr.getVisOnTerrain() || !GameController.getLevel().getClassicSteel() && spr.getType().isOneWay() || spr.getType().isOneWay() && BooleanUtils.toBoolean((int)(stencil.getMask(x, y) & 0x10)))) {
                                    spr.setPixelVisibility(x - spr.getX(), y - spr.getY(), true);
                                }
                                ++n2;
                            }
                        }
                        if (m.isPixelOpaque(x - x0, y - y0)) {
                            stencil.orMask(x, y, 1);
                        }
                    }
                    ++x;
                }
            }
            ++y;
        }
    }

    public void setBlockerMask(int x0, int y0) {
        int xMax;
        LemmImage fgImage = GameController.getFgImage();
        Stencil stencil = GameController.getStencil();
        int yMax = y0 + this.height;
        if (yMax >= fgImage.getHeight()) {
            yMax = fgImage.getHeight();
        }
        if ((xMax = x0 + this.width) >= fgImage.getWidth()) {
            xMax = fgImage.getWidth();
        }
        ListIterator<LemmImage> lit = this.mask.listIterator();
        while (lit.hasNext()) {
            int i = lit.nextIndex();
            if (i >= 3) break;
            LemmImage m = lit.next();
            int y = y0;
            while (y < yMax) {
                if (y >= 0) {
                    int x = x0;
                    while (x < xMax) {
                        if (x >= 0 && m.isPixelOpaque(x - x0, y - y0)) {
                            switch (i) {
                                case 0: {
                                    stencil.orMask(x, y, 128);
                                    break;
                                }
                                case 1: {
                                    stencil.orMask(x, y, 256);
                                    break;
                                }
                                case 2: {
                                    stencil.orMask(x, y, 512);
                                    break;
                                }
                            }
                        }
                        ++x;
                    }
                }
                ++y;
            }
        }
    }

    public boolean checkType(int x0, int y0, int maskNum, int type) {
        int xMax;
        Stencil stencil = GameController.getStencil();
        LemmImage m = this.mask.get(maskNum);
        int yMax = y0 + this.height;
        if (yMax >= stencil.getHeight()) {
            yMax = stencil.getHeight();
        }
        if ((xMax = x0 + this.width) >= stencil.getWidth()) {
            xMax = stencil.getWidth();
        }
        int y = y0;
        while (y < yMax) {
            if (y >= 0) {
                int x = x0;
                while (x < xMax) {
                    int s;
                    if (x >= 0 && m.isPixelOpaque(x - x0, y - y0) && ((s = stencil.getMask(x, y)) & type) != 0) {
                        return true;
                    }
                    ++x;
                }
            }
            ++y;
        }
        return false;
    }

    public void clearType(int x0, int y0, int maskNum, int type) {
        int xMax;
        LemmImage fgImage = GameController.getFgImage();
        Stencil stencil = GameController.getStencil();
        LemmImage m = this.mask.get(maskNum);
        int yMax = y0 + this.height;
        if (yMax >= fgImage.getHeight()) {
            yMax = fgImage.getHeight();
        }
        if ((xMax = x0 + this.width) >= fgImage.getWidth()) {
            xMax = fgImage.getWidth();
        }
        int y = y0;
        while (y < yMax) {
            if (y >= 0) {
                int x = x0;
                while (x < xMax) {
                    if (x >= 0 && m.isPixelOpaque(x - x0, y - y0)) {
                        stencil.andMask(x, y, ~type);
                    }
                    ++x;
                }
            }
            ++y;
        }
    }

    void replaceColors(int templateCol, int replaceCol, int templateCol2, int replaceCol2) {
        ListIterator<LemmImage> itf = this.originalColorMask.listIterator();
        while (itf.hasNext()) {
            int fi = itf.nextIndex();
            LemmImage i = ToolBox.copyLemmImage(itf.next());
            i.replaceColor(templateCol, replaceCol);
            i.replaceColor(templateCol2, replaceCol2);
            this.mask.set(fi, i);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNumFrames() {
        return this.mask.size();
    }
}

