/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.stream.Collectors;
import lemmini.game.LevelInfo;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.tools.Props;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.ArrayUtils;

public class LevelPack {
    public static final String FAILURE_A_DEF = "ROCK BOTTOM! I hope for your sake\nthat you nuked that level.";
    public static final String FAILURE_B_DEF = "Better rethink your strategy before\nyou try this level again!";
    public static final String FAILURE_C_DEF = "A little more practice on this level\nis definitely recommended.";
    public static final String FAILURE_D_DEF = "You got pretty close that time.\nNow try again for that few % extra.";
    public static final String FAILURE_E_DEF = "OH NO, So near and yet so far (teehee)\nMaybe this time.....";
    public static final String SUCCESS_A_DEF = "SPOT ON. You can't get much closer\nthan that. Let's try the next....";
    public static final String SUCCESS_B_DEF = "That level seemed no problem to you on\nthat attempt. Onto the next....";
    public static final String SUCCESS_C_DEF = "You totally stormed that level!\nLet's see if you can storm the next...";
    public static final String SUCCESS_D_DEF = "Superb! You rescued every lemming on\nthat level. Can you do it again....?";
    private String name;
    private boolean allLevelsUnlocked;
    private String codeSeed;
    private final List<String> ratings = new ArrayList<String>(16);
    private final List<List<LevelInfo>> lvlInfo = new ArrayList<List<LevelInfo>>(16);
    private final String path;
    private int maxFallDistance;
    private int codeOffset;
    private final List<String> debriefings = new ArrayList<String>(9);
    private final List<String> mods;

    public LevelPack() {
        this.name = "External Levels";
        this.allLevelsUnlocked = true;
        this.path = "";
        this.codeSeed = "";
        this.maxFallDistance = 126;
        this.codeOffset = 0;
        this.mods = Collections.emptyList();
        this.ratings.add("Single Levels");
        this.lvlInfo.add(new ArrayList(64));
        this.debriefings.add(FAILURE_A_DEF);
        this.debriefings.add(FAILURE_B_DEF);
        this.debriefings.add(FAILURE_C_DEF);
        this.debriefings.add(FAILURE_D_DEF);
        this.debriefings.add(FAILURE_E_DEF);
        this.debriefings.add(SUCCESS_A_DEF);
        this.debriefings.add(SUCCESS_B_DEF);
        this.debriefings.add(SUCCESS_C_DEF);
        this.debriefings.add(SUCCESS_D_DEF);
    }

    public LevelPack(Resource resource) throws ResourceException {
        String rating;
        String track;
        this.path = ToolBox.getParent(resource.getOriginalPath());
        Props props = new Props();
        if (!props.load(resource)) {
            throw new ResourceException(resource.toString());
        }
        this.name = props.get("name", "");
        this.allLevelsUnlocked = props.getBoolean("allLevelsUnlocked", false);
        String[] modsStr = props.getArray("mods", ArrayUtils.EMPTY_STRING_ARRAY);
        this.mods = Arrays.stream(modsStr).map(modStr -> "mods/" + modStr).collect(Collectors.toList());
        this.codeSeed = props.get("codeSeed", "").trim().toUpperCase(Locale.ROOT);
        this.codeOffset = props.getInt("codeOffset", 0);
        this.maxFallDistance = props.getInt("maxFallDistance", 126);
        ArrayList<String> music = new ArrayList<String>(64);
        int idx = 0;
        do {
            if ((track = props.get("music_" + idx++, "")).isEmpty()) continue;
            music.add(track);
        } while (!track.isEmpty());
        this.debriefings.add(props.get("failureA", FAILURE_A_DEF));
        this.debriefings.add(props.get("failureB", FAILURE_B_DEF));
        this.debriefings.add(props.get("failureC", FAILURE_C_DEF));
        this.debriefings.add(props.get("failureD", FAILURE_D_DEF));
        this.debriefings.add(props.get("failureE", FAILURE_E_DEF));
        this.debriefings.add(props.get("successA", SUCCESS_A_DEF));
        this.debriefings.add(props.get("successB", SUCCESS_B_DEF));
        this.debriefings.add(props.get("successC", SUCCESS_C_DEF));
        this.debriefings.add(props.get("successD", SUCCESS_D_DEF));
        idx = 0;
        do {
            rating = props.get("level_" + idx, "");
            ++idx;
            if (rating.isEmpty()) continue;
            this.ratings.add(rating);
        } while (!rating.isEmpty());
        ListIterator<String> lit = this.ratings.listIterator();
        while (lit.hasNext()) {
            String[] levelStr;
            int r = lit.nextIndex();
            idx = 0;
            ArrayList<LevelInfo> levels = new ArrayList<LevelInfo>(64);
            rating = lit.next().trim().toLowerCase(Locale.ROOT);
            do {
                if ((levelStr = props.getArray("level_" + r + "_" + idx, null)) == null) {
                    levelStr = props.getArray(String.valueOf(rating) + "_" + idx, null);
                }
                if (levelStr != null && levelStr.length >= 2) {
                    LevelInfo info = new LevelInfo(String.valueOf(this.path) + levelStr[0], (String)music.get(ToolBox.parseInt(levelStr[1])));
                    levels.add(info);
                }
                ++idx;
            } while (levelStr != null && levelStr.length >= 2);
            this.lvlInfo.add(levels);
        }
    }

    public static String getID(String pack, String rating) {
        pack = Normalizer.normalize(pack.toLowerCase(Locale.ROOT), Normalizer.Form.NFKC);
        rating = Normalizer.normalize(rating.toLowerCase(Locale.ROOT), Normalizer.Form.NFKC);
        return String.valueOf(pack) + "-" + rating;
    }

    public List<String> getRatings() {
        return Collections.unmodifiableList(this.ratings);
    }

    public String getName() {
        return this.name;
    }

    public String getCodeSeed() {
        return this.codeSeed;
    }

    public int getMaxFallDistance() {
        return this.maxFallDistance;
    }

    public List<String> getDebriefings() {
        return Collections.unmodifiableList(this.debriefings);
    }

    public boolean getAllLevelsUnlocked() {
        return this.allLevelsUnlocked;
    }

    public int getCodeOffset() {
        return this.codeOffset;
    }

    public LevelInfo getInfo(int rating, int level) {
        return this.lvlInfo.get(rating).get(level);
    }

    public void setInfo(int rating, int level, LevelInfo li) {
        this.lvlInfo.get(rating).set(level, li);
    }

    public void addLevel(int rating, LevelInfo li) {
        this.lvlInfo.get(rating).add(li);
    }

    public void removeLevel(int rating, int level) {
        this.lvlInfo.get(rating).remove(level);
    }

    public void addRating(String rating, List<LevelInfo> li) {
        this.ratings.add(rating);
        this.lvlInfo.add(li);
    }

    public void removeRating(int rating) {
        this.ratings.remove(rating);
        this.lvlInfo.remove(rating);
    }

    public List<String> getLevels(int rating) {
        return this.lvlInfo.get(rating).stream().map(li -> li.getName().trim()).collect(Collectors.toList());
    }

    public int getRatingCount() {
        return this.lvlInfo.size();
    }

    public int getLevelCount(int rating) {
        return this.lvlInfo.get(rating).size();
    }

    public List<String> getModPaths() {
        return Collections.unmodifiableList(this.mods);
    }
}

