/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import lemmini.game.Core;
import lemmini.game.FileResource;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.tools.Props;
import lemmini.tools.ToolBox;

public class LevelInfo {
    private String name;
    private String author;
    private String music;
    private Resource levelResource;
    private int releaseRate;
    private int numLemmings;
    private int numToRescue;
    private int timeLimitSeconds;
    private int numClimbers;
    private int numFloaters;
    private int numBombers;
    private int numBlockers;
    private int numBuilders;
    private int numBashers;
    private int numMiners;
    private int numDiggers;
    private boolean validLevel;

    public LevelInfo() {
        this.name = "";
        this.author = "";
        this.music = "";
        this.levelResource = new FileResource("", "", Core.resourceTree);
        this.releaseRate = 0;
        this.numLemmings = 1;
        this.numToRescue = 0;
        this.timeLimitSeconds = 0;
        this.numClimbers = 0;
        this.numFloaters = 0;
        this.numBombers = 0;
        this.numBlockers = 0;
        this.numBuilders = 0;
        this.numBashers = 0;
        this.numMiners = 0;
        this.numDiggers = 0;
        this.validLevel = false;
    }

    public LevelInfo(String fname, String newMusic) {
        Resource resource;
        try {
            resource = Core.findResource(fname, false);
        }
        catch (ResourceException ex) {
            resource = null;
        }
        this.init(resource, newMusic);
    }

    public LevelInfo(Resource resource, String newMusic) {
        this.init(resource, newMusic);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(Resource resource, String newMusic) {
        this.levelResource = resource;
        this.music = newMusic;
        this.name = "";
        this.author = "";
        this.releaseRate = 0;
        this.numLemmings = 1;
        this.numToRescue = 0;
        this.timeLimitSeconds = 0;
        this.numClimbers = 0;
        this.numFloaters = 0;
        this.numBombers = 0;
        this.numBlockers = 0;
        this.numBuilders = 0;
        this.numBashers = 0;
        this.numMiners = 0;
        this.numDiggers = 0;
        this.validLevel = false;
        if (resource == null) return;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader r = this.levelResource.getBufferedReader();){
                if (!ToolBox.checkFileID(r, "# LVL")) return;
                ArrayList<Props> propsList = new ArrayList<Props>(4);
                Props props = new Props();
                props.load(r);
                propsList.add(props);
                String mainLevel = props.get("mainLevel", "");
                while (true) {
                    if (mainLevel.isEmpty()) {
                        this.name = Props.get(propsList, "name", "");
                        this.author = Props.get(propsList, "author", "");
                        this.releaseRate = Props.getInt(propsList, "releaseRate", 0);
                        this.numLemmings = Props.getInt(propsList, "numLemmings", 1);
                        if (this.numLemmings > 0) break;
                        this.numLemmings = 1;
                        return;
                    }
                    Resource levelRes2 = this.levelResource.getSibling(mainLevel);
                    if (!levelRes2.exists()) {
                        return;
                    }
                    props = new Props();
                    Object object = null;
                    Object var11_15 = null;
                    try {
                        BufferedReader r2;
                        block25: {
                            r2 = levelRes2.getBufferedReader();
                            try {
                                if (!ToolBox.checkFileID(r2, "# LVL") || props.load(levelRes2)) break block25;
                                if (r2 == null) return;
                            }
                            catch (Throwable throwable2) {
                                if (r2 == null) throw throwable2;
                                ((Reader)r2).close();
                                throw throwable2;
                            }
                            ((Reader)r2).close();
                            return;
                        }
                        if (r2 != null) {
                            ((Reader)r2).close();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (object == null) {
                            object = throwable3;
                            throw object;
                        }
                        if (object == throwable3) throw object;
                        ((Throwable)object).addSuppressed(throwable3);
                        throw object;
                    }
                    propsList.add(props);
                    mainLevel = props.get("mainLevel", "");
                }
                this.numToRescue = Props.getInt(propsList, "numToRescue", 0);
                for (Props props2 : propsList) {
                    this.timeLimitSeconds = props2.getInt("timeLimitSeconds", Integer.MIN_VALUE);
                    if (this.timeLimitSeconds != Integer.MIN_VALUE) break;
                    int timeLimit = props2.getInt("timeLimit", Integer.MIN_VALUE);
                    if (timeLimit == Integer.MIN_VALUE) continue;
                    if (timeLimit >= 0x2222222 || timeLimit <= -35791394) {
                        timeLimit = 0;
                    }
                    this.timeLimitSeconds = timeLimit * 60;
                    break;
                }
                if (this.timeLimitSeconds == Integer.MAX_VALUE || this.timeLimitSeconds < 0) {
                    this.timeLimitSeconds = 0;
                }
                this.numClimbers = Props.getInt(propsList, "numClimbers", 0);
                this.numFloaters = Props.getInt(propsList, "numFloaters", 0);
                this.numBombers = Props.getInt(propsList, "numBombers", 0);
                this.numBlockers = Props.getInt(propsList, "numBlockers", 0);
                this.numBuilders = Props.getInt(propsList, "numBuilders", 0);
                this.numBashers = Props.getInt(propsList, "numBashers", 0);
                this.numMiners = Props.getInt(propsList, "numMiners", 0);
                this.numDiggers = Props.getInt(propsList, "numDiggers", 0);
                this.validLevel = true;
                return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.validLevel = false;
        }
    }

    public Resource getLevelResource() {
        return this.levelResource;
    }

    public void setMusic(String music) {
        this.music = music;
    }

    public String getMusic() {
        return this.music;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getReleaseRate() {
        return this.releaseRate;
    }

    public int getNumLemmings() {
        return this.numLemmings;
    }

    public int getNumToRescue() {
        return this.numToRescue;
    }

    public int getTimeLimit() {
        return this.timeLimitSeconds;
    }

    public int getNumClimbers() {
        return this.numClimbers;
    }

    public int getNumFloaters() {
        return this.numFloaters;
    }

    public int getNumBombers() {
        return this.numBombers;
    }

    public int getNumBlockers() {
        return this.numBlockers;
    }

    public int getNumBuilders() {
        return this.numBuilders;
    }

    public int getNumBashers() {
        return this.numBashers;
    }

    public int getNumMiners() {
        return this.numMiners;
    }

    public int getNumDiggers() {
        return this.numDiggers;
    }

    public boolean isValidLevel() {
        return this.validLevel && this.levelResource != null;
    }
}

