/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.nio.charset.StandardCharsets;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.BooleanUtils;

public class LevelCode {
    private static final int[] LMASK = new int[]{1, 2, 4, 8, 16, 32, 192};
    private static final int[] LSHIFTL;
    private static final int[] LSHIFTR;
    private static final int[] PMASK;
    private static final int[] PSHIFTL;
    private static final int[] PSHIFTR;
    private static final int[] FMASK;
    private static final int[] FSHIFTL;
    private static final int[] FSHIFTR;
    private static final int[] UMASK;
    private static final int[] USHIFTL;
    private static final int[] USHIFTR;
    private static final int MAX_LVL_NUM = 255;
    private static final int MAX_PERCENT = 127;
    private static final int MAX_FAILED = 15;
    private static final int MAX_UNKNOWN = 127;
    private static final int FIRST_LETTER = 65;
    private static final int LAST_LETTER = 90;

    static {
        int[] nArray = new int[7];
        nArray[0] = 3;
        nArray[1] = 1;
        LSHIFTL = nArray;
        int[] nArray2 = new int[7];
        nArray2[3] = 3;
        nArray2[4] = 3;
        nArray2[5] = 5;
        nArray2[6] = 4;
        LSHIFTR = nArray2;
        PMASK = new int[]{1, 2, 4, 8, 16, 32, 64};
        int[] nArray3 = new int[7];
        nArray3[0] = 2;
        PSHIFTL = nArray3;
        int[] nArray4 = new int[7];
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArray4[3] = 2;
        nArray4[4] = 1;
        nArray4[5] = 3;
        nArray4[6] = 6;
        PSHIFTR = nArray4;
        int[] nArray5 = new int[7];
        nArray5[0] = 1;
        nArray5[2] = 2;
        nArray5[4] = 4;
        nArray5[5] = 8;
        FMASK = nArray5;
        int[] nArray6 = new int[7];
        nArray6[0] = 1;
        FSHIFTL = nArray6;
        int[] nArray7 = new int[7];
        nArray7[2] = 1;
        nArray7[4] = 2;
        nArray7[5] = 2;
        FSHIFTR = nArray7;
        int[] nArray8 = new int[7];
        nArray8[0] = 1;
        nArray8[1] = 2;
        nArray8[2] = 4;
        nArray8[3] = 24;
        nArray8[4] = 32;
        nArray8[5] = 64;
        UMASK = nArray8;
        int[] nArray9 = new int[7];
        nArray9[1] = 2;
        nArray9[2] = 1;
        USHIFTL = nArray9;
        int[] nArray10 = new int[7];
        nArray10[3] = 1;
        nArray10[4] = 3;
        nArray10[5] = 3;
        USHIFTR = nArray10;
    }

    public static String create(String seed, int lvl, int percent, int failed, int unknown, int offset) {
        if (lvl > 255 || lvl < 0 || seed == null || seed.length() != 10) {
            return null;
        }
        int i = 0;
        while (i < 10) {
            if (seed.charAt(i) < 'A' || seed.charAt(i) > 'Z') {
                return null;
            }
            ++i;
        }
        percent = ToolBox.cap(0, percent, 127);
        failed = ToolBox.cap(0, failed, 15);
        unknown = ToolBox.cap(0, unknown, 127);
        byte[] bi = seed.getBytes(StandardCharsets.US_ASCII);
        byte[] bo = new byte[bi.length];
        int level = lvl + offset;
        level %= 256;
        int sum = 0;
        int i2 = 0;
        while (i2 < 7) {
            int n = i2;
            bi[n] = (byte)(bi[n] | (byte)((level & LMASK[i2]) << LSHIFTL[i2] >>> LSHIFTR[i2]));
            int n2 = i2;
            bi[n2] = (byte)(bi[n2] | (byte)((percent & PMASK[i2]) << PSHIFTL[i2] >>> PSHIFTR[i2]));
            int n3 = i2;
            bi[n3] = (byte)(bi[n3] | (byte)((failed & FMASK[i2]) << FSHIFTL[i2] >>> FSHIFTR[i2]));
            int n4 = i2;
            bi[n4] = (byte)(bi[n4] | (byte)((unknown & UMASK[i2]) << USHIFTL[i2] >>> USHIFTR[i2]));
            if (bi[i2] > 90) {
                int n5 = i2;
                bi[n5] = (byte)(bi[n5] - 26);
            }
            bo[(i2 + 8 - level % 8) % 7] = bi[i2];
            sum += Byte.toUnsignedInt(bi[i2]);
            ++i2;
        }
        bo[7] = (byte)(bi[7] + (level & 0xF));
        if (bo[7] > 90) {
            bo[7] = (byte)(bo[7] - 26);
        }
        bo[8] = (byte)(bi[8] + ((level & 0xF0) >> 4));
        if (bo[8] > 90) {
            bo[8] = (byte)(bo[8] - 26);
        }
        bo[9] = (byte)(bi[9] + ((sum += Byte.toUnsignedInt(bo[7]) + Byte.toUnsignedInt(bo[8])) & 0xF));
        if (bo[9] > 90) {
            bo[9] = (byte)(bo[9] - 26);
        }
        return new String(bo, StandardCharsets.US_ASCII);
    }

    public static int[] getLevel(String seed, String code, int offset) {
        byte[] bs = seed.getBytes(StandardCharsets.US_ASCII);
        byte[] bi = code.getBytes(StandardCharsets.US_ASCII);
        byte[] bo = new byte[bi.length];
        if (seed.length() != 10 || code.length() != 10) {
            return null;
        }
        int i = 0;
        while (i < 10) {
            if (seed.charAt(i) < 'A' || seed.charAt(i) > 'Z' || code.charAt(i) < 'A' || code.charAt(i) > 'Z') {
                return null;
            }
            ++i;
        }
        if (bi[9] < bs[9]) {
            bi[9] = (byte)(bi[9] + 26);
        }
        if ((bi[0] + bi[1] + bi[2] + bi[3] + bi[4] + bi[5] + bi[6] + bi[7] + bi[8] & 0xF) != bi[9] - bs[9]) {
            return null;
        }
        i = 7;
        while (i < 9) {
            if (bi[i] < bs[i]) {
                int n = i;
                bi[n] = (byte)(bi[n] + 26);
            }
            ++i;
        }
        int level = bi[7] - bs[7] & 0xF | (bi[8] - bs[8] & 0xF) << 4;
        int i2 = 0;
        while (i2 < 7) {
            bo[(i2 + 6 + level % 8) % 7] = bi[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < 7) {
            if (bi[i2] < bs[i2]) {
                int n = i2;
                bi[n] = (byte)(bi[n] + 26);
            }
            ++i2;
        }
        if (BooleanUtils.toBoolean((int)(bo[1] - bs[1] & 2)) || BooleanUtils.toBoolean((int)(bo[6] - bs[6] & 2))) {
            return null;
        }
        int level_ = 0;
        int percent = 0;
        int failed = 0;
        int unknown = 0;
        int i3 = 0;
        while (i3 < 7) {
            int nibble = bo[i3] - bs[i3] & 0xFF;
            level_ += nibble << LSHIFTR[i3] >> LSHIFTL[i3] & LMASK[i3];
            percent += nibble << PSHIFTR[i3] >> PSHIFTL[i3] & PMASK[i3];
            failed += nibble << FSHIFTR[i3] >> FSHIFTL[i3] & FMASK[i3];
            unknown += nibble << USHIFTR[i3] >> USHIFTL[i3] & UMASK[i3];
            ++i3;
        }
        if (level != level_) {
            return null;
        }
        level -= offset;
        while (level < 0) {
            level += 255;
        }
        int[] ret = new int[]{level, percent, failed, unknown};
        return ret;
    }
}

