/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Color;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.GraphicSet;
import lemmini.game.LemmException;
import lemmini.game.Lemming;
import lemmini.game.Minimap;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.game.SpecialGraphicSet;
import lemmini.game.SpriteObject;
import lemmini.game.Stencil;
import lemmini.gameutil.Sprite;
import lemmini.graphics.GraphicsBuffer;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.tools.Props;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;

public class Level {
    public static final int DEFAULT_WIDTH = 3200;
    public static final int DEFAULT_HEIGHT = 320;
    public static final int[] DEFAULT_PARTICLE_COLORS = new int[]{-16711936, -16776961, -1, -1, -65536};
    public static final Color BLANK_COLOR = new Color(0, 0, 0, 0);
    private static final List<String> STYLES = Arrays.asList("dirt", "fire", "marble", "pillar", "crystal", "brick", "rock", "snow", "bubble", "xmas");
    private static final List<String> SPECIAL_STYLES = Arrays.asList("awesome", "menace", "beastii", "beasti", "covox", "prima", "apple");
    private static final int DEFAULT_TOP_BOUNDARY = 8;
    private static final int DEFAULT_BOTTOM_BOUNDARY = 20;
    private static final int DEFAULT_LEFT_BOUNDARY = 0;
    private static final int DEFAULT_RIGHT_BOUNDARY = -16;
    private static final int BG_BUFFER_PADDING = 4;
    private static final int BG_BUFFER_UNSCALED_INDEX = 0;
    private static final int BG_BUFFER_SCALED_INDEX = 1;
    private static final int DEFAULT_MAX_RELEASE_RATE = 99;
    private static final int MAX_MAX_RELEASE_RATE = 106;
    private static final int MIN_RELEASE_RATE = -99;
    private final List<Props> levelProps = new ArrayList<Props>(4);
    private Map<String, GraphicSet> styles;
    private Stencil stencil;
    private LemmImage fgImage;
    private LemmImage[] bgImages;
    private SpriteObject[] sprObjBehind;
    private SpriteObject[] sprObjFront;
    private SpriteObject[] sprObjects;
    private List<SpriteObject> oCombined;
    private List<SpriteObject> oBehind;
    private List<SpriteObject> oFront;
    private List<Entrance> entrances;
    private final int releaseRate;
    private final int maxReleaseRate;
    private final boolean lockReleaseRate;
    private final int numLemmings;
    private final int numToRescue;
    private final int timeLimitSeconds;
    private final int numClimbers;
    private final int numFloaters;
    private final int numBombers;
    private final int numBlockers;
    private final int numBuilders;
    private final int numBashers;
    private final int numMiners;
    private final int numDiggers;
    private final int[] entranceOrder;
    private final int xPosCenter;
    private final int yPosCenter;
    private final int maxFallDistance;
    private final boolean classicSteel;
    private final AutosteelMode autosteelMode;
    private final boolean superlemming;
    private final boolean forceNormalTimerSpeed;
    private final List<LvlObject> objects;
    private final GraphicSet mainStyle;
    private final SpecialGraphicSet specialStyle;
    private final String music;
    private final List<Terrain> terrain;
    private final List<Steel> steel;
    private final Background[] backgrounds;
    private final GraphicsBuffer[][] bgBuffers;
    private final String lvlName;
    private final String author;
    private final List<String> hints = new ArrayList<String>(4);
    private final int levelWidth;
    private final int levelHeight;
    private final int topBoundary;
    private final int bottomBoundary;
    private final int leftBoundary;
    private final int rightBoundary;

    public Level(Resource resource, Level level2) throws ResourceException, LemmException {
        Terrain ter;
        Object[] val;
        String hint;
        Props p = new Props();
        if (!p.load(resource)) {
            throw new ResourceException(resource);
        }
        this.levelProps.add(p);
        String mainLevel = p.get("mainLevel", "");
        while (!mainLevel.isEmpty()) {
            p = new Props();
            Resource resource2 = resource.getSibling(mainLevel);
            if (!p.load(resource2)) {
                throw new ResourceException(resource2);
            }
            this.levelProps.add(p);
            mainLevel = p.get("mainLevel", "");
        }
        this.lvlName = Props.get(this.levelProps, "name", "");
        this.author = Props.get(this.levelProps, "author", "");
        int i = 0;
        while ((hint = this.levelProps.get(0).get("hint_" + i, null)) != null) {
            this.hints.add(hint);
            ++i;
        }
        this.maxFallDistance = Props.getInt(this.levelProps, "maxFallDistance", GameController.getCurLevelPack().getMaxFallDistance());
        this.classicSteel = Props.getBoolean(this.levelProps, "classicSteel", false);
        switch (p.getInt("autosteelMode", 0)) {
            default: {
                this.autosteelMode = AutosteelMode.NONE;
                break;
            }
            case 1: {
                this.autosteelMode = AutosteelMode.SIMPLE;
                break;
            }
            case 2: {
                this.autosteelMode = AutosteelMode.ADVANCED;
            }
        }
        this.levelWidth = p.getInt("width", 3200);
        this.levelHeight = p.getInt("height", 320);
        this.topBoundary = p.getInt("topBoundary", 8);
        this.bottomBoundary = p.getInt("bottomBoundary", 20);
        this.leftBoundary = p.getInt("leftBoundary", 0);
        this.rightBoundary = p.getInt("rightBoundary", -16);
        this.releaseRate = ToolBox.cap(-99, Props.getInt(this.levelProps, "releaseRate", 0), 106);
        this.maxReleaseRate = ToolBox.cap(this.releaseRate, Props.getInt(this.levelProps, "maxReleaseRate", 99), 106);
        this.lockReleaseRate = this.releaseRate == this.maxReleaseRate ? true : Props.getBoolean(this.levelProps, "lockReleaseRate", false);
        this.numLemmings = Props.getInt(this.levelProps, "numLemmings", 1);
        if (this.numLemmings <= 0) {
            throw new LemmException("No lemmings in level.");
        }
        this.numToRescue = Props.getInt(this.levelProps, "numToRescue", 0);
        int timeLimitSecondsTemp = Integer.MIN_VALUE;
        for (Props p2 : this.levelProps) {
            timeLimitSecondsTemp = p2.getInt("timeLimitSeconds", Integer.MIN_VALUE);
            if (timeLimitSecondsTemp != Integer.MIN_VALUE) break;
            int timeLimit = p2.getInt("timeLimit", Integer.MIN_VALUE);
            if (timeLimit == Integer.MIN_VALUE) continue;
            if (timeLimit >= 0x2222222 || timeLimit <= -35791394) {
                timeLimit = 0;
            }
            timeLimitSecondsTemp = timeLimit * 60;
            break;
        }
        if (timeLimitSecondsTemp == Integer.MAX_VALUE || timeLimitSecondsTemp < 0) {
            timeLimitSecondsTemp = 0;
        }
        this.timeLimitSeconds = timeLimitSecondsTemp;
        this.numClimbers = Props.getInt(this.levelProps, "numClimbers", 0);
        this.numFloaters = Props.getInt(this.levelProps, "numFloaters", 0);
        this.numBombers = Props.getInt(this.levelProps, "numBombers", 0);
        this.numBlockers = Props.getInt(this.levelProps, "numBlockers", 0);
        this.numBuilders = Props.getInt(this.levelProps, "numBuilders", 0);
        this.numBashers = Props.getInt(this.levelProps, "numBashers", 0);
        this.numMiners = Props.getInt(this.levelProps, "numMiners", 0);
        this.numDiggers = Props.getInt(this.levelProps, "numDiggers", 0);
        int[] entranceOrderTemp = Props.getIntArray(this.levelProps, "entranceOrder", null);
        if (ArrayUtils.isEmpty((int[])entranceOrderTemp)) {
            entranceOrderTemp = null;
        }
        this.entranceOrder = entranceOrderTemp;
        int xPosCenterTemp = Integer.MIN_VALUE;
        for (Props p2 : this.levelProps) {
            xPosCenterTemp = p2.getInt("xPosCenter", Integer.MIN_VALUE);
            if (xPosCenterTemp != Integer.MIN_VALUE) break;
            int xPos = p2.getInt("xPos", Integer.MIN_VALUE);
            if (xPos == Integer.MIN_VALUE) continue;
            xPosCenterTemp = xPos + 400;
            break;
        }
        if (xPosCenterTemp == Integer.MIN_VALUE) {
            xPosCenterTemp = 0;
        }
        this.xPosCenter = xPosCenterTemp;
        this.yPosCenter = Props.getInt(this.levelProps, "yPosCenter", 0);
        String styleName = p.get("style", "");
        String specialStyleName = p.get("specialStyle", "");
        this.music = Props.get(this.levelProps, "music", null);
        this.superlemming = Props.getBoolean(this.levelProps, "superlemming", false);
        this.forceNormalTimerSpeed = Props.getBoolean(this.levelProps, "forceNormalTimerSpeed", false);
        this.styles = new HashMap<String, GraphicSet>(16);
        this.mainStyle = new GraphicSet(styleName);
        this.styles.put(styleName.toLowerCase(Locale.ROOT), this.mainStyle);
        this.specialStyle = !specialStyleName.isEmpty() ? new SpecialGraphicSet(specialStyleName) : null;
        this.objects = new ArrayList<LvlObject>(64);
        int i2 = 0;
        while (i2 < Integer.MAX_VALUE) {
            val = p.getArray("object_" + i2, null);
            if (val == null || val.length < 5) break;
            LvlObject obj = new LvlObject((String[])val);
            this.objects.add(obj);
            ++i2;
        }
        this.terrain = new ArrayList<Terrain>(512);
        if (this.specialStyle != null) {
            String positionX = p.get("specialStylePositionX", Integer.toString(this.specialStyle.getPositionX()));
            String positionY = p.get("specialStylePositionY", Integer.toString(this.specialStyle.getPositionY()));
            ter = new Terrain(new String[]{"0", positionX, positionY, "0"}, true);
            this.terrain.add(ter);
        }
        i = 0;
        while (i < Integer.MAX_VALUE) {
            val = p.getArray("terrain_" + i, null);
            if (val == null || val.length < 4) break;
            ter = new Terrain((String[])val, false);
            this.terrain.add(ter);
            ++i;
        }
        this.steel = new ArrayList<Steel>(64);
        i = 0;
        while (i < Integer.MAX_VALUE) {
            val = p.getIntArray("steel_" + i, null);
            if (val == null || val.length < 4) break;
            Steel stl = new Steel((int[])val);
            this.steel.add(stl);
            ++i;
        }
        ArrayList<Background> backgroundList = new ArrayList<Background>(4);
        ArrayList<GraphicsBuffer[]> bgBufferList = new ArrayList<GraphicsBuffer[]>(4);
        int i3 = 0;
        while (i3 < Integer.MAX_VALUE) {
            int bgWidth = p.getInt("bg_" + i3 + "_width", 0);
            int bgHeight = p.getInt("bg_" + i3 + "_height", 0);
            if (bgWidth <= 0 || bgHeight <= 0) break;
            boolean bgTiled = p.getBoolean("bg_" + i3 + "_tiled", false);
            int bgTint = p.getInt("bg_" + i3 + "_tint", 0);
            int bgOffsetX = p.getInt("bg_" + i3 + "_offsetX", 0);
            int bgOffsetY = p.getInt("bg_" + i3 + "_offsetY", 0);
            double bgScrollSpeedX = p.getDouble("bg_" + i3 + "_scrollSpeedX", 0.0);
            double bgScrollSpeedY = p.getDouble("bg_" + i3 + "_scrollSpeedY", 0.0);
            double bgScale = p.getDouble("bg_" + i3 + "_scale", 1.0);
            ArrayList<LvlObject> bgObjects = new ArrayList<LvlObject>(16);
            int j = 0;
            while (i3 < Integer.MAX_VALUE) {
                String[] val2 = p.getArray("bg_" + i3 + "_object_" + j, null);
                if (val2 == null || val2.length < 5) break;
                LvlObject obj = new LvlObject(val2);
                bgObjects.add(obj);
                ++j;
            }
            ArrayList<Terrain> bgTerrain = new ArrayList<Terrain>(256);
            int j2 = 0;
            while (i3 < Integer.MAX_VALUE) {
                String[] val3 = p.getArray("bg_" + i3 + "_terrain_" + j2, null);
                if (val3 == null || val3.length < 4) break;
                Terrain ter2 = new Terrain(val3, false);
                bgTerrain.add(ter2);
                ++j2;
            }
            backgroundList.add(new Background(bgWidth, bgHeight, bgObjects, bgTerrain, bgTiled, bgTint, bgOffsetX, bgOffsetY, bgScrollSpeedX, bgScrollSpeedY, bgScale));
            GraphicsBuffer[] bgBufferListEntry = new GraphicsBuffer[]{new GraphicsBuffer(bgWidth + 8, bgHeight + 8, 3, false), new GraphicsBuffer(ToolBox.scale(bgWidth, bgScale), ToolBox.scale(bgHeight, bgScale), 3, false)};
            bgBufferList.add(bgBufferListEntry);
            ++i3;
        }
        this.backgrounds = backgroundList.toArray(new Background[backgroundList.size()]);
        this.bgBuffers = (GraphicsBuffer[][])bgBufferList.toArray((T[])new GraphicsBuffer[bgBufferList.size()][]);
        if (level2 != null) {
            this.fgImage = level2.fgImage;
            level2.fgImage = null;
            this.stencil = level2.stencil;
            level2.stencil = null;
        }
        Lemming.replaceColors(this.getDebrisColor(), this.getDebrisColor2());
    }

    void createLevelImage() {
        if (this.fgImage != null && this.fgImage.getWidth() == this.levelWidth && this.fgImage.getHeight() == this.levelHeight) {
            GraphicsContext gfx = null;
            try {
                gfx = this.fgImage.createGraphicsContext();
                gfx.setBackground(BLANK_COLOR);
                gfx.clearRect(0, 0, this.fgImage.getWidth(), this.fgImage.getHeight());
            }
            finally {
                if (gfx != null) {
                    gfx.dispose();
                }
            }
        } else {
            this.fgImage = ToolBox.createLemmImage(this.levelWidth, this.levelHeight);
        }
    }

    void createStencil() {
        this.bgImages = new LemmImage[this.backgrounds.length];
        int i = 0;
        while (i < this.backgrounds.length) {
            this.bgImages[i] = ToolBox.createLemmImage(this.backgrounds[i].width + 8, this.backgrounds[i].height + 8);
            ++i;
        }
        if (this.stencil != null && this.stencil.getWidth() == this.levelWidth && this.stencil.getHeight() == this.levelHeight) {
            this.stencil.clear();
        } else {
            this.stencil = new Stencil(this.levelWidth, this.levelHeight);
        }
    }

    void paintTerrain() throws ResourceException, LemmException {
        for (Terrain t : this.terrain) {
            boolean isSteel;
            int steelMaskHeight;
            int steelMaskWidth;
            int maskHeight;
            int maskWidth;
            int height;
            int width;
            boolean[][] steelMask;
            boolean[][] mask;
            LemmImage i;
            if (t.id < 0) continue;
            String styleLowerCase = t.style.toLowerCase(Locale.ROOT);
            if (!this.styles.containsKey(styleLowerCase)) {
                this.styles.put(styleLowerCase, new GraphicSet(t.style));
            }
            GraphicSet terrainStyle = this.styles.get(styleLowerCase);
            if (t.specialGraphic) {
                i = this.specialStyle.getImage();
                mask = this.specialStyle.getMask();
                steelMask = this.specialStyle.getSteelMask();
                width = i.getWidth();
                height = i.getHeight();
                maskWidth = ArrayUtils.isNotEmpty((Object[])mask) ? mask[0].length : 0;
                maskHeight = mask.length;
                steelMaskWidth = ArrayUtils.isNotEmpty((Object[])steelMask) ? steelMask[0].length : 0;
                steelMaskHeight = steelMask.length;
                isSteel = true;
            } else {
                GraphicSet.Terrain t2 = terrainStyle.getTerrain(t.id);
                i = t2.getImage();
                mask = t2.getMask();
                steelMask = t2.getSteelMask();
                width = i.getWidth();
                height = i.getHeight();
                maskWidth = ArrayUtils.isNotEmpty((Object[])mask) ? mask[0].length : 0;
                maskHeight = mask.length;
                steelMaskWidth = ArrayUtils.isNotEmpty((Object[])steelMask) ? steelMask[0].length : 0;
                steelMaskHeight = steelMask.length;
                isSteel = t2.isSteel();
            }
            if (this.autosteelMode == AutosteelMode.NONE) {
                isSteel = false;
            }
            int tx = t.xPos;
            int ty = t.yPos;
            boolean rotate = BooleanUtils.toBoolean((int)(t.modifier & 0x80));
            boolean noOneWay = BooleanUtils.toBoolean((int)(t.modifier & 0x40));
            boolean flipHorizontally = BooleanUtils.toBoolean((int)(t.modifier & 0x20));
            boolean fake = BooleanUtils.toBoolean((int)(t.modifier & 0x10));
            boolean upsideDown = BooleanUtils.toBoolean((int)(t.modifier & 4));
            boolean noOverwrite = BooleanUtils.toBoolean((int)(t.modifier & 8));
            boolean remove = !noOverwrite && BooleanUtils.toBoolean((int)(t.modifier & 2));
            boolean invisible = BooleanUtils.toBoolean((int)(t.modifier & 1));
            int width2 = width;
            int height2 = height;
            if (rotate) {
                width = height2;
                height = width2;
            }
            int y = 0;
            while (y < height) {
                block38: {
                    if (y + ty < 0 || y + ty >= this.levelHeight) break block38;
                    int x = 0;
                    while (x < width) {
                        block39: {
                            int newMask;
                            block40: {
                                block41: {
                                    int col;
                                    int alpha;
                                    boolean isPixelOpaque;
                                    if (x + tx < 0 || x + tx >= this.levelWidth) break block39;
                                    int x2 = x;
                                    int y2 = y;
                                    if (upsideDown) {
                                        y2 = height - 1 - y2;
                                    }
                                    if (flipHorizontally) {
                                        x2 = width - 1 - x2;
                                    }
                                    if (rotate) {
                                        int oldX2 = x2;
                                        x2 = y2;
                                        y2 = height2 - 1 - oldX2;
                                    }
                                    boolean bl = isPixelOpaque = (alpha = (col = i.getRGB(x2, y2)) >>> 24 & 0xFF) >= 128;
                                    if (!invisible && (col & 0xFF000000) != 0) {
                                        if (noOverwrite) {
                                            if (noOneWay && isPixelOpaque && !this.fgImage.isPixelOpaque(x + tx, y + ty)) {
                                                this.stencil.orMask(x + tx, y + ty, 16);
                                            }
                                            this.fgImage.addRGBBehind(x + tx, y + ty, col);
                                        } else if (remove) {
                                            if (noOneWay && isPixelOpaque) {
                                                this.stencil.andMask(x + tx, y + ty, -17);
                                            }
                                            this.fgImage.removeAlpha(x + tx, y + ty, alpha);
                                        } else {
                                            if (isPixelOpaque) {
                                                if (noOneWay) {
                                                    this.stencil.orMask(x + tx, y + ty, 16);
                                                } else {
                                                    this.stencil.andMask(x + tx, y + ty, -17);
                                                }
                                            }
                                            this.fgImage.addRGB(x + tx, y + ty, col);
                                        }
                                    }
                                    if (!fake && y2 < maskHeight && x2 < maskWidth && mask[y2][x2]) {
                                        if (remove) {
                                            newMask = this.stencil.getMask(x + tx, y + ty) & 0x10;
                                        } else if (noOverwrite) {
                                            newMask = this.stencil.getMask(x + tx, y + ty) | 1;
                                            if (noOneWay) {
                                                newMask |= 8;
                                            }
                                        } else {
                                            newMask = this.stencil.getMask(x + tx, y + ty) | 1;
                                            newMask = noOneWay ? (newMask |= 8) : (newMask &= 0xFFFFFFF7);
                                        }
                                        this.stencil.setMask(x + tx, y + ty, newMask);
                                    }
                                    if (fake || y2 >= steelMaskHeight || x2 >= steelMaskWidth || !steelMask[y2][x2]) break block39;
                                    newMask = this.stencil.getMask(x + tx, y + ty);
                                    if (remove) break block40;
                                    if (!noOverwrite) break block41;
                                    switch (this.autosteelMode) {
                                        default: {
                                            break;
                                        }
                                        case SIMPLE: {
                                            if (isSteel) {
                                                newMask |= 2;
                                                break;
                                            }
                                            break block40;
                                        }
                                        case ADVANCED: {
                                            if (isSteel && !BooleanUtils.toBoolean((int)(this.stencil.getMask(x + tx, y + ty) & 1))) {
                                                newMask |= 2;
                                                break;
                                            }
                                            break block40;
                                        }
                                    }
                                    break block40;
                                }
                                switch (this.autosteelMode) {
                                    default: {
                                        break;
                                    }
                                    case SIMPLE: {
                                        if (!isSteel) break;
                                        newMask |= 2;
                                        break;
                                    }
                                    case ADVANCED: {
                                        if (isSteel) {
                                            newMask |= 2;
                                            break;
                                        }
                                        newMask &= 0xFFFFFFFD;
                                    }
                                }
                            }
                            this.stencil.setMask(x + tx, y + ty, newMask);
                        }
                        ++x;
                    }
                }
                ++y;
            }
        }
    }

    void paintSteel() {
        this.steel.stream().forEachOrdered(stl -> {
            int sx = stl.xPos;
            int sy = stl.yPos;
            int y = 0;
            while (y < stl.height) {
                if (y + sy >= 0 && y + sy < this.levelHeight) {
                    int x = 0;
                    while (x < stl.width) {
                        if ((this.classicSteel || BooleanUtils.toBoolean((int)(this.stencil.getMask(x + sx, y + sy) & 1))) && x + sx >= 0 && x + sx < this.levelWidth) {
                            if (stl.negative) {
                                this.stencil.andMask(x + sx, y + sy, -3);
                            } else {
                                this.stencil.orMask(x + sx, y + sy, 2);
                            }
                        }
                        ++x;
                    }
                }
                ++y;
            }
        });
    }

    void paintObjects() throws ResourceException, LemmException {
        ListIterator<LvlObject> lit = this.objects.listIterator();
        while (lit.hasNext()) {
            int stencilMask;
            int x;
            boolean invisible;
            int n = lit.nextIndex();
            LvlObject o = lit.next();
            if (o.id < 0) {
                this.oCombined.add(null);
                continue;
            }
            String styleLowerCase = o.style.toLowerCase(Locale.ROOT);
            if (!this.styles.containsKey(styleLowerCase)) {
                this.styles.put(styleLowerCase, new GraphicSet(o.style));
            }
            GraphicSet objectStyle = this.styles.get(styleLowerCase);
            boolean rotate = BooleanUtils.toBoolean((int)(o.flags & 0x10));
            boolean upsideDown = BooleanUtils.toBoolean((int)(o.flags & 1));
            boolean fake = BooleanUtils.toBoolean((int)(o.flags & 2));
            boolean upsideDownMask = BooleanUtils.toBoolean((int)(o.flags & 4));
            boolean flipHorizontally = BooleanUtils.toBoolean((int)(o.flags & 8));
            GraphicSet.LvlObject o2 = objectStyle.getObject(o.id);
            SpriteObject spr = new SpriteObject(o2, GraphicSet.Orientation.getOrientation(flipHorizontally, upsideDown, rotate), false);
            spr.setX(o.xPos);
            spr.setY(o.yPos);
            if (spr.getType() == SpriteObject.Type.ENTRANCE && !fake) {
                Entrance e = new Entrance(o.xPos + spr.getWidth() / 2 + spr.getMaskOffsetX(), o.yPos + spr.getMaskOffsetY(), BooleanUtils.toBoolean((int)(o.objSpecificModifier & 1)));
                e.id = this.oCombined.size();
                this.entrances.add(e);
            }
            boolean drawOnVis = !(invisible = BooleanUtils.toBoolean((int)(o.paintMode & 2))) && BooleanUtils.toBoolean((int)(o.paintMode & 8));
            boolean noOverwrite = !drawOnVis && BooleanUtils.toBoolean((int)(o.paintMode & 4));
            boolean inFront = !invisible && !noOverwrite;
            boolean drawFull = inFront && !drawOnVis;
            spr.setVisOnTerrain(drawOnVis);
            if (!invisible) {
                if (inFront) {
                    this.oFront.add(spr);
                } else {
                    this.oBehind.add(spr);
                }
            }
            this.oCombined.add(spr);
            int y = 0;
            while (y < spr.getHeight()) {
                if (y + spr.getY() >= 0 && y + spr.getY() < this.levelHeight) {
                    x = 0;
                    while (x < spr.getWidth()) {
                        if (x + spr.getX() >= 0 && x + spr.getX() < this.levelWidth) {
                            this.stencil.addID(spr.getX() + x, spr.getY() + y, n);
                        }
                        ++x;
                    }
                }
                ++y;
            }
            if (!fake) {
                y = spr.getMaskOffsetY();
                while (y < spr.getMaskHeight() + spr.getMaskOffsetY()) {
                    x = spr.getMaskOffsetX();
                    while (x < spr.getMaskWidth() + spr.getMaskOffsetX()) {
                        int xDest = x;
                        int yDest = y;
                        if (rotate) {
                            int oldXDest = xDest;
                            xDest = spr.getWidth() - 1 - yDest + 10;
                            yDest = oldXDest + 10;
                        }
                        if (flipHorizontally) {
                            xDest = spr.getWidth() - xDest - 1;
                        }
                        if (upsideDownMask) {
                            yDest = spr.getHeight() - yDest - 1;
                            if (spr.getType().isTriggeredByFoot()) {
                                yDest += 20;
                            }
                        }
                        stencilMask = this.stencil.getMask(xDest + spr.getX(), yDest + spr.getY());
                        int maskType = spr.getMaskType();
                        if ((this.classicSteel || spr.getType().isTriggeredByFoot() || BooleanUtils.toBoolean((int)(stencilMask & 1))) && (!spr.getType().isOneWay() || !BooleanUtils.toBoolean((int)(stencilMask & 8))) && xDest + spr.getX() >= 0 && xDest + spr.getX() < this.levelWidth && spr.getMask(x, y)) {
                            this.stencil.addGadget(spr.getX() + xDest, yDest + spr.getY(), maskType, n);
                        }
                        ++x;
                    }
                    ++y;
                }
            }
            if (invisible) continue;
            y = 0;
            while (y < spr.getHeight()) {
                x = 0;
                while (x < spr.getWidth()) {
                    boolean paint = true;
                    if (x + spr.getX() < 0 || x + spr.getX() >= this.levelWidth || y + spr.getY() < 0 || y + spr.getY() >= this.levelHeight) {
                        paint = false;
                    } else if (inFront) {
                        boolean opaque = this.fgImage.isPixelOpaque(x + spr.getX(), y + spr.getY());
                        stencilMask = this.stencil.getMask(x + spr.getX(), y + spr.getY());
                        boolean bl = paint = (drawFull || opaque && drawOnVis) && (!spr.getType().isOneWay() || !BooleanUtils.toBoolean((int)(stencilMask & 0x10)));
                    }
                    if (!paint) {
                        spr.setPixelVisibility(x, y, false);
                    }
                    ++x;
                }
                ++y;
            }
        }
    }

    void paintBackground() throws ResourceException, LemmException {
        if (ArrayUtils.isNotEmpty((Object[])this.bgImages)) {
            ArrayList<SpriteObject> bgOCombined = new ArrayList<SpriteObject>(32);
            ArrayList<SpriteObject> bgOFront = new ArrayList<SpriteObject>(32);
            ArrayList<SpriteObject> bgOBehind = new ArrayList<SpriteObject>(32);
            int m = 0;
            while (m < this.backgrounds.length) {
                Background bg = this.backgrounds[m];
                LemmImage targetBg = this.bgImages[m];
                LemmImage unpaddedBg = ToolBox.createLemmImage(targetBg.getWidth() - 8, targetBg.getHeight() - 8);
                bgOCombined.clear();
                bgOBehind.clear();
                bgOFront.clear();
                for (Terrain t : this.terrain) {
                    if (t.id < 0) continue;
                    String styleLowerCase = t.style.toLowerCase(Locale.ROOT);
                    if (!this.styles.containsKey(styleLowerCase)) {
                        this.styles.put(styleLowerCase, new GraphicSet(t.style));
                    }
                    GraphicSet terrainStyle = this.styles.get(styleLowerCase);
                    LemmImage i = terrainStyle.getTerrain(t.id).getImage();
                    int width = i.getWidth();
                    int height = i.getHeight();
                    int tx = t.xPos;
                    int ty = t.yPos;
                    boolean rotate = BooleanUtils.toBoolean((int)(t.modifier & 0x80));
                    boolean flipHorizontally = BooleanUtils.toBoolean((int)(t.modifier & 0x20));
                    boolean upsideDown = BooleanUtils.toBoolean((int)(t.modifier & 4));
                    boolean overwrite = !BooleanUtils.toBoolean((int)(t.modifier & 8));
                    boolean remove = BooleanUtils.toBoolean((int)(t.modifier & 2));
                    int width2 = width;
                    int height2 = height;
                    if (rotate) {
                        width = height2;
                        height = width2;
                    }
                    int y = 0;
                    while (y < height) {
                        if (y + ty >= 0 && y + ty < unpaddedBg.getHeight()) {
                            int x = 0;
                            while (x < width) {
                                if (x + tx >= 0 && x + tx < unpaddedBg.getWidth()) {
                                    int col;
                                    int x2 = x;
                                    int y2 = y;
                                    if (upsideDown) {
                                        y2 = height - 1 - y2;
                                    }
                                    if (flipHorizontally) {
                                        x2 = width - 1 - x2;
                                    }
                                    if (rotate) {
                                        int oldX2 = x2;
                                        x2 = y2;
                                        y2 = height2 - 1 - oldX2;
                                    }
                                    if (((col = i.getRGB(x2, y2)) & 0xFF000000) != 0) {
                                        if (!overwrite) {
                                            unpaddedBg.addRGBBehind(x + tx, y + ty, col);
                                        } else if (remove) {
                                            unpaddedBg.removeAlpha(x + tx, y + ty, col >>> 24 & 0xFF);
                                        } else {
                                            unpaddedBg.addRGB(x + tx, y + ty, col);
                                        }
                                    }
                                }
                                ++x;
                            }
                        }
                        ++y;
                    }
                }
                unpaddedBg.applyTint(bg.tint);
                GraphicsContext targetBgGfx = null;
                try {
                    targetBgGfx = targetBg.createGraphicsContext();
                    int y = 4 - (bg.tiled ? unpaddedBg.getHeight() : 0);
                    int j = 0;
                    while (j < (bg.tiled ? 3 : 1)) {
                        int x = 4 - (bg.tiled ? unpaddedBg.getWidth() : 0);
                        int k = 0;
                        while (k < (bg.tiled ? 3 : 1)) {
                            targetBgGfx.drawImage(unpaddedBg, x, y);
                            x += unpaddedBg.getWidth();
                            ++k;
                        }
                        y += unpaddedBg.getHeight();
                        ++j;
                    }
                }
                finally {
                    if (targetBgGfx != null) {
                        targetBgGfx.dispose();
                    }
                }
                for (LvlObject o : this.objects) {
                    if (o.id < 0) {
                        this.oCombined.add(null);
                        continue;
                    }
                    String styleLowerCase = o.style.toLowerCase(Locale.ROOT);
                    if (!this.styles.containsKey(styleLowerCase)) {
                        this.styles.put(styleLowerCase, new GraphicSet(o.style));
                    }
                    GraphicSet objectStyle = this.styles.get(styleLowerCase);
                    boolean rotate = BooleanUtils.toBoolean((int)(o.flags & 0x10));
                    boolean upsideDown = BooleanUtils.toBoolean((int)(o.flags & 1));
                    boolean flipHorizontally = BooleanUtils.toBoolean((int)(o.flags & 8));
                    GraphicSet.LvlObject o2 = objectStyle.getObject(o.id);
                    SpriteObject spr = new SpriteObject(o2, GraphicSet.Orientation.getOrientation(flipHorizontally, upsideDown, rotate), false);
                    spr.setX(o.xPos);
                    spr.setY(o.yPos);
                    boolean invisible = BooleanUtils.toBoolean((int)(o.paintMode & 2));
                    boolean drawOnVis = !invisible && BooleanUtils.toBoolean((int)(o.paintMode & 8));
                    boolean noOverwrite = !drawOnVis && BooleanUtils.toBoolean((int)(o.paintMode & 4));
                    boolean inFront = !invisible && !noOverwrite;
                    boolean drawFull = inFront && !drawOnVis;
                    spr.setVisOnTerrain(drawOnVis);
                    if (inFront) {
                        bgOFront.add(spr);
                    } else {
                        bgOBehind.add(spr);
                    }
                    bgOCombined.add(spr);
                    if (!invisible) {
                        int y = 0;
                        while (y < spr.getHeight()) {
                            int x = 0;
                            while (x < spr.getWidth()) {
                                boolean paint = true;
                                if (x + spr.getX() < 0 || x + spr.getX() >= unpaddedBg.getWidth() || y + spr.getY() < 0 || y + spr.getY() >= unpaddedBg.getHeight()) {
                                    paint = false;
                                } else if (inFront) {
                                    boolean opaque = unpaddedBg.isPixelOpaque(x + spr.getX(), y + spr.getY());
                                    boolean bl = paint = drawFull || opaque && drawOnVis;
                                }
                                if (!paint) {
                                    spr.setPixelVisibility(x, y, false);
                                }
                                ++x;
                            }
                            ++y;
                        }
                    }
                    spr.applyTint(bg.tint);
                }
                bg.sprObjects = bgOCombined.toArray(new SpriteObject[bgOCombined.size()]);
                bg.sprObjFront = bgOFront.toArray(new SpriteObject[bgOFront.size()]);
                bg.sprObjBehind = bgOBehind.toArray(new SpriteObject[bgOBehind.size()]);
                ++m;
            }
        }
    }

    void paintLevel() throws ResourceException, LemmException {
        this.sprObjFront = null;
        this.sprObjBehind = null;
        this.sprObjects = null;
        this.entrances = null;
        System.gc();
        this.createLevelImage();
        this.createStencil();
        this.paintTerrain();
        this.paintSteel();
        this.oCombined = new ArrayList<SpriteObject>(64);
        this.oBehind = new ArrayList<SpriteObject>(64);
        this.oFront = new ArrayList<SpriteObject>(64);
        this.entrances = new ArrayList<Entrance>(8);
        this.paintObjects();
        this.paintBackground();
        this.sprObjects = this.oCombined.toArray(new SpriteObject[this.oCombined.size()]);
        this.sprObjFront = this.oFront.toArray(new SpriteObject[this.oFront.size()]);
        this.sprObjBehind = this.oBehind.toArray(new SpriteObject[this.oBehind.size()]);
        System.gc();
    }

    public LemmImage getFgImage() {
        return this.fgImage;
    }

    public Stencil getStencil() {
        return this.stencil;
    }

    public void drawBehindObjects(GraphicsContext g, int width, int height, int xOfs, int yOfs) {
        if (this.sprObjBehind != null) {
            int n = this.sprObjBehind.length - 1;
            while (n >= 0) {
                SpriteObject spr = this.sprObjBehind[n];
                LemmImage img = spr.getImage();
                if (spr.getX() + spr.getWidth() > xOfs && spr.getX() < xOfs + width && spr.getY() + spr.getHeight() > yOfs && spr.getY() < yOfs + height) {
                    g.drawImage(img, spr.getX() - xOfs, spr.getY() - yOfs);
                }
                --n;
            }
        }
    }

    public void drawInFrontObjects(GraphicsContext g, int width, int height, int xOfs, int yOfs) {
        if (this.sprObjFront != null) {
            SpriteObject[] spriteObjectArray = this.sprObjFront;
            int n = this.sprObjFront.length;
            int n2 = 0;
            while (n2 < n) {
                SpriteObject spr = spriteObjectArray[n2];
                LemmImage img = spr.getImage();
                if (spr.getX() + spr.getWidth() > xOfs && spr.getX() < xOfs + width && spr.getY() + spr.getHeight() > yOfs && spr.getY() < yOfs + height) {
                    g.drawImage(img, spr.getX() - xOfs, spr.getY() - yOfs);
                }
                ++n2;
            }
        }
    }

    public void drawBackground(GraphicsContext g, int width, int height, int xOfs, int yOfs) {
        if (ArrayUtils.isEmpty((Object[])this.bgImages)) {
            return;
        }
        int i = this.backgrounds.length - 1;
        while (i >= 0) {
            LemmImage bgImage = this.bgImages[i];
            Background bg = this.backgrounds[i];
            GraphicsBuffer[] buffers = this.bgBuffers[i];
            int bgImageWidth = bgImage.getWidth() - 8;
            int bgImageWidthScaled = ToolBox.scale(bgImageWidth, bg.scale);
            int bgImageHeight = bgImage.getHeight() - 8;
            int bgImageHeightScaled = ToolBox.scale(bgImageHeight, bg.scale);
            int bgBufferPaddingScaled = ToolBox.scale(4, bg.scale);
            if (bgImageWidthScaled > 0 && bgImageHeightScaled > 0) {
                int k;
                int x;
                LemmImage unscaledBufferImg = buffers[0].getImage();
                GraphicsContext unscaledBufferGfx = buffers[0].getGraphicsContext();
                unscaledBufferGfx.clearRect(0, 0, unscaledBufferImg.getWidth(), unscaledBufferImg.getHeight());
                int y = 4 - (bg.tiled ? bgImageHeight : 0);
                int j = 0;
                while (j < (bg.tiled ? 3 : 1)) {
                    x = 4 - (bg.tiled ? bgImageWidth : 0);
                    k = 0;
                    while (k < (bg.tiled ? 3 : 1)) {
                        if (bg.sprObjBehind != null) {
                            int n = bg.sprObjBehind.length - 1;
                            while (n >= 0) {
                                SpriteObject spr = bg.sprObjBehind[n];
                                LemmImage img = spr.getImage();
                                unscaledBufferGfx.drawImage(img, x + spr.getX(), y + spr.getY());
                                --n;
                            }
                        }
                        x += bgImageWidth;
                        ++k;
                    }
                    y += bgImageHeight;
                    ++j;
                }
                unscaledBufferGfx.drawImage(bgImage, 0, 0);
                y = 4 - (bg.tiled ? bgImageHeight : 0);
                j = 0;
                while (j < (bg.tiled ? 3 : 1)) {
                    x = 4 - (bg.tiled ? bgImageWidth : 0);
                    k = 0;
                    while (k < (bg.tiled ? 3 : 1)) {
                        if (bg.sprObjFront != null) {
                            SpriteObject[] spriteObjectArray = bg.sprObjFront;
                            int n = bg.sprObjFront.length;
                            int spr = 0;
                            while (spr < n) {
                                SpriteObject spr2 = spriteObjectArray[spr];
                                LemmImage img = spr2.getImage();
                                unscaledBufferGfx.drawImage(img, x + spr2.getX(), y + spr2.getY());
                                ++spr;
                            }
                        }
                        x += bgImageWidth;
                        ++k;
                    }
                    y += bgImageHeight;
                    ++j;
                }
                LemmImage scaledBufferImg = buffers[1].getImage();
                GraphicsContext scaledBufferGfx = buffers[1].getGraphicsContext();
                scaledBufferGfx.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Core.isBilinear() ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                scaledBufferGfx.clearRect(0, 0, scaledBufferImg.getWidth(), scaledBufferImg.getHeight());
                scaledBufferGfx.drawImage(unscaledBufferImg, -bgBufferPaddingScaled, -bgBufferPaddingScaled, bgImageWidthScaled + bgBufferPaddingScaled * 2, bgImageHeightScaled + bgBufferPaddingScaled * 2);
                int xOfsNew = (int)((double)(-xOfs) * bg.scrollSpeedX) + bg.offsetX;
                int yOfsNew = (int)((double)(-yOfs) * bg.scrollSpeedY) + bg.offsetY;
                if (bg.tiled) {
                    xOfsNew -= (xOfsNew %= bgImageWidthScaled) > 0 ? bgImageWidthScaled : 0;
                    yOfsNew -= (yOfsNew %= bgImageHeightScaled) > 0 ? bgImageHeightScaled : 0;
                }
                int y2 = yOfsNew;
                while (y2 < height) {
                    int x2 = xOfsNew;
                    while (x2 < width) {
                        g.drawImage(scaledBufferImg, x2, y2);
                        if (!bg.tiled) break;
                        x2 += bgImageWidthScaled;
                    }
                    if (!bg.tiled) break;
                    y2 += bgImageHeightScaled;
                }
            }
            --i;
        }
    }

    public void advanceBackgroundFrame() {
        Background[] backgroundArray = this.backgrounds;
        int n = this.backgrounds.length;
        int n2 = 0;
        while (n2 < n) {
            Background bg = backgroundArray[n2];
            SpriteObject[] spriteObjectArray = bg.sprObjects;
            int n3 = bg.sprObjects.length;
            int n4 = 0;
            while (n4 < n3) {
                SpriteObject spr = spriteObjectArray[n4];
                if (spr != null) {
                    spr.getImageAnim();
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void openBackgroundEntrances() {
        Background[] backgroundArray = this.backgrounds;
        int n = this.backgrounds.length;
        int n2 = 0;
        while (n2 < n) {
            Background bg = backgroundArray[n2];
            SpriteObject[] spriteObjectArray = bg.sprObjects;
            int n3 = bg.sprObjects.length;
            int n4 = 0;
            while (n4 < n3) {
                SpriteObject spr = spriteObjectArray[n4];
                if (spr != null && spr.getAnimMode() == Sprite.Animation.ONCE_ENTRANCE) {
                    spr.setAnimMode(Sprite.Animation.ONCE);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public LemmImage createMinimap(LemmImage fgImage, double scaleX, double scaleY, boolean highQuality, boolean tint, boolean drawBackground) {
        Level level = GameController.getLevel();
        LemmImage img = ToolBox.createLemmImage(fgImage.getWidth(), fgImage.getHeight());
        GraphicsContext gx = null;
        try {
            gx = img.createGraphicsContext();
            if (tint) {
                gx.setBackground(BLANK_COLOR);
            } else {
                gx.setBackground(this.getBgColor());
            }
            gx.clearRect(0, 0, img.getWidth(), img.getHeight());
            if (drawBackground) {
                this.drawBackground(gx, fgImage.getWidth(), fgImage.getHeight(), 0, 0);
            }
            if (level != null && level.sprObjBehind != null) {
                int n = level.sprObjBehind.length - 1;
                while (n >= 0) {
                    SpriteObject spr = level.sprObjBehind[n];
                    LemmImage sprImg = spr.getImage();
                    gx.drawImage(sprImg, spr.getX(), spr.getY());
                    --n;
                }
            }
            gx.drawImage(fgImage, 0, 0);
            if (level != null && level.sprObjFront != null) {
                SpriteObject[] spriteObjectArray = level.sprObjFront;
                int sprImg = level.sprObjFront.length;
                int spr = 0;
                while (spr < sprImg) {
                    SpriteObject spr2 = spriteObjectArray[spr];
                    LemmImage sprImg2 = spr2.getImage();
                    gx.drawImage(sprImg2, spr2.getX(), spr2.getY());
                    ++spr;
                }
            }
        }
        finally {
            if (gx != null) {
                gx.dispose();
            }
        }
        if (scaleX != 1.0 || scaleY != 1.0) {
            int width = ToolBox.scale(fgImage.getWidth(), scaleX);
            int height = ToolBox.scale(fgImage.getHeight(), scaleY);
            Object interpolationHint = highQuality ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            img = img.getScaledInstance(width, height, interpolationHint, highQuality);
        }
        if (tint) {
            int y = 0;
            while (y < img.getHeight()) {
                int x = 0;
                while (x < img.getWidth()) {
                    int c = img.getRGB(x, y);
                    c = Minimap.tintColor(c);
                    img.setRGB(x, y, c);
                    ++x;
                }
                ++y;
            }
        }
        return img;
    }

    public SpriteObject getSprObject(int idx) {
        if (idx >= 0 && idx < this.sprObjects.length) {
            return this.sprObjects[idx];
        }
        return null;
    }

    public int getNumSprObjects() {
        if (this.sprObjects == null) {
            return 0;
        }
        return this.sprObjects.length;
    }

    Entrance getEntrance(int idx) {
        return this.entrances.get(idx);
    }

    public int getNumEntrances() {
        if (this.entrances == null) {
            return 0;
        }
        return this.entrances.size();
    }

    public int[] getEntranceOrder() {
        return this.entranceOrder;
    }

    public Color getBgColor() {
        Color bgColor = BLANK_COLOR;
        if (this.specialStyle != null) {
            bgColor = this.specialStyle.getBgColor();
        }
        if (bgColor.equals(BLANK_COLOR)) {
            bgColor = this.mainStyle.getBgColor();
        }
        return bgColor;
    }

    public int getMaxFallDistance() {
        return this.maxFallDistance;
    }

    public boolean getClassicSteel() {
        return this.classicSteel;
    }

    public int[] getParticleCol() {
        return this.mainStyle.getParticleColor();
    }

    public int getXPosCenter() {
        return this.xPosCenter;
    }

    public int getYPosCenter() {
        return this.yPosCenter;
    }

    public int getNumClimbers() {
        return this.numClimbers;
    }

    public int getNumFloaters() {
        return this.numFloaters;
    }

    public int getNumBombers() {
        return this.numBombers;
    }

    public int getNumBlockers() {
        return this.numBlockers;
    }

    public int getNumBuilders() {
        return this.numBuilders;
    }

    public int getNumBashers() {
        return this.numBashers;
    }

    public int getNumMiners() {
        return this.numMiners;
    }

    public int getNumDiggers() {
        return this.numDiggers;
    }

    public int getTimeLimitSeconds() {
        return this.timeLimitSeconds;
    }

    public int getNumToRescue() {
        return this.numToRescue;
    }

    public int getNumLemmings() {
        return this.numLemmings;
    }

    public final int getDebrisColor() {
        int debrisColor = 0;
        if (this.specialStyle != null) {
            debrisColor = this.specialStyle.getDebrisColor();
        }
        if (debrisColor == 0) {
            debrisColor = this.mainStyle.getDebrisColor();
        }
        return debrisColor;
    }

    public final int getDebrisColor2() {
        int debrisColor2 = 0;
        if (this.specialStyle != null) {
            debrisColor2 = this.specialStyle.getDebrisColor2();
        }
        if (debrisColor2 == 0) {
            debrisColor2 = this.mainStyle.getDebrisColor2();
        }
        return debrisColor2;
    }

    public int getReleaseRate() {
        return this.releaseRate;
    }

    public int getMaxReleaseRate() {
        return this.maxReleaseRate;
    }

    public boolean isReleaseRateLocked() {
        return this.lockReleaseRate;
    }

    public int getWidth() {
        return this.levelWidth;
    }

    public int getHeight() {
        return this.levelHeight;
    }

    public int getTopBoundary() {
        return this.topBoundary;
    }

    public int getBottomBoundary() {
        return this.bottomBoundary;
    }

    public int getLeftBoundary() {
        return this.leftBoundary;
    }

    public int getRightBoundary() {
        return this.rightBoundary;
    }

    public String getMusic() {
        return this.music;
    }

    public boolean isSuperLemming() {
        return this.superlemming;
    }

    public boolean getForceNormalTimerSpeed() {
        return this.forceNormalTimerSpeed;
    }

    public String getStyleName() {
        return this.mainStyle.getName();
    }

    public String getSpecialStyleName() {
        return this.specialStyle != null ? this.specialStyle.getName() : "";
    }

    public String getLevelName() {
        return this.lvlName;
    }

    public String getAuthor() {
        return this.author;
    }

    public int getNumHints() {
        return this.hints.size();
    }

    public String getHint(int index) {
        if (index < this.hints.size()) {
            return this.hints.get(index);
        }
        return null;
    }

    private static enum AutosteelMode {
        NONE,
        SIMPLE,
        ADVANCED;

    }

    public class Background {
        int width;
        int height;
        List<LvlObject> objects;
        List<Terrain> terrain;
        SpriteObject[] sprObjects;
        SpriteObject[] sprObjFront;
        SpriteObject[] sprObjBehind;
        boolean tiled;
        int tint;
        int offsetX;
        int offsetY;
        double scrollSpeedX;
        double scrollSpeedY;
        double scale;

        Background(int width, int height, List<LvlObject> objects, List<Terrain> terrain, boolean tiled, int tint, int offsetX, int offsetY, double scrollSpeedX, double scrollSpeedY, double scale) {
            this.width = width;
            this.height = height;
            this.objects = objects;
            this.terrain = terrain;
            this.tiled = tiled;
            this.tint = tint;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.scrollSpeedX = scrollSpeedX;
            this.scrollSpeedY = scrollSpeedY;
            this.scale = scale;
        }
    }

    public class Entrance {
        int id;
        int xPos;
        int yPos;
        boolean leftEntrance;

        Entrance(int x, int y, boolean left) {
            this.xPos = x;
            this.yPos = y;
            this.leftEntrance = left;
        }
    }

    public class LvlObject {
        static final int MODE_VIS_ON_TERRAIN = 8;
        static final int MODE_NO_OVERWRITE = 4;
        static final int MODE_INVISIBLE = 2;
        static final int FLAG_UPSIDE_DOWN = 1;
        static final int FLAG_FAKE = 2;
        static final int FLAG_UPSIDE_DOWN_MASK = 4;
        static final int FLAG_FLIP_HORIZONTALLY = 8;
        static final int FLAG_ROTATE = 16;
        static final int OPTION_ENTRANCE_LEFT = 1;
        int id;
        int xPos;
        int yPos;
        int paintMode;
        int flags;
        int objSpecificModifier;
        String style;

        public LvlObject(String[] val) {
            this.id = ToolBox.parseInt(val[0]);
            this.xPos = ToolBox.parseInt(val[1]);
            this.yPos = ToolBox.parseInt(val[2]);
            this.paintMode = ToolBox.parseInt(val[3]);
            this.flags = ToolBox.parseInt(val[4]);
            this.objSpecificModifier = val.length >= 6 ? ToolBox.parseInt(val[5]) : 0;
            this.style = val.length >= 7 ? val[6] : Level.this.mainStyle.getName();
        }
    }

    public class Steel {
        int xPos;
        int yPos;
        int width;
        int height;
        boolean negative;

        public Steel(int[] val) {
            this.xPos = val[0];
            this.yPos = val[1];
            this.width = val[2];
            this.height = val[3];
            this.negative = val.length >= 5 ? BooleanUtils.toBoolean((int)(val[4] & 1)) : false;
        }
    }

    public class Terrain {
        static final int MODE_ROTATE = 128;
        static final int MODE_NO_ONE_WAY = 64;
        static final int MODE_FLIP_HORIZONTALLY = 32;
        static final int MODE_FAKE = 16;
        static final int MODE_NO_OVERWRITE = 8;
        static final int MODE_UPSIDE_DOWN = 4;
        static final int MODE_REMOVE = 2;
        static final int MODE_INVISIBLE = 1;
        int id;
        int xPos;
        int yPos;
        int modifier;
        boolean specialGraphic;
        String style;

        public Terrain(String[] val, boolean special) {
            this.id = ToolBox.parseInt(val[0]);
            this.xPos = ToolBox.parseInt(val[1]);
            this.yPos = ToolBox.parseInt(val[2]);
            this.modifier = ToolBox.parseInt(val[3]);
            this.specialGraphic = special;
            this.style = val.length >= 5 ? val[4] : Level.this.mainStyle.getName();
        }
    }
}

