/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import lemmini.game.Lemming;
import lemmini.game.Mask;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;

class LemmingResource {
    int footX;
    int footY;
    int size;
    int maskX;
    int maskY;
    int width;
    int height;
    int frames;
    Lemming.Animation animMode;
    int dirs;
    int maskStep;
    private final List<List<LemmImage>> img = new ArrayList<List<LemmImage>>(2);
    private final List<List<LemmImage>> originalColorImg = new ArrayList<List<LemmImage>>(2);
    private List<Mask> mask = null;

    LemmingResource() {
        this.width = 1;
        this.height = 1;
        this.dirs = 1;
        this.animMode = Lemming.Animation.NONE;
        ArrayList<LemmImage> imgTemp = new ArrayList<LemmImage>(1);
        imgTemp.add(ToolBox.createLemmImage(this.width, this.height, 2));
        this.img.add(imgTemp);
        this.originalColorImg.add(new ArrayList(imgTemp));
    }

    LemmingResource(LemmImage sourceImg, int animFrames) {
        this.frames = animFrames;
        this.width = sourceImg.getWidth();
        this.height = sourceImg.getHeight() / animFrames;
        this.dirs = 1;
        this.animMode = Lemming.Animation.NONE;
        List<LemmImage> anim = ToolBox.getAnimation(sourceImg, animFrames);
        this.img.add(anim);
        this.originalColorImg.add(new ArrayList<LemmImage>(anim));
    }

    LemmingResource(LemmImage sourceImg, LemmImage sourceImgLeft, int animFrames) {
        this.frames = animFrames;
        this.width = Math.min(sourceImg.getWidth(), sourceImgLeft.getWidth());
        this.height = Math.min(sourceImg.getHeight() / animFrames, sourceImgLeft.getHeight() / animFrames);
        this.dirs = 2;
        this.animMode = Lemming.Animation.NONE;
        List<LemmImage> animRight = ToolBox.getAnimation(sourceImg, animFrames);
        List<LemmImage> animLeft = ToolBox.getAnimation(sourceImgLeft, animFrames);
        this.img.add(animRight);
        this.img.add(animLeft);
        this.originalColorImg.add(new ArrayList<LemmImage>(animRight));
        this.originalColorImg.add(new ArrayList<LemmImage>(animLeft));
    }

    Mask getMask(Lemming.Direction dir) {
        if (this.dirs > 1) {
            return this.mask.get(dir.ordinal());
        }
        return this.mask.get(0);
    }

    void setMasks(List<Mask> m) {
        this.mask = m;
    }

    LemmImage getImage(Lemming.Direction dir, int frame) {
        if (this.dirs > 1) {
            return this.img.get(dir.ordinal()).get(frame);
        }
        return this.img.get(0).get(frame);
    }

    void replaceColors(int templateCol, int replaceCol, int templateCol2, int replaceCol2) {
        ListIterator<List<LemmImage>> itd = this.originalColorImg.listIterator();
        while (itd.hasNext()) {
            int di = itd.nextIndex();
            ListIterator<LemmImage> itf = itd.next().listIterator();
            while (itf.hasNext()) {
                int fi = itf.nextIndex();
                LemmImage i = ToolBox.copyLemmImage(itf.next());
                i.replaceColor(templateCol, replaceCol);
                i.replaceColor(templateCol2, replaceCol2);
                this.img.get(di).set(fi, i);
            }
        }
        if (this.mask != null) {
            this.mask.stream().filter(Objects::nonNull).forEach(d -> d.replaceColors(templateCol, replaceCol, templateCol2, replaceCol2));
        }
    }
}

