/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lemmini.game.Core;
import lemmini.game.ExplodeFont;
import lemmini.game.GameController;
import lemmini.game.LemmingResource;
import lemmini.game.Mask;
import lemmini.game.MiscGfx;
import lemmini.game.ReplayAssignSkillEvent;
import lemmini.game.ReplayEvent;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.game.SpriteObject;
import lemmini.game.Stencil;
import lemmini.graphics.LemmImage;
import lemmini.sound.Sound;
import lemmini.tools.Props;
import org.apache.commons.lang3.BooleanUtils;

public class Lemming {
    public static final int HEIGHT = 20;
    private static final String LEMM_INI_STR = "gfx/lemming/lemming.ini";
    private static final int NUM_RESOURCES = 18;
    private static final int WALKER_STEP = 1;
    private static final int CLIMBER_STEP = 1;
    private static final int WALKER_OBSTACLE_HEIGHT = 14;
    private static final int BASHER_CHECK_STEP = 12;
    private static final int BASHER_CHECK_STEP_STEEL = 16;
    private static final int BASHER_CHECK_STEP_STEEL_LOW = 3;
    private static final int BASHER_FALL_DISTANCE = 6;
    private static final int MINER_CHECK_STEP_STEEL = 16;
    private static final int MINER_FALL_DISTANCE = 1;
    private static final int FALLER_STEP = 3;
    private static final int FLOATER_STEP = 2;
    private static final int FLOATER_STEP_SLOW = 1;
    private static final int JUMPER_STEP = 2;
    private static final int JUMPER_JUMP = 6;
    private static final int DIGGER_STEP = 2;
    private static final int FALL_DISTANCE_FLOAT = 32;
    private static final int FALL_DISTANCE_FALL = 8;
    private static final int STEPS_MAX = 12;
    private static final int STEPS_WARNING = 9;
    private static final int TIME_SCALE = 2;
    private static final int MAX_BOMB_TIMER = 5;
    private static final int[] MAX_EXPLODE_CTR = new int[]{31, 31, 32, 31, 31};
    private static final int EXPLODER_LIFE = 102;
    private static final int DEF_TEMPLATE_COLOR = -65281;
    private LemmingResource lemRes;
    private int frameIdx = 0;
    private int x;
    private int y;
    private Direction dir;
    private Type type = Type.FALLER;
    private int counter = 0;
    private int counter2;
    private int explodeNumCtr = 0;
    private boolean canFloat;
    private boolean canClimb;
    private boolean canChangeSkill;
    private boolean flapper;
    private boolean drowner;
    private boolean nuke;
    private boolean hasDied;
    private boolean hasExited;
    private int explodeCtr;
    private int selectCtr = 0;
    private static List<LemmingResource> lemmings = new ArrayList<LemmingResource>(18);
    private static ExplodeFont explodeFont;
    private static int templateColor;
    private static int templateColor2;

    public Lemming(int sx, int sy, Direction d) {
        this.lemRes = Lemming.getResource(this.type);
        this.dir = d;
        this.x = sx;
        this.y = sy;
        this.canFloat = false;
        this.canClimb = false;
        this.canChangeSkill = false;
        this.hasDied = false;
        this.hasExited = false;
        this.flapper = false;
        this.drowner = false;
        this.nuke = false;
    }

    public static int getOrdinal(Type t) {
        switch (t) {
            case FLAPPER_BLOCKER: {
                return Type.FLAPPER.ordinal();
            }
            case FLOATER_START: {
                return Type.FLOATER.ordinal();
            }
        }
        return t.ordinal();
    }

    public void animate() {
        int checkMask;
        int eraseMask;
        int i;
        int free;
        Type oldType = this.type;
        Type newType = this.type;
        boolean explode = false;
        if (this.explodeNumCtr != 0 && ++this.explodeCtr >= MAX_EXPLODE_CTR[this.explodeNumCtr - 1]) {
            this.explodeCtr -= MAX_EXPLODE_CTR[this.explodeNumCtr - 1];
            --this.explodeNumCtr;
            if (this.explodeNumCtr == 0) {
                explode = true;
            }
        }
        if (this.selectCtr > 0) {
            --this.selectCtr;
        }
        switch (this.type) {
            case FLIPPER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                int idx = this.frameIdx + 1;
                switch (idx) {
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: {
                        this.y -= 4;
                        break;
                    }
                }
                this.turnedByBlocker();
                break;
            }
            case FALLER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                free = this.freeBelow(3);
                this.y += StrictMath.min(3, free);
                if (!this.crossedLowerBorder()) {
                    this.counter += free;
                    if (this.canFloat && this.counter >= 32) {
                        newType = Type.FLOATER_START;
                        this.counter2 = 0;
                    } else if (free == 0) {
                        if (this.counter > GameController.getLevel().getMaxFallDistance()) {
                            newType = Type.SPLATTER;
                        } else {
                            newType = Type.WALKER;
                            this.counter = 0;
                        }
                    }
                }
                this.turnedByBlocker();
                break;
            }
            case JUMPER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                int levitation = this.aboveGround();
                if (levitation > 2) {
                    this.y -= 2;
                } else {
                    this.y -= levitation;
                    newType = Type.WALKER;
                }
                this.turnedByBlocker();
                break;
            }
            case WALKER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                if (this.dir == Direction.RIGHT) {
                    ++this.x;
                } else if (this.dir == Direction.LEFT) {
                    --this.x;
                }
                if (this.flipDirBorder()) break;
                free = this.freeBelow(8);
                this.y = free >= 8 ? (this.y += 3) : (this.y += free);
                boolean ignoreBlockers = false;
                int levitation = this.aboveGround();
                if (levitation < 14 && this.y >= 8) {
                    if (levitation >= 6) {
                        this.y -= 2;
                        newType = Type.JUMPER;
                        break;
                    }
                    this.y -= levitation;
                } else {
                    if (this.canClimb && this.y >= 14) {
                        newType = Type.CLIMBER;
                        break;
                    }
                    this.flipDir();
                    ignoreBlockers = true;
                }
                if (free > 0 && free >= 8) {
                    this.counter = 4;
                    newType = Type.FALLER;
                    ++this.y;
                }
                if (ignoreBlockers) break;
                this.turnedByBlocker();
                break;
            }
            case FLOATER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                free = this.freeBelow(2);
                this.y += StrictMath.min(2, free);
                if (!this.crossedLowerBorder()) {
                    this.counter += free;
                    if (free == 0) {
                        newType = Type.WALKER;
                        this.counter = 0;
                    }
                }
                this.turnedByBlocker();
                break;
            }
            case FLOATER_START: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                free = this.freeBelow(3);
                switch (this.counter2++) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (free >= 3) {
                            this.y += 3;
                            break;
                        }
                        this.y += free;
                        break;
                    }
                    case 8: 
                    case 9: {
                        --this.y;
                        break;
                    }
                    case 10: 
                    case 11: {
                        break;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        this.y = free >= 1 ? ++this.y : (this.y += free);
                        if (this.counter2 - 1 != 15) break;
                        this.type = Type.FLOATER;
                        break;
                    }
                    default: {
                        this.type = Type.FLOATER;
                    }
                }
                if (!this.crossedLowerBorder()) {
                    this.counter += StrictMath.min(2, free);
                    if (free == 0) {
                        newType = Type.WALKER;
                        this.counter = 0;
                    }
                }
                this.turnedByBlocker();
                break;
            }
            case CLIMBER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                int idx = this.frameIdx + 1;
                if (idx >= this.lemRes.frames * 2) {
                    idx = 0;
                }
                switch (idx) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (!this.reachedPlateau(idx + 13)) break;
                        this.counter = 0;
                        this.y += -idx + 4;
                        newType = Type.FLIPPER;
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        if (!this.freeAboveClimber()) {
                            this.flipDir();
                            this.x = this.dir == Direction.LEFT ? --this.x : ++this.x;
                            newType = Type.FALLER;
                            this.counter = 0;
                            break;
                        }
                        --this.y;
                        break;
                    }
                }
                this.turnedByBlocker();
                break;
            }
            case DIGGER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                this.turnedByBlocker();
                break;
            }
            case BASHER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                int idx = this.frameIdx + 1;
                if (idx >= this.lemRes.frames * 2) {
                    idx = 0;
                }
                block33 : switch (idx) {
                    case 4: 
                    case 6: 
                    case 8: 
                    case 10: {
                        Mask m = this.lemRes.getMask(this.dir);
                        int eraseMask2 = 1;
                        int checkMask2 = 0;
                        if (!GameController.getLevel().getClassicSteel()) {
                            eraseMask2 |= 0xC00;
                            checkMask2 |= 6;
                            checkMask2 |= this.dir == Direction.LEFT ? 2048 : 1024;
                        }
                        m.eraseMask(this.screenMaskX(), this.screenMaskY(), idx / 2 - 2, eraseMask2, checkMask2);
                        if (idx != 10 || this.canBash()) break;
                        newType = Type.WALKER;
                        break;
                    }
                    case 36: 
                    case 38: 
                    case 40: 
                    case 42: {
                        Mask m = this.lemRes.getMask(this.dir);
                        int eraseMask2 = 1;
                        int checkMask2 = 0;
                        if (!GameController.getLevel().getClassicSteel()) {
                            eraseMask2 |= 0xC00;
                            checkMask2 |= 6;
                            checkMask2 |= this.dir == Direction.LEFT ? 2048 : 1024;
                        }
                        m.eraseMask(this.screenMaskX(), this.screenMaskY(), idx / 2 - 18, eraseMask2, checkMask2);
                        break;
                    }
                    case 22: 
                    case 24: 
                    case 26: 
                    case 28: 
                    case 30: 
                    case 54: 
                    case 56: 
                    case 58: 
                    case 60: 
                    case 62: {
                        i = 0;
                        while (i < 2) {
                            this.x = this.dir == Direction.RIGHT ? ++this.x : --this.x;
                            free = this.freeBelow(6);
                            if (free >= 6) {
                                this.y += 3;
                                newType = Type.FALLER;
                                break block33;
                            }
                            this.y += free;
                            ++i;
                        }
                        break;
                    }
                }
                this.turnedByBlocker();
                if (!this.canBashSteel(true)) {
                    this.flipDir();
                    newType = Type.WALKER;
                }
                if (!this.flipDirBorder()) break;
                newType = Type.WALKER;
                break;
            }
            case MINER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                int idx = this.frameIdx + 1;
                if (idx >= this.lemRes.frames * 2) {
                    idx = 0;
                }
                int oldX = this.x;
                int oldY = this.y;
                switch (idx) {
                    case 0: {
                        this.y += 2;
                        break;
                    }
                    case 2: 
                    case 4: {
                        Mask m = this.lemRes.getMask(this.dir);
                        eraseMask = 1;
                        checkMask = 0;
                        if (!GameController.getLevel().getClassicSteel()) {
                            eraseMask |= 0xC00;
                            checkMask |= 6;
                            checkMask |= this.dir == Direction.LEFT ? 2048 : 1024;
                        }
                        m.eraseMask(this.screenMaskX(), this.screenMaskY(), idx / 2 - 1, eraseMask, checkMask);
                        break;
                    }
                    case 6: {
                        this.y += 2;
                    }
                    case 30: {
                        int free2;
                        this.x = this.dir == Direction.RIGHT ? (this.x += 4) : (this.x -= 4);
                        free = this.freeBelow(1);
                        if (this.dir == Direction.RIGHT) {
                            int oldX2 = this.x++;
                            free2 = this.freeBelow(1);
                            this.x = oldX2;
                        } else {
                            free2 = free;
                        }
                        if (free2 >= 1) {
                            if (this.dir == Direction.RIGHT && free < 1) {
                                ++this.x;
                            }
                            this.y += StrictMath.min(3, free2);
                            newType = Type.FALLER;
                            break;
                        }
                        if (this.canMine(false, true)) break;
                        if (!GameController.getLevel().getClassicSteel()) {
                            this.x = oldX;
                            this.y = oldY;
                        }
                        this.flipDir();
                        newType = Type.WALKER;
                        break;
                    }
                }
                this.turnedByBlocker();
                break;
            }
            case SHRUGGER: {
                if (explode) {
                    newType = this.getExploderType();
                }
                this.turnedByBlocker();
                break;
            }
            case BUILDER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                int idx = this.frameIdx + 1;
                if (idx >= this.lemRes.frames * 2) {
                    ++this.counter;
                    this.y -= 2;
                    int i2 = 0;
                    while (i2 < 4) {
                        this.x = this.dir == Direction.RIGHT ? ++this.x : --this.x;
                        int levitation = this.aboveGround();
                        if (this.counter < 12 && (i2 == 3 && !this.freeAboveBuilder() || levitation > 0)) {
                            newType = Type.WALKER;
                            this.flipDir();
                            break;
                        }
                        ++i2;
                    }
                    if (this.counter >= 12) {
                        newType = Type.SHRUGGER;
                        break;
                    }
                    if (this.y < GameController.getLevel().getTopBoundary() + 2) {
                        newType = Type.WALKER;
                        break;
                    }
                } else if (idx == 18) {
                    Mask m = this.lemRes.getMask(this.dir);
                    m.paintStep(this.screenMaskX(), this.screenMaskY(), 0);
                } else if (idx == 20 && this.counter >= 9) {
                    this.playVisualSFX(Sound.Effect.STEP_WARNING);
                }
                this.turnedByBlocker();
                break;
            }
            case BLOCKER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                free = this.freeBelow(3);
                if (free > 0) {
                    this.eraseBlockerMask();
                    this.y += StrictMath.min(3, free);
                    this.counter += free;
                    if (this.counter >= 8) {
                        newType = Type.FALLER;
                        break;
                    }
                    newType = Type.WALKER;
                    break;
                }
                this.counter = 0;
                break;
            }
            case FLAPPER_BLOCKER: {
                free = this.freeBelow(3);
                if (free > 0) {
                    this.eraseBlockerMask();
                    this.type = Type.FLAPPER;
                } else {
                    int idx = this.frameIdx + 1;
                    if (idx != 10 || this.nuke) break;
                    this.playVisualSFX(Sound.Effect.OHNO);
                    break;
                }
            }
            case FLAPPER: {
                int idx = this.frameIdx + 1;
                if (idx == 10 && !this.nuke) {
                    this.playVisualSFX(Sound.Effect.OHNO);
                }
                free = this.freeBelow(3);
                this.y += StrictMath.min(3, free);
                this.crossedLowerBorder();
                break;
            }
            case DROWNER: {
                if (explode) {
                    newType = this.getExploderType();
                    break;
                }
                if (!this.flapper) {
                    if (this.dir == Direction.RIGHT) {
                        if (this.x < GameController.getWidth() + GameController.getLevel().getRightBoundary() - 16 && !BooleanUtils.toBoolean((int)(GameController.getStencil().getMask(this.x + 16, this.y) & 1))) {
                            ++this.x;
                        }
                    } else if (this.dir == Direction.LEFT && this.x >= GameController.getLevel().getLeftBoundary() + 16 && !BooleanUtils.toBoolean((int)(GameController.getStencil().getMask(this.x - 16, this.y) & 1))) {
                        --this.x;
                    }
                }
                this.turnedByBlocker();
                break;
            }
            case FRIER: {
                if (GameController.getLevel().getStyleName().equals("bubble")) {
                    this.playVisualSFX(Sound.Effect.EXPLODE);
                    this.addExplosion();
                    this.hasDied = true;
                    break;
                }
                if (!explode) break;
                newType = this.getExploderType();
                break;
            }
            case EXPLODER: {
                ++this.counter;
                if (this.counter == 2) {
                    Stencil stencil = GameController.getStencil();
                    Mask m = this.lemRes.getMask(Direction.RIGHT);
                    this.playVisualSFX(Sound.Effect.EXPLODE);
                    if (!GameController.getLevel().getClassicSteel()) {
                        m.eraseMask(this.screenMaskX(), StrictMath.max(this.screenMaskY(), -8), 0, 3073, 6);
                        break;
                    }
                    if (this.x < GameController.getLevel().getLeftBoundary() || this.x >= GameController.getWidth() + GameController.getLevel().getRightBoundary() || this.y >= GameController.getHeight() || BooleanUtils.toBoolean((int)(stencil.getMask(this.x, this.y) & 6)) || BooleanUtils.toBoolean((int)(stencil.getMask(this.x, this.y) & 0x8000)) || this.drowner) break;
                    m.eraseMask(this.screenMaskX(), StrictMath.max(this.screenMaskY(), -8), 0, 1, 0);
                    break;
                }
                if (this.counter < 102) break;
                this.hasDied = true;
                break;
            }
            default: {
                if (!explode) break;
                newType = this.getExploderType();
            }
        }
        if (this.y < GameController.getLevel().getTopBoundary()) {
            this.y = GameController.getLevel().getTopBoundary();
        }
        if (!this.hasDied && this.type != Type.EXPLODER) {
            int s = this.stencilFoot();
            int object = this.objectFoot();
            block44 : switch (s & 0xF000) {
                case 4096: {
                    SpriteObject spr;
                    if (this.type == Type.DROWNER || (spr = GameController.getLevel().getSprObject(object)) == null) break;
                    boolean triggered = true;
                    if (spr.canBeTriggered() && !spr.trigger(this)) {
                        triggered = false;
                    }
                    if (!triggered) break;
                    if (this.type == Type.BLOCKER || this.type == Type.FLAPPER_BLOCKER) {
                        this.eraseBlockerMask();
                    }
                    GameController.sound.playVisualSFX(spr);
                    this.drowner = true;
                    newType = Type.DROWNER;
                    break;
                }
                case 16384: {
                    SpriteObject spr;
                    if (this.type == Type.FRIER || (spr = GameController.getLevel().getSprObject(object)) == null) break;
                    boolean triggered = true;
                    if (spr.canBeTriggered() && !spr.trigger(this)) {
                        triggered = false;
                    }
                    if (!triggered) break;
                    if (this.type == Type.BLOCKER || this.type == Type.FLAPPER_BLOCKER) {
                        this.eraseBlockerMask();
                    }
                    GameController.sound.playVisualSFX(spr);
                    newType = Type.FRIER;
                    break;
                }
                case 8192: {
                    SpriteObject spr = GameController.getLevel().getSprObject(object);
                    if (spr == null) break;
                    boolean triggered = true;
                    if (spr.canBeTriggered() && !spr.trigger(this)) {
                        triggered = false;
                    }
                    if (!triggered) break;
                    if (this.type == Type.BLOCKER || this.type == Type.FLAPPER_BLOCKER) {
                        this.eraseBlockerMask();
                    }
                    GameController.sound.playVisualSFX(spr);
                    this.hasDied = true;
                    break;
                }
                case 32768: {
                    boolean triggered;
                    if (Core.player.isMaximumExitPhysics()) {
                        switch (newType) {
                            case FALLER: 
                            case CLIMBER: 
                            case FLIPPER: 
                            case SPLATTER: 
                            case BLOCKER: 
                            case DROWNER: 
                            case FRIER: 
                            case SHRUGGER: 
                            case EXPLODER: 
                            case NUKE: {
                                newType = Type.MAX_EXIT_LEM;
                                break;
                            }
                        }
                    }
                    switch (newType) {
                        case WALKER: 
                        case FLOATER: 
                        case FLAPPER: 
                        case DROWNER: 
                        case BUILDER: 
                        case DIGGER: 
                        case BASHER: 
                        case MINER: 
                        case JUMPER: 
                        case FLOATER_START: 
                        case MAX_EXIT_LEM: {
                            SpriteObject spr = GameController.getLevel().getSprObject(object);
                            if (spr == null) break block44;
                            triggered = true;
                            if (spr.canBeTriggered() && !spr.trigger(this)) {
                                triggered = false;
                            }
                            if (!triggered) break block44;
                            if (this.type == Type.BLOCKER || this.type == Type.FLAPPER_BLOCKER) {
                                this.eraseBlockerMask();
                            }
                            GameController.sound.playVisualSFX(spr);
                            newType = Type.HOMER;
                            break block44;
                        }
                    }
                    break;
                }
            }
        }
        if (oldType == newType) {
            boolean trigger = false;
            switch (this.lemRes.animMode) {
                case LOOP: {
                    if (++this.frameIdx >= this.lemRes.frames * 2) {
                        this.frameIdx = 0;
                    }
                    if (this.lemRes.maskStep <= 0 || this.frameIdx % (this.lemRes.maskStep * 2) != 0) break;
                    trigger = true;
                    break;
                }
                case ONCE: {
                    if (this.frameIdx < this.lemRes.frames * 2 - 1) {
                        ++this.frameIdx;
                        break;
                    }
                    trigger = true;
                    break;
                }
            }
            if (trigger) {
                switch (this.type) {
                    case FLAPPER_BLOCKER: {
                        this.eraseBlockerMask();
                    }
                    case FLAPPER: {
                        newType = Type.EXPLODER;
                        break;
                    }
                    case DROWNER: {
                        this.playVisualSFX(Sound.Effect.DROWN);
                    }
                    case FRIER: {
                        if (this.flapper) {
                            newType = Type.EXPLODER;
                            break;
                        }
                    }
                    case SPLATTER: {
                        this.hasDied = true;
                        break;
                    }
                    case HOMER: {
                        this.hasExited = true;
                        GameController.increaseExited();
                        break;
                    }
                    case FLOATER_START: {
                        this.type = Type.FLOATER;
                    }
                    case FLOATER: {
                        this.frameIdx = 16;
                        break;
                    }
                    case FLIPPER: {
                        newType = Type.WALKER;
                        break;
                    }
                    case DIGGER: {
                        Mask m = this.lemRes.getMask(this.dir);
                        int freeMin = Integer.MAX_VALUE;
                        int xOld = this.x;
                        i = -4;
                        while (i < 6) {
                            this.x = xOld + i;
                            free = this.freeBelow(2);
                            if (free < freeMin) {
                                freeMin = free;
                            }
                            ++i;
                        }
                        this.x = xOld;
                        free = freeMin;
                        if (free > 0) {
                            newType = Type.FALLER;
                        }
                        this.y += 2;
                        eraseMask = 1;
                        checkMask = 0;
                        if (!GameController.getLevel().getClassicSteel()) {
                            eraseMask |= 0xC00;
                            checkMask |= 6;
                        }
                        m.eraseMask(this.screenMaskX(), this.screenMaskY(), 0, eraseMask, checkMask);
                        if (this.canDig(true)) break;
                        newType = Type.WALKER;
                        break;
                    }
                    case SHRUGGER: {
                        if (this.aboveGround() > 0) {
                            this.x = this.dir == Direction.RIGHT ? --this.x : ++this.x;
                        }
                        newType = Type.WALKER;
                        break;
                    }
                }
            }
        }
        this.changeType(oldType, newType);
    }

    public void playVisualSFX(Sound.Effect e) {
        GameController.sound.playVisualSFX(e, this.footX(), this.midY());
    }

    private boolean turnedByBlocker() {
        int s = this.stencilFoot();
        if (BooleanUtils.toBoolean((int)(s & 0x80)) && this.dir == Direction.RIGHT) {
            this.dir = Direction.LEFT;
            return true;
        }
        if (BooleanUtils.toBoolean((int)(s & 0x200)) && this.dir == Direction.LEFT) {
            this.dir = Direction.RIGHT;
            return true;
        }
        if (BooleanUtils.toBoolean((int)(s & 0x100))) {
            return false;
        }
        if (BooleanUtils.toBoolean((int)(s & 0x20)) && this.dir == Direction.RIGHT) {
            int id = this.objectFoot();
            if (id >= 0) {
                SpriteObject spr = GameController.getLevel().getSprObject(id);
                GameController.sound.playVisualSFX(spr);
            }
            this.dir = Direction.LEFT;
            return true;
        }
        if (BooleanUtils.toBoolean((int)(s & 0x40)) && this.dir == Direction.LEFT) {
            int id = this.objectFoot();
            if (id >= 0) {
                SpriteObject spr = GameController.getLevel().getSprObject(id);
                GameController.sound.playVisualSFX(spr);
            }
            this.dir = Direction.RIGHT;
            return true;
        }
        return false;
    }

    private void changeType(Type oldType, Type newType) {
        if (oldType != newType) {
            this.type = newType;
            this.lemRes = Lemming.getResource(this.type);
            this.frameIdx = newType == Type.DIGGER ? this.lemRes.frames * 2 - 1 : 0;
            switch (newType) {
                case SPLATTER: {
                    this.counter = 0;
                    this.explodeNumCtr = 0;
                    this.playVisualSFX(Sound.Effect.SPLAT);
                    break;
                }
                case FLAPPER: 
                case FLAPPER_BLOCKER: {
                    this.flapper = true;
                    break;
                }
                case EXPLODER: {
                    this.counter = 0;
                    this.explodeNumCtr = 0;
                    this.addExplosion();
                    break;
                }
            }
            switch (newType) {
                case WALKER: 
                case BUILDER: 
                case SHRUGGER: 
                case DIGGER: 
                case BASHER: 
                case MINER: {
                    this.canChangeSkill = true;
                    break;
                }
                default: {
                    this.canChangeSkill = false;
                }
            }
        }
    }

    private void addExplosion() {
        GameController.addExplosion(this.footX(), this.midY());
    }

    private Type getExploderType() {
        switch (this.type) {
            case WALKER: 
            case FLIPPER: 
            case FLAPPER: 
            case HOMER: 
            case BUILDER: 
            case SHRUGGER: 
            case DIGGER: 
            case BASHER: 
            case MINER: 
            case JUMPER: {
                return Type.FLAPPER;
            }
            case BLOCKER: 
            case FLAPPER_BLOCKER: {
                return Type.FLAPPER_BLOCKER;
            }
        }
        return Type.EXPLODER;
    }

    private int stencilFoot() {
        int xm = this.x;
        int ym = this.y;
        int retval = xm >= GameController.getLevel().getLeftBoundary() && xm < GameController.getWidth() + GameController.getLevel().getRightBoundary() && ym >= GameController.getLevel().getTopBoundary() && ym < GameController.getHeight() ? GameController.getStencil().getMask(xm, ym) : 0;
        return retval;
    }

    private int objectFoot() {
        int xm = this.x;
        int ym = this.y;
        int retval = xm >= GameController.getLevel().getLeftBoundary() && xm < GameController.getWidth() + GameController.getLevel().getRightBoundary() && ym >= GameController.getLevel().getTopBoundary() && ym < GameController.getHeight() ? GameController.getStencil().getMaskObjectID(xm, ym) : -1;
        return retval;
    }

    private boolean canBash() {
        int xm = this.x;
        int ypos = this.y - 12;
        int bricks = 0;
        int i = 18;
        while (i < 22) {
            int xb = this.dir == Direction.RIGHT ? xm + i : xm - i + 1;
            if (BooleanUtils.toBoolean((int)(GameController.getStencil().getMask(xb, ypos) & 1))) {
                ++bricks;
            }
            ++i;
        }
        return bricks > 0;
    }

    private boolean canBashSteel(boolean playSound) {
        int xMax;
        int xMin;
        int yMin = this.y - 16;
        int yMax = this.y - (GameController.getLevel().getClassicSteel() ? 16 : 3);
        if (this.dir == Direction.RIGHT) {
            xMin = this.x + 16;
            xMax = this.x + 16 + 1;
        } else {
            xMin = this.x - 16;
            xMax = this.x - 16 + 1;
        }
        int yb = yMin;
        while (yb <= yMax) {
            int xb = xMin;
            while (xb <= xMax) {
                int sval = GameController.getStencil().getMask(xb, yb);
                boolean hitOneWayLeft = BooleanUtils.toBoolean((int)(sval & 0x400)) && this.dir == Direction.RIGHT;
                boolean hitOneWayRight = BooleanUtils.toBoolean((int)(sval & 0x800)) && this.dir == Direction.LEFT;
                boolean hitSteel = BooleanUtils.toBoolean((int)(sval & 6));
                if (hitOneWayLeft || hitOneWayRight || hitSteel) {
                    if (playSound) {
                        SpriteObject spr = GameController.getLevel().getSprObject(GameController.getStencil().getMaskObjectID(xb, yb));
                        if (spr != null && (hitOneWayLeft && spr.getType() == SpriteObject.Type.ONE_WAY_LEFT || hitOneWayRight && spr.getType() == SpriteObject.Type.ONE_WAY_RIGHT || hitSteel && spr.getType() == SpriteObject.Type.STEEL)) {
                            GameController.sound.playVisualSFX(spr);
                        } else {
                            this.playVisualSFX(Sound.Effect.STEEL);
                        }
                    }
                    return false;
                }
                ++xb;
            }
            ++yb;
        }
        return true;
    }

    private boolean canDig(boolean playSound) {
        boolean classicSteel = GameController.getLevel().getClassicSteel();
        int i = 0;
        while (i < 2) {
            int j = classicSteel ? 0 : -4;
            while (j < (classicSteel ? 1 : 6)) {
                int ym = this.y + i;
                int xm = this.x + j;
                int sval = GameController.getStencil().getMask(xm, ym);
                if (BooleanUtils.toBoolean((int)(sval & 1)) && BooleanUtils.toBoolean((int)(sval & 6))) {
                    if (playSound) {
                        SpriteObject spr = GameController.getLevel().getSprObject(GameController.getStencil().getMaskObjectID(xm, ym));
                        if (spr != null && spr.getType() == SpriteObject.Type.STEEL) {
                            GameController.sound.playVisualSFX(spr);
                        } else {
                            this.playVisualSFX(Sound.Effect.STEEL);
                        }
                    }
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    private boolean canMine(boolean start, boolean playSound) {
        boolean hitSteel;
        boolean hitOneWayRight;
        boolean hitOneWayLeft;
        int sval;
        int xb;
        int xMax;
        int xMin;
        if (this.x < GameController.getLevel().getLeftBoundary() || this.x >= GameController.getWidth() + GameController.getLevel().getRightBoundary()) {
            if (!start && playSound) {
                this.playVisualSFX(Sound.Effect.STEEL);
            }
            return false;
        }
        int yMin = this.y - 16;
        int yMax = this.y - 16 + 1;
        if (this.dir == Direction.RIGHT) {
            xMin = this.x + 14;
            xMax = this.x + 14 + 1;
        } else {
            xMin = this.x - 14;
            xMax = this.x - 14 + 1;
        }
        int yb = yMin;
        while (yb <= yMax) {
            xb = xMin;
            while (xb <= xMax) {
                sval = GameController.getStencil().getMask(xb, yb);
                hitOneWayLeft = BooleanUtils.toBoolean((int)(sval & 0x400)) && this.dir == Direction.RIGHT;
                hitOneWayRight = BooleanUtils.toBoolean((int)(sval & 0x800)) && this.dir == Direction.LEFT;
                hitSteel = BooleanUtils.toBoolean((int)(sval & 6));
                if (hitOneWayLeft || hitOneWayRight || hitSteel) {
                    if (playSound) {
                        SpriteObject spr = GameController.getLevel().getSprObject(GameController.getStencil().getMaskObjectID(xb, yb));
                        if (spr != null && (hitOneWayLeft && spr.getType() == SpriteObject.Type.ONE_WAY_LEFT || hitOneWayRight && spr.getType() == SpriteObject.Type.ONE_WAY_RIGHT || hitSteel && spr.getType() == SpriteObject.Type.STEEL)) {
                            GameController.sound.playVisualSFX(spr);
                        } else {
                            this.playVisualSFX(Sound.Effect.STEEL);
                        }
                    }
                    return false;
                }
                ++xb;
            }
            ++yb;
        }
        yMin = this.y;
        yMax = this.y + 1;
        xMin = this.x;
        xMax = this.x + 1;
        yb = yMin;
        while (yb <= yMax) {
            xb = xMin;
            while (xb <= xMax) {
                sval = GameController.getStencil().getMask(xb, yb);
                hitOneWayLeft = !start && BooleanUtils.toBoolean((int)(sval & 0x400)) && this.dir == Direction.RIGHT;
                hitOneWayRight = !start && BooleanUtils.toBoolean((int)(sval & 0x800)) && this.dir == Direction.LEFT;
                hitSteel = BooleanUtils.toBoolean((int)(sval & 6));
                if (hitOneWayLeft || hitOneWayRight || hitSteel) {
                    if (playSound) {
                        SpriteObject spr = GameController.getLevel().getSprObject(GameController.getStencil().getMaskObjectID(xb, yb));
                        if (spr != null && (hitOneWayLeft && spr.getType() == SpriteObject.Type.ONE_WAY_LEFT || hitOneWayRight && spr.getType() == SpriteObject.Type.ONE_WAY_RIGHT || hitSteel && spr.getType() == SpriteObject.Type.STEEL)) {
                            GameController.sound.playVisualSFX(spr);
                        } else {
                            this.playVisualSFX(Sound.Effect.STEEL);
                        }
                    }
                    return false;
                }
                ++xb;
            }
            ++yb;
        }
        return true;
    }

    private int freeBelow(int step) {
        if (this.x < GameController.getLevel().getLeftBoundary() || this.x >= GameController.getWidth() + GameController.getLevel().getRightBoundary()) {
            return 0;
        }
        int free = 0;
        Stencil stencil = GameController.getStencil();
        int yb = this.y;
        int pos = this.x + yb * GameController.getWidth();
        int i = 0;
        while (i < step) {
            if (yb + i >= GameController.getHeight()) {
                return Integer.MAX_VALUE;
            }
            int s = stencil.getMask(pos);
            if (BooleanUtils.toBoolean((int)(s & 1))) break;
            ++free;
            pos += GameController.getWidth();
            ++i;
        }
        return free;
    }

    private void flipDir() {
        this.dir = this.dir == Direction.RIGHT ? Direction.LEFT : Direction.RIGHT;
    }

    private boolean flipDirBorder() {
        boolean flip = false;
        if (this.lemRes.dirs > 1) {
            if (this.x < GameController.getLevel().getLeftBoundary() && this.dir == Direction.LEFT) {
                this.x = GameController.getLevel().getLeftBoundary() - 1;
                flip = true;
            } else if (this.x >= GameController.getWidth() + GameController.getLevel().getRightBoundary() && this.dir == Direction.RIGHT) {
                this.x = GameController.getWidth() + GameController.getLevel().getRightBoundary();
                flip = true;
            }
        }
        if (flip) {
            this.flipDir();
        }
        return flip;
    }

    private boolean freeAboveBuilder() {
        if (this.dir == Direction.LEFT && this.x - 3 < GameController.getLevel().getLeftBoundary() || this.dir == Direction.RIGHT && this.x + 4 >= GameController.getWidth() + GameController.getLevel().getRightBoundary()) {
            return false;
        }
        int yMin = this.y - 18;
        int yMax = this.y - 17;
        int xm = this.dir == Direction.RIGHT ? this.x + 4 : this.x - 3;
        Stencil stencil = GameController.getStencil();
        int yb = yMin;
        while (yb <= yMax) {
            if (BooleanUtils.toBoolean((int)(stencil.getMask(xm, yb) & 1))) {
                return false;
            }
            ++yb;
        }
        return true;
    }

    private boolean freeAboveClimber() {
        if (this.x < GameController.getLevel().getLeftBoundary() || this.x >= GameController.getWidth() + GameController.getLevel().getRightBoundary() || this.x <= GameController.getLevel().getTopBoundary()) {
            return false;
        }
        int ym = this.y - 18;
        int xm = this.x;
        xm = this.dir == Direction.LEFT ? ++xm : --xm;
        Stencil stencil = GameController.getStencil();
        return ym >= 0 && !BooleanUtils.toBoolean((int)(stencil.getMask(xm, ym) & 1));
    }

    private boolean crossedLowerBorder() {
        if (this.y >= GameController.getHeight() + GameController.getLevel().getBottomBoundary()) {
            this.hasDied = true;
            this.playVisualSFX(Sound.Effect.DIE);
            return true;
        }
        return false;
    }

    private int aboveGround() {
        if (this.x < GameController.getLevel().getLeftBoundary() || this.x >= GameController.getWidth() + GameController.getLevel().getRightBoundary()) {
            return GameController.getHeight() + 1;
        }
        int ym = this.y - 1;
        if (ym >= GameController.getHeight()) {
            return 0;
        }
        int pos = this.x;
        Stencil stencil = GameController.getStencil();
        pos += ym * GameController.getWidth();
        int levitation = 0;
        while (levitation < 14) {
            if (ym < GameController.getLevel().getTopBoundary() - 1) {
                return 15;
            }
            if (!BooleanUtils.toBoolean((int)(stencil.getMask(pos) & 1))) break;
            ++levitation;
            pos -= GameController.getWidth();
            --ym;
        }
        return levitation;
    }

    private boolean reachedPlateau(int hand) {
        if (this.x - 2 < GameController.getLevel().getLeftBoundary() || this.x + 2 >= GameController.getWidth() + GameController.getLevel().getRightBoundary()) {
            return false;
        }
        int ym = this.y - hand;
        if (ym >= GameController.getHeight()) {
            return true;
        }
        if (ym < 0 || ym <= GameController.getLevel().getTopBoundary()) {
            return false;
        }
        int pos = this.x;
        return !BooleanUtils.toBoolean((int)(GameController.getStencil().getMask(pos += ym * GameController.getWidth()) & 1));
    }

    private void eraseBlockerMask() {
        LemmingResource res = Lemming.getResource(Type.BLOCKER);
        Mask m = res.getMask(this.dir);
        int maskX = this.x - res.maskX;
        int maskY = this.y - res.maskY;
        m.clearType(maskX, maskY, 0, 128);
        m.clearType(maskX, maskY, 1, 256);
        m.clearType(maskX, maskY, 2, 512);
    }

    public static void replaceColors(int replaceCol, int replaceCol2) {
        lemmings.stream().forEach(lemm -> lemm.replaceColors(templateColor, replaceCol, templateColor2, replaceCol2));
    }

    public static void loadLemmings() throws ResourceException {
        explodeFont = new ExplodeFont();
        Props p = new Props();
        Resource resource = Core.findResource(LEMM_INI_STR, true);
        if (!p.load(resource)) {
            throw new ResourceException(LEMM_INI_STR);
        }
        lemmings.clear();
        templateColor = p.getInt("templateColor", -65281) & 0xFFFFFF;
        templateColor2 = p.getInt("templateColor2", templateColor) & 0xFFFFFF;
        Type[] lemmTypes = Type.values();
        int i = 0;
        while (i < 18) {
            int[] val;
            LemmingResource newLemResource;
            LemmImage sourceImg;
            Type type = lemmTypes[i];
            boolean bidirectional = type.bidirectional;
            if (type.frames > 0) {
                resource = Core.findResource("gfx/lemming/lemm_" + type.name().toLowerCase(Locale.ROOT) + ".png", Core.IMAGE_EXTENSIONS);
                sourceImg = Core.loadLemmImage(resource);
                if (bidirectional) {
                    resource = Core.findResource("gfx/lemming/lemm_" + type.name().toLowerCase(Locale.ROOT) + "_left.png", Core.IMAGE_EXTENSIONS);
                    LemmImage sourceImgLeft = Core.loadLemmImage(resource);
                    newLemResource = new LemmingResource(sourceImg, sourceImgLeft, type.frames);
                } else {
                    newLemResource = new LemmingResource(sourceImg, type.frames);
                }
            } else {
                newLemResource = new LemmingResource();
            }
            Animation animation = newLemResource.animMode = type.loop ? Animation.LOOP : Animation.ONCE;
            if (type.maskFrames > 0) {
                resource = Core.findResource("gfx/lemming/mask_" + type.name().toLowerCase(Locale.ROOT) + ".png", Core.IMAGE_EXTENSIONS);
                sourceImg = Core.loadLemmImage(resource);
                ArrayList<Mask> masks = new ArrayList<Mask>(2);
                masks.add(new Mask(sourceImg, type.maskFrames));
                if (bidirectional) {
                    resource = Core.findResource("gfx/lemming/mask_" + type.name().toLowerCase(Locale.ROOT) + "_left.png", Core.IMAGE_EXTENSIONS);
                    LemmImage sourceImgLeft = Core.loadLemmImage(resource);
                    masks.add(new Mask(sourceImgLeft, type.maskFrames));
                }
                newLemResource.setMasks(masks);
                newLemResource.maskStep = type.maskStep;
            }
            if ((val = p.getIntArray("pos_" + i, null)) != null && val.length == 3) {
                newLemResource.footX = val[0];
                newLemResource.footY = val[1];
                newLemResource.size = val[2];
            }
            if ((val = p.getIntArray("maskPos_" + i, null)) != null && val.length == 2) {
                newLemResource.maskX = val[0];
                newLemResource.maskY = val[1];
            }
            lemmings.add(newLemResource);
            ++i;
        }
    }

    public String getLemmingInfo() {
        String n = this.type.name;
        if (!n.isEmpty()) {
            if (this.canClimb && this.canFloat) {
                n = String.valueOf(n) + " (A)";
            } else if (this.canClimb && this.type != Type.CLIMBER && this.type != Type.FLIPPER) {
                n = String.valueOf(n) + " (C)";
            } else if (this.canFloat && this.type != Type.FLOATER && this.type != Type.FLOATER_START) {
                n = String.valueOf(n) + " (F)";
            }
        }
        return n;
    }

    public Type getSkill() {
        return this.type;
    }

    public boolean setSkill(Type newSkill, boolean playSound, ReplayEvent r) {
        if (r == null || newSkill != Type.FLAPPER) {
            return this.setSkill(newSkill, playSound);
        }
        if (r instanceof ReplayAssignSkillEvent) {
            ReplayAssignSkillEvent rs = (ReplayAssignSkillEvent)r;
            if (rs.isTimedBomber()) {
                if (this.explodeNumCtr == 0) {
                    this.explodeNumCtr = 5;
                    this.explodeCtr = 0;
                    return this.playSetSkillSound(true, playSound);
                }
                return this.playSetSkillSound(false, playSound);
            }
            this.changeType(this.type, this.getExploderType());
            return this.playSetSkillSound(true, playSound);
        }
        return this.setSkill(newSkill, playSound);
    }

    public boolean setSkill(Type newSkill, boolean playSound) {
        if (newSkill == this.type || this.hasDied) {
            return this.playSetSkillSound(false, playSound);
        }
        switch (this.type) {
            case FLAPPER: 
            case DROWNER: 
            case FRIER: 
            case HOMER: {
                if (newSkill != Type.NUKE) {
                    return this.playSetSkillSound(false, playSound);
                }
            }
            case SPLATTER: 
            case EXPLODER: {
                if (newSkill == Type.NUKE) {
                    this.nuke = true;
                }
                return this.playSetSkillSound(false, playSound);
            }
        }
        switch (newSkill) {
            case CLIMBER: {
                if (this.canClimb || this.type == Type.BLOCKER) {
                    return this.playSetSkillSound(false, playSound);
                }
                this.canClimb = true;
                return this.playSetSkillSound(true, playSound);
            }
            case FLOATER: {
                if (this.canFloat || this.type == Type.BLOCKER) {
                    return this.playSetSkillSound(false, playSound);
                }
                this.canFloat = true;
                return this.playSetSkillSound(true, playSound);
            }
            case NUKE: {
                if (this.nuke) {
                    return this.playSetSkillSound(false, playSound);
                }
                this.nuke = true;
                if (this.explodeNumCtr == 0) {
                    this.explodeNumCtr = 5;
                    this.explodeCtr = 0;
                    return this.playSetSkillSound(true, playSound);
                }
                return this.playSetSkillSound(false, playSound);
            }
            case FLAPPER: {
                if (GameController.isOptionEnabled(GameController.SLTooOption.TIMED_BOMBERS)) {
                    if (this.explodeNumCtr == 0) {
                        this.explodeNumCtr = 5;
                        this.explodeCtr = 0;
                        return this.playSetSkillSound(true, playSound);
                    }
                    return this.playSetSkillSound(false, playSound);
                }
                this.changeType(this.type, this.getExploderType());
                return this.playSetSkillSound(true, playSound);
            }
        }
        if (this.canChangeSkill) {
            switch (newSkill) {
                case DIGGER: {
                    if (this.canDig(playSound)) {
                        this.changeType(this.type, newSkill);
                        this.counter = 0;
                        return this.playSetSkillSound(true, playSound);
                    }
                    playSound = false;
                    return this.playSetSkillSound(false, playSound);
                }
                case MINER: {
                    if (this.canMine(true, playSound)) {
                        this.y += 2;
                        this.changeType(this.type, newSkill);
                        this.counter = 0;
                        return this.playSetSkillSound(true, playSound);
                    }
                    playSound = false;
                    return this.playSetSkillSound(false, playSound);
                }
                case BASHER: {
                    if (this.canBashSteel(playSound)) {
                        this.changeType(this.type, newSkill);
                        this.counter = 0;
                        return this.playSetSkillSound(true, playSound);
                    }
                    playSound = false;
                    return this.playSetSkillSound(false, playSound);
                }
                case BUILDER: {
                    if (this.y < GameController.getLevel().getTopBoundary() + 2) {
                        return this.playSetSkillSound(false, playSound);
                    }
                    this.changeType(this.type, newSkill);
                    this.counter = 0;
                    return this.playSetSkillSound(true, playSound);
                }
                case BLOCKER: {
                    LemmingResource lem = Lemming.getResource(Type.BLOCKER);
                    Mask m = lem.getMask(Direction.LEFT);
                    int maskX = this.x - lem.maskX;
                    int maskY = this.y - lem.maskY;
                    int i = 0;
                    while (i < m.getNumFrames()) {
                        if (m.checkType(maskX, maskY, i, 33664)) {
                            return this.playSetSkillSound(false, playSound);
                        }
                        ++i;
                    }
                    this.changeType(this.type, newSkill);
                    this.counter = 0;
                    m.setBlockerMask(maskX, maskY);
                    return this.playSetSkillSound(true, playSound);
                }
            }
        }
        return this.playSetSkillSound(false, playSound);
    }

    private boolean playSetSkillSound(boolean validAssign, boolean playSound) {
        if (validAssign) {
            if (playSound) {
                GameController.sound.play(Sound.Effect.ASSIGN_SKILL, this.getPan());
            }
        } else if (playSound) {
            GameController.sound.play(Sound.Effect.INVALID, this.getPan());
        }
        return validAssign;
    }

    public int width() {
        return this.lemRes.width;
    }

    public int height() {
        return this.lemRes.height;
    }

    private static LemmingResource getResource(Type type) {
        return lemmings.get(Lemming.getOrdinal(type));
    }

    public int screenX() {
        return this.x - this.lemRes.footX;
    }

    public int screenY() {
        return this.y - this.lemRes.footY;
    }

    public int midX() {
        return this.x + 3;
    }

    public int midY() {
        return this.y - this.lemRes.size;
    }

    public int footX() {
        return this.x;
    }

    public int footY() {
        return this.y;
    }

    public int screenMaskX() {
        return this.x - this.lemRes.maskX;
    }

    public int screenMaskY() {
        return this.y - this.lemRes.maskY;
    }

    public Direction getDirection() {
        return this.dir;
    }

    public LemmImage getImage() {
        return this.lemRes.getImage(this.dir, this.frameIdx / 2);
    }

    public LemmImage getCountdown() {
        if (this.explodeNumCtr == 0) {
            return null;
        }
        return explodeFont.getImage(this.explodeNumCtr - 1);
    }

    public void setSelected() {
        this.selectCtr = 20;
    }

    public LemmImage getSelectImg() {
        if (this.selectCtr == 0) {
            return null;
        }
        return MiscGfx.getImage(MiscGfx.Index.SELECT);
    }

    public boolean hasDied() {
        return this.hasDied;
    }

    public boolean hasExited() {
        return this.hasExited;
    }

    public boolean nuke() {
        return this.nuke;
    }

    public boolean canFloat() {
        return this.canFloat;
    }

    public boolean canClimb() {
        return this.canClimb;
    }

    public boolean canChangeSkill() {
        return this.canChangeSkill;
    }

    public boolean hasTimer() {
        return this.explodeNumCtr > 0;
    }

    public double getPan() {
        return Sound.getPan(this.x);
    }

    static enum Animation {
        NONE,
        LOOP,
        ONCE;

    }

    public static enum Direction {
        RIGHT,
        LEFT;

        private static final Map<Integer, Direction> LOOKUP;

        static {
            LOOKUP = new HashMap<Integer, Direction>();
            EnumSet.allOf(Direction.class).stream().forEach(s -> {
                Direction direction = LOOKUP.put(s.ordinal(), (Direction)((Object)s));
            });
        }

        public static Direction get(int val) {
            return LOOKUP.get(val);
        }
    }

    public static enum Type {
        WALKER("WALKER", 8, true, true, 0, 0),
        FALLER("FALLER", 4, true, true, 0, 0),
        CLIMBER("CLIMBER", 8, true, true, 0, 0),
        FLIPPER("FLIPPER", 8, true, false, 0, 0),
        FLOATER("FLOATER", 16, true, false, 0, 0),
        FLAPPER("FLAPPER", 16, false, false, 0, 0),
        SPLATTER("SPLATTER", 16, false, false, 0, 0),
        BLOCKER("BLOCKER", 16, false, true, 3, 0),
        DROWNER("DROWNER", 16, false, false, 0, 0),
        FRIER("FRIER", 14, false, false, 0, 0),
        HOMER("HOMER", 8, false, false, 0, 0),
        BUILDER("BUILDER", 16, true, true, 1, 9),
        SHRUGGER("SHRUGGER", 8, true, false, 0, 0),
        DIGGER("DIGGER", 16, false, true, 1, 8),
        BASHER("BASHER", 32, true, true, 4, 8),
        MINER("MINER", 24, true, true, 2, 12),
        JUMPER("JUMPER", 1, true, true, 0, 0),
        EXPLODER("EXPLODER", 0, false, false, 1, 0),
        NUKE("", 0, false, false, 0, 0),
        FLAPPER_BLOCKER("FLAPPER", 0, false, false, 0, 0),
        FLOATER_START("FLOATER", 0, false, false, 0, 0),
        MAX_EXIT_LEM("FALLER", 0, false, false, 0, 0);

        private final String name;
        private final int frames;
        private final boolean bidirectional;
        private final boolean loop;
        private final int maskFrames;
        private final int maskStep;

        private Type(String name, int frames, boolean bidirectional, boolean loop, int maskFrames, int maskStep) {
            this.name = name;
            this.frames = frames;
            this.bidirectional = bidirectional;
            this.loop = loop;
            this.maskFrames = maskFrames;
            this.maskStep = maskStep;
        }
    }
}

