/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Color;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import lemmini.game.Core;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.tools.Props;
import lemmini.tools.ToolBox;
import org.apache.commons.io.FilenameUtils;

public class LemmFont {
    private static final String FONT_INI_STR = "gfx/font/font.ini";
    private static int width;
    private static int height;
    private static final Map<Integer, LemmChar> chars;
    private static final Map<String, Subset> subsets;
    private static Glyph missingChar;
    private static final List<Glyph> missingCharFont;

    static {
        chars = new HashMap<Integer, LemmChar>(512);
        subsets = new HashMap<String, Subset>(4);
        missingCharFont = new ArrayList<Glyph>(16);
    }

    public static void init() throws ResourceException {
        Props p = new Props();
        Resource resource = Core.findResource(FONT_INI_STR, true);
        if (!p.load(resource)) {
            throw new ResourceException(FONT_INI_STR);
        }
        width = p.getInt("width", 0);
        height = p.getInt("height", 0);
        chars.clear();
        subsets.clear();
        missingCharFont.clear();
        int i = 0;
        while (true) {
            String fileName = p.get("subset_" + i + "_fileName", "");
            int numChars = p.getInt("subset_" + i + "_numChars", 0);
            if (fileName.isEmpty() | numChars <= 0) break;
            resource = Core.findResource("gfx/font/" + fileName, Core.IMAGE_EXTENSIONS);
            String name = FilenameUtils.removeExtension(fileName);
            LemmImage sourceImg = Core.loadLemmImage(resource);
            List<LemmImage> glyphImg = ToolBox.getAnimation(sourceImg, numChars, sourceImg.getWidth());
            ArrayList<Glyph> glyphs = new ArrayList<Glyph>(numChars);
            ListIterator<LemmImage> lit = glyphImg.listIterator();
            while (lit.hasNext()) {
                int c = lit.nextIndex();
                glyphs.add(new Glyph(lit.next()));
                int codePoint = p.getInt("subset_" + i + "_char_" + c + "_codePoint", -1);
                if (!Character.isValidCodePoint(codePoint)) continue;
                chars.put(codePoint, new LemmChar(name, c));
            }
            subsets.put(name, new Subset(glyphs));
            ++i;
        }
        LemmImage img = ToolBox.createLemmImage(width, height);
        GraphicsContext g = null;
        try {
            g = img.createGraphicsContext();
            g.setColor(Color.GREEN);
            g.drawRect(1, 1, width - 3, height - 3);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        missingChar = new Glyph(img);
        img = Core.loadLemmImageJar("missing_char_font.png");
        List<LemmImage> missingGlyphFontImg = ToolBox.getAnimation(img, 16);
        missingGlyphFontImg.stream().forEachOrdered(missingGlyphImg -> missingCharFont.add(new Glyph((LemmImage)missingGlyphImg)));
    }

    public static void strImage(GraphicsContext g, String s, int x, int y, LemmColor color) {
        s = Normalizer.normalize(s, Normalizer.Form.NFC);
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (LemmFont.isLegalChar(c) && !Character.isIdentifierIgnorable(c)) {
                if (Character.isSpaceChar(c) || Character.isISOControl(c)) {
                    x += width;
                } else {
                    LemmFont.drawCharacter(g, c, x, y, color);
                    x += width;
                }
            }
            i += Character.charCount(c);
        }
    }

    public static void strImage(GraphicsContext g, String s, LemmColor color) {
        LemmFont.strImage(g, s, 0, 0, color);
    }

    public static LemmImage strImage(String s, LemmColor color) {
        LemmImage image = ToolBox.createLemmImage(LemmFont.getCharCount(s) * width, height);
        GraphicsContext g = image.createGraphicsContext();
        try {
            g = image.createGraphicsContext();
            LemmFont.strImage(g, s, 0, 0, color);
        }
        finally {
            if (g != null) {
                g.dispose();
            }
        }
        return image;
    }

    public static LemmImage strImage(String s) {
        return LemmFont.strImage(s, LemmColor.GREEN);
    }

    public static void strImage(GraphicsContext g, String s) {
        LemmFont.strImage(g, s, 0, 0, LemmColor.GREEN);
    }

    private static void drawCharacter(GraphicsContext g, int c, int x, int y, LemmColor color) {
        if (chars.containsKey(c)) {
            LemmChar lemmChar = chars.get(c);
            g.drawImage(subsets.get(lemmChar.subset).getGlyph(lemmChar.glyphIndex).getColor(color), x, y);
        } else {
            LemmFont.drawMissingChar(g, c, x, y, color);
        }
    }

    private static void drawMissingChar(GraphicsContext g, int c, int x, int y, LemmColor color) {
        g.drawImage(missingChar.getColor(color), x, y);
        boolean bmpCodePoint = Character.isBmpCodePoint(c);
        int digitsPerRow = bmpCodePoint ? 2 : 3;
        int i = 0;
        while (i < 2) {
            int j = 0;
            while (j < digitsPerRow) {
                LemmImage hexDigit = missingCharFont.get(c >>> (digitsPerRow * 2 - 1 - (i * digitsPerRow + j)) * 4 & 0xF).getColor(color);
                g.drawImage(hexDigit, x + (width / 2 + (j - 1) * hexDigit.getWidth()) - (bmpCodePoint ? 0 : hexDigit.getWidth() / 2), y + (height / 2 + (i - 1) * hexDigit.getHeight()));
                ++j;
            }
            ++i;
        }
    }

    public static int getWidth() {
        return width;
    }

    public static int getHeight() {
        return height;
    }

    public static int getCharCount(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFC);
        int charCount = 0;
        int i = 0;
        while (i < s.length()) {
            int c = s.codePointAt(i);
            if (LemmFont.isLegalChar(c) && !Character.isIdentifierIgnorable(c)) {
                ++charCount;
            }
            i += Character.charCount(c);
        }
        return charCount;
    }

    /*
     * Exception decompiling
     */
    public static List<String> split(String s, int maxLineLength) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CASE], 0[SWITCH]], but top level block is 16[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isLegalChar(int c) {
        return Character.isValidCodePoint(c) && Character.getType(c) != 19 && (c & 0xFFFF) < 65534 && (c < 64976 || c > 65007);
    }

    private static class Glyph {
        private final List<LemmImage> glyphColors;

        Glyph(LemmImage glyph) {
            int width = glyph.getWidth();
            int height = glyph.getHeight();
            LemmImage[] glyphColorsArray = new LemmImage[]{glyph, ToolBox.createLemmImage(width, height), ToolBox.createLemmImage(width, height), ToolBox.createLemmImage(width, height), ToolBox.createLemmImage(width, height), ToolBox.createLemmImage(width, height), ToolBox.createLemmImage(width, height), ToolBox.createLemmImage(width, height)};
            int xp = 0;
            while (xp < width) {
                int yp = 0;
                while (yp < height) {
                    int col = glyph.getRGB(xp, yp);
                    Color color = new Color(col, true);
                    int a = color.getAlpha();
                    int r = color.getRed();
                    int g = color.getGreen();
                    int b = color.getBlue();
                    glyphColorsArray[1].setRGB(xp, yp, new Color(r, b, g, a).getRGB());
                    glyphColorsArray[2].setRGB(xp, yp, new Color(g, r, b, a).getRGB());
                    int hotterRed = Math.min(255, (int)((double)g * 1.2));
                    glyphColorsArray[3].setRGB(xp, yp, new Color(hotterRed, r, b, a).getRGB());
                    glyphColorsArray[4].setRGB(xp, yp, new Color(g, g, b, a).getRGB());
                    int warmerRed = Math.min(255, (int)((double)g * 1.2));
                    int adjustedGreen = Math.max(0, (int)((double)g * 0.8));
                    glyphColorsArray[5].setRGB(xp, yp, new Color(warmerRed, adjustedGreen, b, a).getRGB());
                    glyphColorsArray[6].setRGB(xp, yp, new Color(r, g, g, a).getRGB());
                    int violetGreen = (r + b) / 2;
                    glyphColorsArray[7].setRGB(xp, yp, new Color(g, violetGreen, g, a).getRGB());
                    ++yp;
                }
                ++xp;
            }
            this.glyphColors = Arrays.asList(glyphColorsArray);
        }

        LemmImage getColor(LemmColor color) {
            return this.glyphColors.get(color.ordinal());
        }
    }

    private static class LemmChar {
        String subset;
        int glyphIndex;

        LemmChar(String subset, int glyphIndex) {
            this.subset = subset;
            this.glyphIndex = glyphIndex;
        }
    }

    public static enum LemmColor {
        GREEN,
        BLUE,
        RED,
        HOT_RED,
        YELLOW,
        ORANGE,
        TURQUOISE,
        VIOLET;

    }

    private static class Subset {
        List<Glyph> glyphs;

        Subset(List<Glyph> glyphs) {
            this.glyphs = glyphs;
        }

        Glyph getGlyph(int g) {
            return this.glyphs.get(g);
        }
    }
}

