/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import lemmini.game.Core;
import lemmini.game.Lemming;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;

public class LemmCursor {
    private static final int HIT_DISTANCE = 12;
    private static int x;
    private static int y;
    private static CursorType type;
    private static List<LemmImage> cursorImg;
    private static List<LemmImage> boxImg;
    private static final List<Cursor> cursor;
    private static final List<Cursor> boxCursor;
    private static boolean box;

    static {
        cursor = new ArrayList<Cursor>(CursorType.values().length);
        boxCursor = new ArrayList<Cursor>(CursorType.values().length);
    }

    public static void init() throws ResourceException {
        cursor.clear();
        boxCursor.clear();
        CursorType[] cursorTypes = CursorType.values();
        Resource resource = Core.findResource("gfx/misc/cursor.png", Core.IMAGE_EXTENSIONS);
        cursorImg = ToolBox.getAnimation(Core.loadLemmImage(resource), cursorTypes.length);
        resource = Core.findResource("gfx/misc/box.png", Core.IMAGE_EXTENSIONS);
        boxImg = ToolBox.getAnimation(Core.loadLemmImage(resource), cursorTypes.length);
        LemmImage firstCursorImg = cursorImg.get(0);
        int cx = firstCursorImg.getWidth() / 2;
        int cy = firstCursorImg.getHeight() / 2;
        Iterator<LemmImage> cursorIt = cursorImg.iterator();
        Iterator<LemmImage> boxIt = boxImg.iterator();
        while (cursorIt.hasNext() && boxIt.hasNext()) {
            cursor.add(ToolBox.createCursor(cursorIt.next(), cx, cy));
            boxCursor.add(ToolBox.createCursor(boxIt.next(), cx, cy));
        }
        type = CursorType.NORMAL;
        box = false;
        LemmCursor.setX(0);
        LemmCursor.setY(0);
    }

    public static LemmImage getImage(CursorType t) {
        return cursorImg.get(t.ordinal());
    }

    public static LemmImage getImage() {
        return LemmCursor.getImage(type);
    }

    public static LemmImage getBoxImage(CursorType t) {
        return boxImg.get(t.ordinal());
    }

    public static LemmImage getBoxImage() {
        return LemmCursor.getBoxImage(type);
    }

    public static Cursor getCursor() {
        if (box) {
            return boxCursor.get(type.ordinal());
        }
        return cursor.get(type.ordinal());
    }

    public static CursorType getType() {
        return type;
    }

    public static void setType(CursorType t) {
        type = t;
    }

    public static boolean isBox() {
        return box;
    }

    public static void setBox(boolean b) {
        box = b;
    }

    public static boolean doesCollide(Lemming l, int xOfs, int yOfs) {
        int lx = l.footX() - xOfs;
        int ly = l.midY() - yOfs;
        int cx = LemmCursor.getX();
        int cy = LemmCursor.getY();
        int dx = Math.abs(lx - cx);
        int dy = Math.abs(ly - cy);
        return dx <= 12 && dy <= 12;
    }

    public static void setX(int x) {
        LemmCursor.x = x;
    }

    public static int getX() {
        return x;
    }

    public static void setY(int y) {
        LemmCursor.y = y;
    }

    public static int getY() {
        return y;
    }

    public static enum CursorType {
        NORMAL(false, false, false),
        LEFT(true, false, false),
        RIGHT(false, true, false),
        WALKER(false, false, true),
        WALKER_LEFT(true, false, true),
        WALKER_RIGHT(false, true, true);

        private final boolean leftOnly;
        private final boolean rightOnly;
        private final boolean walkerOnly;

        private CursorType(boolean leftOnly, boolean rightOnly, boolean walkerOnly) {
            this.leftOnly = leftOnly;
            this.rightOnly = rightOnly;
            this.walkerOnly = walkerOnly;
        }

        public boolean isLeftOnly() {
            return this.leftOnly;
        }

        public boolean isRightOnly() {
            return this.rightOnly;
        }

        public boolean isWalkerOnly() {
            return this.walkerOnly;
        }
    }
}

