/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.gameutil.Sprite;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.tools.ToolBox;

public class Icons {
    private static final int DEFAULT_PITCH = 4;
    private static final int[] ANIMATION_CTR = new int[]{3, 3, 4, 3, 3};
    private static int animateCtr = 0;
    private static int currentAnimateFrame = 0;
    private static final int ORIGINAL_WIDTH = 32;
    private static final int ORIGINAL_HEIGHT = 40;
    private static final int ENHANCED_WIDTH = 34;
    private static final int ENHANCED_HEIGHT = 54;
    private static LemmImage iconImg;
    private static GraphicsContext iconGfx;
    private static IconType selectedSkill;
    private static final List<Sprite> icons;
    private static final List<Sprite> bgIcons;
    private static final List<Sprite> bgIconsLarge;
    private static final List<Sprite> iconLabels;
    private static final HashMap<IconType, Integer> iconFrame;
    private static final HashMap<IconType, Boolean> iconPressed;

    static {
        iconGfx = null;
        selectedSkill = null;
        icons = new ArrayList<Sprite>(IconType.values().length);
        bgIcons = new ArrayList<Sprite>(IconType.values().length);
        bgIconsLarge = new ArrayList<Sprite>(IconType.values().length);
        iconLabels = new ArrayList<Sprite>(IconType.values().length);
        iconFrame = new HashMap(IconType.values().length);
        iconPressed = new HashMap(IconType.values().length);
    }

    public static int getIconWidth() {
        if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
            return 34;
        }
        return 32;
    }

    public static int getIconHeight() {
        if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
            return 54;
        }
        return 40;
    }

    public static List<IconType> CurrentIconOrder() {
        ArrayList<IconType> rslt = new ArrayList<IconType>();
        rslt.add(IconType.MINUS);
        rslt.add(IconType.PLUS);
        rslt.addAll(Icons.SkillIconOrder());
        rslt.add(IconType.PAUSE);
        rslt.add(IconType.NUKE);
        rslt.add(IconType.FFWD);
        rslt.add(IconType.RESTART);
        rslt.add(IconType.VLOCK);
        return rslt;
    }

    public static List<IconType> SkillIconOrder() {
        ArrayList<IconType> rslt = new ArrayList<IconType>();
        rslt.add(IconType.CLIMB);
        rslt.add(IconType.FLOAT);
        rslt.add(IconType.BOMB);
        rslt.add(IconType.BLOCK);
        rslt.add(IconType.BUILD);
        rslt.add(IconType.BASH);
        rslt.add(IconType.MINE);
        rslt.add(IconType.DIG);
        return rslt;
    }

    public static void init() throws ResourceException {
        IconType x;
        int n;
        int n2;
        IconType[] iconTypeArray;
        if (iconFrame.isEmpty()) {
            iconTypeArray = IconType.values();
            n2 = iconTypeArray.length;
            n = 0;
            while (n < n2) {
                x = iconTypeArray[n];
                iconFrame.put(x, 0);
                ++n;
            }
        }
        if (iconPressed.isEmpty()) {
            iconTypeArray = IconType.values();
            n2 = iconTypeArray.length;
            n = 0;
            while (n < n2) {
                x = iconTypeArray[n];
                iconPressed.put(x, false);
                ++n;
            }
        }
        Icons.LoadIconResources();
        Icons.reset();
    }

    private static boolean ModHasEnhancedIconBar() throws ResourceException {
        ArrayList<String> iconbarImages = new ArrayList<String>();
        iconbarImages.add("icon_empty_large");
        iconbarImages.add("iconbar_filler");
        iconbarImages.add("ticon_bash");
        iconbarImages.add("ticon_block");
        iconbarImages.add("ticon_bomb");
        iconbarImages.add("ticon_build");
        iconbarImages.add("ticon_climb");
        iconbarImages.add("ticon_dig");
        iconbarImages.add("ticon_float");
        iconbarImages.add("ticon_mine");
        iconbarImages.add("ticon_minus");
        iconbarImages.add("ticon_plus");
        iconbarImages.add("ticon_pause");
        iconbarImages.add("ticon_ffwd");
        iconbarImages.add("ticon_nuke");
        iconbarImages.add("ticon_restart");
        iconbarImages.add("ticon_vlock");
        iconbarImages.add("anim_bash");
        iconbarImages.add("anim_block");
        iconbarImages.add("anim_bomb");
        iconbarImages.add("anim_build");
        iconbarImages.add("anim_climb");
        iconbarImages.add("anim_dig");
        iconbarImages.add("anim_float");
        iconbarImages.add("anim_mine");
        iconbarImages.add("anim_minus");
        iconbarImages.add("anim_plus");
        iconbarImages.add("anim_pause");
        iconbarImages.add("anim_ffwd");
        iconbarImages.add("anim_nuke");
        iconbarImages.add("anim_restart");
        iconbarImages.add("anim_vlock");
        iconbarImages.add("large_minimap_center");
        iconbarImages.add("large_minimap_left");
        iconbarImages.add("large_minimap_right");
        Resource resource = null;
        for (String img : iconbarImages) {
            String resString = "gfx/iconbar/" + img + ".png";
            resource = Core.findResourceEx(resString, true, false, Core.IMAGE_EXTENSIONS);
            if (resource == null) continue;
            return true;
        }
        return false;
    }

    public static void LoadIconResources() throws ResourceException {
        bgIcons.clear();
        bgIconsLarge.clear();
        icons.clear();
        iconLabels.clear();
        if (iconGfx != null) {
            iconGfx.dispose();
        }
        List<IconType> iconOrder = Icons.CurrentIconOrder();
        iconImg = ToolBox.createLemmImage(Icons.getIconWidth() * iconOrder.size(), Icons.getIconHeight());
        iconGfx = iconImg.createGraphicsContext();
        boolean bModUsesEnhancedIconBar = Icons.ModHasEnhancedIconBar();
        int i = 0;
        while (i < iconOrder.size()) {
            Resource resource = null;
            String iconName = iconOrder.get(i).toString().toLowerCase(Locale.ROOT);
            if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
                resource = Core.findResourceEx("gfx/iconbar/anim_" + iconName + ".png", true, false, Core.IMAGE_EXTENSIONS);
            }
            if (resource == null && bModUsesEnhancedIconBar) {
                resource = Core.findResourceEx("gfx/iconbar/ticon_" + iconName + ".png", true, false, Core.IMAGE_EXTENSIONS);
            }
            if (resource == null && !bModUsesEnhancedIconBar) {
                resource = Core.findResourceEx("gfx/icons/icon_" + iconName + ".png", true, false, Core.IMAGE_EXTENSIONS);
            }
            if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR) && resource == null) {
                resource = Core.findResourceEx("gfx/iconbar/anim_" + iconName + ".png", false, true, Core.IMAGE_EXTENSIONS);
            }
            if (resource == null) {
                resource = Core.findResourceEx("gfx/iconbar/ticon_" + iconName + ".png", false, true, Core.IMAGE_EXTENSIONS);
            }
            if (resource == null) {
                resource = Core.findResource("gfx/iconbar/ticon_" + iconName + ".png", Core.IMAGE_EXTENSIONS);
            }
            LemmImage sourceImg = Core.loadLemmImage(resource);
            int frames = sourceImg.getHeight() / 40;
            Sprite icon = new Sprite(sourceImg, frames, 1, false);
            icons.add(icon);
            resource = Core.findResource("gfx/icons/icon_empty.png", Core.IMAGE_EXTENSIONS);
            sourceImg = Core.loadLemmImage(resource);
            icon = new Sprite(sourceImg, 2, 1, false);
            bgIcons.add(icon);
            resource = Core.findResource("gfx/iconbar/icon_empty_large.png", Core.IMAGE_EXTENSIONS);
            sourceImg = Core.loadLemmImage(resource);
            icon = new Sprite(sourceImg, 2, 1, false);
            bgIconsLarge.add(icon);
            resource = Core.findResource("gfx/icon_labels/label_" + iconName + ".png", Core.IMAGE_EXTENSIONS);
            sourceImg = Core.loadLemmImage(resource);
            icon = new Sprite(sourceImg, 2, 1, false);
            iconLabels.add(icon);
            ++i;
        }
    }

    public static IconType getType(int x) {
        List<IconType> iconOrder = Icons.CurrentIconOrder();
        if (x < 0 || x >= iconOrder.size() * Icons.getIconWidth()) {
            return null;
        }
        return iconOrder.get(x / Icons.getIconWidth());
    }

    public static LemmImage getImg() {
        return iconImg;
    }

    static boolean isPressed(IconType type) {
        List<IconType> iconOrder = Icons.CurrentIconOrder();
        int idx = iconOrder.indexOf((Object)type);
        if (idx == -1) {
            return false;
        }
        return icons.get(idx).getFrameIdx() != 0;
    }

    static void press(IconType type) {
        List<IconType> iconOrder = Icons.CurrentIconOrder();
        int idx = iconOrder.indexOf((Object)type);
        if (idx == -1) {
            return;
        }
        switch (type) {
            case PAUSE: 
            case FFWD: 
            case VLOCK: {
                if (idx >= iconOrder.size()) break;
                boolean toggleFrame = iconPressed.get((Object)type) == false;
                Icons.setIconFrame(idx, toggleFrame);
                Icons.drawIcon(idx);
                break;
            }
            case CLIMB: 
            case FLOAT: 
            case BOMB: 
            case BLOCK: 
            case BUILD: 
            case BASH: 
            case MINE: 
            case DIG: {
                for (IconType x : Icons.SkillIconOrder()) {
                    int i = iconOrder.indexOf((Object)x);
                    if (i == -1 || i == idx) continue;
                    Icons.setIconFrame(i, false);
                    Icons.drawIcon(i);
                }
                selectedSkill = type;
            }
            case MINUS: 
            case PLUS: 
            case NUKE: 
            case RESTART: {
                Icons.setIconFrame(idx, true);
                Icons.drawIcon(idx);
                break;
            }
        }
    }

    public static void Animate() {
        if (++animateCtr >= ANIMATION_CTR[currentAnimateFrame % ANIMATION_CTR.length]) {
            animateCtr -= ANIMATION_CTR[currentAnimateFrame % ANIMATION_CTR.length];
            currentAnimateFrame = currentAnimateFrame++ % ANIMATION_CTR.length;
            List<IconType> iconOrder = Icons.CurrentIconOrder();
            for (IconType x : iconPressed.keySet()) {
                int frameCount;
                int idx;
                if (!iconPressed.get((Object)x).booleanValue() || (idx = iconOrder.indexOf((Object)x)) == -1 || idx >= icons.size() - 1 || (frameCount = icons.get(idx).getNumFrames()) <= 2) continue;
                int oldFrame = iconFrame.get((Object)x);
                int newFrame = (oldFrame + 1) % frameCount;
                iconFrame.replace(x, newFrame);
                Icons.drawIcon(idx);
            }
        }
    }

    static void release(IconType type) {
        List<IconType> iconOrder = Icons.CurrentIconOrder();
        int idx = iconOrder.indexOf((Object)type);
        if (idx == -1) {
            return;
        }
        switch (type) {
            case MINUS: 
            case PLUS: 
            case RESTART: {
                Icons.setIconFrame(idx, false);
                Icons.drawIcon(idx);
                break;
            }
            case NUKE: {
                if (GameController.isNuked()) break;
                Icons.setIconFrame(idx, false);
                Icons.drawIcon(idx);
                break;
            }
        }
    }

    private static void setIconFrame(int iconIdx, boolean pressed) {
        if (iconIdx < Icons.CurrentIconOrder().size()) {
            int frameIdx = pressed ? 1 : 0;
            IconType type = Icons.CurrentIconOrder().get(iconIdx);
            iconFrame.replace(type, frameIdx);
            iconPressed.replace(type, pressed);
        }
    }

    private static void drawIcon(int idx) {
        if (idx <= Icons.CurrentIconOrder().size()) {
            Sprite bgIcon;
            IconType type = Icons.CurrentIconOrder().get(idx);
            int x = 0;
            int y = 0;
            if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
                bgIcon = bgIconsLarge.get(idx);
                x = 1;
                y = 14;
            } else {
                bgIcon = bgIcons.get(idx);
            }
            Sprite iconLabel = iconLabels.get(idx);
            Sprite icon = icons.get(idx);
            int frameIdx = Math.min(iconFrame.get((Object)type), icon.getNumFrames() - 1);
            int staticFrameIdx = iconPressed.get((Object)type) != false ? 1 : 0;
            bgIcon.setFrameIdx(staticFrameIdx);
            iconLabel.setFrameIdx(staticFrameIdx);
            icon.setFrameIdx(frameIdx);
            iconGfx.drawImage(bgIcon.getImage(), Icons.getIconWidth() * idx, 0);
            int yIcon = 0;
            int yLabel = 30;
            if (GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR)) {
                yLabel = 44;
                yIcon = GameController.isOptionEnabled(GameController.SLTooOption.ICON_LABELS) ? -7 : -4;
                switch (type) {
                    case BLOCK: {
                        --yIcon;
                        break;
                    }
                    case BASH: 
                    case MINE: 
                    case DIG: {
                        yIcon -= 2;
                        break;
                    }
                    case BUILD: 
                    case PAUSE: 
                    case FFWD: 
                    case NUKE: 
                    case RESTART: 
                    case VLOCK: {
                        yIcon -= 3;
                    }
                }
            }
            iconGfx.drawImage(icon.getImage(), Icons.getIconWidth() * idx + x, 0 + y + yIcon);
            if (GameController.isOptionEnabled(GameController.SLTooOption.ICON_LABELS)) {
                iconGfx.drawImage(iconLabel.getImage(), Icons.getIconWidth() * idx + x, yLabel);
            }
        }
    }

    static IconType getSelectedSkill() {
        return selectedSkill;
    }

    static IconType getNextRadioIcon(IconType type) {
        List<IconType> skillOrder = Icons.SkillIconOrder();
        int skillIdx = skillOrder.indexOf((Object)type);
        if (skillIdx == -1) {
            return null;
        }
        int nextSkillIdx = skillIdx == skillOrder.size() - 1 ? 0 : skillIdx + 1;
        return skillOrder.get(nextSkillIdx);
    }

    static IconType getPreviousRadioIcon(IconType type) {
        List<IconType> skillOrder = Icons.SkillIconOrder();
        int skillIdx = skillOrder.indexOf((Object)type);
        if (skillIdx == -1) {
            return null;
        }
        int nextSkillIdx = skillIdx == 0 ? skillOrder.size() - 1 : skillIdx - 1;
        return skillOrder.get(nextSkillIdx);
    }

    static void reset() {
        int i = 0;
        while (i < Icons.CurrentIconOrder().size()) {
            Icons.setIconFrame(i, false);
            Icons.drawIcon(i);
            ++i;
        }
        selectedSkill = null;
    }

    static void redraw() {
        if (iconGfx != null) {
            iconGfx.dispose();
        }
        List<IconType> iconOrder = Icons.CurrentIconOrder();
        iconImg = ToolBox.createLemmImage(Icons.getIconWidth() * iconOrder.size(), Icons.getIconHeight());
        iconGfx = iconImg.createGraphicsContext();
        int i = 0;
        while (i < iconOrder.size()) {
            Icons.drawIcon(i);
            ++i;
        }
        selectedSkill = null;
    }

    static int GetPitch(IconType type) {
        List<IconType> iconOrder = Icons.CurrentIconOrder();
        int idx = iconOrder.indexOf((Object)type);
        if (idx == -1) {
            return 4;
        }
        switch (type) {
            case MINUS: 
            case PLUS: 
            case EMPTY: {
                return 4;
            }
        }
        int pitch = 0;
        int i = 0;
        while (i < Icons.CurrentIconOrder().size()) {
            IconType tmpType = iconOrder.get(i);
            if (tmpType == type) {
                return pitch;
            }
            if (tmpType != IconType.MINUS && tmpType != IconType.PLUS && tmpType != IconType.EMPTY) {
                ++pitch;
            }
            ++i;
        }
        return 4;
    }

    public static enum IconType {
        MINUS,
        PLUS,
        CLIMB,
        FLOAT,
        BOMB,
        BLOCK,
        BUILD,
        BASH,
        MINE,
        DIG,
        PAUSE,
        FFWD,
        NUKE,
        RESTART,
        VLOCK,
        EMPTY;

    }
}

