/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import lemmini.game.Core;
import lemmini.game.LemmException;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.game.SpriteObject;
import lemmini.gameutil.Sprite;
import lemmini.graphics.LemmImage;
import lemmini.tools.Props;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.ArrayUtils;

public class GraphicSet {
    public static final int[] DEFAULT_PARTICLE_COLORS = new int[]{-16711936, -16776961, -1, -1, -65536};
    private static final List<String> DEFAULT_STYLES = Arrays.asList("dirt", "fire", "marble", "pillar", "crystal", "brick", "rock", "snow", "bubble", "xmas");
    private static final int DEFAULT_ANIMATION_SPEED = 2;
    private static final int[] SPECIAL_STYLE_OBJECT_ORDER;
    private static final String[] SPECIAL_STYLE_NAMES;
    private final String name;
    private final Props props;
    private final Color bgColor;
    private final int debrisColor;
    private final int debrisColor2;
    private final int[] particleColor;
    private final List<LvlObject> objects;
    private final List<Terrain> terrain;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 7;
        SPECIAL_STYLE_OBJECT_ORDER = nArray;
        SPECIAL_STYLE_NAMES = new String[]{"awesome", "beasti", "beastii", "menace"};
    }

    public GraphicSet(String name) throws LemmException, ResourceException {
        this.name = name;
        this.props = new Props();
        if (name.toLowerCase(Locale.ROOT).equals("special")) {
            Resource resource = Core.findResource("styles/dirt/dirt.ini", true);
            if (!this.props.load(resource)) {
                throw new LemmException("Unable to read dirt.ini.");
            }
            int bgCol = this.props.getInt("bgColor", this.props.getInt("bgColor", 0)) | 0xFF000000;
            this.bgColor = new Color(bgCol);
            this.debrisColor = this.props.getInt("debrisColor", 0xFFFFFF) | 0xFF000000;
            this.debrisColor2 = this.props.getInt("debrisColor2", this.debrisColor) | 0xFF000000;
            this.particleColor = this.props.getIntArray("particleColor", this.props.getIntArray("particleColor", DEFAULT_PARTICLE_COLORS));
            int i = 0;
            while (i < this.particleColor.length) {
                int n = i++;
                this.particleColor[n] = this.particleColor[n] | 0xFF000000;
            }
            this.objects = new ArrayList<LvlObject>(SPECIAL_STYLE_OBJECT_ORDER.length);
            Object[] objectArray = SPECIAL_STYLE_OBJECT_ORDER;
            int n = SPECIAL_STYLE_OBJECT_ORDER.length;
            int n2 = 0;
            while (n2 < n) {
                int idx = objectArray[n2];
                LvlObject obj = new LvlObject(this.props, "styles/dirt/dirt", idx);
                if (obj.numFrames < 0) break;
                this.objects.add(obj);
                ++n2;
            }
            this.terrain = new ArrayList<Terrain>(SPECIAL_STYLE_NAMES.length);
            objectArray = SPECIAL_STYLE_NAMES;
            n = SPECIAL_STYLE_NAMES.length;
            n2 = 0;
            while (n2 < n) {
                int name2 = objectArray[n2];
                this.terrain.add(new Terrain("styles/special/" + (String)name2 + "/" + (String)name2, -1, false));
                ++n2;
            }
        } else {
            LvlObject obj;
            String pathPrefix = "styles/" + name + "/" + name;
            Resource resource = Core.findResource(String.valueOf(pathPrefix) + ".ini", true);
            if (!this.props.load(resource)) {
                throw new LemmException("Unable to read " + name + ".ini.");
            }
            int bgCol = this.props.getInt("bgColor", this.props.getInt("bgColor", 0)) | 0xFF000000;
            this.bgColor = new Color(bgCol);
            this.debrisColor = this.props.getInt("debrisColor", 0xFFFFFF) | 0xFF000000;
            this.debrisColor2 = this.props.getInt("debrisColor2", this.debrisColor) | 0xFF000000;
            this.particleColor = this.props.getIntArray("particleColor", this.props.getIntArray("particleColor", DEFAULT_PARTICLE_COLORS));
            int i = 0;
            while (i < this.particleColor.length) {
                int n = i++;
                this.particleColor[n] = this.particleColor[n] | 0xFF000000;
            }
            this.objects = new ArrayList<LvlObject>(64);
            int idx = 0;
            while ((obj = new LvlObject(this.props, pathPrefix, idx)).numFrames >= 0) {
                this.objects.add(obj);
                ++idx;
            }
            int tiles = this.props.getInt("tiles", 0);
            int[] steelTiles = this.props.getIntArray("steelTiles", ArrayUtils.EMPTY_INT_ARRAY);
            this.terrain = new ArrayList<Terrain>(tiles);
            int idx2 = 0;
            while (idx2 < tiles) {
                this.terrain.add(new Terrain(pathPrefix, idx2, ArrayUtils.contains((int[])steelTiles, (int)idx2)));
                ++idx2;
            }
        }
    }

    public void unloadImages() {
        this.objects.stream().forEach(obj -> {
            ((LvlObject)obj).images.clear();
            ((LvlObject)obj).mask = null;
        });
        this.terrain.stream().forEach(ter -> {
            ((Terrain)ter).image = null;
            ((Terrain)ter).mask = null;
        });
    }

    public String getName() {
        return this.name;
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public int getDebrisColor() {
        return this.debrisColor;
    }

    public int getDebrisColor2() {
        return this.debrisColor2;
    }

    public int[] getParticleColor() {
        return this.particleColor;
    }

    public LvlObject getObject(int idx) {
        return this.objects.get(idx);
    }

    public Terrain getTerrain(int idx) {
        return this.terrain.get(idx);
    }

    public class LvlObject {
        private final int index;
        private final String pathPrefix;
        private final int numFrames;
        private final int speed;
        private final Sprite.Animation animMode;
        private final SpriteObject.Type type;
        private final int maskOffsetX;
        private final int maskOffsetY;
        private final int[] sound;
        private final Map<Orientation, List<LemmImage>> images = new EnumMap<Orientation, List<LemmImage>>(Orientation.class);
        private boolean[][] mask = null;

        private LvlObject(Props props, String pathPrefix, int idx) {
            this.index = idx;
            this.pathPrefix = pathPrefix;
            this.numFrames = props.getInt("frames_" + this.index, -1);
            this.speed = props.getInt("speed_" + this.index, 2);
            this.type = SpriteObject.getType(props.getInt("type_" + this.index, 0));
            Sprite.Animation animModeTemp = Sprite.getAnimationMode(props.getInt("anim_" + this.index, 0));
            this.animMode = this.type == SpriteObject.Type.ENTRANCE && animModeTemp == Sprite.Animation.ONCE ? Sprite.Animation.ONCE_ENTRANCE : animModeTemp;
            this.maskOffsetX = props.getInt("maskOffsetX_" + this.index, 0);
            this.maskOffsetY = props.getInt("maskOffsetY_" + this.index, 0);
            int[] soundTemp = props.getIntArray("sound_" + this.index, ArrayUtils.EMPTY_INT_ARRAY);
            if (soundTemp.length >= 2 && this.numFrames > 0) {
                this.sound = new int[this.numFrames];
                Arrays.fill(this.sound, -1);
                int i = 0;
                while (i < soundTemp.length - 1) {
                    if (soundTemp[i + 1] >= 0) {
                        this.sound[soundTemp[i + 1]] = soundTemp[i];
                    }
                    i += 2;
                }
            } else if (ArrayUtils.isNotEmpty((int[])soundTemp)) {
                this.sound = new int[1];
                this.sound[0] = soundTemp[0];
            } else {
                this.sound = ArrayUtils.EMPTY_INT_ARRAY;
            }
        }

        public int getNumFrames() {
            return this.numFrames;
        }

        public int getSpeed() {
            return this.speed;
        }

        public Sprite.Animation getAnimationMode() {
            return this.animMode;
        }

        public SpriteObject.Type getType() {
            return this.type;
        }

        public int getMaskOffsetX() {
            return this.maskOffsetX;
        }

        public int getMaskOffsetY() {
            return this.maskOffsetY;
        }

        public int[] getSound() {
            return this.sound;
        }

        public List<LemmImage> getImages(Orientation orientation) throws ResourceException {
            if (!this.images.containsKey((Object)Orientation.NORMAL)) {
                Resource resource = Core.findResource(String.valueOf(this.pathPrefix) + "o_" + this.index + ".png", Core.IMAGE_EXTENSIONS);
                LemmImage sourceImage = Core.loadLemmImage(resource);
                this.images.put(Orientation.NORMAL, ToolBox.getAnimation(sourceImage, this.numFrames));
            }
            if (!this.images.containsKey((Object)orientation)) {
                ArrayList newImages = new ArrayList(this.images.get((Object)Orientation.NORMAL));
                ListIterator<LemmImage> lit = newImages.listIterator();
                while (lit.hasNext()) {
                    LemmImage image = ((LemmImage)lit.next()).transform(orientation.rotate(), orientation.flipHoriz(), orientation.flipVert());
                    lit.set(image);
                }
                this.images.put(orientation, newImages);
            }
            return this.images.get((Object)orientation);
        }

        public boolean[][] getMask() throws ResourceException {
            if (this.mask == null) {
                switch (this.type) {
                    case TURN_LEFT: 
                    case TURN_RIGHT: 
                    case ONE_WAY_LEFT: 
                    case ONE_WAY_RIGHT: 
                    case TRAP_DROWN: 
                    case TRAP_REPLACE: 
                    case TRAP_DIE: 
                    case EXIT: 
                    case STEEL: {
                        Resource resource = Core.findResource(String.valueOf(this.pathPrefix) + "om_" + this.index + ".png", Core.IMAGE_EXTENSIONS);
                        LemmImage sourceImage = Core.loadLemmImage(resource);
                        this.mask = new boolean[sourceImage.getHeight()][sourceImage.getWidth()];
                        int y = 0;
                        while (y < this.mask.length) {
                            int x = 0;
                            while (x < this.mask[y].length) {
                                this.mask[y][x] = sourceImage.getRGB(x, y) >>> 24 >= 128;
                                ++x;
                            }
                            ++y;
                        }
                        break;
                    }
                    default: {
                        this.mask = new boolean[0][0];
                    }
                }
            }
            return this.mask;
        }
    }

    public static enum Orientation {
        NORMAL(false, false, false),
        ROTATED_90(true, false, false),
        FLIPPED_HORIZ(false, true, false),
        ROTATED_90_FLIPPED_HORIZ(true, true, false),
        FLIPPED_VERT(false, false, true),
        ROTATED_90_FLIPPED_VERT(true, false, true),
        ROTATED_180(false, true, true),
        ROTATED_270(true, true, true);

        private final boolean rotate;
        private final boolean flipHoriz;
        private final boolean flipVert;

        private Orientation(boolean rotate, boolean flipHoriz, boolean flipVert) {
            this.rotate = rotate;
            this.flipHoriz = flipHoriz;
            this.flipVert = flipVert;
        }

        public boolean rotate() {
            return this.rotate;
        }

        public boolean flipHoriz() {
            return this.flipHoriz;
        }

        public boolean flipVert() {
            return this.flipVert;
        }

        public static Orientation getOrientation(boolean flipHoriz, boolean flipVert, boolean rotate) {
            if (rotate) {
                if (flipHoriz) {
                    if (flipVert) {
                        return ROTATED_270;
                    }
                    return ROTATED_90_FLIPPED_HORIZ;
                }
                if (flipVert) {
                    return ROTATED_90_FLIPPED_VERT;
                }
                return ROTATED_90;
            }
            if (flipHoriz) {
                if (flipVert) {
                    return ROTATED_180;
                }
                return FLIPPED_HORIZ;
            }
            if (flipVert) {
                return FLIPPED_VERT;
            }
            return NORMAL;
        }
    }

    public class Terrain {
        private final int index;
        private final String pathPrefix;
        private final boolean steel;
        private LemmImage image = null;
        private boolean[][] mask = null;
        private boolean[][] steelMask = null;

        private Terrain(String pathPrefix, int idx, boolean stl) {
            this.index = idx;
            this.steel = stl;
            this.pathPrefix = pathPrefix;
        }

        public boolean isSteel() {
            return this.steel;
        }

        public LemmImage getImage() throws ResourceException {
            if (this.image == null) {
                Resource resource = this.index >= 0 ? Core.findResource(String.valueOf(this.pathPrefix) + "_" + this.index + ".png", Core.IMAGE_EXTENSIONS) : Core.findResource(String.valueOf(this.pathPrefix) + ".png", Core.IMAGE_EXTENSIONS);
                this.image = Core.loadLemmImage(resource);
            }
            return this.image;
        }

        public boolean[][] getMask() throws ResourceException {
            if (this.mask == null) {
                LemmImage sourceImage;
                try {
                    Resource resource = this.index >= 0 ? Core.findResource(String.valueOf(this.pathPrefix) + "m_" + this.index + ".png", Core.IMAGE_EXTENSIONS) : Core.findResource(String.valueOf(this.pathPrefix) + "m.png", Core.IMAGE_EXTENSIONS);
                    sourceImage = Core.loadLemmImage(resource);
                }
                catch (ResourceException ex) {
                    sourceImage = this.getImage();
                }
                this.mask = new boolean[sourceImage.getHeight()][sourceImage.getWidth()];
                int y = 0;
                while (y < this.mask.length) {
                    int x = 0;
                    while (x < this.mask[y].length) {
                        this.mask[y][x] = sourceImage.getRGB(x, y) >>> 24 >= 128;
                        ++x;
                    }
                    ++y;
                }
            }
            return this.mask;
        }

        public boolean[][] getSteelMask() throws ResourceException {
            if (this.steelMask == null) {
                if (this.steel) {
                    LemmImage sourceImage = this.getImage();
                    this.steelMask = new boolean[sourceImage.getHeight()][sourceImage.getWidth()];
                    int y = 0;
                    while (y < this.steelMask.length) {
                        int x = 0;
                        while (x < this.steelMask[y].length) {
                            this.steelMask[y][x] = sourceImage.getRGB(x, y) >>> 24 >= 128;
                            ++x;
                        }
                        ++y;
                    }
                } else {
                    this.steelMask = new boolean[0][0];
                }
            }
            return this.steelMask;
        }
    }
}

