/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Color;
import java.io.BufferedWriter;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.swing.JOptionPane;
import lemmini.LemminiFrame;
import lemmini.extract.ExtractDAT;
import lemmini.extract.ExtractLevel;
import lemmini.game.Core;
import lemmini.game.Explosion;
import lemmini.game.ExternalLevelEntry;
import lemmini.game.FileResource;
import lemmini.game.Icons;
import lemmini.game.LemmCursor;
import lemmini.game.LemmException;
import lemmini.game.LemmFont;
import lemmini.game.Lemming;
import lemmini.game.Level;
import lemmini.game.LevelInfo;
import lemmini.game.LevelPack;
import lemmini.game.LevelRecord;
import lemmini.game.Minimap;
import lemmini.game.MiscGfx;
import lemmini.game.NumFont;
import lemmini.game.ReplayAssignSkillEvent;
import lemmini.game.ReplayLevelInfo;
import lemmini.game.ReplayMovePosEvent;
import lemmini.game.ReplayReleaseRateEvent;
import lemmini.game.ReplaySelectSkillEvent;
import lemmini.game.ReplayStream;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.game.SpriteObject;
import lemmini.game.Stencil;
import lemmini.game.TextScreen;
import lemmini.game.TrapDoor;
import lemmini.game.Vsfx;
import lemmini.gameutil.Fader;
import lemmini.gameutil.KeyRepeat;
import lemmini.gameutil.Sprite;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;
import lemmini.sound.Music;
import lemmini.sound.Sound;
import lemmini.tools.NanosecondTimer;
import lemmini.tools.Props;
import lemmini.tools.ToolBox;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class GameController {
    public static final int KEYREPEAT_ICON = 1;
    public static final int KEYREPEAT_KEY = 2;
    public static final int FAST_FWD_MULTI = 3;
    public static final int FASTER_FAST_FWD_MULTI = 6;
    public static final int TURBO_MULTI = 9;
    public static final int SUPERLEMM_MULTI = 3;
    public static final long NANOSEC_PER_FRAME = 30000000L;
    public static final int MAX_ANIM_CTR = 2;
    private static final int MAX_START_SOUND_CTR = 28;
    private static final int MAX_ENTRANCE_OPEN_CTR = 72;
    private static final int[] MAX_SECOND_CTR = new int[]{34, 33, 33};
    private static final int[] MAX_SUPERLEMMING_SECOND_CTR = new int[]{100};
    private static final long NANOSEC_NUKE_DOUBLE_CLICK = 240000000L;
    private static final long NANOSEC_RESTART_DOUBLE_CLICK = 240000000L;
    private static final long NANOSEC_RELEASE_DOUBLE_CLICK = 200000000L;
    private static final long NANOSEC_KEYREPEAT_START = 250000000L;
    private static final long NANOSEC_KEYREPEAT_REPEAT = 39000000L;
    private static final String LEVEL_DIR_REGEX = "levels/[^/]+/levelpack.ini";
    private static final String LEVEL_CACHE_INI = "$levelcache.ini";
    public static Sound sound;
    private static Stencil stencil;
    private static LemmImage fgImage;
    private static final Set<Option> options;
    private static final Set<SLTooOption> SLToptions;
    private static final Set<RetroLemminiOption> RLoptions;
    private static ExitSoundOption exitSoundOption;
    private static MenuThemeOption menuThemeOption;
    private static boolean fastForward;
    private static boolean turbo;
    private static boolean verticalLock;
    private static boolean superLemming;
    private static boolean forceNormalTimerSpeed;
    private static State gameState;
    private static TransitionState transitionState;
    private static Lemming.Type lemmSkill;
    private static boolean entranceOpened;
    private static boolean nuke;
    private static boolean paused;
    private static boolean cheatWasActivated;
    private static boolean forceAdvanceFrame;
    private static int entranceOpenCtr;
    private static int startSoundCtr;
    private static boolean startSoundPlayed;
    private static final Set<SpriteObject> entranceSprites;
    private static int secondCtr;
    private static int releaseCtr;
    private static int releaseBase;
    private static Level level;
    private static int curRating;
    private static int curLevelPack;
    private static int curLevelNumber;
    private static int nextRating;
    private static int nextLevelPack;
    private static int nextLevelNumber;
    private static List<String> modPaths;
    private static final List<Lemming> lemmings;
    private static final List<Explosion> explosions;
    private static final Queue<Lemming> lemmsUnderCursor;
    private static final List<Vsfx> vsfxs;
    private static List<LevelPack> levelPacks;
    private static Set<ExternalLevelEntry> externalLevelList;
    private static LemmImage mapPreview;
    private static NanosecondTimer timerNuke;
    private static NanosecondTimer timerRestart;
    private static KeyRepeat plus;
    private static KeyRepeat minus;
    private static Lemming lemmSkillRequest;
    private static int xPos;
    private static int xPosCenter;
    private static int yPos;
    private static int yPosCenter;
    private static ReplayStream replay;
    private static int replayFrame;
    private static int releaseRateOld;
    private static boolean nukeOld;
    private static int xPosOld;
    private static int yPosOld;
    private static Lemming.Type lemmSkillOld;
    private static boolean replayMode;
    private static boolean stopReplayMode;
    private static int numExited;
    private static int releaseRate;
    private static boolean lockReleaseRate;
    private static int numLemmingsMax;
    private static int numLemmingsOut;
    private static int numToRescue;
    private static int time;
    private static int timeLimit;
    private static int timeElapsedTillLastExited;
    private static boolean timed;
    private static int numClimbers;
    private static int numFloaters;
    private static int numBombers;
    private static int numBlockers;
    private static int numBuilders;
    private static int numBashers;
    private static int numMiners;
    private static int numDiggers;
    private static int numSkillsUsed;
    private static int updateCtr;
    private static double soundGain;
    private static double musicGain;
    private static int width;
    private static int height;
    private static int timesFailed;

    static {
        options = EnumSet.noneOf(Option.class);
        SLToptions = EnumSet.noneOf(SLTooOption.class);
        RLoptions = EnumSet.noneOf(RetroLemminiOption.class);
        exitSoundOption = ExitSoundOption.AUTO;
        menuThemeOption = MenuThemeOption.WINLEMM;
        cheatWasActivated = false;
        forceAdvanceFrame = false;
        entranceSprites = new HashSet<SpriteObject>();
        lemmings = new LinkedList<Lemming>();
        explosions = new LinkedList<Explosion>();
        lemmsUnderCursor = Collections.asLifoQueue(new ArrayDeque(128));
        vsfxs = new LinkedList<Vsfx>();
        soundGain = 1.0;
        musicGain = 1.0;
        width = 3200;
        height = 320;
    }

    public static void init() throws ResourceException {
        System.out.println("initializing GameController...");
        width = 3200;
        height = 320;
        fgImage = ToolBox.createLemmImage(width, height);
        gameState = State.INIT;
        plus = new KeyRepeat(250000000L, 39000000L, 200000000L);
        minus = new KeyRepeat(250000000L, 39000000L, 200000000L);
        timerNuke = new NanosecondTimer();
        timerRestart = new NanosecondTimer();
        levelPacks = new ArrayList<LevelPack>(32);
        externalLevelList = new LinkedHashSet<ExternalLevelEntry>();
        LevelPack externalLevels = new LevelPack();
        Props externalLevelsINI = new Props();
        modPaths = Collections.emptyList();
        if (externalLevelsINI.load(Core.resourceTree.getPath("levels/$external/$levelcache.ini"))) {
            String[] levelData;
            boolean updateINI = false;
            int i = 0;
            while ((levelData = externalLevelsINI.getArray("level_" + i, null)) != null) {
                if (levelData.length >= 2) {
                    Path lvlPath = Paths.get(levelData[1], new String[0]);
                    if (Files.isReadable(lvlPath)) {
                        GameController.addExternalLevel(lvlPath, externalLevels, false);
                    } else {
                        updateINI = true;
                    }
                }
                ++i;
            }
            if (updateINI) {
                GameController.saveExternalLevelList();
            }
        }
        levelPacks.add(externalLevels);
        TreeSet dirs = new TreeSet();
        Core.resourceTree.getAllPathsRegex(LEVEL_DIR_REGEX).stream().map(file -> file.getParent().getFileName().toString().toLowerCase(Locale.ROOT)).forEach(dirs::add);
        dirs.stream().sorted().forEachOrdered(lvlName -> {
            try {
                Resource resource = Core.findResource("levels/" + lvlName + "/levelpack.ini", false);
                levelPacks.add(new LevelPack(resource));
            }
            catch (ResourceException resourceException) {
                // empty catch block
            }
        });
        curRating = 0;
        curLevelPack = 0;
        curLevelNumber = 0;
        modPaths = levelPacks.get(curLevelPack).getModPaths();
        sound = new Sound();
        sound.setGain(soundGain);
        Icons.init();
        Explosion.init();
        Lemming.loadLemmings();
        lemmSkillRequest = null;
        MiscGfx.init(ToolBox.scale(width, 0.0625));
        LemmFont.init();
        TextScreen.init();
        NumFont.init();
        LemmCursor.init();
        Music.init();
        Music.setGain(musicGain);
        timesFailed = 0;
        numSkillsUsed = 0;
        replayFrame = 0;
        replay = new ReplayStream();
        replayMode = false;
        stopReplayMode = false;
        cheatWasActivated = Core.player.isDebugMode() || Core.player.isMaximumExitPhysics();
        System.out.println("GameController initialization complete.");
    }

    static int absLevelNum(int lvlPack, int rating, int level) {
        LevelPack lpack = levelPacks.get(lvlPack);
        int absLvl = level;
        int i = 0;
        while (i < rating) {
            absLvl += lpack.getLevelCount(i);
            ++i;
        }
        return absLvl;
    }

    public static int[] relLevelNum(int lvlPack, int lvlAbs) {
        int[] retval = new int[2];
        LevelPack lpack = levelPacks.get(lvlPack);
        int ratings = lpack.getRatings().size();
        int lvl = -1;
        int rating = -1;
        int i = 0;
        int ls = 0;
        while (i < ratings) {
            int lsOld = ls;
            if (lvlAbs < (ls += lpack.getLevelCount(i))) {
                rating = i;
                lvl = lvlAbs - lsOld;
                break;
            }
            ++i;
        }
        retval[0] = rating;
        retval[1] = lvl;
        return retval;
    }

    private static boolean needVLock() {
        return GameController.getLevel() != null && GameController.getLevel().getHeight() > 320;
    }

    public static synchronized boolean nextLevel() {
        int num = curLevelNumber + 1;
        if (num < levelPacks.get(curLevelPack).getLevelCount(curRating)) {
            curLevelNumber = num;
            return true;
        }
        return false;
    }

    public static synchronized boolean nextRating() {
        int num = curRating + 1;
        if (num < levelPacks.get(curLevelPack).getRatings().size()) {
            curRating = num;
            curLevelNumber = 0;
            return true;
        }
        return false;
    }

    public static synchronized void endLevel() {
        if (!replayMode && !cheatWasActivated) {
            replay.addEndEvent(replayFrame);
        }
        transitionState = TransitionState.END_LEVEL;
        gameState = State.LEVEL_END;
        Fader.setState(Fader.State.OUT);
    }

    static synchronized void finishLevel() {
        Music.close();
        GameController.setFastForward(false);
        GameController.setVerticalLock(false);
        GameController.setSuperLemming(false);
        if (!GameController.wasLost() && curLevelPack != 0) {
            LevelPack lvlPack = GameController.getCurLevelPack();
            String curRatingString = lvlPack.getRatings().get(curRating);
            Core.player.setLevelRecord(lvlPack.getName(), curRatingString, curLevelNumber, GameController.getLevelRecord());
            if (curLevelNumber + 1 < lvlPack.getLevelCount(curRating)) {
                Core.player.setAvailable(lvlPack.getName(), curRatingString, curLevelNumber + 1);
            }
            Core.player.store();
        }
        replayMode = false;
        gameState = State.DEBRIEFING;
    }

    private static synchronized void restartLevel(boolean doReplay, boolean showBriefing) throws LemmException, ResourceException {
        if (!replayMode && GameController.wasLost() && (gameState == State.LEVEL || gameState == State.LEVEL_END || gameState == State.DEBRIEFING)) {
            ++timesFailed;
        }
        GameController.initLevel(showBriefing);
        if (doReplay) {
            replayMode = true;
            replay.save("temp//replay.rpl");
            replay.rewind();
        } else {
            replayMode = false;
            replay.clear();
        }
    }

    private static synchronized void initLevel(boolean showBriefing) throws LemmException, ResourceException {
        if (showBriefing) {
            Music.stop();
        }
        GameController.setFastForward(false);
        GameController.setVerticalLock(false);
        GameController.setPaused(false);
        nuke = false;
        lemmSkillRequest = null;
        TextScreen.setMode(TextScreen.Mode.INIT);
        lemmings.clear();
        explosions.clear();
        Icons.reset();
        plus.init();
        minus.init();
        int oldWidth = width;
        int oldHeight = height;
        numExited = 0;
        releaseRate = level.getReleaseRate();
        lockReleaseRate = level.isReleaseRateLocked();
        numLemmingsMax = level.getNumLemmings();
        numLemmingsOut = 0;
        numToRescue = level.getNumToRescue();
        time = level.getTimeLimitSeconds();
        numClimbers = level.getNumClimbers();
        numFloaters = level.getNumFloaters();
        numBombers = level.getNumBombers();
        numBlockers = level.getNumBlockers();
        numBuilders = level.getNumBuilders();
        numBashers = level.getNumBashers();
        numMiners = level.getNumMiners();
        numDiggers = level.getNumDiggers();
        numSkillsUsed = 0;
        xPosCenter = level.getXPosCenter();
        yPosCenter = level.getYPosCenter();
        width = level.getWidth();
        height = level.getHeight();
        if (time <= 0) {
            timed = false;
            time = 0;
        } else {
            timed = true;
        }
        timeLimit = time;
        timeElapsedTillLastExited = 0;
        level.paintLevel();
        stencil = level.getStencil();
        fgImage = level.getFgImage();
        if (width != oldWidth || height != oldHeight) {
            MiscGfx.setMinimapWidth(ToolBox.scale(width, 0.0625));
        }
        TrapDoor.reset(level.getNumEntrances(), level.getEntranceOrder());
        startSoundPlayed = false;
        startSoundCtr = 0;
        entranceOpened = false;
        entranceOpenCtr = 0;
        secondCtr = 0;
        releaseCtr = 0;
        lemmSkill = null;
        entranceSprites.clear();
        int i = 0;
        while (i < level.getNumEntrances()) {
            SpriteObject spr = level.getSprObject(GameController.level.getEntrance((int)i).id);
            if (spr != null) {
                entranceSprites.add(spr);
            }
            ++i;
        }
        GameController.calcReleaseBase();
        int scaleFactorWidth = width / 800;
        if (width % 800 != 0) {
            ++scaleFactorWidth;
        }
        int scaleFactorHeight = height / 80;
        if (height % 80 != 0) {
            ++scaleFactorHeight;
        }
        int scaleFactor = NumberUtils.max((int)4, (int)scaleFactorWidth, (int)scaleFactorHeight);
        mapPreview = level.createMinimap(fgImage, 1.0 / (double)scaleFactor, 1.0 / (double)scaleFactor, true, false, true);
        Minimap.init(0.0625, 0.125, !GameController.isOptionEnabled(RetroLemminiOption.FULL_COLOR_MINIMAP));
        GameController.setSuperLemming(level.isSuperLemming());
        forceNormalTimerSpeed = level.getForceNormalTimerSpeed();
        replayFrame = 0;
        stopReplayMode = false;
        releaseRateOld = releaseRate;
        lemmSkillOld = lemmSkill;
        nukeOld = false;
        if (showBriefing) {
            String music = level.getMusic();
            try {
                if (music == null) {
                    music = levelPacks.get(curLevelPack).getInfo(curRating, curLevelNumber).getMusic();
                }
                if (music == null) {
                    music = Music.getRandomTrack(level.getStyleName(), level.getSpecialStyleName());
                }
                Music.load("music/" + music);
            }
            catch (ResourceException ex) {
                Core.musicResourceError(music);
                music = "";
            }
            catch (LemmException ex) {
                Resource resource;
                String ext;
                if (music == null) {
                    music = "";
                }
                if (!(ext = FilenameUtils.getExtension((resource = Core.findResource("music/" + music, Core.MUSIC_EXTENSIONS)).getFileName()).toLowerCase(Locale.ROOT)).equals("ogg")) {
                    JOptionPane.showMessageDialog(null, "Unable to load music resource:\n" + ex.getMessage() + "\n\nAttempting midi fallback.", "Error Loading Music", 0);
                }
                try {
                    music = Music.getRandomTrack(level.getStyleName(), level.getSpecialStyleName());
                    Music.load("music/" + music);
                }
                catch (ResourceException ex2) {
                    Core.resourceError(ex2.getMessage());
                    return;
                }
                catch (LemmException ex2) {
                    JOptionPane.showMessageDialog(null, "Unable to load music resource:\n" + ex2.getMessage() + "\n\nNo music will play for this level.", "Error Loading Music", 0);
                }
            }
            Music.setGain(musicGain);
        }
        sound.setGain(soundGain);
        if (showBriefing) {
            gameState = State.BRIEFING;
        } else {
            gameState = State.LEVEL;
            transitionState = TransitionState.TO_LEVEL;
        }
        cheatWasActivated = Core.player.isDebugMode() || Core.player.isMaximumExitPhysics();
    }

    public static synchronized void requestRestartLevel(boolean doReplay, boolean showBriefing) {
        if (doReplay && !replayMode) {
            replay.addEndEvent(replayFrame);
        }
        transitionState = doReplay || replayMode ? (showBriefing ? TransitionState.REPLAY_LEVEL : TransitionState.REPLAY_LEVEL_NO_BRIEFING) : TransitionState.RESTART_LEVEL;
        if (gameState == State.LEVEL) {
            gameState = State.LEVEL_END;
        }
        Fader.setState(Fader.State.OUT);
    }

    public static synchronized void requestChangeLevel(int lPack, int rating, int lNum, boolean doReplay) {
        nextLevelPack = lPack;
        nextRating = rating;
        nextLevelNumber = lNum;
        transitionState = doReplay ? TransitionState.LOAD_REPLAY : TransitionState.LOAD_LEVEL;
        if (gameState == State.LEVEL) {
            gameState = State.LEVEL_END;
        }
        Fader.setState(Fader.State.OUT);
    }

    private static synchronized Level changeLevel(int lPack, int rating, int lNum, boolean doReplay) throws LemmException, ResourceException {
        timesFailed = 0;
        curLevelPack = lPack;
        curRating = rating;
        curLevelNumber = lNum;
        List<String> oldMods = modPaths;
        modPaths = levelPacks.get(curLevelPack).getModPaths();
        if (!modPaths.equals(oldMods)) {
            sound.load();
            MiscGfx.init(ToolBox.scale(width, 0.0625));
            Icons.init();
            Explosion.init();
            LemmFont.init();
            TextScreen.init();
            NumFont.init();
            LemmCursor.init();
            Lemming.loadLemmings();
        }
        Resource lvlRes = levelPacks.get(curLevelPack).getInfo(curRating, curLevelNumber).getLevelResource();
        level = new Level(lvlRes, level);
        GameController.initLevel(true);
        if (doReplay) {
            replayMode = true;
            replay.rewind();
        } else {
            replayMode = false;
            replay.clear();
        }
        return level;
    }

    public static synchronized boolean wasLost() {
        return gameState == State.LEVEL || numExited < numToRescue;
    }

    public static synchronized LemmImage getReplayImage() {
        if (!replayMode) {
            return null;
        }
        if ((replayFrame & 0x3F) > 32) {
            return MiscGfx.getImage(MiscGfx.Index.REPLAY_1);
        }
        return MiscGfx.getImage(MiscGfx.Index.REPLAY_2);
    }

    public static synchronized Lemming lemmUnderCursor(LemmCursor.CursorType type) {
        if (lemmSkill != null && !type.isWalkerOnly()) {
            block26: for (Lemming l : lemmsUnderCursor) {
                if (type.isLeftOnly() && l.getDirection() != Lemming.Direction.LEFT || type.isRightOnly() && l.getDirection() != Lemming.Direction.RIGHT) continue;
                block0 : switch (l.getSkill()) {
                    case BLOCKER: {
                        if (l.getSkill() == lemmSkill || l.getLemmingInfo().isEmpty()) continue block26;
                        switch (lemmSkill) {
                            case FLAPPER: {
                                if (l.hasTimer()) break block0;
                                return l;
                            }
                        }
                        break;
                    }
                    case BUILDER: 
                    case SHRUGGER: 
                    case DIGGER: 
                    case BASHER: 
                    case MINER: {
                        if (l.getSkill() == lemmSkill || l.getLemmingInfo().isEmpty()) continue block26;
                        switch (lemmSkill) {
                            case CLIMBER: {
                                if (l.canClimb()) break block0;
                                return l;
                            }
                            case FLOATER: {
                                if (l.canFloat()) break block0;
                                return l;
                            }
                            case FLAPPER: {
                                if (l.hasTimer()) break block0;
                                return l;
                            }
                        }
                        return l;
                    }
                }
            }
        }
        block27: for (Lemming l : lemmsUnderCursor) {
            if (type.isWalkerOnly() && l.getSkill() != Lemming.Type.WALKER || type.isLeftOnly() && l.getDirection() != Lemming.Direction.LEFT || type.isRightOnly() && l.getDirection() != Lemming.Direction.RIGHT) continue;
            block12 : switch (l.getSkill()) {
                case WALKER: {
                    if (l.getSkill() == lemmSkill || l.getLemmingInfo().isEmpty()) continue block27;
                    if (lemmSkill == null) {
                        return l;
                    }
                    switch (lemmSkill) {
                        case CLIMBER: {
                            if (l.canClimb()) break block12;
                            return l;
                        }
                        case FLOATER: {
                            if (l.canFloat()) break block12;
                            return l;
                        }
                        case FLAPPER: {
                            if (l.hasTimer()) break block12;
                            return l;
                        }
                    }
                    return l;
                }
                case FALLER: 
                case CLIMBER: 
                case FLIPPER: 
                case FLOATER: 
                case JUMPER: {
                    if (lemmSkill == null || l.getSkill() == lemmSkill || l.getLemmingInfo().isEmpty()) continue block27;
                    if (lemmSkill == null) {
                        return l;
                    }
                    switch (lemmSkill) {
                        case CLIMBER: {
                            if (l.canClimb()) break block12;
                            return l;
                        }
                        case FLOATER: {
                            if (l.canFloat()) break block12;
                            return l;
                        }
                        case FLAPPER: {
                            if (l.hasTimer()) break block12;
                            return l;
                        }
                    }
                    break;
                }
            }
        }
        if (type == LemmCursor.CursorType.NORMAL) {
            for (Lemming l : lemmsUnderCursor) {
                if (l.getLemmingInfo().isEmpty()) continue;
                return l;
            }
        }
        return null;
    }

    static synchronized void increaseExited() {
        ++numExited;
        timeElapsedTillLastExited = time;
    }

    public static void stopReplayMode() {
        if (replayMode) {
            replay.clearFrom(replayFrame);
            replayMode = false;
            stopReplayMode = false;
        }
    }

    public static synchronized String getTimeString() {
        return String.format(Locale.ROOT, "%d-%02d", time / 60, time % 60);
    }

    public static String getLastLevelPlayedString() {
        int levelPackIndex = GameController.getCurLevelPackIdx();
        int ratingIndex = GameController.getCurRating();
        int levelIndex = GameController.getCurLevelNumber();
        return String.valueOf(levelPackIndex) + "," + ratingIndex + "," + levelIndex;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static synchronized void update() {
        block72: {
            if (GameController.gameState != State.LEVEL) {
                return;
            }
            ++GameController.updateCtr;
            if (!GameController.replayMode) {
                GameController.assignSkill(false);
            }
            if ((fired = GameController.plus.fired()) != KeyRepeat.Event.NONE && !GameController.lockReleaseRate && GameController.releaseRate < GameController.level.getMaxReleaseRate()) {
                GameController.releaseRate = fired == KeyRepeat.Event.DOUBLE_CLICK ? GameController.level.getMaxReleaseRate() : ++GameController.releaseRate;
                GameController.calcReleaseBase();
                GameController.sound.playPitched(Sound.PitchedEffect.RELEASE_RATE, (int)Math.round((double)GameController.releaseRate * 2.69));
            }
            if ((fired = GameController.minus.fired()) != KeyRepeat.Event.NONE && !GameController.lockReleaseRate && GameController.releaseRate > GameController.level.getReleaseRate()) {
                GameController.releaseRate = fired == KeyRepeat.Event.DOUBLE_CLICK ? GameController.level.getReleaseRate() : --GameController.releaseRate;
                GameController.calcReleaseBase();
                GameController.sound.playPitched(Sound.PitchedEffect.RELEASE_RATE, (int)Math.round((double)GameController.releaseRate * 2.69));
            }
            if (GameController.forceAdvanceFrame) {
                GameController.forceAdvanceFrame = false;
            } else if (GameController.isPaused()) {
                return;
            }
            if (GameController.replayMode && GameController.stopReplayMode) {
                GameController.stopReplayMode();
            }
            if (GameController.replayMode) ** GOTO lbl145
            if (!GameController.cheatWasActivated) {
                if (GameController.releaseRate != GameController.releaseRateOld) {
                    GameController.replay.addReleaseRateEvent(GameController.replayFrame, GameController.releaseRate);
                    GameController.releaseRateOld = GameController.releaseRate;
                }
                if (GameController.nuke != GameController.nukeOld) {
                    GameController.replay.addNukeEvent(GameController.replayFrame);
                    GameController.nukeOld = GameController.nuke;
                }
                if (GameController.getXPos() != GameController.xPosOld || GameController.getYPos() != GameController.yPosOld) {
                    GameController.replay.addPosEvent(GameController.replayFrame, GameController.getXPos() + Core.getDrawWidth() / 2, GameController.getYPos() + 160, 0);
                    GameController.xPosOld = GameController.getXPos();
                    GameController.yPosOld = GameController.getYPos();
                }
                if (GameController.lemmSkill != GameController.lemmSkillOld) {
                    GameController.replay.addSelectSkillEvent(GameController.replayFrame, GameController.lemmSkill, 0);
                    GameController.lemmSkillOld = GameController.lemmSkill;
                }
            } else {
                GameController.replay.clear();
            }
            break block72;
lbl-1000:
            // 1 sources

            {
                switch (r.type) {
                    case 0: {
                        rs /* !! */  = (ReplayAssignSkillEvent)r;
                        l = GameController.lemmings.get(rs /* !! */ .lemming);
                        l.setSkill(rs /* !! */ .skill, false, r);
                        l.setSelected();
                        pan = l.getPan();
                        switch (GameController.$SWITCH_TABLE$lemmini$game$Lemming$Type()[rs /* !! */ .skill.ordinal()]) {
                            case 3: {
                                if (GameController.numClimbers == 0x7FFFFFFF) break;
                                --GameController.numClimbers;
                                ++GameController.numSkillsUsed;
                                break;
                            }
                            case 5: {
                                if (GameController.numFloaters == 0x7FFFFFFF) break;
                                --GameController.numFloaters;
                                ++GameController.numSkillsUsed;
                                break;
                            }
                            case 6: {
                                if (GameController.numBombers == 0x7FFFFFFF) break;
                                --GameController.numBombers;
                                ++GameController.numSkillsUsed;
                                break;
                            }
                            case 8: {
                                if (GameController.numBlockers == 0x7FFFFFFF) break;
                                --GameController.numBlockers;
                                ++GameController.numSkillsUsed;
                                break;
                            }
                            case 12: {
                                if (GameController.numBuilders == 0x7FFFFFFF) break;
                                --GameController.numBuilders;
                                ++GameController.numSkillsUsed;
                                break;
                            }
                            case 15: {
                                if (GameController.numBashers == 0x7FFFFFFF) break;
                                --GameController.numBashers;
                                ++GameController.numSkillsUsed;
                                break;
                            }
                            case 16: {
                                if (GameController.numMiners == 0x7FFFFFFF) break;
                                --GameController.numMiners;
                                ++GameController.numSkillsUsed;
                                break;
                            }
                            case 14: {
                                if (GameController.numDiggers == 0x7FFFFFFF) break;
                                --GameController.numDiggers;
                                ++GameController.numSkillsUsed;
                                break;
                            }
                        }
                        GameController.sound.play(Sound.Effect.SELECT_SKILL, pan);
                        break;
                    }
                    case 3: {
                        if (GameController.lockReleaseRate) break;
                        rr = (ReplayReleaseRateEvent)r;
                        GameController.releaseRate = rr.releaseRate;
                        GameController.calcReleaseBase();
                        GameController.sound.playPitched(Sound.PitchedEffect.RELEASE_RATE, GameController.releaseRate + 99);
                        GameController.releaseRateOld = GameController.releaseRate;
                        break;
                    }
                    case 4: {
                        GameController.nuke();
                        GameController.pressIcon(Icons.IconType.NUKE);
                        GameController.nukeOld = GameController.nuke;
                        break;
                    }
                    case 1: {
                        rx = (ReplayMovePosEvent)r;
                        if (!GameController.isOptionEnabled(Option.REPLAY_SCROLL) || rx.player != 0) continue block28;
                        GameController.setXPos(rx.xPos - Core.getDrawWidth() / 2);
                        GameController.setYPos(rx.yPos - 160);
                        GameController.xPosOld = GameController.xPos;
                        GameController.yPosOld = GameController.yPos;
                        break;
                    }
                    case 2: {
                        rs /* !! */  = (ReplaySelectSkillEvent)r;
                        if (rs /* !! */ .player != 0) break;
                        GameController.lemmSkill = rs /* !! */ .skill;
                        switch (GameController.$SWITCH_TABLE$lemmini$game$Lemming$Type()[GameController.lemmSkill.ordinal()]) {
                            case 3: {
                                GameController.pressIcon(Icons.IconType.CLIMB);
                                break;
                            }
                            case 5: {
                                GameController.pressIcon(Icons.IconType.FLOAT);
                                break;
                            }
                            case 6: {
                                GameController.pressIcon(Icons.IconType.BOMB);
                                break;
                            }
                            case 8: {
                                GameController.pressIcon(Icons.IconType.BLOCK);
                                break;
                            }
                            case 12: {
                                GameController.pressIcon(Icons.IconType.BUILD);
                                break;
                            }
                            case 15: {
                                GameController.pressIcon(Icons.IconType.BASH);
                                break;
                            }
                            case 16: {
                                GameController.pressIcon(Icons.IconType.MINE);
                                break;
                            }
                            case 14: {
                                GameController.pressIcon(Icons.IconType.DIG);
                                break;
                            }
                        }
                        GameController.lemmSkillOld = GameController.lemmSkill;
                        break;
                    }
                    case 5: {
                        GameController.stopReplayMode = true;
                        break;
                    }
                }
lbl145:
                // 11 sources

                ** while ((r = GameController.replay.getNext((int)GameController.replayFrame)) != null)
            }
        }
        nukeTemp = GameController.nuke;
        if (++GameController.secondCtr > (GameController.superLemming != false && GameController.forceNormalTimerSpeed != false ? GameController.MAX_SUPERLEMMING_SECOND_CTR[GameController.time % GameController.MAX_SUPERLEMMING_SECOND_CTR.length] : GameController.MAX_SECOND_CTR[GameController.time % GameController.MAX_SECOND_CTR.length])) {
            GameController.secondCtr -= GameController.superLemming != false && GameController.forceNormalTimerSpeed != false ? GameController.MAX_SUPERLEMMING_SECOND_CTR[GameController.time % GameController.MAX_SUPERLEMMING_SECOND_CTR.length] : GameController.MAX_SECOND_CTR[GameController.time % GameController.MAX_SECOND_CTR.length];
            if (GameController.timed) {
                if (GameController.time > 0) {
                    --GameController.time;
                }
            } else {
                ++GameController.time;
            }
            if (!Core.player.isDebugMode() && GameController.time <= 0 && GameController.timed) {
                GameController.endLevel();
            }
        }
        if (GameController.entranceOpened && !nukeTemp && GameController.numLemmingsOut < GameController.getNumLemmingsMax() && --GameController.releaseCtr <= 0) {
            GameController.releaseCtr = GameController.releaseBase;
            if (GameController.level.getNumEntrances() != 0) {
                e = GameController.level.getEntrance(TrapDoor.getNext());
                l = new Lemming(e.xPos + 2, e.yPos + 20, e.leftEntrance != false ? Lemming.Direction.LEFT : Lemming.Direction.RIGHT);
                GameController.lemmings.add(l);
                ++GameController.numLemmingsOut;
            }
        }
        if (nukeTemp && (GameController.updateCtr & 1) == 1) {
            for (Lemming l : GameController.lemmings) {
                if (l.nuke() || l.hasDied() || l.hasExited()) continue;
                l.setSkill(Lemming.Type.NUKE, false);
                break;
            }
        }
        if (!GameController.startSoundPlayed && ++GameController.startSoundCtr == 28) {
            for (SpriteObject spr : GameController.entranceSprites) {
                y = spr.getY() + spr.getHeight() + 24;
                GameController.sound.playVisualSFXSilent(Sound.Effect.START, spr.midX(), y);
            }
            GameController.sound.play(Sound.Effect.START);
            GameController.startSoundPlayed = true;
        }
        if (!GameController.entranceOpened) {
            if (++GameController.entranceOpenCtr == 72) {
                i = 0;
                while (i < GameController.level.getNumSprObjects()) {
                    spr = GameController.level.getSprObject(i);
                    if (spr != null && spr.getAnimMode() == Sprite.Animation.ONCE_ENTRANCE) {
                        spr.setAnimMode(Sprite.Animation.ONCE);
                    }
                    ++i;
                }
                GameController.level.openBackgroundEntrances();
                GameController.entranceSprites.stream().forEach((Consumer<SpriteObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, play(lemmini.game.SpriteObject ), (Llemmini/game/SpriteObject;)V)((Sound)GameController.sound));
            } else if (GameController.entranceOpenCtr == 102) {
                GameController.entranceOpened = true;
                GameController.releaseCtr = 0;
                if (GameController.isOptionEnabled(Option.MUSIC_ON)) {
                    Music.play();
                }
            }
        }
        if ((nukeTemp || GameController.numLemmingsOut == GameController.getNumLemmingsMax()) && GameController.lemmings.isEmpty()) {
            endLevel = true;
            i = 0;
            while (i < GameController.level.getNumSprObjects()) {
                sprite = GameController.level.getSprObject(i);
                if (sprite != null && sprite.isTriggered()) {
                    endLevel = false;
                    break;
                }
                ++i;
            }
            if (endLevel) {
                GameController.endLevel();
            }
        }
        it = GameController.lemmings.iterator();
        while (it.hasNext()) {
            l = it.next();
            l.animate();
            if (!l.hasDied() && !l.hasExited()) continue;
            it.remove();
        }
        it = GameController.explosions.iterator();
        while (it.hasNext()) {
            e = (Explosion)it.next();
            if (e.isFinished()) {
                it.remove();
                continue;
            }
            e.update();
        }
        it = GameController.vsfxs.iterator();
        while (it.hasNext()) {
            l = (Vsfx)it.next();
            l.animate();
            if (!l.hasFinished()) continue;
            it.remove();
        }
        n = 0;
        while (n < GameController.level.getNumSprObjects()) {
            spr = GameController.level.getSprObject(n);
            if (spr != null) {
                spr.getImageAnim();
            }
            ++n;
        }
        GameController.level.advanceBackgroundFrame();
        if (!GameController.replayMode) {
            GameController.assignSkill(true);
        }
        ++GameController.replayFrame;
    }

    public static synchronized void requestSkill(Lemming lemm) {
        if (lemmSkill != null) {
            lemmSkillRequest = lemm;
        }
        GameController.stopReplayMode();
        if (!GameController.isOptionEnabled(SLTooOption.DISABLE_FRAME_STEPPING)) {
            GameController.advanceFrame();
        }
    }

    private static synchronized void assignSkill(boolean delete) {
        if (lemmSkillRequest == null || lemmSkill == null) {
            return;
        }
        Lemming lemm = lemmSkillRequest;
        if (delete) {
            lemmSkillRequest = null;
        }
        boolean canSet = false;
        GameController.stopReplayMode();
        if (Core.player.isDebugMode()) {
            canSet = lemm.setSkill(lemmSkill, true);
        } else {
            switch (lemmSkill) {
                case CLIMBER: {
                    if (numClimbers > 0) {
                        if (!lemm.setSkill(lemmSkill, true)) break;
                        if (numClimbers != Integer.MAX_VALUE) {
                            --numClimbers;
                            ++numSkillsUsed;
                        }
                        canSet = true;
                        break;
                    }
                    sound.play(Sound.Effect.INVALID, lemm.getPan());
                    break;
                }
                case FLOATER: {
                    if (numFloaters > 0) {
                        if (!lemm.setSkill(lemmSkill, true)) break;
                        if (numFloaters != Integer.MAX_VALUE) {
                            --numFloaters;
                            ++numSkillsUsed;
                        }
                        canSet = true;
                        break;
                    }
                    sound.play(Sound.Effect.INVALID, lemm.getPan());
                    break;
                }
                case FLAPPER: {
                    if (numBombers > 0) {
                        if (!lemm.setSkill(lemmSkill, true)) break;
                        if (numBombers != Integer.MAX_VALUE) {
                            --numBombers;
                            ++numSkillsUsed;
                        }
                        canSet = true;
                        break;
                    }
                    sound.play(Sound.Effect.INVALID, lemm.getPan());
                    break;
                }
                case BLOCKER: {
                    if (numBlockers > 0) {
                        if (!lemm.setSkill(lemmSkill, true)) break;
                        if (numBlockers != Integer.MAX_VALUE) {
                            --numBlockers;
                            ++numSkillsUsed;
                        }
                        canSet = true;
                        break;
                    }
                    sound.play(Sound.Effect.INVALID, lemm.getPan());
                    break;
                }
                case BUILDER: {
                    if (numBuilders > 0) {
                        if (!lemm.setSkill(lemmSkill, true)) break;
                        if (numBuilders != Integer.MAX_VALUE) {
                            --numBuilders;
                            ++numSkillsUsed;
                        }
                        canSet = true;
                        break;
                    }
                    sound.play(Sound.Effect.INVALID, lemm.getPan());
                    break;
                }
                case BASHER: {
                    if (numBashers > 0) {
                        if (!lemm.setSkill(lemmSkill, true)) break;
                        if (numBashers != Integer.MAX_VALUE) {
                            --numBashers;
                            ++numSkillsUsed;
                        }
                        canSet = true;
                        break;
                    }
                    sound.play(Sound.Effect.INVALID, lemm.getPan());
                    break;
                }
                case MINER: {
                    if (numMiners > 0) {
                        if (!lemm.setSkill(lemmSkill, true)) break;
                        if (numMiners != Integer.MAX_VALUE) {
                            --numMiners;
                            ++numSkillsUsed;
                        }
                        canSet = true;
                        break;
                    }
                    sound.play(Sound.Effect.INVALID, lemm.getPan());
                    break;
                }
                case DIGGER: {
                    if (numDiggers > 0) {
                        if (!lemm.setSkill(lemmSkill, true)) break;
                        if (numDiggers != Integer.MAX_VALUE) {
                            --numDiggers;
                            ++numSkillsUsed;
                        }
                        canSet = true;
                        break;
                    }
                    sound.play(Sound.Effect.INVALID, lemm.getPan());
                    break;
                }
            }
        }
        if (canSet) {
            int idx;
            lemmSkillRequest = null;
            if (GameController.isPaused() && GameController.isOptionEnabled(Option.UNPAUSE_ON_ASSIGNMENT)) {
                GameController.setPaused(false);
                GameController.pressIcon(Icons.IconType.PAUSE);
            }
            if (!cheatWasActivated && (idx = lemmings.indexOf(lemm)) != -1) {
                replay.addAssignSkillEvent(replayFrame + (delete ? 1 : 0), lemmSkill, idx);
            }
        } else if (!delete) {
            lemmSkillRequest = null;
        }
    }

    private static void calcReleaseBase() {
        releaseBase = 107 - releaseRate;
    }

    public static synchronized void handleIconButton(Icons.IconType type) {
        if (GameController.testIcon(type)) {
            switch (type) {
                case PLUS: {
                    plus.pressed(1);
                    GameController.stopReplayMode();
                    break;
                }
                case MINUS: {
                    minus.pressed(1);
                    GameController.stopReplayMode();
                    break;
                }
                case CLIMB: {
                    lemmSkill = Lemming.Type.CLIMBER;
                    GameController.stopReplayMode();
                    break;
                }
                case FLOAT: {
                    lemmSkill = Lemming.Type.FLOATER;
                    GameController.stopReplayMode();
                    break;
                }
                case BOMB: {
                    lemmSkill = Lemming.Type.FLAPPER;
                    GameController.stopReplayMode();
                    break;
                }
                case BLOCK: {
                    lemmSkill = Lemming.Type.BLOCKER;
                    GameController.stopReplayMode();
                    break;
                }
                case BUILD: {
                    lemmSkill = Lemming.Type.BUILDER;
                    GameController.stopReplayMode();
                    break;
                }
                case BASH: {
                    lemmSkill = Lemming.Type.BASHER;
                    GameController.stopReplayMode();
                    break;
                }
                case MINE: {
                    lemmSkill = Lemming.Type.MINER;
                    GameController.stopReplayMode();
                    break;
                }
                case DIG: {
                    lemmSkill = Lemming.Type.DIGGER;
                    GameController.stopReplayMode();
                    break;
                }
                case PAUSE: {
                    if (GameController.isOptionEnabled(Option.PAUSE_STOPS_FAST_FORWARD) && !paused && fastForward) {
                        fastForward = false;
                        GameController.pressIcon(Icons.IconType.FFWD);
                    }
                    GameController.setPaused(!GameController.isPaused());
                    break;
                }
                case NUKE: {
                    GameController.stopReplayMode();
                    if (timerNuke.delta() < 240000000L) {
                        if (nuke) break;
                        GameController.nuke();
                        break;
                    }
                    timerNuke.deltaUpdate();
                    break;
                }
                case FFWD: {
                    GameController.setFastForward(!GameController.isFastForward());
                    break;
                }
                case VLOCK: {
                    GameController.setVerticalLock(!GameController.isVerticalLock());
                    break;
                }
                case RESTART: {
                    if (timerRestart.delta() < 240000000L) {
                        GameController.requestRestartLevel(true, false);
                        break;
                    }
                    timerRestart.deltaUpdate();
                    break;
                }
            }
            switch (type) {
                case CLIMB: 
                case FLOAT: 
                case BOMB: 
                case BLOCK: 
                case BUILD: 
                case BASH: 
                case MINE: 
                case DIG: 
                case PAUSE: 
                case FFWD: 
                case NUKE: 
                case RESTART: {
                    sound.playPitched(Sound.PitchedEffect.SKILL, Icons.GetPitch(type));
                    break;
                }
                case VLOCK: {
                    if (!GameController.needVLock()) break;
                    sound.playPitched(Sound.PitchedEffect.SKILL, Icons.GetPitch(type));
                    break;
                }
            }
            GameController.pressIcon(type);
        } else {
            sound.play(Sound.Effect.INVALID);
        }
    }

    public static synchronized void nextSkill() {
        Icons.IconType pressedIcon = Icons.getSelectedSkill();
        Icons.IconType testIcon = pressedIcon == null ? Icons.SkillIconOrder().get(0) : Icons.getNextRadioIcon(pressedIcon);
        while (testIcon != pressedIcon) {
            if (GameController.testIcon(testIcon)) break;
            testIcon = Icons.getNextRadioIcon(testIcon);
        }
        GameController.handleIconButton(testIcon);
    }

    public static synchronized void previousSkill() {
        Icons.IconType pressedIcon = Icons.getSelectedSkill();
        Icons.IconType testIcon = pressedIcon == null ? Icons.SkillIconOrder().get(Icons.SkillIconOrder().size() - 1) : Icons.getPreviousRadioIcon(pressedIcon);
        while (testIcon != pressedIcon) {
            if (GameController.testIcon(testIcon)) break;
            testIcon = Icons.getPreviousRadioIcon(testIcon);
        }
        GameController.handleIconButton(testIcon);
    }

    private static boolean testIcon(Icons.IconType type) {
        switch (type) {
            case MINUS: 
            case PLUS: 
            case PAUSE: 
            case FFWD: 
            case RESTART: 
            case VLOCK: {
                return true;
            }
            case CLIMB: {
                return (Core.player.isDebugMode() || numClimbers > 0) && Icons.getSelectedSkill() != type;
            }
            case FLOAT: {
                return (Core.player.isDebugMode() || numFloaters > 0) && Icons.getSelectedSkill() != type;
            }
            case BOMB: {
                return (Core.player.isDebugMode() || numBombers > 0) && Icons.getSelectedSkill() != type;
            }
            case BLOCK: {
                return (Core.player.isDebugMode() || numBlockers > 0) && Icons.getSelectedSkill() != type;
            }
            case BUILD: {
                return (Core.player.isDebugMode() || numBuilders > 0) && Icons.getSelectedSkill() != type;
            }
            case BASH: {
                return (Core.player.isDebugMode() || numBashers > 0) && Icons.getSelectedSkill() != type;
            }
            case MINE: {
                return (Core.player.isDebugMode() || numMiners > 0) && Icons.getSelectedSkill() != type;
            }
            case DIG: {
                return (Core.player.isDebugMode() || numDiggers > 0) && Icons.getSelectedSkill() != type;
            }
            case NUKE: {
                return !nuke;
            }
        }
        return false;
    }

    private static void nuke() {
        nuke = true;
        sound.play(Sound.Effect.NUKE);
    }

    public static boolean isNuked() {
        return nuke;
    }

    public static void fade() {
        boolean showBriefing;
        boolean doReplay = transitionState == TransitionState.REPLAY_LEVEL || transitionState == TransitionState.REPLAY_LEVEL_NO_BRIEFING;
        boolean bl = showBriefing = transitionState != TransitionState.REPLAY_LEVEL_NO_BRIEFING;
        if (Fader.getState() == Fader.State.BLACK && transitionState != TransitionState.NONE) {
            switch (transitionState) {
                case END_LEVEL: {
                    GameController.finishLevel();
                    LemmCursor.setBox(false);
                    LemminiFrame.getFrame().setCursor(LemmCursor.CursorType.NORMAL);
                    break;
                }
                case TO_BRIEFING: {
                    gameState = State.BRIEFING;
                    break;
                }
                case TO_DEBRIEFING: {
                    gameState = State.DEBRIEFING;
                    break;
                }
                case TO_INTRO: {
                    gameState = State.INTRO;
                    break;
                }
                case REPLAY_LEVEL_NO_BRIEFING: 
                case TO_LEVEL: {
                    GameController.setXPos(xPosCenter - Core.getDrawWidth() / 2);
                    GameController.setYPos(yPosCenter - 160);
                    xPosOld = xPos;
                    yPosOld = yPos;
                    gameState = State.LEVEL;
                    if (transitionState != TransitionState.REPLAY_LEVEL_NO_BRIEFING) break;
                }
                case RESTART_LEVEL: 
                case REPLAY_LEVEL: {
                    try {
                        GameController.restartLevel(doReplay, showBriefing);
                    }
                    catch (ResourceException ex) {
                        Core.resourceError(ex.getMessage());
                        return;
                    }
                    catch (LemmException ex) {
                        JOptionPane.showMessageDialog(LemminiFrame.getFrame(), ex.getMessage(), "Error", 0);
                        System.exit(1);
                    }
                    LemmCursor.setBox(false);
                    LemminiFrame.getFrame().setCursor(LemmCursor.CursorType.NORMAL);
                    break;
                }
                case LOAD_LEVEL: 
                case LOAD_REPLAY: {
                    try {
                        GameController.changeLevel(nextLevelPack, nextRating, nextLevelNumber, transitionState == TransitionState.LOAD_REPLAY);
                    }
                    catch (ResourceException ex) {
                        Core.resourceError(ex.getMessage());
                        return;
                    }
                    catch (LemmException ex) {
                        JOptionPane.showMessageDialog(LemminiFrame.getFrame(), ex.getMessage(), "Error", 0);
                        System.exit(1);
                    }
                    GameController.setTitle();
                    LemminiFrame.getFrame().setCursor(LemmCursor.CursorType.NORMAL);
                    break;
                }
            }
            if (transitionState == TransitionState.TO_LEVEL) {
                Fader.setStep(8);
            } else {
                Fader.setStep(15);
            }
            Fader.setState(Fader.State.IN);
            transitionState = TransitionState.NONE;
        } else {
            Fader.fade();
        }
        if (gameState == State.LEVEL_END || gameState == State.LEVEL && transitionState != TransitionState.NONE) {
            GameController.fadeSound(showBriefing);
        }
    }

    private static void setTitle() {
        if (gameState == State.INTRO) {
            Core.setTitle("RetroLemmini");
            return;
        }
        int numLemmings = level.getNumLemmings();
        String numToRescue = GameController.isOptionEnabled(Option.NO_PERCENTAGES) || numLemmings > 100 ? String.valueOf(level.getNumToRescue()) : String.valueOf(level.getNumToRescue() * 100 / numLemmings) + "%";
        String lemmingWord = numLemmings == 1 ? "Lemming" : "Lemmings";
        Core.setTitle(String.format("RetroLemmini - %s - %s %d - %s - Save %s of %d %s", GameController.getCurLevelPack().getName(), GameController.getCurLevelPack().getRatings().get(GameController.getCurRating()), curLevelNumber + 1, level.getLevelName().trim(), numToRescue, numLemmings, lemmingWord));
    }

    public static synchronized void drawExplosions(GraphicsContext g, int width, int height, int xOfs, int yOfs) {
        explosions.stream().forEachOrdered(e -> e.draw(g, width, height, xOfs, yOfs));
    }

    public static synchronized void addExplosion(int x, int y) {
        explosions.add(new Explosion(x, y));
    }

    public static synchronized void drawVisualSfx(GraphicsContext g) {
        vsfxs.stream().forEachOrdered(v -> {
            int vx = v.screenX();
            int vy = v.screenY();
            if (vx + v.width() > xPos && vx < xPos + Core.getDrawWidth() && vy + v.height() > yPos && vy < yPos + 320) {
                g.drawImage(v.getImage(), vx - xPos, vy - yPos);
            }
        });
    }

    public static synchronized void drawLemmings(GraphicsContext g) {
        lemmings.stream().forEachOrdered(l -> {
            LemmImage sel;
            LemmImage cd;
            int lx = l.screenX();
            int ly = l.screenY();
            int mx = l.midX();
            if (lx + l.width() > xPos && lx < xPos + Core.getDrawWidth() && ly + l.height() > yPos && ly < yPos + 320) {
                g.drawImage(l.getImage(), lx - xPos, ly - yPos);
            }
            if ((cd = l.getCountdown()) != null) {
                int x = mx - xPos - cd.getWidth() / 2;
                int y = ly - yPos - cd.getHeight();
                if (x + cd.getHeight() > 0 && x < Core.getDrawWidth() && y + cd.getHeight() > 0 && y < 320) {
                    g.drawImage(cd, x, y);
                }
            }
            if ((sel = l.getSelectImg()) != null) {
                int x = mx - xPos - sel.getWidth() / 2;
                int y = ly - yPos - sel.getHeight();
                if (x + sel.getHeight() > 0 && x < Core.getDrawWidth() && y + sel.getHeight() > 0 && y < 320) {
                    g.drawImage(sel, x, y);
                }
            }
        });
    }

    public static synchronized void drawMinimapLemmings(GraphicsContext g, int x, int y) {
        lemmings.stream().forEachOrdered(l -> {
            int lx = l.footX();
            int ly = l.footY();
            Minimap.drawLemming(g, x, y, lx, ly);
        });
    }

    public static void drawIconsAndCounters(GraphicsContext g, int iconsX, int iconsY, int countersX, int countersY) {
        GameController.drawIcons(g, iconsX, iconsY);
        GameController.drawCounters(g, countersX, countersY);
    }

    private static void drawIcons(GraphicsContext g, int x, int y) {
        Icons.Animate();
        g.drawImage(Icons.getImg(), x, y);
    }

    private static void drawCounters(GraphicsContext g, int x, int y) {
        Integer val = NumberUtils.INTEGER_ZERO;
        List<Icons.IconType> iconOrder = Icons.CurrentIconOrder();
        int i = 0;
        while (i < iconOrder.size()) {
            Icons.IconType type = iconOrder.get(i);
            switch (type) {
                case MINUS: {
                    val = level.getReleaseRate();
                    break;
                }
                case PLUS: {
                    val = lockReleaseRate ? null : Integer.valueOf(releaseRate);
                    break;
                }
                case CLIMB: {
                    val = numClimbers;
                    break;
                }
                case FLOAT: {
                    val = numFloaters;
                    break;
                }
                case BOMB: {
                    val = numBombers;
                    break;
                }
                case BLOCK: {
                    val = numBlockers;
                    break;
                }
                case BUILD: {
                    val = numBuilders;
                    break;
                }
                case BASH: {
                    val = numBashers;
                    break;
                }
                case MINE: {
                    val = numMiners;
                    break;
                }
                case DIG: {
                    val = numDiggers;
                    break;
                }
                default: {
                    val = 0;
                }
            }
            if (val == null || type == Icons.IconType.MINUS && type == Icons.IconType.PLUS || val.compareTo(NumberUtils.INTEGER_ZERO) > 0) {
                LemmImage numImage = NumFont.numImage(val);
                int centerX = x + Icons.getIconWidth() * i + Icons.getIconWidth() / 2;
                g.setColor(Color.BLACK);
                g.fillRect(centerX - 8, y, 16, 11);
                g.fillRect(centerX - 9, y + 1, 18, 9);
                g.drawImage(numImage, centerX - numImage.getWidth() / 2, y);
            }
            ++i;
        }
    }

    public static int getCurLevelPackIdx() {
        return curLevelPack;
    }

    public static LevelPack getCurLevelPack() {
        return levelPacks.get(curLevelPack);
    }

    public static int getLevelPackCount() {
        return levelPacks.size();
    }

    public static LevelPack getLevelPack(int i) {
        return levelPacks.get(i);
    }

    public static int getCurRating() {
        return curRating;
    }

    public static int getCurLevelNumber() {
        return curLevelNumber;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] addExternalLevel(Path lvlPath, LevelPack lp, boolean showErrors) {
        if (lp == null) {
            lp = levelPacks.get(0);
        }
        if (lvlPath == null) return null;
        try {
            block36: {
                String fNameStr = lvlPath.getFileName().toString();
                String fNameStrNoExt = FilenameUtils.removeExtension(fNameStr);
                try {
                    LevelFormat format = LevelFormat.valueOf(FilenameUtils.getExtension(fNameStr).toUpperCase(Locale.ROOT));
                    ExternalLevelEntry entry = new ExternalLevelEntry(format, lvlPath);
                    if (externalLevelList.contains(entry)) {
                        switch (format) {
                            case DAT: {
                                List<String> ratings = lp.getRatings();
                                ListIterator<String> lit = ratings.listIterator(1);
                                while (lit.hasNext()) {
                                    int i = lit.nextIndex();
                                    if (!lit.next().toLowerCase(Locale.ROOT).equals(fNameStrNoExt.toLowerCase(Locale.ROOT))) continue;
                                    int[] nArray = new int[3];
                                    nArray[1] = i;
                                    return nArray;
                                }
                                break;
                            }
                            case INI: 
                            case LVL: {
                                int numLevels = lp.getLevelCount(0);
                                int i = 0;
                                while (i < numLevels) {
                                    if (FilenameUtils.removeExtension(lp.getInfo(0, i).getLevelResource().getFileName().toLowerCase(Locale.ROOT)).equals(fNameStrNoExt.toLowerCase(Locale.ROOT))) {
                                        int[] nArray = new int[3];
                                        nArray[2] = i;
                                        return nArray;
                                    }
                                    ++i;
                                }
                                break;
                            }
                        }
                        break block36;
                    }
                    switch (format) {
                        case DAT: {
                            List<byte[]> levels = ExtractDAT.decompress(lvlPath);
                            if (levels.isEmpty()) {
                                if (!showErrors) return null;
                                JOptionPane.showMessageDialog(LemminiFrame.getFrame(), "DAT file is empty.", "Load Level", 0);
                                return null;
                            }
                            ArrayList<LevelInfo> liList = new ArrayList<LevelInfo>(levels.size());
                            ListIterator<byte[]> lit = levels.listIterator();
                            while (true) {
                                if (!lit.hasNext()) {
                                    lp.addRating(fNameStrNoExt, liList);
                                    externalLevelList.add(entry);
                                    GameController.saveExternalLevelList();
                                    int[] nArray = new int[3];
                                    nArray[1] = lp.getRatings().size() - 1;
                                    return nArray;
                                }
                                int i = lit.nextIndex();
                                String outName = "levels/$external/" + fNameStrNoExt + "_" + i + ".ini";
                                Throwable throwable = null;
                                Object var13_27 = null;
                                try (BufferedWriter w = Core.resourceTree.newBufferedWriter(outName, new OpenOption[0]);){
                                    ExtractLevel.convertLevel(lit.next(), String.valueOf(fNameStr.toLowerCase(Locale.ROOT)) + " (section " + i + ")", w, false, false);
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                        throw throwable;
                                    }
                                    if (throwable == throwable2) throw throwable;
                                    throwable.addSuppressed(throwable2);
                                    throw throwable;
                                }
                                LevelInfo li = new LevelInfo(new FileResource(outName, outName, Core.resourceTree), null);
                                if (!li.isValidLevel()) {
                                    return null;
                                }
                                liList.add(li);
                            }
                        }
                        case LVL: {
                            String outName = "levels/$external/" + fNameStrNoExt + ".ini";
                            Throwable i = null;
                            Object var11_22 = null;
                            try (BufferedWriter w = Core.resourceTree.newBufferedWriter("levels/$external/" + fNameStrNoExt + ".ini", new OpenOption[0]);){
                                ExtractLevel.convertLevel(lvlPath, w, false, false);
                            }
                            catch (Throwable throwable) {
                                if (i == null) {
                                    i = throwable;
                                    throw i;
                                }
                                if (i == throwable) throw i;
                                i.addSuppressed(throwable);
                                throw i;
                            }
                            lvlPath = Core.resourceTree.getPath(outName);
                        }
                        case INI: {
                            LevelInfo li = new LevelInfo(new FileResource(lvlPath), null);
                            if (!li.isValidLevel()) break;
                            lp.addLevel(0, li);
                            externalLevelList.add(entry);
                            GameController.saveExternalLevelList();
                            int[] nArray = new int[3];
                            nArray[2] = lp.getLevelCount(0) - 1;
                            return nArray;
                        }
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (!showErrors) return null;
            JOptionPane.showMessageDialog(LemminiFrame.getFrame(), "Wrong format!", "Load Level", 0);
            return null;
        }
        catch (Exception ex) {
            ToolBox.showException(ex);
        }
        return null;
    }

    public static void clearExternalLevelList() {
        externalLevelList.clear();
        levelPacks.set(0, new LevelPack());
        GameController.saveExternalLevelList();
    }

    private static void saveExternalLevelList() {
        int idx = 0;
        Props output = new Props();
        for (ExternalLevelEntry extLvl : externalLevelList) {
            output.set("level_" + idx++, extLvl.toString());
        }
        output.save("levels/$external/$levelcache.ini");
    }

    public static void setXPos(int x) {
        xPos = width < Core.getDrawWidth() ? (width - Core.getDrawWidth()) / 2 : (x >= width - Core.getDrawWidth() ? width - Core.getDrawWidth() : (x < 0 ? 0 : x));
    }

    public static void setYPos(int y) {
        yPos = height < 320 ? height - 320 : (y >= height - 320 ? height - 320 : (y < 0 ? 0 : y));
    }

    public static int getXPos() {
        return xPos;
    }

    public static int getYPos() {
        return yPos;
    }

    public static void setGameState(State s) {
        gameState = s;
    }

    public static State getGameState() {
        return gameState;
    }

    public static void advanceFrame() {
        forceAdvanceFrame = true;
    }

    public static void setTransition(TransitionState ts) {
        transitionState = ts;
    }

    public static ReplayLevelInfo loadReplay(Path fn) throws LemmException {
        return replay.load(fn);
    }

    public static boolean saveReplay(Path fn) {
        return replay.save(fn);
    }

    public static void setSuperLemming(boolean sl) {
        superLemming = sl;
    }

    public static boolean isSuperLemming() {
        return superLemming;
    }

    public static void setWasCheated(boolean c) {
        cheatWasActivated = c;
    }

    public static boolean getWasCheated() {
        return cheatWasActivated;
    }

    public static void setPaused(boolean p) {
        paused = p;
    }

    public static boolean isPaused() {
        return paused;
    }

    public static void setFastForward(boolean ff) {
        fastForward = ff;
    }

    public static void setTurbo(boolean t) {
        turbo = t;
    }

    public static boolean isFastForward() {
        return fastForward;
    }

    public static boolean isTurbo() {
        return turbo;
    }

    public static void setVerticalLock(boolean vl) {
        if (!GameController.needVLock()) {
            return;
        }
        verticalLock = vl;
    }

    public static boolean isVerticalLock() {
        return verticalLock;
    }

    public static int getNumExited() {
        return numExited;
    }

    public static void setNumExited(int n) {
        numExited = n;
    }

    public static Level getLevel() {
        return level;
    }

    public static int getNumLemmings() {
        return lemmings.size();
    }

    public static int getNumLemmingsMax() {
        return numLemmingsMax;
    }

    public static int getNumLemmingsPossibleMax() {
        return GameController.getNumLemmingsUnreleased() + GameController.getNumLemmings() + numExited;
    }

    public static int getNumLemmingsUnreleased() {
        return GameController.getNumLemmingsMax() - numLemmingsOut;
    }

    public static Icons.IconType getIconType(int x) {
        return Icons.getType(x);
    }

    public static void pressIcon(Icons.IconType t) {
        Icons.press(t);
    }

    public static void releaseIcon(Icons.IconType t) {
        Icons.release(t);
    }

    public static void pressPlus(int d) {
        GameController.stopReplayMode();
        plus.pressed(d);
    }

    public static void releasePlus(int d) {
        plus.released(d);
    }

    public static void pressMinus(int d) {
        GameController.stopReplayMode();
        minus.pressed(d);
    }

    public static void releaseMinus(int d) {
        minus.released(d);
    }

    public static int getNumLemmsUnderCursor() {
        return lemmsUnderCursor.size();
    }

    public static synchronized void updateLemmsUnderCursor() {
        lemmsUnderCursor.clear();
        lemmings.stream().forEachOrdered(l -> {
            int lx = l.screenX();
            int ly = l.screenY();
            if (lx + l.width() >= xPos && lx < xPos + Core.getDrawWidth() && ly + l.height() >= yPos && ly < yPos + 320 && LemmCursor.doesCollide(l, xPos, yPos)) {
                lemmsUnderCursor.add((Lemming)l);
            }
        });
    }

    public static List<Lemming> getLemmings() {
        return Collections.unmodifiableList(lemmings);
    }

    public static synchronized void addLemming(Lemming l) {
        lemmings.add(l);
    }

    public static List<Vsfx> getVsfx() {
        return Collections.unmodifiableList(vsfxs);
    }

    public static synchronized void addVsfx(Vsfx v) {
        vsfxs.add(v);
    }

    public static void setSoundGain(double g) {
        soundGain = g;
        if (sound != null) {
            sound.setGain(soundGain);
        }
        Core.programProps.setDouble("soundGain", g);
    }

    public static double getSoundGain() {
        return soundGain;
    }

    public static void setMusicGain(double g) {
        musicGain = g;
        if (Music.getType() != null) {
            Music.setGain(musicGain);
        }
        Core.programProps.setDouble("musicGain", g);
    }

    public static double getMusicGain() {
        return musicGain;
    }

    public static void resetGain() {
        if (sound != null) {
            sound.setGain(soundGain);
        }
        if (Music.getType() != null) {
            Music.setGain(musicGain);
        }
    }

    private static void fadeSound(boolean shouldFadeMusic) {
        if (sound != null) {
            sound.setGain(sound.getGain() - (double)Fader.getStep() / 255.0 * soundGain * 1.5);
        }
        if (Music.getType() != null && shouldFadeMusic) {
            Music.setGain(Music.getGain() - (double)Fader.getStep() / 255.0 * musicGain * 1.5);
        }
    }

    public static void setOption(Option option, boolean enable) {
        if (enable) {
            options.add(option);
        } else {
            options.remove((Object)option);
        }
        if (option == Option.NO_PERCENTAGES && gameState != null) {
            switch (gameState) {
                case BRIEFING: 
                case LEVEL: 
                case DEBRIEFING: 
                case LEVEL_END: {
                    GameController.setTitle();
                    break;
                }
            }
        }
    }

    public static boolean isOptionEnabled(Option option) {
        return options.contains((Object)option);
    }

    public static void setOption(SLTooOption option, boolean enable) {
        if (enable) {
            SLToptions.add(option);
        } else {
            SLToptions.remove((Object)option);
        }
        if (option == SLTooOption.ICON_LABELS && gameState != null) {
            Icons.redraw();
        } else if (option == SLTooOption.ENHANCED_ICONBAR && gameState != null) {
            try {
                Icons.LoadIconResources();
            }
            catch (ResourceException e) {
                System.out.println("error loading resources...");
            }
            Icons.redraw();
        }
    }

    public static boolean isOptionEnabled(SLTooOption option) {
        return SLToptions.contains((Object)option);
    }

    public static void setOption(RetroLemminiOption option, boolean enable) {
        if (enable) {
            RLoptions.add(option);
        } else {
            RLoptions.remove((Object)option);
        }
    }

    public static boolean isOptionEnabled(RetroLemminiOption option) {
        return RLoptions.contains((Object)option);
    }

    public static void setExitSoundOption(ExitSoundOption option) {
        exitSoundOption = option;
    }

    public static ExitSoundOption getExitSoundOption() {
        return exitSoundOption;
    }

    public static void setMenuThemeOption(MenuThemeOption option) {
        menuThemeOption = option;
    }

    public static MenuThemeOption getMenuThemeOption() {
        return menuThemeOption;
    }

    public static LemmImage getFgImage() {
        return fgImage;
    }

    public static Stencil getStencil() {
        return stencil;
    }

    public static LemmImage getMapPreview() {
        return mapPreview;
    }

    public static int getNumToRescue() {
        return numToRescue;
    }

    public static int getTime() {
        return time;
    }

    public static boolean isTimed() {
        return timed;
    }

    public static void setTimed(boolean isTimed) {
        timed = isTimed;
    }

    public static int getScore() {
        return numExited * 100 / numLemmingsMax * 100 + numClimbers + numFloaters + numBombers + numBlockers + numBuilders + numBashers + numMiners + numDiggers;
    }

    public static LevelRecord getLevelRecord() {
        if (!GameController.wasLost() && !cheatWasActivated) {
            return new LevelRecord(true, numExited, numSkillsUsed, timed ? timeLimit - timeElapsedTillLastExited : time, GameController.getScore());
        }
        return LevelRecord.BLANK_LEVEL_RECORD;
    }

    public static int getTimesFailed() {
        return timesFailed;
    }

    public static int getWidth() {
        return width;
    }

    public static int getHeight() {
        return height;
    }

    public static List<String> getModPaths() {
        return modPaths;
    }

    public static enum ExitSoundOption {
        YIPPEE,
        BOING,
        AUTO;

    }

    public static enum LevelFormat {
        INI,
        LVL,
        DAT;

    }

    public static enum MenuThemeOption {
        AMIGA,
        WINLEMM;

    }

    public static enum Option {
        MUSIC_ON,
        SOUND_ON,
        ADVANCED_SELECT,
        CLASSIC_CURSOR,
        SWAP_BUTTONS,
        FASTER_FAST_FORWARD,
        PAUSE_STOPS_FAST_FORWARD,
        NO_PERCENTAGES,
        REPLAY_SCROLL,
        UNPAUSE_ON_ASSIGNMENT;

    }

    public static enum RetroLemminiOption {
        AUTOSAVE_REPLAYS,
        SHOW_MENU_BAR,
        FULL_COLOR_MINIMAP;

    }

    public static enum SLTooOption {
        TIMED_BOMBERS,
        UNLOCK_ALL_LEVELS,
        DISABLE_SCROLL_WHEEL,
        DISABLE_FRAME_STEPPING,
        VISUAL_SFX,
        ENHANCED_STATUS,
        SHOW_LEVEL_NAME,
        ENHANCED_ICONBAR,
        ICON_LABELS,
        ANIMATED_ICONS,
        CLASSIC_SCROLLER,
        DEBUG_VERBOSE_PLAYER_LOAD;

    }

    public static enum State {
        INIT,
        INTRO,
        BRIEFING,
        LEVEL,
        DEBRIEFING,
        LEVEL_END;

    }

    public static enum TransitionState {
        NONE,
        RESTART_LEVEL,
        REPLAY_LEVEL,
        REPLAY_LEVEL_NO_BRIEFING,
        LOAD_LEVEL,
        LOAD_REPLAY,
        END_LEVEL,
        TO_INTRO,
        TO_BRIEFING,
        TO_DEBRIEFING,
        TO_LEVEL;

    }
}

