/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import lemmini.game.Resource;
import lemmini.tools.CaseInsensitiveFileTree;
import lemmini.tools.ToolBox;
import org.apache.commons.io.FilenameUtils;

public class FileResource
implements Resource {
    private final String origPath;
    private final String realPath;
    private final CaseInsensitiveFileTree tree;
    private final Path file;

    public FileResource(Path file) throws IOException {
        this.realPath = this.origPath = FilenameUtils.separatorsToUnix(file.toString());
        this.tree = new CaseInsensitiveFileTree(file.getParent(), 1);
        this.file = file;
    }

    public FileResource(String origPath, CaseInsensitiveFileTree tree) {
        this(origPath, origPath, tree);
    }

    public FileResource(String origPath, String realPath, CaseInsensitiveFileTree tree) {
        this.origPath = origPath;
        this.realPath = realPath;
        this.tree = tree;
        this.file = tree.getPath(realPath);
    }

    @Override
    public boolean exists() {
        return Files.isRegularFile(this.file, new LinkOption[0]);
    }

    @Override
    public String getFileName() {
        return this.file.getFileName().toString();
    }

    @Override
    public String getOriginalPath() {
        return this.origPath;
    }

    @Override
    public FileResource getSibling(String sibling) {
        String newOrigPath = String.valueOf(ToolBox.getParent(this.origPath)) + sibling;
        String newRealPath = String.valueOf(ToolBox.getParent(this.realPath)) + sibling;
        return new FileResource(newOrigPath, newRealPath, this.tree);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return Files.newInputStream(this.file, new OpenOption[0]);
    }

    @Override
    public BufferedReader getBufferedReader() throws IOException {
        return ToolBox.getBufferedReader(this.file);
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return Files.readAllBytes(this.file);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileResource)) {
            return false;
        }
        FileResource res2 = (FileResource)o;
        return this.file.equals(res2.file);
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + Objects.hashCode(this.file);
        return hash;
    }
}

