/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Color;
import lemmini.game.Core;
import lemmini.game.GameController;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;

public class Explosion {
    private static final int PARTICLE_NUM = 24;
    private static final double MAX_DX = 1.5;
    private static final double MIN_DX = -1.5;
    private static final double MAX_DY = 1.0;
    private static final double MIN_DY = -4.0;
    private static final int LIFE_COUNTER = 64;
    private static final int LIFE_VARIANCE = 16;
    private static final double GRAVITY = 0.1;
    private static final int REMOVE_IMAGE_CTR = 2;
    private static final int PARTICLE_SIZE = 2;
    private final Particle[] particles;
    private int counter;
    private final int xExp;
    private final int yExp;
    private int maxCounter;
    private boolean finished;
    private static LemmImage expImg;

    static void init() throws ResourceException {
        Resource resource = Core.findResource("gfx/misc/explode.png", Core.IMAGE_EXTENSIONS);
        expImg = Core.loadLemmImage(resource);
    }

    public Explosion(int x, int y) {
        this.xExp = x - expImg.getWidth() / 2;
        this.yExp = y - expImg.getHeight() / 2;
        this.maxCounter = 0;
        this.particles = new Particle[24];
        int i = 0;
        while (i < this.particles.length) {
            double dx = Math.random() * 3.0 + -1.5;
            double dy = Math.random() * 5.0 + -4.0;
            int color = GameController.getLevel().getParticleCol()[(int)(Math.random() * (double)GameController.getLevel().getParticleCol().length)];
            int lifeCtr = 64 + (int)(Math.random() * 2.0 * 16.0) - 16;
            if (lifeCtr > this.maxCounter) {
                this.maxCounter = lifeCtr;
            }
            this.particles[i] = new Particle(x, y, dx, dy, color, lifeCtr);
            ++i;
        }
        this.counter = 0;
        this.finished = false;
    }

    public void update() {
        if (this.counter > 2) {
            int i = 0;
            while (i < this.particles.length) {
                Particle p = this.particles[i];
                if (p != null) {
                    p.x += p.dx;
                    p.y += p.dy + (double)this.counter * 0.1;
                    if (p.lifeCtr > 0) {
                        --p.lifeCtr;
                    } else {
                        this.particles[i] = null;
                    }
                }
                ++i;
            }
        }
        if (++this.counter > this.maxCounter) {
            this.finished = true;
        }
    }

    public void draw(GraphicsContext g, int width, int height, int xOfs, int yOfs) {
        if (!this.finished) {
            int maxY = height - 1;
            int maxX = width - 1;
            if (this.counter <= 2) {
                int x = this.xExp - xOfs;
                int y = this.yExp - yOfs;
                if (x + expImg.getWidth() > 0 && x <= maxX && y + expImg.getHeight() > 0 && y <= maxY) {
                    g.drawImage(expImg, x, y);
                }
            } else {
                Particle[] particleArray = this.particles;
                int n = this.particles.length;
                int n2 = 0;
                while (n2 < n) {
                    Particle p = particleArray[n2];
                    if (p != null) {
                        int x = (int)p.x - xOfs;
                        int y = (int)p.y - yOfs;
                        if (x + 2 > 0 && x <= maxX && y + 2 > 0 && y <= maxY) {
                            g.setColor(p.color);
                            g.fillRect(x, y, 2, 2);
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    private class Particle {
        double x;
        double y;
        double dx;
        double dy;
        Color color;
        int lifeCtr;

        Particle(double x0, double y0, double dx0, double dy0, int col, int lCtr) {
            this.x = x0;
            this.y = y0;
            this.dx = dx0;
            this.dy = dy0;
            this.color = new Color(col);
            this.lifeCtr = lCtr;
        }
    }
}

