/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import lemmini.LemminiFrame;
import lemmini.game.FileResource;
import lemmini.game.GameController;
import lemmini.game.LemmException;
import lemmini.game.Player;
import lemmini.game.Resource;
import lemmini.game.ResourceException;
import lemmini.game.TextScreen;
import lemmini.graphics.LemmImage;
import lemmini.gui.LegalFrame;
import lemmini.tools.CaseInsensitiveFileTree;
import lemmini.tools.Props;
import lemmini.tools.ToolBox;
import org.apache.commons.io.FilenameUtils;

public class Core {
    public static final String REVISION = "2.3";
    public static final String COMMIT_ID = "611ee17ebb3a6c2f01d742079de6aa5d617df467";
    public static final String REV_DATE = "March 2025";
    public static final String STYLES_REVISION = "2.1";
    public static final String[] LEVEL_EXTENSIONS = new String[]{"ini", "lvl", "dat"};
    public static final String[] REPLAY_EXTENSIONS = new String[]{"rpl"};
    public static final String[] IMAGE_EXTENSIONS = new String[]{"png", "bmp", "gif", "jpg", "wbmp"};
    public static final String[] MUSIC_EXTENSIONS = new String[]{"wav", "aiff", "aifc", "au", "snd", "ogg", "xm", "s3m", "mod", "mid"};
    public static final String[] SOUNDBANK_EXTENSIONS = new String[]{"sf2", "dls"};
    public static final String[] SOUND_EXTENSIONS = new String[]{"wav", "aiff", "aifc", "au", "snd"};
    public static final String EXTERNAL_LEVEL_CACHE_PATH = "levels/$external/";
    public static final String MODS_PATH = "mods/";
    public static final String MUSIC_PATH = "music/";
    public static final String REPLAYS_PATH = "replays/";
    public static final String SOUND_PATH = "sound/";
    public static final String STYLES_PATH = "styles/";
    public static final String TEMP_PATH = "temp/";
    public static final Path[] EMPTY_PATH_ARRAY = new Path[0];
    private static final String PROGRAM_PROPS_FILE_NAME = "retrolemmini_settings.ini";
    private static final String PLAYER_PROPS_FILE_NAME = "players.ini";
    public static final Set<String> OG_STYLES = new HashSet<String>(Arrays.asList("brick", "bubble", "crystal", "dirt", "fire", "marble", "pillar", "rock", "snow", "xmas"));
    public static Props programProps;
    private static Path programPropsFilePath;
    private static Path playerPropsFilePath;
    public static Path settingsPath;
    public static Path resourcePath;
    public static Path gamePath;
    public static CaseInsensitiveFileTree settingsTree;
    public static CaseInsensitiveFileTree resourceTree;
    public static Player player;
    private static Props playerProps;
    private static List<String> players;
    private static double scale;
    private static boolean bilinear;
    private static int drawWidth;
    private static int drawHeight;

    static {
        scale = 1.0;
    }

    public static boolean init(String workingFolder) throws LemmException, IOException {
        System.out.println("\ninitializing Core...");
        String tmp = new File(workingFolder).getPath();
        gamePath = Paths.get(tmp, new String[0]);
        System.out.println("    gamePath detected as: " + gamePath.toString());
        settingsPath = gamePath.toString().endsWith(".jar") ? Paths.get(gamePath.getParent().toString(), "settings") : Paths.get(gamePath.toString(), "settings");
        System.out.println("      settingsPath: " + settingsPath.toString());
        settingsTree = new CaseInsensitiveFileTree(settingsPath);
        System.out.println("    creating players folder: " + Paths.get(settingsTree.getRoot().toString(), "players/").toString());
        settingsTree.createDirectories("players/", new FileAttribute[0]);
        programPropsFilePath = settingsPath.resolve(PROGRAM_PROPS_FILE_NAME);
        playerPropsFilePath = settingsPath.resolve(PLAYER_PROPS_FILE_NAME);
        System.out.println("    game config: " + programPropsFilePath.toString());
        System.out.println("    player data: " + playerPropsFilePath.toString());
        programProps = new Props();
        if (!programProps.load(programPropsFilePath)) {
            System.out.println("    unable to read config file... prompting disclaimer agreement ...");
            LegalFrame ld = new LegalFrame();
            ld.setVisible(true);
            ld.waitUntilClosed();
            if (!ld.isOK()) {
                System.out.println("    user declined agreement. quitting...");
                return false;
            }
            System.out.println("    user agreed");
        } else {
            System.out.println("    config file read successfully");
        }
        resourcePath = gamePath.toString().endsWith(".jar") ? Paths.get(gamePath.getParent().toString(), "resources") : Paths.get(gamePath.toString(), "resources");
        System.out.println("      resourcePath: " + resourcePath.toString());
        resourceTree = new CaseInsensitiveFileTree(resourcePath);
        bilinear = programProps.getBoolean("bilinear", true);
        GameController.setOption(GameController.Option.MUSIC_ON, programProps.getBoolean("music", true));
        GameController.setOption(GameController.Option.SOUND_ON, programProps.getBoolean("sound", true));
        GameController.setMusicGain(programProps.getDouble("musicGain", 1.0));
        GameController.setSoundGain(programProps.getDouble("soundGain", 1.0));
        GameController.setOption(GameController.Option.ADVANCED_SELECT, programProps.getBoolean("advancedSelect", true));
        GameController.setOption(GameController.Option.CLASSIC_CURSOR, programProps.getBoolean("classicalCursor", false));
        GameController.setOption(GameController.Option.SWAP_BUTTONS, programProps.getBoolean("swapButtons", false));
        GameController.setOption(GameController.Option.FASTER_FAST_FORWARD, programProps.getBoolean("fasterFastForward", false));
        GameController.setOption(GameController.Option.PAUSE_STOPS_FAST_FORWARD, programProps.getBoolean("pauseStopsFastForward", true));
        GameController.setOption(GameController.Option.NO_PERCENTAGES, programProps.getBoolean("noPercentages", true));
        GameController.setOption(GameController.Option.REPLAY_SCROLL, programProps.getBoolean("replayScroll", true));
        GameController.setOption(GameController.Option.UNPAUSE_ON_ASSIGNMENT, programProps.getBoolean("unpauseOnAssignment", true));
        GameController.setOption(GameController.SLTooOption.TIMED_BOMBERS, programProps.getBoolean("timedBombers", true));
        GameController.setOption(GameController.SLTooOption.UNLOCK_ALL_LEVELS, programProps.getBoolean("unlockAllLevels", true));
        GameController.setOption(GameController.SLTooOption.DISABLE_SCROLL_WHEEL, programProps.getBoolean("disableScrollWheel", true));
        GameController.setOption(GameController.SLTooOption.DISABLE_FRAME_STEPPING, programProps.getBoolean("disableFrameStepping", true));
        GameController.setOption(GameController.SLTooOption.VISUAL_SFX, programProps.getBoolean("visualSFX", true));
        GameController.setOption(GameController.SLTooOption.ENHANCED_STATUS, programProps.getBoolean("enhancedStatus", true));
        GameController.setOption(GameController.SLTooOption.SHOW_LEVEL_NAME, programProps.getBoolean("showLevelName", true));
        GameController.setOption(GameController.SLTooOption.ENHANCED_ICONBAR, programProps.getBoolean("enhancedIconBar", true));
        GameController.setOption(GameController.SLTooOption.ICON_LABELS, programProps.getBoolean("iconLabels", false));
        GameController.setOption(GameController.SLTooOption.ANIMATED_ICONS, programProps.getBoolean("animatedIcons", true));
        GameController.setOption(GameController.SLTooOption.CLASSIC_SCROLLER, programProps.getBoolean("classicScroller", true));
        GameController.setOption(GameController.SLTooOption.DEBUG_VERBOSE_PLAYER_LOAD, programProps.getBoolean("debugVerbosePlayerLoad", false));
        GameController.setOption(GameController.RetroLemminiOption.AUTOSAVE_REPLAYS, programProps.getBoolean("autoSaveReplays", false));
        GameController.setOption(GameController.RetroLemminiOption.SHOW_MENU_BAR, programProps.getBoolean("showMenuBar", true));
        GameController.setOption(GameController.RetroLemminiOption.FULL_COLOR_MINIMAP, programProps.getBoolean("fullColorMinimap", true));
        GameController.setExitSoundOption(GameController.ExitSoundOption.valueOf(programProps.get("exitSound", "AUTO")));
        GameController.setMenuThemeOption(GameController.MenuThemeOption.valueOf(programProps.get("menuTheme", "WINLEMM")));
        System.out.println("      all settings read from config");
        if (resourcePath.toString().isEmpty()) {
            if (resourcePath.toString().isEmpty()) {
                System.out.println("    resourcePath is invalid...");
            }
            System.out.println("    quitting...");
            throw new LemmException(String.format("Resources folder is missing from " + gamePath + ". The program will now quit.", null));
        }
        System.out.println("    creating levels folder (with external levels cache): " + Paths.get(resourceTree.getRoot().toString(), EXTERNAL_LEVEL_CACHE_PATH).toString());
        resourceTree.createDirectories(EXTERNAL_LEVEL_CACHE_PATH, new FileAttribute[0]);
        System.out.println("    creating mods folder: " + Paths.get(resourceTree.getRoot().toString(), MODS_PATH).toString());
        resourceTree.createDirectories(MODS_PATH, new FileAttribute[0]);
        System.out.println("    creating music folder: " + Paths.get(resourceTree.getRoot().toString(), MUSIC_PATH).toString());
        resourceTree.createDirectories(MUSIC_PATH, new FileAttribute[0]);
        System.out.println("    creating music folder: " + Paths.get(resourceTree.getRoot().toString(), MUSIC_PATH).toString());
        resourceTree.createDirectories(REPLAYS_PATH, new FileAttribute[0]);
        System.out.println("    creating sound folder: " + Paths.get(resourceTree.getRoot().toString(), SOUND_PATH).toString());
        resourceTree.createDirectories(SOUND_PATH, new FileAttribute[0]);
        System.out.println("    creating styles folder: " + Paths.get(resourceTree.getRoot().toString(), STYLES_PATH).toString());
        resourceTree.createDirectories(STYLES_PATH, new FileAttribute[0]);
        System.out.println("    creating temp folder: " + Paths.get(resourceTree.getRoot().toString(), TEMP_PATH).toString());
        resourceTree.createDirectories(TEMP_PATH, new FileAttribute[0]);
        System.gc();
        System.out.println("    loading player settings...");
        Core.loadPlayerSettings();
        System.out.println("    validating default styles...");
        Core.validateDefaultStyles();
        System.out.println("Core initialization complete.");
        return true;
    }

    private static void loadPlayerSettings() {
        String p;
        playerProps = new Props();
        playerProps.load(playerPropsFilePath);
        String defaultPlayer = playerProps.get("defaultPlayer", "default");
        players = new ArrayList<String>(16);
        int idx = 0;
        while (!(p = playerProps.get("player_" + idx, "")).isEmpty()) {
            players.add(p);
            ++idx;
        }
        if (players.isEmpty()) {
            players.add("default");
            playerProps.set("player_0", "default");
        }
        player = new Player(defaultPlayer);
    }

    public static void saveSettings() {
        programProps.setBoolean("music", GameController.isOptionEnabled(GameController.Option.MUSIC_ON));
        programProps.setBoolean("sound", GameController.isOptionEnabled(GameController.Option.SOUND_ON));
        programProps.set("mixerName", GameController.sound.getMixers()[GameController.sound.getMixerIdx()]);
        programProps.setBoolean("bilinear", Core.isBilinear());
        programProps.setBoolean("advancedSelect", GameController.isOptionEnabled(GameController.Option.ADVANCED_SELECT));
        programProps.setBoolean("classicalCursor", GameController.isOptionEnabled(GameController.Option.CLASSIC_CURSOR));
        programProps.setBoolean("swapButtons", GameController.isOptionEnabled(GameController.Option.SWAP_BUTTONS));
        programProps.setBoolean("fasterFastForward", GameController.isOptionEnabled(GameController.Option.FASTER_FAST_FORWARD));
        programProps.setBoolean("pauseStopsFastForward", GameController.isOptionEnabled(GameController.Option.PAUSE_STOPS_FAST_FORWARD));
        programProps.setBoolean("noPercentages", GameController.isOptionEnabled(GameController.Option.NO_PERCENTAGES));
        programProps.setBoolean("replayScroll", GameController.isOptionEnabled(GameController.Option.REPLAY_SCROLL));
        programProps.setBoolean("unpauseOnAssignment", GameController.isOptionEnabled(GameController.Option.UNPAUSE_ON_ASSIGNMENT));
        programProps.setBoolean("timedBombers", GameController.isOptionEnabled(GameController.SLTooOption.TIMED_BOMBERS));
        programProps.setBoolean("unlockAllLevels", GameController.isOptionEnabled(GameController.SLTooOption.UNLOCK_ALL_LEVELS));
        programProps.setBoolean("disableScrollWheel", GameController.isOptionEnabled(GameController.SLTooOption.DISABLE_SCROLL_WHEEL));
        programProps.setBoolean("disableFrameStepping", GameController.isOptionEnabled(GameController.SLTooOption.DISABLE_FRAME_STEPPING));
        programProps.setBoolean("visualSFX", GameController.isOptionEnabled(GameController.SLTooOption.VISUAL_SFX));
        programProps.setBoolean("enhancedStatus", GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_STATUS));
        programProps.setBoolean("showLevelName", GameController.isOptionEnabled(GameController.SLTooOption.SHOW_LEVEL_NAME));
        programProps.setBoolean("enhancedIconBar", GameController.isOptionEnabled(GameController.SLTooOption.ENHANCED_ICONBAR));
        programProps.setBoolean("iconLabels", GameController.isOptionEnabled(GameController.SLTooOption.ICON_LABELS));
        programProps.setBoolean("animatedIcons", GameController.isOptionEnabled(GameController.SLTooOption.ANIMATED_ICONS));
        programProps.setBoolean("classicScroller", GameController.isOptionEnabled(GameController.SLTooOption.CLASSIC_SCROLLER));
        programProps.setBoolean("debugVerbosePlayerLoad", GameController.isOptionEnabled(GameController.SLTooOption.DEBUG_VERBOSE_PLAYER_LOAD));
        programProps.setBoolean("autoSaveReplays", GameController.isOptionEnabled(GameController.RetroLemminiOption.AUTOSAVE_REPLAYS));
        programProps.setBoolean("showMenuBar", GameController.isOptionEnabled(GameController.RetroLemminiOption.SHOW_MENU_BAR));
        programProps.setBoolean("fullColorMinimap", GameController.isOptionEnabled(GameController.RetroLemminiOption.FULL_COLOR_MINIMAP));
        programProps.set("exitSound", GameController.getExitSoundOption().name());
        programProps.set("menuTheme", GameController.getMenuThemeOption().name());
        programProps.save(programPropsFilePath, false);
    }

    public static void validateDefaultStyles() {
        ArrayList<String> outdatedStyles = new ArrayList<String>();
        for (String style : OG_STYLES) {
            File iniFile = new File(resourcePath + "/styles/" + style + "/" + style + ".ini");
            if (!iniFile.exists()) {
                outdatedStyles.add(String.valueOf(style) + " (missing .ini file)");
                continue;
            }
            String version = null;
            boolean foundRevision = false;
            try {
                Throwable throwable = null;
                Object var7_9 = null;
                try (BufferedReader reader = new BufferedReader(new FileReader(iniFile));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!line.startsWith("revision = ")) continue;
                        version = line.split("=")[1].trim();
                        foundRevision = true;
                        break;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                System.err.println("Error reading file: " + iniFile.getAbsolutePath());
                outdatedStyles.add(String.valueOf(style) + " (error reading file)");
                continue;
            }
            if (version != null && foundRevision && version.equals(STYLES_REVISION)) continue;
            outdatedStyles.add(style);
        }
        if (!outdatedStyles.isEmpty()) {
            StringBuilder message = new StringBuilder("Warning: The following styles are out of date:\n\n");
            for (String outdatedStyle : outdatedStyles) {
                message.append(" \u2022 ").append(outdatedStyle).append("\n");
            }
            message.append("\nRetroLemmini will run, but there may be some compatibility issues with these styles.\n\nTo get the latest version of these styles, please download RetroLemmini 2.3\nand replace each outdated style with the updated version.\n");
            JOptionPane.showMessageDialog(null, message.toString(), "Outdated Styles", 2);
            System.out.println("    validation complete. The following styles are out of date:\n     " + outdatedStyles);
        } else {
            System.out.println("    validation complete. All styles are up to date.");
        }
    }

    public static String appendBeforeExtension(String fname, String suffix) {
        String extension = FilenameUtils.getExtension(fname);
        if (extension.isEmpty()) {
            return String.valueOf(FilenameUtils.removeExtension(fname)) + suffix;
        }
        return String.valueOf(FilenameUtils.removeExtension(fname)) + suffix + "." + extension;
    }

    public static Resource findResource(String fname, boolean searchMods) throws ResourceException {
        String originalExt = FilenameUtils.getExtension(fname);
        return Core.findResource(fname, searchMods, true, originalExt);
    }

    public static Resource findResource(String fname, String ... extensions) throws ResourceException {
        return Core.findResource(fname, true, true, extensions);
    }

    public static Resource findResource(String fname, boolean searchMods, String ... extensions) throws ResourceException {
        return Core.findResource(fname, searchMods, true, extensions);
    }

    public static Resource findResource(String fname, boolean searchMods, boolean searchMain, String ... extensions) throws ResourceException {
        Resource rslt = Core.findResourceEx(fname, searchMods, searchMain, extensions);
        if (rslt == null) {
            throw new ResourceException(fname);
        }
        return rslt;
    }

    public static Resource findResourceEx(String fname, boolean searchMods, boolean searchMain, String ... extensions) throws ResourceException {
        String fnameNoExt = FilenameUtils.removeExtension(fname);
        if (searchMods) {
            HashMap<String, String> legacyFileMap = new HashMap<String, String>();
            legacyFileMap.put("gfx/menu/background_main_amiga", "gfx/misc/background_main");
            legacyFileMap.put("gfx/menu/background_main_retro", "gfx/misc/background_main");
            legacyFileMap.put("gfx/menu/background_level_amiga", "gfx/misc/background_level");
            legacyFileMap.put("gfx/menu/background_level_retro", "gfx/misc/background_level");
            HashMap<String, String> overrideFileMap = new HashMap<String, String>();
            overrideFileMap.put("gfx/menu/background_main_amiga", "gfx/menu/background_main");
            overrideFileMap.put("gfx/menu/background_main_retro", "gfx/menu/background_main");
            overrideFileMap.put("gfx/menu/background_level_amiga", "gfx/menu/background_level");
            overrideFileMap.put("gfx/menu/background_level_retro", "gfx/menu/background_level");
            for (String mod : GameController.getModPaths()) {
                String[] stringArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    String legacyResString;
                    String overrideResString;
                    String ext = stringArray[n2];
                    String resString = String.valueOf(mod) + "/" + fnameNoExt + "." + ext;
                    if (resourceTree.exists(resString)) {
                        return new FileResource(fname, resString, resourceTree);
                    }
                    if (overrideFileMap.containsKey(fnameNoExt) && resourceTree.exists(overrideResString = String.valueOf(mod) + "/" + (String)overrideFileMap.get(fnameNoExt) + "." + ext)) {
                        return new FileResource(fname, overrideResString, resourceTree);
                    }
                    if (legacyFileMap.containsKey(fnameNoExt) && resourceTree.exists(legacyResString = String.valueOf(mod) + "/" + (String)legacyFileMap.get(fnameNoExt) + "." + ext)) {
                        return new FileResource(fname, legacyResString, resourceTree);
                    }
                    ++n2;
                }
            }
        }
        if (searchMain) {
            String[] stringArray = extensions;
            int n = extensions.length;
            int n3 = 0;
            while (n3 < n) {
                String ext = stringArray[n3];
                String resString = String.valueOf(fnameNoExt) + "." + ext;
                if (resourceTree.exists(resString)) {
                    return new FileResource(fname, resString, resourceTree);
                }
                ++n3;
            }
        }
        return null;
    }

    public static List<String> searchForResources(String folder, boolean searchMods, String ... extensions) {
        LinkedHashSet resources = new LinkedHashSet(64);
        if (searchMods) {
            GameController.getModPaths().stream().forEachOrdered(mod -> {
                String lowercasePath = (MODS_PATH + mod + "/" + folder).toLowerCase(Locale.ROOT);
                resourceTree.getAllPathsRegex(String.valueOf(ToolBox.literalToRegex(lowercasePath)) + "[^/]+").stream().map(file -> file.getFileName().toString()).filter(fileName -> FilenameUtils.isExtension(fileName.toLowerCase(Locale.ROOT), extensions)).forEachOrdered(resources::add);
            });
        }
        String lowercasePath = folder.toLowerCase(Locale.ROOT);
        resourceTree.getAllPathsRegex(String.valueOf(ToolBox.literalToRegex(lowercasePath)) + "[^/]+").stream().map(file -> file.getFileName().toString()).filter(fileName -> FilenameUtils.isExtension(fileName.toLowerCase(Locale.ROOT), extensions)).forEachOrdered(resources::add);
        return new ArrayList<String>(resources);
    }

    public static void setTitle(String title) {
        LemminiFrame.getFrame().setTitle(title);
    }

    public static void saveProgramProps() {
        programProps.save(programPropsFilePath, true);
        playerProps.set("defaultPlayer", player.getName());
        player.store();
    }

    public static void resourceError(String rsrc) {
        String message = String.format("Missing resource:<br><br>resources/%s<br><br>Please visit <a href='https://www.lemmingsforums.net/index.php?msg=105737'>this help topic</a> on the Lemmings Forums for help.", rsrc);
        JEditorPane pane = new JEditorPane("text/html", "<html><body style='font-family:sans-serif;'>" + message + "</body></html>");
        pane.setEditable(false);
        pane.setOpaque(false);
        pane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JOptionPane.showMessageDialog(null, pane, "Error", 0);
        Core.returnToMainMenu();
    }

    public static void musicResourceError(String rsrc) {
        String message = String.format("Missing music resource:<br><br>resources/music/%s<br><br>No music will play for this level.<br><br>Please visit <a href='https://www.lemmingsforums.net/index.php?msg=105737'>this help topic</a> on the Lemmings Forums for help.", rsrc);
        JEditorPane pane = new JEditorPane("text/html", "<html><body style='font-family:sans-serif;'>" + message + "</body></html>");
        pane.setEditable(false);
        pane.setOpaque(false);
        pane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JOptionPane.showMessageDialog(null, pane, "Error", 0);
    }

    public static void returnToMainMenu() {
        GameController.setTransition(GameController.TransitionState.TO_INTRO);
        TextScreen.initIntro();
    }

    public static LemmImage loadLemmImage(Resource resource) throws ResourceException {
        BufferedImage img = null;
        if (resource != null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream in = resource.getInputStream();){
                    img = ImageIO.read(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                img = null;
            }
        }
        if (img == null) {
            throw new ResourceException(resource);
        }
        return new LemmImage(img);
    }

    public static LemmImage loadLemmImageJar(String fname) throws ResourceException {
        BufferedImage img;
        try {
            img = ImageIO.read(ToolBox.findFile(fname));
        }
        catch (IOException ex) {
            throw new ResourceException(fname);
        }
        return new LemmImage(img);
    }

    public static String getPlayer(int idx) {
        return players.get(idx);
    }

    public static int getPlayerCount() {
        if (players == null) {
            return 0;
        }
        return players.size();
    }

    public static void deletePlayer(int idx) {
        Player.deletePlayerINIFile(players.get(idx));
        players.remove(idx);
    }

    public static void clearPlayers() {
        players.clear();
        playerProps.clear();
    }

    public static void addPlayer(String name) {
        players.add(name);
        playerProps.set("player_" + (players.size() - 1), name);
    }

    public static int getDrawWidth() {
        return drawWidth;
    }

    public static int getScaledDrawWidth() {
        return scale == 1.0 ? drawWidth : (int)Math.ceil((double)drawWidth * scale);
    }

    public static int getDrawHeight() {
        return drawHeight;
    }

    public static int getScaledDrawHeight() {
        return scale == 1.0 ? drawHeight : (int)Math.ceil((double)drawHeight * scale);
    }

    public static void setDrawSize(int w, int h) {
        drawWidth = w;
        drawHeight = h;
    }

    public static double getScale() {
        return scale;
    }

    public static void setScale(double s) {
        scale = s;
    }

    public static int scale(int n) {
        return ToolBox.scale(n, scale);
    }

    public static int unscale(int n) {
        return ToolBox.unscale(n, scale);
    }

    public static boolean isBilinear() {
        return bilinear;
    }

    public static void setBilinear(boolean b) {
        bilinear = b;
    }

    public static Path getProgramPropsFilePath() {
        return programPropsFilePath;
    }

    public static void setProgramPropsFilePath(Path programPropsFilePath) {
        Core.programPropsFilePath = programPropsFilePath;
    }
}

