/*
 * Decompiled with CFR 0.152.
 */
package lemmini.game;

import lemmini.game.TextScreen;
import lemmini.graphics.GraphicsContext;
import lemmini.graphics.LemmImage;

class Button {
    private final int x;
    private final int y;
    protected int width;
    protected int height;
    protected TextScreen.Button type;
    protected boolean selected;
    public boolean pressed;
    protected LemmImage image;
    protected LemmImage imgSelected;
    protected LemmImage imgPressed;

    Button(int xi, int yi, TextScreen.Button typei) {
        this.x = xi;
        this.y = yi;
        this.type = typei;
        this.width = 0;
        this.height = 0;
        this.selected = false;
        this.pressed = false;
        this.image = null;
        this.imgSelected = null;
        this.imgSelected = null;
    }

    void SetImage(LemmImage img) {
        this.image = img;
        if (this.image.getHeight() > this.height) {
            this.height = this.image.getHeight();
        }
        if (this.image.getWidth() > this.width) {
            this.width = this.image.getWidth();
        }
    }

    void SetImageSelected(LemmImage img) {
        this.imgSelected = img;
        if (this.imgSelected.getHeight() > this.height) {
            this.height = this.imgSelected.getHeight();
        }
        if (this.imgSelected.getWidth() > this.width) {
            this.width = this.imgSelected.getWidth();
        }
    }

    void SetImagePressed(LemmImage img) {
        this.imgPressed = img;
        if (this.imgPressed.getHeight() > this.height) {
            this.height = this.imgPressed.getHeight();
        }
        if (this.imgPressed.getWidth() > this.width) {
            this.width = this.imgPressed.getWidth();
        }
    }

    LemmImage getImage() {
        if (this.pressed) {
            return this.imgPressed;
        }
        if (this.selected) {
            return this.imgSelected;
        }
        return this.image;
    }

    void draw(GraphicsContext g, int cx, int cy) {
        LemmImage img = this.getImage();
        if (img != null) {
            g.drawImage(this.getImage(), cx + this.x, cy + this.y);
        }
    }

    boolean inside(int xi, int yi) {
        return xi >= this.x && xi < this.x + this.width && yi >= this.y && yi < this.y + this.height;
    }
}

