/*
 * Decompiled with CFR 0.152.
 */
package lemmini.extract;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.BooleanUtils;

class Terrain {
    static final int FLAG_ROTATE = 128;
    static final int FLAG_NO_ONE_WAY = 64;
    static final int FLAG_FLIP_HORIZONTALLY = 32;
    static final int FLAG_NO_OVERWRITE = 8;
    static final int FLAG_UPSIDE_DOWN = 4;
    static final int FLAG_ERASE = 2;
    int id;
    long xPos;
    long yPos;
    int modifier;
    int styleIndex;
    boolean exists;
    byte byte3Value;

    Terrain(byte[] b, double scale, boolean classic, int format) throws Exception {
        switch (format) {
            case 0: {
                this.styleIndex = 0;
                this.byte3Value = b[3];
                int mask = 255;
                byte[] byArray = b;
                int n = b.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b1 = byArray[n2];
                    mask &= Byte.toUnsignedInt(b1);
                    ++n2;
                }
                this.exists = mask != 255;
                this.modifier = (b[0] & 0xE0) >> 4;
                this.xPos = (((long)b[0] & (classic ? 31L : 15L)) << 8 | Byte.toUnsignedLong(b[1])) - 16L;
                this.xPos = StrictMath.round((double)this.xPos * scale);
                this.yPos = Byte.toUnsignedLong(b[2]) << 1 | ((long)b[3] & 0x80L) >> 7;
                if (BooleanUtils.toBoolean((int)((int)this.yPos & 0x100))) {
                    this.yPos -= 512L;
                }
                this.yPos -= 4L;
                this.yPos = StrictMath.round((double)this.yPos * scale);
                this.id = b[3] & 0x3F;
                if (classic || !BooleanUtils.toBoolean((int)(b[0] & 0x10))) break;
                this.id += 64;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.styleIndex = 0;
                this.byte3Value = 0;
                this.xPos = Byte.toUnsignedLong(b[0]) | (long)(b[1] << 8);
                this.xPos = Math.round((double)this.xPos * scale);
                this.yPos = Byte.toUnsignedLong(b[2]) | (long)(b[3] << 8);
                this.yPos = Math.round((double)this.yPos * scale);
                this.id = Byte.toUnsignedInt(b[4]);
                this.modifier = 0;
                if (BooleanUtils.toBoolean((int)(b[5] & 1))) {
                    this.modifier |= 8;
                }
                if (BooleanUtils.toBoolean((int)(b[5] & 2))) {
                    this.modifier |= 2;
                }
                if (BooleanUtils.toBoolean((int)(b[5] & 4))) {
                    this.modifier |= 4;
                }
                if (BooleanUtils.toBoolean((int)(b[5] & 8))) {
                    this.modifier |= 0x20;
                }
                if (BooleanUtils.toBoolean((int)(b[5] & 0x10))) {
                    this.modifier |= 0x40;
                }
                this.exists = BooleanUtils.toBoolean((int)(b[5] & 0x80));
                break;
            }
            case 4: {
                this.byte3Value = 0;
                this.xPos = Byte.toUnsignedLong(b[0]) | Byte.toUnsignedLong(b[1]) << 8 | Byte.toUnsignedLong(b[2]) << 16 | (long)(b[3] << 24);
                this.xPos = Math.round((double)this.xPos * scale);
                this.yPos = Byte.toUnsignedLong(b[4]) | Byte.toUnsignedLong(b[5]) << 8 | Byte.toUnsignedLong(b[6]) << 16 | (long)(b[7] << 24);
                this.yPos = Math.round((double)this.yPos * scale);
                this.id = Byte.toUnsignedInt(b[8]) | Byte.toUnsignedInt(b[9]) << 8;
                this.modifier = 0;
                if (BooleanUtils.toBoolean((int)(b[10] & 1))) {
                    this.modifier |= 8;
                }
                if (BooleanUtils.toBoolean((int)(b[10] & 2))) {
                    this.modifier |= 2;
                }
                if (BooleanUtils.toBoolean((int)(b[10] & 4))) {
                    this.modifier |= 4;
                }
                if (BooleanUtils.toBoolean((int)(b[10] & 8))) {
                    this.modifier |= 0x20;
                }
                if (BooleanUtils.toBoolean((int)(b[10] & 0x10))) {
                    this.modifier |= 0x40;
                }
                if (BooleanUtils.toBoolean((int)(b[10] & 0x20))) {
                    this.modifier |= 0x80;
                }
                this.exists = BooleanUtils.toBoolean((int)(b[10] & 0x80));
                this.styleIndex = Byte.toUnsignedInt(b[12]);
                break;
            }
            default: {
                throw new Exception(String.format("Unsupported level format: %d", format));
            }
        }
    }

    static Terrain getTerrain(ByteBuffer b, double scale, boolean classic, int format) throws Exception {
        int byteCount;
        switch (format) {
            case 0: {
                byteCount = 4;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                byteCount = 8;
                break;
            }
            case 4: {
                byteCount = 16;
                break;
            }
            default: {
                throw new Exception(String.format("Unsupported level format: %d", format));
            }
        }
        byte[] bytes = new byte[byteCount];
        b.get(bytes);
        return new Terrain(bytes, scale, classic, format);
    }
}

