/*
 * Decompiled with CFR 0.152.
 */
package lemmini.extract;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.BooleanUtils;

class Steel {
    long xPos;
    long yPos;
    long width;
    long height;
    boolean negative;
    boolean exists;
    byte byte3Value;

    Steel(byte[] b, double scale, boolean classic, int format) throws Exception {
        switch (format) {
            case 0: {
                this.byte3Value = b[3];
                int sum = 0;
                byte[] byArray = b;
                int n = b.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b1 = byArray[n2];
                    sum += Byte.toUnsignedInt(b1);
                    ++n2;
                }
                this.exists = sum != 0;
                this.xPos = (Byte.toUnsignedLong(b[0]) << 1 | ((long)b[1] & 0x80L) >> 7) * 4L - 16L;
                if (!classic) {
                    this.xPos -= ((long)b[3] & 0xC0L) >>> 6;
                }
                this.xPos = StrictMath.round((double)this.xPos * scale);
                this.yPos = ((long)b[1] & 0x7FL) * 4L;
                if (!classic) {
                    this.yPos -= ((long)b[3] & 0x30L) >>> 4;
                }
                this.yPos = StrictMath.round((double)this.yPos * scale);
                this.width = (((long)b[2] & 0xF0L) >> 4) * 4L + 4L;
                if (!classic) {
                    this.width -= ((long)b[3] & 0xCL) >>> 2;
                }
                this.width = StrictMath.round((double)this.width * scale);
                this.height = ((long)b[2] & 0xFL) * 4L + 4L;
                if (!classic) {
                    this.height -= (long)b[3] & 3L;
                }
                this.height = StrictMath.round((double)this.height * scale);
                this.negative = false;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.byte3Value = 0;
                this.xPos = Byte.toUnsignedLong(b[0]) | (long)(b[1] << 8);
                this.xPos = Math.round((double)this.xPos * scale);
                this.yPos = Byte.toUnsignedLong(b[2]) | (long)(b[3] << 8);
                this.yPos = Math.round((double)this.yPos * scale);
                this.width = Byte.toUnsignedLong(b[4]) + 1L;
                this.width = Math.round((double)this.width * scale);
                this.height = Byte.toUnsignedLong(b[5]) + 1L;
                this.height = Math.round((double)this.height * scale);
                int steelType = b[6] & 0x7F;
                this.negative = steelType == 1;
                this.exists = BooleanUtils.toBoolean((int)(b[6] & 0x80)) && (steelType == 0 || steelType == 1);
                break;
            }
            case 4: {
                this.byte3Value = 0;
                this.xPos = Byte.toUnsignedLong(b[0]) | Byte.toUnsignedLong(b[1]) << 8 | Byte.toUnsignedLong(b[2]) << 16 | (long)(b[3] << 24);
                this.xPos = Math.round((double)this.xPos * scale);
                this.yPos = Byte.toUnsignedLong(b[4]) | Byte.toUnsignedLong(b[5]) << 8 | Byte.toUnsignedLong(b[6]) << 16 | (long)(b[7] << 24);
                this.yPos = Math.round((double)this.yPos * scale);
                this.width = (Byte.toUnsignedLong(b[8]) | Byte.toUnsignedLong(b[9]) << 8 | Byte.toUnsignedLong(b[10]) << 16 | (long)(b[11] << 24)) + 1L;
                this.width = Math.round((double)this.width * scale);
                this.height = (Byte.toUnsignedLong(b[12]) | Byte.toUnsignedLong(b[13]) << 8 | Byte.toUnsignedLong(b[14]) << 16 | (long)(b[15] << 24)) + 1L;
                this.height = Math.round((double)this.height * scale);
                int steelType = b[16] & 0x7F;
                this.negative = steelType == 1;
                this.exists = BooleanUtils.toBoolean((int)(b[16] & 0x80)) && (steelType == 0 || steelType == 1);
                break;
            }
            default: {
                throw new Exception(String.format("Unsupported level format: %d", format));
            }
        }
    }

    static Steel getSteel(ByteBuffer b, double scale, boolean classic, int format) throws Exception {
        int byteCount;
        switch (format) {
            case 0: {
                byteCount = 4;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                byteCount = 8;
                break;
            }
            case 4: {
                byteCount = 20;
                break;
            }
            default: {
                throw new Exception(String.format("Unsupported level format: %d", format));
            }
        }
        byte[] bytes = new byte[byteCount];
        b.get(bytes);
        return new Steel(bytes, scale, classic, format);
    }
}

