/*
 * Decompiled with CFR 0.152.
 */
package lemmini.extract;

import java.nio.ByteBuffer;
import org.apache.commons.lang3.BooleanUtils;

class LvlObject {
    static final int MODE_VIS_ON_TERRAIN = 8;
    static final int MODE_NO_OVERWRITE = 4;
    static final int MODE_INVISIBLE = 2;
    static final int FLAG_UPSIDE_DOWN = 1;
    static final int FLAG_FAKE = 2;
    static final int FLAG_UPSIDE_DOWN_MASK = 4;
    static final int FLAG_FLIP_HORIZONTALLY = 8;
    static final int FLAG_ROTATE = 16;
    static final int ENTRANCE_ID = 1;
    static final int GREEN_FLAG_ID = 2;
    long xPos;
    long yPos;
    int id;
    int paintMode;
    int flags;
    boolean leftFacing;
    int styleIndex;
    boolean exists;
    byte byte4Value;
    byte byte6Value;
    byte byte7Value;

    LvlObject(byte[] b, double scale, boolean classic, int format) throws Exception {
        switch (format) {
            case 0: {
                this.styleIndex = 0;
                this.byte4Value = b[4];
                this.byte6Value = b[6];
                this.byte7Value = b[7];
                int sum = 0;
                byte[] byArray = b;
                int n = b.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b1 = byArray[n2];
                    sum += Byte.toUnsignedInt(b1);
                    ++n2;
                }
                this.exists = sum != 0;
                this.xPos = ((long)(b[0] << 8) | Byte.toUnsignedLong(b[1])) - 16L;
                this.xPos = StrictMath.round((double)this.xPos * scale);
                this.yPos = (long)(b[2] << 8) | Byte.toUnsignedLong(b[3]);
                this.yPos = StrictMath.round((double)this.yPos * scale);
                this.id = classic ? (b[4] & 0x7F) << 8 | Byte.toUnsignedInt(b[5]) : Byte.toUnsignedInt(b[5]);
                this.paintMode = 0;
                this.flags = 0;
                if (BooleanUtils.toBoolean((int)(b[6] & 0x80))) {
                    this.paintMode |= 4;
                }
                if (BooleanUtils.toBoolean((int)(b[6] & 0x40))) {
                    this.paintMode |= 8;
                }
                if (BooleanUtils.toBoolean((int)(b[7] & 0x80)) && (b[7] & 0xF) == 15) {
                    this.flags |= 1;
                    if (!classic) {
                        this.flags |= 4;
                    }
                }
                if (classic || !BooleanUtils.toBoolean((int)(b[6] & 0x10))) break;
                this.flags |= 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.styleIndex = 0;
                this.byte4Value = 0;
                this.byte6Value = 0;
                this.byte7Value = 0;
                this.xPos = Byte.toUnsignedLong(b[0]) | (long)(b[1] << 8);
                this.xPos = Math.round((double)this.xPos * scale);
                this.yPos = Byte.toUnsignedLong(b[2]) | (long)(b[3] << 8);
                this.yPos = Math.round((double)this.yPos * scale);
                this.id = Byte.toUnsignedInt(b[4]);
                this.paintMode = 0;
                this.flags = 0;
                if (BooleanUtils.toBoolean((int)(b[7] & 1))) {
                    this.paintMode |= 4;
                }
                if (BooleanUtils.toBoolean((int)(b[7] & 2))) {
                    this.paintMode |= 8;
                }
                if (BooleanUtils.toBoolean((int)(b[7] & 4))) {
                    this.flags |= 1;
                    this.flags |= 4;
                }
                this.leftFacing = BooleanUtils.toBoolean((int)(b[7] & 8));
                if (BooleanUtils.toBoolean((int)(b[7] & 0x10))) {
                    this.flags |= 2;
                }
                if (BooleanUtils.toBoolean((int)(b[7] & 0x20))) {
                    this.paintMode |= 2;
                }
                if (BooleanUtils.toBoolean((int)(b[7] & 0x40))) {
                    this.flags |= 8;
                }
                this.exists = BooleanUtils.toBoolean((int)(b[7] & 0x80));
                break;
            }
            case 4: {
                this.byte4Value = 0;
                this.byte6Value = 0;
                this.byte7Value = 0;
                this.xPos = Byte.toUnsignedLong(b[0]) | Byte.toUnsignedLong(b[1]) << 8 | Byte.toUnsignedLong(b[2]) << 16 | (long)(b[3] << 24);
                this.xPos = Math.round((double)this.xPos * scale);
                this.yPos = Byte.toUnsignedLong(b[4]) | Byte.toUnsignedLong(b[5]) << 8 | Byte.toUnsignedLong(b[6]) << 16 | (long)(b[7] << 24);
                this.yPos = Math.round((double)this.yPos * scale);
                this.id = Byte.toUnsignedInt(b[8]) | Byte.toUnsignedInt(b[9]) << 8;
                this.paintMode = 0;
                this.flags = 0;
                if (BooleanUtils.toBoolean((int)(b[12] & 1))) {
                    this.paintMode |= 4;
                }
                if (BooleanUtils.toBoolean((int)(b[12] & 2))) {
                    this.paintMode |= 8;
                }
                if (BooleanUtils.toBoolean((int)(b[12] & 4))) {
                    this.flags |= 1;
                    this.flags |= 4;
                }
                this.leftFacing = BooleanUtils.toBoolean((int)(b[12] & 8));
                if (BooleanUtils.toBoolean((int)(b[12] & 0x10))) {
                    this.flags |= 2;
                }
                if (BooleanUtils.toBoolean((int)(b[12] & 0x20))) {
                    this.paintMode |= 2;
                }
                if (BooleanUtils.toBoolean((int)(b[12] & 0x40))) {
                    this.flags |= 8;
                }
                this.exists = BooleanUtils.toBoolean((int)(b[12] & 0x80));
                if (BooleanUtils.toBoolean((int)(b[13] & 1))) {
                    this.flags |= 0x10;
                }
                this.styleIndex = Byte.toUnsignedInt(b[14]);
                break;
            }
            default: {
                throw new Exception(String.format("Unsupported level format: %d", format));
            }
        }
    }

    static LvlObject getObject(ByteBuffer b, double scale, boolean classic, int format) throws Exception {
        int byteCount;
        switch (format) {
            case 0: 
            case 3: {
                byteCount = 8;
                break;
            }
            case 1: 
            case 2: {
                byteCount = 16;
                break;
            }
            case 4: {
                byteCount = 20;
                break;
            }
            default: {
                throw new Exception(String.format("Unsupported level format: %d", format));
            }
        }
        byte[] bytes = new byte[byteCount];
        b.get(bytes);
        return new LvlObject(bytes, scale, classic, format);
    }
}

