/*
 * Decompiled with CFR 0.152.
 */
package lemmini.extract;

import java.io.IOException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lemmini.extract.LvlObject;
import lemmini.extract.Steel;
import lemmini.extract.Terrain;
import lemmini.tools.ToolBox;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;

public class ExtractLevel {
    private static final double DEFAULT_SCALE = 2.0;
    private static final int DEFAULT_WIDTH = 1584;
    private static final int DEFAULT_HEIGHT = 160;
    private static final int MINIMUM_WIDTH = 320;
    private static final int MINIMUM_HEIGHT = 160;
    private static final int FAKE_OBJECT_CUTOFF = 16;
    private static final int MAX_ENTRANCES = 4;
    private static final int MAX_ENTRANCES_MULTI = 2;
    private static final int MAX_GREEN_FLAGS = 1;
    private static final Map<Integer, String> STYLES = new HashMap<Integer, String>(32);
    private static final Map<Integer, String> SPECIAL_STYLES = new HashMap<Integer, String>(16);
    private static final Map<String, Set<Integer>> OBJECTS_TO_ALIGN = new HashMap<String, Set<Integer>>(32);
    private static final Map<Integer, String> MUSIC_INDEX = new HashMap<Integer, String>(64);
    private static final Map<String, String> MUSIC_STRING = new HashMap<String, String>(64);
    private static final int GIMMICK_FLAG_SUPERLEMMING = 1;
    private static final int GIMMICK_FLAG_CHEAPO_FALL_DISTANCE = 0x40000000;
    private static final int SKILL_FLAG_CLIMBER = 16384;
    private static final int SKILL_FLAG_FLOATER = 4096;
    private static final int SKILL_FLAG_BOMBER = 512;
    private static final int SKILL_FLAG_BLOCKER = 128;
    private static final int SKILL_FLAG_BUILDER = 32;
    private static final int SKILL_FLAG_BASHER = 8;
    private static final int SKILL_FLAG_MINER = 4;
    private static final int SKILL_FLAG_DIGGER = 2;
    private static final int OPTION_FLAG_NEGATIVE_STEEL = 1;
    private static final int OPTION_FLAG_AUTOSTEEL = 2;
    private static final int OPTION_FLAG_IGNORE_STEEL = 4;
    private static final int OPTION_FLAG_SIMPLE_AUTOSTEEL = 8;
    private static final int OPTION_FLAG_CUSTOM_GIMMICKS = 32;
    private static final int OPTION_FLAG_CUSTOM_SKILL_SET = 64;
    private static final int OPTION_FLAG_INVERT_ONE_WAY = 128;
    private static final int OPTION_FLAG_LOCK_RELEASE_RATE = 256;

    static {
        ExtractLevel.addStyle(0, "dirt", 0, 3, 4, 5, 6, 7, 8, 10);
        ExtractLevel.addStyle(1, "fire", 0, 3, 4, 5, 6, 7, 8, 10);
        ExtractLevel.addStyle(2, "marble", 0, 3, 4, 5, 6, 8, 9);
        ExtractLevel.addStyle(3, "pillar", 0, 3, 4, 5, 6, 8, 9, 10, 15, 16, 17);
        ExtractLevel.addStyle(4, "crystal", 0, 4, 5, 6, 7, 8, 9, 10);
        ExtractLevel.addStyle(5, "brick", 0, 3, 4, 5, 6, 7, 9);
        ExtractLevel.addStyle(6, "rock", 0, 3, 4, 5, 6, 7, 8, 9, 10);
        ExtractLevel.addStyle(7, "snow", 0, 3, 4, 5, 6, 8, 9);
        ExtractLevel.addStyle(8, "bubble", 0, 3, 4, 5, 6, 8, 9, 10);
        ExtractLevel.addStyle(9, "xmas", 0, 3, 10, 11, 12);
        SPECIAL_STYLES.put(0, "awesome");
        SPECIAL_STYLES.put(1, "menace");
        SPECIAL_STYLES.put(2, "beastii");
        SPECIAL_STYLES.put(3, "beasti");
        SPECIAL_STYLES.put(4, "covox");
        SPECIAL_STYLES.put(5, "prima");
        SPECIAL_STYLES.put(10, "awesome_md");
        SPECIAL_STYLES.put(11, "menace_md");
        SPECIAL_STYLES.put(12, "beasti_md");
        SPECIAL_STYLES.put(13, "beastii_md");
        SPECIAL_STYLES.put(14, "hebereke");
        SPECIAL_STYLES.put(15, "apple");
        SPECIAL_STYLES.put(101, "apple");
        MUSIC_INDEX.put(1, "cancan.mod");
        MUSIC_INDEX.put(2, "lemming1.mod");
        MUSIC_INDEX.put(3, "tim2.mod");
        MUSIC_INDEX.put(4, "lemming2.mod");
        MUSIC_INDEX.put(5, "tim8.mod");
        MUSIC_INDEX.put(6, "tim3.mod");
        MUSIC_INDEX.put(7, "tim5.mod");
        MUSIC_INDEX.put(8, "doggie.mod");
        MUSIC_INDEX.put(9, "tim6.mod");
        MUSIC_INDEX.put(10, "lemming3.mod");
        MUSIC_INDEX.put(11, "tim7.mod");
        MUSIC_INDEX.put(12, "tim9.mod");
        MUSIC_INDEX.put(13, "tim1.mod");
        MUSIC_INDEX.put(14, "tim10.mod");
        MUSIC_INDEX.put(15, "tim4.mod");
        MUSIC_INDEX.put(16, "tenlemms.mod");
        MUSIC_INDEX.put(17, "mountain.mod");
        MUSIC_INDEX.put(18, "tune1.mod");
        MUSIC_INDEX.put(19, "tune2.mod");
        MUSIC_INDEX.put(20, "tune3.mod");
        MUSIC_INDEX.put(21, "tune4.mod");
        MUSIC_INDEX.put(22, "tune5.mod");
        MUSIC_INDEX.put(23, "tune6.mod");
        MUSIC_STRING.put("awesome", "special/awesome.mod");
        MUSIC_STRING.put("beasti", "special/beasti.mod");
        MUSIC_STRING.put("beastii", "special/beastii.mod");
        MUSIC_STRING.put("menace", "special/menace.mod");
        MUSIC_STRING.put("ohno_01", "tune1.mod");
        MUSIC_STRING.put("ohno_02", "tune2.mod");
        MUSIC_STRING.put("ohno_03", "tune3.mod");
        MUSIC_STRING.put("ohno_04", "tune4.mod");
        MUSIC_STRING.put("ohno_05", "tune5.mod");
        MUSIC_STRING.put("ohno_06", "tune6.mod");
        MUSIC_STRING.put("orig_01", "cancan.mod");
        MUSIC_STRING.put("orig_02", "lemming1.mod");
        MUSIC_STRING.put("orig_03", "tim2.mod");
        MUSIC_STRING.put("orig_04", "lemming2.mod");
        MUSIC_STRING.put("orig_05", "tim8.mod");
        MUSIC_STRING.put("orig_06", "tim3.mod");
        MUSIC_STRING.put("orig_07", "tim5.mod");
        MUSIC_STRING.put("orig_08", "doggie.mod");
        MUSIC_STRING.put("orig_09", "tim6.mod");
        MUSIC_STRING.put("orig_10", "lemming3.mod");
        MUSIC_STRING.put("orig_11", "tim7.mod");
        MUSIC_STRING.put("orig_12", "tim9.mod");
        MUSIC_STRING.put("orig_13", "tim1.mod");
        MUSIC_STRING.put("orig_14", "tim10.mod");
        MUSIC_STRING.put("orig_15", "tim4.mod");
        MUSIC_STRING.put("orig_16", "tenlemms.mod");
        MUSIC_STRING.put("orig_17", "mountain.mod");
        MUSIC_STRING.put("sunsoftspecial", "special/hebereke.ogg");
        MUSIC_STRING.put("xmas_01", "xmas/jb.mod");
        MUSIC_STRING.put("xmas_02", "xmas/kw.mod");
        MUSIC_STRING.put("xmas_03", "xmas/rudi.mod");
    }

    private static void addStyle(int styleIndex, String styleName, Integer ... styleObjectsToAlign) {
        STYLES.put(styleIndex, styleName);
        OBJECTS_TO_ALIGN.put(styleName, new HashSet<Integer>(Arrays.asList(styleObjectsToAlign)));
    }

    public static void convertLevel(Path fnIn, Writer out, boolean multi, boolean classic) throws Exception {
        byte[] b;
        try {
            if (!Files.isRegularFile(fnIn, new LinkOption[0])) {
                throw new Exception(String.format("File %s not found.", fnIn));
            }
            long fileSize = Files.size(fnIn);
            if (fileSize < 177L) {
                throw new Exception("Lemmings level files must be at least 177 bytes in size!");
            }
            b = Files.readAllBytes(fnIn);
        }
        catch (IOException e) {
            throw new Exception(String.format("I/O error while reading %s.", fnIn));
        }
        ExtractLevel.convertLevel(b, fnIn.getFileName().toString().toLowerCase(Locale.ROOT), out, multi, classic);
    }

    public static void convertLevel(byte[] in, String fName, Writer out, boolean multi, boolean classic) throws Exception {
        ByteBuffer b;
        int greenFlagCount;
        int activeEntranceCount;
        int entranceCount;
        String author;
        String lvlName;
        String origLvlName;
        long height;
        long width;
        ArrayList remappedEntranceOrder;
        ArrayList<Integer> entranceOrder;
        ArrayList<Steel> steel;
        ArrayList<Terrain> terrain;
        ArrayList<LvlObject> objects;
        byte extra2;
        byte extra1;
        String musicStr;
        long specialStylePositionY;
        long specialStylePositionX;
        String specialStyleStr;
        int specialStyle;
        String[] styleList;
        String styleStr;
        int optionFlags;
        long yPos;
        long xPos;
        double scale;
        int numDiggers;
        int numMiners;
        int numBashers;
        int numBuilders;
        int numBlockers;
        int numBombers;
        int numFloaters;
        int numClimbers;
        int gimmickFlags;
        int timeLimit;
        int timeLimitSeconds;
        int numToRescue;
        int numLemmings;
        int releaseRate;
        byte format;
        block176: {
            int steelCount;
            int terrainCount;
            int objectCount;
            block175: {
                int style;
                format = 0;
                releaseRate = 0;
                numLemmings = 0;
                numToRescue = 0;
                timeLimitSeconds = 0;
                timeLimit = 0;
                gimmickFlags = 0;
                numClimbers = 0;
                numFloaters = 0;
                numBombers = 0;
                numBlockers = 0;
                numBuilders = 0;
                numBashers = 0;
                numMiners = 0;
                numDiggers = 0;
                scale = 2.0;
                xPos = 0L;
                yPos = StrictMath.round(160.0);
                optionFlags = 0;
                styleStr = null;
                styleList = ArrayUtils.EMPTY_STRING_ARRAY;
                specialStyle = -1;
                specialStyleStr = null;
                specialStylePositionX = 0L;
                specialStylePositionY = 0L;
                int music = 0;
                musicStr = null;
                extra1 = 0;
                extra2 = 0;
                objects = new ArrayList<LvlObject>(256);
                terrain = new ArrayList<Terrain>(2048);
                steel = new ArrayList<Steel>(256);
                entranceOrder = new ArrayList<Integer>(64);
                remappedEntranceOrder = new ArrayList(64);
                width = StrictMath.round(3168.0);
                height = StrictMath.round(320.0);
                origLvlName = null;
                lvlName = "";
                author = "";
                entranceCount = 0;
                activeEntranceCount = 0;
                greenFlagCount = 0;
                if (in.length < 177) {
                    throw new Exception("Lemmings level files must be at least 177 bytes in size!");
                }
                b = ByteBuffer.wrap(in).asReadOnlyBuffer();
                if (classic) {
                    if (in.length != 2048) {
                        throw new Exception("Format 0 level files must be 2,048 bytes in size!");
                    }
                    releaseRate = b.getShort();
                    if (releaseRate >= 100) {
                        releaseRate -= 65536;
                    }
                    numLemmings = Short.toUnsignedInt(b.getShort());
                    numToRescue = Short.toUnsignedInt(b.getShort());
                    timeLimit = Short.toUnsignedInt(b.getShort());
                    numClimbers = Short.toUnsignedInt(b.getShort());
                    numFloaters = Short.toUnsignedInt(b.getShort());
                    numBombers = Short.toUnsignedInt(b.getShort());
                    numBlockers = Short.toUnsignedInt(b.getShort());
                    numBuilders = Short.toUnsignedInt(b.getShort());
                    numBashers = Short.toUnsignedInt(b.getShort());
                    numMiners = Short.toUnsignedInt(b.getShort());
                    numDiggers = Short.toUnsignedInt(b.getShort());
                    xPos = Short.toUnsignedLong(b.getShort());
                    xPos += multi ? 72L : 160L;
                    xPos = StrictMath.round((double)xPos * scale);
                    yPos = StrictMath.round(80.0 * scale);
                    style = Short.toUnsignedInt(b.getShort());
                    styleStr = STYLES.get(style);
                    if (styleStr == null) {
                        throw new Exception(String.format("%s uses an unsupported style: %d", fName, style));
                    }
                    specialStyle = Short.toUnsignedInt(b.getShort()) - 1;
                    if (specialStyle > -1 && (specialStyleStr = SPECIAL_STYLES.get(specialStyle)) == null) {
                        throw new Exception(String.format("%s uses an unsupported special style: %d", fName, specialStyle));
                    }
                    extra1 = b.get();
                    extra2 = b.get();
                } else {
                    int[] skillCounts;
                    int skillFlags = 0;
                    format = b.get();
                    switch (format) {
                        case 0: {
                            if (in.length != 2048) {
                                throw new Exception("Format 0 level files must be 2,048 bytes in size!");
                            }
                            releaseRate = b.get();
                            if (releaseRate >= 100) {
                                releaseRate -= 256;
                            }
                            numLemmings = Short.toUnsignedInt(b.getShort());
                            numToRescue = Short.toUnsignedInt(b.getShort());
                            timeLimitSeconds = Byte.toUnsignedInt(b.get());
                            timeLimit = Byte.toUnsignedInt(b.get());
                            skillCounts = new int[8];
                            gimmickFlags = Byte.toUnsignedInt(b.get()) << 24;
                            skillCounts[0] = Byte.toUnsignedInt(b.get());
                            gimmickFlags |= Byte.toUnsignedInt(b.get()) << 16;
                            skillCounts[1] = Byte.toUnsignedInt(b.get());
                            gimmickFlags |= Byte.toUnsignedInt(b.get()) << 8;
                            skillCounts[2] = Byte.toUnsignedInt(b.get());
                            gimmickFlags |= Byte.toUnsignedInt(b.get());
                            skillCounts[3] = Byte.toUnsignedInt(b.get());
                            b.get();
                            skillCounts[4] = Byte.toUnsignedInt(b.get());
                            b.get();
                            skillCounts[5] = Byte.toUnsignedInt(b.get());
                            skillFlags = Byte.toUnsignedInt(b.get()) << 8;
                            skillCounts[6] = Byte.toUnsignedInt(b.get());
                            skillFlags |= Byte.toUnsignedInt(b.get());
                            skillCounts[7] = Byte.toUnsignedInt(b.get());
                            int i = 0;
                            while (i < skillCounts.length) {
                                if (skillCounts[i] >= 100) {
                                    skillCounts[i] = Integer.MAX_VALUE;
                                }
                                ++i;
                            }
                            xPos = Short.toUnsignedLong(b.getShort());
                            xPos += multi ? 72L : 160L;
                            xPos = Math.round((double)xPos * scale);
                            yPos = Math.round(80.0 * scale);
                            music = Byte.toUnsignedInt(b.get());
                            if (music > 0 && music < 253 && (musicStr = MUSIC_INDEX.get(music)) == null) {
                                throw new Exception(String.format("%s uses an unsupported music index: %d", fName, music));
                            }
                            style = Byte.toUnsignedInt(b.get());
                            styleStr = STYLES.get(style);
                            if (styleStr == null) {
                                throw new Exception(String.format("%s uses an unsupported style: %d", fName, style));
                            }
                            optionFlags = b.get();
                            specialStyle = Byte.toUnsignedInt(b.get()) - 1;
                            if (specialStyle > -1 && (specialStyleStr = SPECIAL_STYLES.get(specialStyle)) == null) {
                                throw new Exception(String.format("%s uses an unsupported special style: %d", fName, specialStyle));
                            }
                            extra1 = b.get();
                            extra2 = b.get();
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            if (format <= 3 && in.length != 10240) {
                                throw new Exception("Format 1, 2, and 3 level files must be 10,240 bytes in size!");
                            }
                            b.order(ByteOrder.LITTLE_ENDIAN);
                            if (format >= 2) {
                                music = Byte.toUnsignedInt(b.get());
                            } else {
                                b.get();
                            }
                            numLemmings = Short.toUnsignedInt(b.getShort());
                            numToRescue = Short.toUnsignedInt(b.getShort());
                            timeLimitSeconds = Short.toUnsignedInt(b.getShort());
                            releaseRate = b.get();
                            if (releaseRate >= 100) {
                                releaseRate -= 256;
                            }
                            optionFlags = b.get();
                            if (format >= 4) {
                                style = 255;
                                specialStyle = 255;
                                int scaleInt = Byte.toUnsignedInt(b.get());
                                scale = scaleInt == 0 ? 2.0 : 16.0 / (double)scaleInt;
                                b.get();
                            } else {
                                style = Byte.toUnsignedInt(b.get());
                                specialStyle = Byte.toUnsignedInt(b.get()) - 1;
                            }
                            if (format >= 2) {
                                xPos = Short.toUnsignedLong(b.getShort());
                                xPos += multi ? 72L : 160L;
                                xPos = Math.round((double)xPos * scale);
                                yPos = Short.toUnsignedLong(b.getShort()) + 80L;
                                yPos = Math.round((double)yPos * scale);
                            } else {
                                music = Byte.toUnsignedInt(b.get());
                                b.get();
                                xPos = Short.toUnsignedLong(b.getShort());
                                xPos += multi ? 72L : 160L;
                                xPos = Math.round((double)xPos * scale);
                                yPos = Math.round(80.0 * scale);
                            }
                            if (music > 0 && music < 253 && (musicStr = MUSIC_INDEX.get(music)) == null) {
                                throw new Exception(String.format("%s uses an unsupported music index: %d", fName, music));
                            }
                            skillCounts = new int[16];
                            int i = 0;
                            while (i < skillCounts.length) {
                                skillCounts[i] = Byte.toUnsignedInt(b.get());
                                if (skillCounts[i] >= 100) {
                                    skillCounts[i] = Integer.MAX_VALUE;
                                }
                                ++i;
                            }
                            gimmickFlags = b.getInt();
                            skillFlags = Short.toUnsignedInt(b.getShort());
                            b.get();
                            b.get();
                            if (format >= 4) {
                                width = Math.round((double)Integer.toUnsignedLong(b.getInt()) * scale);
                                height = Math.round((double)Integer.toUnsignedLong(b.getInt()) * scale);
                                specialStylePositionX = Math.round((double)b.getInt() * scale);
                                specialStylePositionY = Math.round((double)b.getInt() * scale);
                                b.getInt();
                                optionFlags |= Byte.toUnsignedInt(b.get()) << 8;
                                b.position(b.position() + 3);
                            } else {
                                width = Math.round((double)Math.max(1584 + b.getShort(), 320) * scale);
                                height = Math.round((double)Math.max(160 + b.getShort(), 160) * scale);
                                specialStylePositionX = Math.round((double)b.getShort() * scale);
                                specialStylePositionY = Math.round((double)b.getShort() * scale);
                            }
                            byte[] bString = new byte[16];
                            b.get(bString);
                            author = new String(bString, StandardCharsets.US_ASCII).trim();
                            author = ToolBox.addBackslashes(author, false);
                            bString = new byte[32];
                            b.get(bString);
                            lvlName = new String(bString, StandardCharsets.US_ASCII);
                            if (format >= 3) {
                                bString = new byte[16];
                                b.get(bString);
                                String strTemp = new String(bString, StandardCharsets.US_ASCII).trim().toLowerCase(Locale.ROOT);
                                if (!strTemp.isEmpty()) {
                                    styleStr = strTemp;
                                }
                                b.get(bString);
                                strTemp = new String(bString, StandardCharsets.US_ASCII).trim().toLowerCase(Locale.ROOT);
                                if (strTemp.equals("none")) {
                                    specialStyle = -1;
                                    specialStyleStr = null;
                                } else if (!strTemp.isEmpty()) {
                                    specialStyleStr = strTemp;
                                }
                            } else {
                                b.position(b.position() + 32);
                            }
                            if (styleStr == null && style != 255 && (styleStr = STYLES.get(style)) == null) {
                                throw new Exception(String.format("%s uses an unsupported style: %d", fName, style));
                            }
                            if (specialStyleStr == null && specialStyle != 254 && specialStyle > -1 && (specialStyleStr = SPECIAL_STYLES.get(specialStyle)) == null) {
                                throw new Exception(String.format("%s uses an unsupported special style: %d", fName, specialStyle));
                            }
                            if (format == 3) {
                                int i2 = 0;
                                while (i2 < 32) {
                                    int entranceIndex2 = Byte.toUnsignedInt(b.get());
                                    if (BooleanUtils.toBoolean((int)(entranceIndex2 & 0x80))) {
                                        entranceOrder.add(entranceIndex2 & 0x7F);
                                    }
                                    ++i2;
                                }
                            } else if (format <= 2) {
                                b.position(b.position() + 32);
                            }
                            b.position(b.position() + 32);
                            break;
                        }
                        default: {
                            throw new Exception(String.format("Unsupported level format: %d", format));
                        }
                    }
                    if (format >= 1 || BooleanUtils.toBoolean((int)(optionFlags & 0x40))) {
                        int skillIndex = 15;
                        int numSkills = 0;
                        while (skillIndex >= 0 && numSkills < 8) {
                            int skillCountIndex;
                            switch (format) {
                                case 0: {
                                    skillCountIndex = numSkills;
                                    break;
                                }
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: {
                                    skillCountIndex = skillCounts.length - 1 - skillIndex;
                                    break;
                                }
                                default: {
                                    throw new Exception(String.format("Unsupported level format: %d", format));
                                }
                            }
                            switch (1 << skillIndex) {
                                case 16384: {
                                    if (BooleanUtils.toBoolean((int)(skillFlags & 0x4000))) {
                                        numClimbers = skillCounts[skillCountIndex];
                                        ++numSkills;
                                        break;
                                    }
                                    numClimbers = 0;
                                    break;
                                }
                                case 4096: {
                                    if (BooleanUtils.toBoolean((int)(skillFlags & 0x1000))) {
                                        numFloaters = skillCounts[skillCountIndex];
                                        ++numSkills;
                                        break;
                                    }
                                    numFloaters = 0;
                                    break;
                                }
                                case 512: {
                                    if (BooleanUtils.toBoolean((int)(skillFlags & 0x200))) {
                                        numBombers = skillCounts[skillCountIndex];
                                        ++numSkills;
                                        break;
                                    }
                                    numBombers = 0;
                                    break;
                                }
                                case 128: {
                                    if (BooleanUtils.toBoolean((int)(skillFlags & 0x80))) {
                                        numBlockers = skillCounts[skillCountIndex];
                                        ++numSkills;
                                        break;
                                    }
                                    numBlockers = 0;
                                    break;
                                }
                                case 32: {
                                    if (BooleanUtils.toBoolean((int)(skillFlags & 0x20))) {
                                        numBuilders = skillCounts[skillCountIndex];
                                        ++numSkills;
                                        break;
                                    }
                                    numBuilders = 0;
                                    break;
                                }
                                case 8: {
                                    if (BooleanUtils.toBoolean((int)(skillFlags & 8))) {
                                        numBashers = skillCounts[skillCountIndex];
                                        ++numSkills;
                                        break;
                                    }
                                    numBashers = 0;
                                    break;
                                }
                                case 4: {
                                    if (BooleanUtils.toBoolean((int)(skillFlags & 4))) {
                                        numMiners = skillCounts[skillCountIndex];
                                        ++numSkills;
                                        break;
                                    }
                                    numMiners = 0;
                                    break;
                                }
                                case 2: {
                                    if (BooleanUtils.toBoolean((int)(skillFlags & 2))) {
                                        numDiggers = skillCounts[skillCountIndex];
                                        ++numSkills;
                                        break;
                                    }
                                    numDiggers = 0;
                                    break;
                                }
                                default: {
                                    if (!BooleanUtils.toBoolean((int)(skillFlags & 1 << skillIndex))) break;
                                    ++numSkills;
                                }
                            }
                            --skillIndex;
                        }
                    } else {
                        numClimbers = skillCounts[0];
                        numFloaters = skillCounts[1];
                        numBombers = skillCounts[2];
                        numBlockers = skillCounts[3];
                        numBuilders = skillCounts[4];
                        numBashers = skillCounts[5];
                        numMiners = skillCounts[6];
                        numDiggers = skillCounts[7];
                    }
                }
                if (format < 4) break block175;
                boolean exitLoop = false;
                block52: do {
                    block18 : switch (b.get()) {
                        default: {
                            exitLoop = true;
                            break;
                        }
                        case 1: {
                            objects.add(LvlObject.getObject(b, scale, classic, format));
                            break;
                        }
                        case 2: {
                            terrain.add(Terrain.getTerrain(b, scale, classic, format));
                            break;
                        }
                        case 3: {
                            steel.add(Steel.getSteel(b, scale, classic, format));
                            break;
                        }
                        case 4: {
                            int entranceIndex3;
                            entranceOrder.clear();
                            while ((entranceIndex3 = Short.toUnsignedInt(b.getShort())) != 65535) {
                                entranceOrder.add(entranceIndex3);
                            }
                            continue block52;
                        }
                        case 5: {
                            String strTemp;
                            xPos = Integer.toUnsignedLong(b.getInt());
                            xPos += multi ? 72L : 160L;
                            xPos = Math.round((double)xPos * scale);
                            yPos = Integer.toUnsignedLong(b.getInt()) + 80L;
                            yPos = Math.round((double)yPos * scale);
                            b.getInt();
                            b.getInt();
                            byte[] bString = new byte[16];
                            b.get(bString);
                            switch (strTemp = new String(bString, StandardCharsets.US_ASCII).trim().toLowerCase(Locale.ROOT)) {
                                case "frenzy": 
                                case "": 
                                case "*": 
                                case "gimmick": {
                                    musicStr = null;
                                    break block18;
                                }
                            }
                            musicStr = MUSIC_STRING.getOrDefault(strTemp, strTemp);
                            break;
                        }
                        case 6: {
                            int listSize = Short.toUnsignedInt(b.getShort());
                            if (listSize > styleList.length) {
                                Arrays.copyOf(styleList, listSize);
                            }
                            int i = 0;
                            while (i < listSize) {
                                byte[] bString = new byte[16];
                                b.get(bString);
                                styleList[i] = new String(bString, StandardCharsets.US_ASCII).trim().toLowerCase(Locale.ROOT);
                                ++i;
                            }
                            break block18;
                        }
                    }
                } while (!exitLoop);
                break block176;
            }
            switch (format) {
                case 0: {
                    objectCount = 32;
                    terrainCount = 400;
                    steelCount = 32;
                    break;
                }
                case 1: 
                case 2: {
                    objectCount = 64;
                    terrainCount = 1000;
                    steelCount = 128;
                    break;
                }
                case 3: {
                    objectCount = 128;
                    terrainCount = 1000;
                    steelCount = 128;
                    break;
                }
                case 4: {
                    objectCount = 0;
                    terrainCount = 0;
                    steelCount = 0;
                    break;
                }
                default: {
                    throw new Exception(String.format("Unsupported level format: %d", format));
                }
            }
            int i = 0;
            while (i < objectCount) {
                objects.add(LvlObject.getObject(b, scale, classic, format));
                ++i;
            }
            i = 0;
            while (i < terrainCount) {
                terrain.add(Terrain.getTerrain(b, scale, classic, format));
                ++i;
            }
            i = 0;
            while (i < steelCount) {
                steel.add(Steel.getSteel(b, scale, classic, format));
                ++i;
            }
        }
        int[] entranceLookup = new int[objects.size()];
        Arrays.fill(entranceLookup, -1);
        Iterator it = objects.listIterator();
        while (it.hasNext()) {
            int i = it.nextIndex();
            LvlObject obj = (LvlObject)it.next();
            if (!obj.exists) continue;
            if (classic) {
                if (obj.id == 1) {
                    if (++entranceCount > (multi ? 2 : 4)) {
                        obj.flags |= 2;
                    }
                } else if (obj.id == 2) {
                    if (++greenFlagCount > 1) {
                        obj.flags |= 2;
                    }
                } else if (i >= 16) {
                    obj.flags |= 2;
                }
            }
            if (obj.id != 1 || BooleanUtils.toBoolean((int)(obj.flags & 2))) continue;
            entranceLookup[i] = activeEntranceCount++;
        }
        for (Terrain ter : terrain) {
            if (!BooleanUtils.toBoolean((int)(optionFlags & 0x80))) continue;
            if (BooleanUtils.toBoolean((int)(ter.modifier & 0x40))) {
                ter.modifier &= 0xFFFFFFBF;
                continue;
            }
            ter.modifier |= 0x40;
        }
        if (format == 0 && BooleanUtils.toBoolean((int)(optionFlags & 1)) && steel.size() > 16) {
            it = steel.listIterator(16);
            while (it.hasNext()) {
                ((Steel)it.next()).negative = true;
            }
        }
        entranceOrder.stream().filter(entranceIndex -> entranceLookup[entranceIndex] >= 0).forEachOrdered(entranceIndex -> {
            boolean bl = remappedEntranceOrder.add(entranceLookup[entranceIndex]);
        });
        if (format == 0) {
            byte[] bName = new byte[32];
            b.get(bName);
            lvlName = new String(bName, classic ? StandardCharsets.ISO_8859_1 : StandardCharsets.US_ASCII);
        }
        lvlName = ToolBox.addBackslashes(lvlName, false);
        if (classic && lvlName.indexOf(96) != -1) {
            origLvlName = lvlName;
            lvlName = lvlName.replace('`', '\'');
        }
        out.write("# LVL extracted by SuperLemmini # " + fName + "\r\n");
        out.write("releaseRate = " + releaseRate + "\r\n");
        if (BooleanUtils.toBoolean((int)(optionFlags & 0x100))) {
            out.write("lockReleaseRate = true\r\n");
        }
        out.write("numLemmings = " + numLemmings + "\r\n");
        out.write("numToRescue = " + numToRescue + "\r\n");
        if (classic) {
            out.write("timeLimit = " + timeLimit + "\r\n");
            out.write("numClimbers = " + numClimbers + "\r\n");
            out.write("numFloaters = " + numFloaters + "\r\n");
            out.write("numBombers = " + numBombers + "\r\n");
            out.write("numBlockers = " + numBlockers + "\r\n");
            out.write("numBuilders = " + numBuilders + "\r\n");
            out.write("numBashers = " + numBashers + "\r\n");
            out.write("numMiners = " + numMiners + "\r\n");
            out.write("numDiggers = " + numDiggers + "\r\n");
        } else {
            out.write("timeLimitSeconds = " + (timeLimit * 60 + timeLimitSeconds) + "\r\n");
            out.write("numClimbers = " + ToolBox.intToString(numClimbers, false) + "\r\n");
            out.write("numFloaters = " + ToolBox.intToString(numFloaters, false) + "\r\n");
            out.write("numBombers = " + ToolBox.intToString(numBombers, false) + "\r\n");
            out.write("numBlockers = " + ToolBox.intToString(numBlockers, false) + "\r\n");
            out.write("numBuilders = " + ToolBox.intToString(numBuilders, false) + "\r\n");
            out.write("numBashers = " + ToolBox.intToString(numBashers, false) + "\r\n");
            out.write("numMiners = " + ToolBox.intToString(numMiners, false) + "\r\n");
            out.write("numDiggers = " + ToolBox.intToString(numDiggers, false) + "\r\n");
            if (!remappedEntranceOrder.isEmpty()) {
                out.write("entranceOrder = ");
                it = remappedEntranceOrder.iterator();
                while (it.hasNext()) {
                    out.write(((Integer)it.next()).toString());
                    if (!it.hasNext()) continue;
                    out.write(", ");
                }
                out.write("\r\n");
            } else if (activeEntranceCount == 3) {
                out.write("entranceOrder = 0, 1, 2\r\n");
            }
        }
        out.write("xPosCenter = " + xPos + "\r\n");
        if (!classic) {
            out.write("yPosCenter = " + yPos + "\r\n");
        }
        out.write("style = " + ToolBox.addBackslashes(styleStr, false) + "\r\n");
        if (specialStyleStr != null) {
            out.write("specialStyle = " + ToolBox.addBackslashes(specialStyleStr, false) + "\r\n");
            if (format >= 3) {
                out.write("specialStylePositionX = " + specialStylePositionX + "\r\n");
                out.write("specialStylePositionY = " + specialStylePositionY + "\r\n");
            }
        }
        if (musicStr != null) {
            out.write("music = " + ToolBox.addBackslashes(musicStr, false) + "\r\n");
        }
        if (BooleanUtils.toBoolean((int)(optionFlags & 2))) {
            if (BooleanUtils.toBoolean((int)(optionFlags & 8))) {
                out.write("autosteelMode = 1\r\n");
            } else {
                out.write("autosteelMode = 2\r\n");
            }
        }
        if (classic) {
            if (extra1 != 0) {
                out.write("superlemming = true\r\n");
            }
            if (!(extra1 == 0 && extra2 == 0 || extra1 == -1 && extra2 == -1)) {
                out.write("#byte30Value = " + extra1 + "\r\n");
                out.write("#byte31Value = " + extra2 + "\r\n");
            }
            out.write("forceNormalTimerSpeed = true\r\n");
            out.write("classicSteel = true\r\n");
        } else {
            if (format >= 1 || BooleanUtils.toBoolean((int)(optionFlags & 0x20))) {
                if (BooleanUtils.toBoolean((int)(gimmickFlags & 1))) {
                    out.write("superlemming = true\r\n");
                }
                if (BooleanUtils.toBoolean((int)(gimmickFlags & 0x40000000))) {
                    out.write("maxFallDistance = 152\r\n");
                }
            } else {
                block41 : switch (extra1) {
                    case -1: {
                        out.write("superlemming = true\r\n");
                        break;
                    }
                    case 66: {
                        switch (extra2) {
                            case 1: 
                            case 9: 
                            case 10: {
                                out.write("superlemming = true\r\n");
                                break block41;
                            }
                        }
                        break;
                    }
                }
            }
            out.write("width = " + width + "\r\n");
            out.write("height = " + height + "\r\n");
        }
        out.write("\r\n# Objects\r\n");
        out.write("# ID, X position, Y position, paint mode, flags,\r\n");
        out.write("#         object-specific modifier (optional),\r\n");
        out.write("#         style (optional, requires object-specific modifier)\r\n");
        out.write("# Paint modes: 0 = full, 2 = invisible, 4 = don't overwrite,\r\n");
        out.write("#              8 = visible only on terrain (only one value possible)\r\n");
        out.write("# Flags: 1 = upside down, 2 = fake, 4 = upside-down mask,\r\n");
        out.write("#        8 = flip horizontally, 16 = rotate (combining allowed)\r\n");
        int maxObjectID = -1;
        ListIterator it2 = objects.listIterator(objects.size());
        while (it2.hasPrevious()) {
            int i = it2.previousIndex();
            LvlObject obj = (LvlObject)it2.previous();
            if (!obj.exists) continue;
            maxObjectID = i;
            break;
        }
        it2 = objects.listIterator();
        while (it2.nextIndex() <= maxObjectID && it2.hasNext()) {
            long newYPos;
            long newXPos;
            int i = it2.nextIndex();
            LvlObject obj = (LvlObject)it2.next();
            if (classic && OBJECTS_TO_ALIGN.getOrDefault(styleStr, Collections.emptySet()).contains(obj.id)) {
                newXPos = obj.xPos - obj.xPos % StrictMath.round(4.0 * scale);
                newYPos = obj.yPos - obj.yPos % StrictMath.round(4.0 * scale);
            } else {
                newXPos = obj.xPos;
                newYPos = obj.yPos;
            }
            if (obj.exists) {
                out.write("object_" + i + " = " + obj.id + ", " + newXPos + ", " + newYPos + ", " + obj.paintMode + ", " + obj.flags);
                if (!classic) {
                    if (obj.id == 1 && obj.leftFacing) {
                        out.write(", 1");
                    } else {
                        out.write(", 0");
                    }
                    if (obj.styleIndex >= 0 && obj.styleIndex < styleList.length) {
                        out.write(", " + styleList[obj.styleIndex]);
                    }
                }
                out.write("\r\n");
                if (!classic) continue;
                if (newXPos != obj.xPos || newYPos != obj.yPos) {
                    out.write("#object_" + i + "_origPosition = " + obj.xPos + ", " + obj.yPos + "\r\n");
                }
                if (BooleanUtils.toBoolean((int)(obj.byte4Value & 0x80))) {
                    out.write("#object_" + i + "_byte4Value = " + obj.byte4Value + "\r\n");
                }
                if ((obj.byte6Value & 0x3F) != 0) {
                    out.write("#object_" + i + "_byte6Value = " + obj.byte6Value + "\r\n");
                }
                if ((obj.byte7Value & 0x7F) == 15) continue;
                out.write("#object_" + i + "_byte7Value = " + obj.byte7Value + "\r\n");
                continue;
            }
            out.write("object_" + i + " = -1, 0, 0, 0, 0\r\n");
        }
        out.write("\r\n# Terrain\r\n");
        out.write("# ID, X position, Y position, modifier, style (optional)\r\n");
        out.write("# Modifier: 1 = invisible, 2 = remove, 4 = upside down, 8 = don't overwrite,\r\n");
        out.write("#           16 = fake, 32 = flip horizontally, 64 = no one-way arrows,\r\n");
        out.write("#           128 = rotate (combining allowed)\r\n");
        int maxTerrainID = -1;
        ListIterator it3 = terrain.listIterator(terrain.size());
        while (it3.hasPrevious()) {
            int i = it3.previousIndex();
            Terrain ter = (Terrain)it3.previous();
            if (!ter.exists) continue;
            maxTerrainID = i;
            break;
        }
        int maxValidTerrainID = -1;
        if (!classic) {
            maxValidTerrainID = maxTerrainID;
        } else if (specialStyle < 0) {
            ListIterator it4 = terrain.listIterator();
            while (it4.nextIndex() <= maxTerrainID && it4.hasNext()) {
                int i = it4.nextIndex();
                Terrain ter = (Terrain)it4.next();
                if (!ter.exists) break;
                maxValidTerrainID = i;
            }
        }
        ListIterator it5 = terrain.listIterator();
        while (it5.nextIndex() <= maxTerrainID && it5.hasNext()) {
            int i = it5.nextIndex();
            if (i > maxValidTerrainID) {
                out.write("#");
            }
            Terrain ter = (Terrain)it5.next();
            if (ter.exists) {
                out.write("terrain_" + i + " = " + ter.id + ", " + ter.xPos + ", " + ter.yPos + ", " + ter.modifier);
                if (ter.styleIndex >= 0 && ter.styleIndex < styleList.length) {
                    out.write(", " + styleList[ter.styleIndex]);
                }
                out.write("\r\n");
                if (!classic || !BooleanUtils.toBoolean((int)(ter.byte3Value & 0x40))) continue;
                out.write("#terrain_" + i + "_byte3Value = " + ter.byte3Value + "\r\n");
                continue;
            }
            out.write("terrain_" + i + " = -1, 0, 0, 0\r\n");
        }
        out.write("\r\n# Steel\r\n");
        out.write("# X position, Y position, width, height, flags (optional)\r\n");
        out.write("# Flags: 1 = remove existing steel\r\n");
        int maxSteelID = -1;
        if (!BooleanUtils.toBoolean((int)(optionFlags & 4))) {
            ListIterator it6 = steel.listIterator(steel.size());
            while (it6.hasPrevious()) {
                int i = it6.previousIndex();
                Steel stl = (Steel)it6.previous();
                if (!stl.exists) continue;
                maxSteelID = i;
                break;
            }
        }
        ListIterator it7 = steel.listIterator();
        while (it7.nextIndex() <= maxSteelID && it7.hasNext()) {
            int i = it7.nextIndex();
            Steel stl = (Steel)it7.next();
            if (stl.exists) {
                out.write("steel_" + i + " = " + stl.xPos + ", " + stl.yPos + ", " + stl.width + ", " + stl.height);
                if (!classic) {
                    out.write(", " + (stl.negative ? "1" : "0"));
                }
                out.write("\r\n");
                if (!classic || stl.byte3Value == 0) continue;
                out.write("#steel_" + i + "_byte3Value = " + stl.byte3Value + "\r\n");
                continue;
            }
            out.write("steel_" + i + " = 0, 0, 0, 0\r\n");
        }
        out.write("\r\n# Name and author\r\n");
        if (origLvlName != null) {
            out.write("#origName = " + origLvlName + "\r\n");
        }
        out.write("name = " + lvlName + "\r\n");
        if (!author.isEmpty()) {
            out.write("author = " + author + "\r\n");
        }
    }
}

