/*
 * Decompiled with CFR 0.152.
 */
package lemmini.extract;

import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lemmini.extract.DATSection;

public class ExtractDAT {
    public static List<byte[]> decompress(Path source) throws Exception {
        ArrayList<byte[]> decompressedSections = new ArrayList<byte[]>(32);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (SeekableByteChannel datFile = Files.newByteChannel(source, new OpenOption[0]);){
                while (datFile.position() != datFile.size()) {
                    DATSection section = DATSection.getDATSection(datFile);
                    if (section == null) {
                        throw new Exception(String.format("%s is not a valid Lemmings DAT file.", source));
                    }
                    byte[] decompressedSection = section.decompress();
                    decompressedSections.add(decompressedSection);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new Exception(String.format("I/O error while reading %s.", source));
        }
        return Collections.unmodifiableList(decompressedSections);
    }
}

